/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.DataFormatException;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.common.ServerState;
import org.opends.server.replication.protocol.ReplicationMsg;
import org.opends.server.types.ByteSequenceReader;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringBuilder;

public class MonitorMsg
extends ReplicationMsg {
    private final int destination;
    private final int senderID;
    SubTopoMonitorData data = new SubTopoMonitorData();

    public MonitorMsg(int sender, int destination) {
        this.senderID = sender;
        this.destination = destination;
    }

    public void setReplServerDbState(ServerState state) {
        this.data.replServerDbState = state;
    }

    public void setServerState(int serverId, ServerState state, Long approxFirstMissingDate, boolean isLDAP) {
        if (this.data.ldapStates == null) {
            this.data.ldapStates = new HashMap();
        }
        if (this.data.rsStates == null) {
            this.data.rsStates = new HashMap();
        }
        ServerData sd = new ServerData();
        sd.state = state;
        sd.approxFirstMissingDate = approxFirstMissingDate;
        if (isLDAP) {
            this.data.ldapStates.put(serverId, sd);
        } else {
            this.data.rsStates.put(serverId, sd);
        }
    }

    public ServerState getLDAPServerState(int serverId) {
        return this.data.ldapStates.get((Object)Integer.valueOf((int)serverId)).state;
    }

    public ServerState getRSServerState(int serverId) {
        return this.data.rsStates.get((Object)Integer.valueOf((int)serverId)).state;
    }

    public Long getLDAPApproxFirstMissingDate(int serverId) {
        return this.data.ldapStates.get((Object)Integer.valueOf((int)serverId)).approxFirstMissingDate;
    }

    public Long getRSApproxFirstMissingDate(int serverId) {
        return this.data.rsStates.get((Object)Integer.valueOf((int)serverId)).approxFirstMissingDate;
    }

    public MonitorMsg(byte[] in, short version) throws DataFormatException {
        ByteSequenceReader reader = ByteString.wrap(in).asReader();
        if (version == 1) {
            try {
                if (in[0] != 19) {
                    throw new DataFormatException("input is not a valid " + this.getClass().getCanonicalName());
                }
                int pos = 1;
                int length = MonitorMsg.getNextLength(in, pos);
                String senderIDString = new String(in, pos, length, "UTF-8");
                this.senderID = Integer.valueOf(senderIDString);
                pos += length + 1;
                length = MonitorMsg.getNextLength(in, pos);
                String destinationString = new String(in, pos, length, "UTF-8");
                this.destination = Integer.valueOf(destinationString);
                reader.position(pos += length + 1);
            }
            catch (UnsupportedEncodingException e) {
                throw new DataFormatException("UTF-8 is not supported by this jvm.");
            }
        } else {
            if (reader.get() != 19) {
                throw new DataFormatException("input is not a valid " + this.getClass().getCanonicalName());
            }
            if (version <= 3) {
                this.senderID = reader.getShort();
                this.destination = reader.getShort();
            } else {
                this.senderID = reader.getInt();
                this.destination = reader.getInt();
            }
        }
        ASN1Reader asn1Reader = ASN1.getReader(reader);
        try {
            asn1Reader.readStartSequence();
            while (asn1Reader.hasNextElement()) {
                ServerState newState = new ServerState();
                int serverId = 0;
                Long outime = 0L;
                boolean isLDAPServer = false;
                asn1Reader.readStartSequence();
                while (asn1Reader.hasNextElement()) {
                    ChangeNumber cn = version >= 7 ? ChangeNumber.valueOf(asn1Reader.readOctetString()) : ChangeNumber.valueOf(asn1Reader.readOctetStringAsString());
                    if (this.data.replServerDbState != null && serverId == 0) {
                        serverId = cn.getServerId();
                        outime = cn.getTime();
                        isLDAPServer = cn.getSeqnum() > 0;
                        continue;
                    }
                    newState.update(cn);
                }
                asn1Reader.readEndSequence();
                if (this.data.replServerDbState == null) {
                    this.data.replServerDbState = newState;
                    continue;
                }
                ServerData sd = new ServerData();
                sd.state = newState;
                sd.approxFirstMissingDate = outime;
                if (isLDAPServer) {
                    this.data.ldapStates.put(serverId, sd);
                    continue;
                }
                this.data.rsStates.put(serverId, sd);
            }
            asn1Reader.readEndSequence();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Override
    public byte[] getBytes(short protocolVersion) {
        try {
            ByteStringBuilder byteBuilder = new ByteStringBuilder();
            if (protocolVersion > 1) {
                byteBuilder.append((byte)19);
                if (protocolVersion >= 4) {
                    byteBuilder.append(this.senderID);
                    byteBuilder.append(this.destination);
                } else {
                    byteBuilder.append((short)this.senderID);
                    byteBuilder.append((short)this.destination);
                }
            }
            ASN1Writer writer = ASN1.getWriter(byteBuilder);
            writer.writeStartSequence();
            writer.writeStartSequence();
            this.data.replServerDbState.writeTo(writer, protocolVersion);
            writer.writeEndSequence();
            this.writeServerStates(protocolVersion, writer, false);
            this.writeServerStates(protocolVersion, writer, true);
            writer.writeEndSequence();
            if (protocolVersion > 1) {
                return byteBuilder.toByteArray();
            }
            byte[] temp = byteBuilder.toByteArray();
            byte[] senderBytes = String.valueOf(this.senderID).getBytes("UTF-8");
            byte[] destinationBytes = String.valueOf(this.destination).getBytes("UTF-8");
            int length = 2 + senderBytes.length + 1 + destinationBytes.length + temp.length + 1;
            byte[] resultByteArray = new byte[length];
            resultByteArray[0] = 19;
            int pos = 1;
            pos = MonitorMsg.addByteArray(senderBytes, resultByteArray, pos);
            pos = MonitorMsg.addByteArray(destinationBytes, resultByteArray, pos);
            pos = MonitorMsg.addByteArray(temp, resultByteArray, pos);
            return resultByteArray;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void writeServerStates(short protocolVersion, ASN1Writer writer, boolean writeRSStates) throws IOException {
        HashMap<Integer, ServerData> servers = writeRSStates ? this.data.rsStates : this.data.ldapStates;
        for (Map.Entry server : servers.entrySet()) {
            writer.writeStartSequence();
            ChangeNumber cn = new ChangeNumber(((ServerData)server.getValue()).approxFirstMissingDate, writeRSStates ? 0 : 1, (Integer)server.getKey());
            if (protocolVersion >= 7) {
                writer.writeOctetString(cn.toByteString());
            } else {
                writer.writeOctetString(cn.toString());
            }
            ((ServerData)server.getValue()).state.writeTo(writer, protocolVersion);
            writer.writeEndSequence();
        }
    }

    public ServerState getReplServerDbState() {
        return this.data.replServerDbState;
    }

    public Iterator<Integer> ldapIterator() {
        return this.data.ldapStates.keySet().iterator();
    }

    public Iterator<Integer> rsIterator() {
        return this.data.rsStates.keySet().iterator();
    }

    public int getDestination() {
        return this.destination;
    }

    public int getSenderID() {
        return this.senderID;
    }

    public String toString() {
        ServerData sd;
        String stateS = "\nRState:[";
        stateS = stateS + this.data.replServerDbState.toString();
        stateS = stateS + "]";
        stateS = stateS + "\nLDAPStates:[";
        for (Integer sid : this.data.ldapStates.keySet()) {
            sd = this.data.ldapStates.get(sid);
            stateS = stateS + "\n[LSstate(" + sid + ")=" + sd.state.toString() + "]" + " afmd=" + sd.approxFirstMissingDate + "]";
        }
        stateS = stateS + "\nRSStates:[";
        for (Integer sid : this.data.rsStates.keySet()) {
            sd = this.data.rsStates.get(sid);
            stateS = stateS + "\n[RSState(" + sid + ")=" + sd.state.toString() + "]" + " afmd=" + sd.approxFirstMissingDate + "]";
        }
        return this.getClass().getCanonicalName() + "[ sender=" + this.senderID + " destination=" + this.destination + " data=[" + stateS + "]" + "]";
    }

    class SubTopoMonitorData {
        ServerState replServerDbState;
        HashMap<Integer, ServerData> ldapStates = new HashMap();
        HashMap<Integer, ServerData> rsStates = new HashMap();

        SubTopoMonitorData() {
        }
    }

    static class ServerData {
        ServerState state;
        Long approxFirstMissingDate;

        ServerData() {
        }
    }
}

