/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import org.opends.server.replication.protocol.ReplicationMsg;

public class WindowMsg
extends ReplicationMsg {
    private final int numAck;

    public WindowMsg(int numAck) {
        this.numAck = numAck;
    }

    public WindowMsg(byte[] in) throws DataFormatException {
        try {
            if (in[0] != 8) {
                throw new DataFormatException("input is not a valid Window Message");
            }
            int pos = 1;
            int length = WindowMsg.getNextLength(in, pos);
            String numAckStr = new String(in, pos, length, "UTF-8");
            pos += length + 1;
            this.numAck = Integer.parseInt(numAckStr);
        }
        catch (UnsupportedEncodingException e) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
    }

    @Override
    public byte[] getBytes(short protocolVersion) {
        try {
            byte[] byteNumAck = String.valueOf(this.numAck).getBytes("UTF-8");
            int length = 1 + byteNumAck.length + 1;
            byte[] resultByteArray = new byte[length];
            resultByteArray[0] = 8;
            int pos = 1;
            pos = WindowMsg.addByteArray(byteNumAck, resultByteArray, pos);
            return resultByteArray;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public int getNumAck() {
        return this.numAck;
    }

    public String toString() {
        return "WindowMsg : numAck: " + this.numAck;
    }
}

