/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.DataFormatException;
import org.opends.messages.Message;
import org.opends.messages.ReplicationMessages;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.replication.common.AssuredMode;
import org.opends.server.replication.common.DSInfo;
import org.opends.server.replication.common.ServerState;
import org.opends.server.replication.common.ServerStatus;
import org.opends.server.replication.common.StatusMachine;
import org.opends.server.replication.common.StatusMachineEvent;
import org.opends.server.replication.protocol.ChangeStatusMsg;
import org.opends.server.replication.protocol.NotSupportedOldVersionPDUException;
import org.opends.server.replication.protocol.ProtocolVersion;
import org.opends.server.replication.protocol.ReplServerStartDSMsg;
import org.opends.server.replication.protocol.ReplServerStartMsg;
import org.opends.server.replication.protocol.ReplicationMsg;
import org.opends.server.replication.protocol.ServerStartMsg;
import org.opends.server.replication.protocol.Session;
import org.opends.server.replication.protocol.StartMsg;
import org.opends.server.replication.protocol.StartSessionMsg;
import org.opends.server.replication.protocol.StopMsg;
import org.opends.server.replication.protocol.TopologyMsg;
import org.opends.server.replication.server.MonitorData;
import org.opends.server.replication.server.ReplicationServer;
import org.opends.server.replication.server.ServerHandler;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.Attributes;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;

public class DataServerHandler
extends ServerHandler {
    long tmpGenerationId;
    private ServerStatus status = ServerStatus.INVALID_STATUS;
    private List<String> refUrls = new ArrayList<String>();
    private boolean assuredFlag = false;
    private AssuredMode assuredMode = AssuredMode.SAFE_DATA_MODE;
    private byte safeDataLevel = (byte)-1;
    private Set<String> eclIncludes = new HashSet<String>();
    private Set<String> eclIncludesForDeletes = new HashSet<String>();

    public DataServerHandler(Session session, int queueSize, String replicationServerURL, int replicationServerId, ReplicationServer replicationServer, int rcvWindowSize) {
        super(session, queueSize, replicationServerURL, replicationServerId, replicationServer, rcvWindowSize);
    }

    public void changeStatusForResetGenId(long newGenId) throws IOException {
        StatusMachineEvent event;
        if (newGenId == -1L) {
            event = StatusMachineEvent.TO_BAD_GEN_ID_STATUS_EVENT;
        } else {
            if (newGenId == this.generationId) {
                if (this.status == ServerStatus.BAD_GEN_ID_STATUS) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("In RS " + this.replicationServerDomain.getReplicationServer().getServerId() + ". Closing connection to DS " + this.getServerId() + " for baseDn " + this.getServiceId() + " to force reconnection as new local" + " generationId and remote one match and DS is in bad gen id: " + newGenId);
                    }
                    if (this.session != null && this.getProtocolVersion() >= 4) {
                        try {
                            this.session.publish(new StopMsg());
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                    }
                    this.status = ServerStatus.NOT_CONNECTED_STATUS;
                    return;
                }
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("In RS " + this.replicationServerDomain.getReplicationServer().getServerId() + ". DS " + this.getServerId() + " for baseDn " + this.getServiceId() + " has already generation id " + newGenId + " so no ChangeStatusMsg sent to him.");
                }
                return;
            }
            event = StatusMachineEvent.TO_BAD_GEN_ID_STATUS_EVENT;
        }
        if (event == StatusMachineEvent.TO_BAD_GEN_ID_STATUS_EVENT && this.status == ServerStatus.FULL_UPDATE_STATUS) {
            Message message = ReplicationMessages.NOTE_BAD_GEN_ID_IN_FULL_UPDATE.get(Integer.toString(this.replicationServerDomain.getReplicationServer().getServerId()), this.getServiceId(), Integer.toString(this.serverId), Long.toString(this.generationId), Long.toString(newGenId));
            ErrorLogger.logError(message);
            return;
        }
        ServerStatus newStatus = StatusMachine.computeNewStatus(this.status, event);
        if (newStatus == ServerStatus.INVALID_STATUS) {
            Message msg = ReplicationMessages.ERR_RS_CANNOT_CHANGE_STATUS.get(this.getServiceId(), Integer.toString(this.serverId), this.status.toString(), event.toString());
            ErrorLogger.logError(msg);
            return;
        }
        ChangeStatusMsg csMsg = new ChangeStatusMsg(newStatus, ServerStatus.INVALID_STATUS);
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In RS " + this.replicationServerDomain.getReplicationServer().getServerId() + " Sending change status for reset gen id to " + this.getServerId() + " for baseDn " + this.getServiceId() + ":\n" + csMsg);
        }
        this.session.publish(csMsg);
        this.status = newStatus;
    }

    public ServerStatus changeStatusFromStatusAnalyzer(StatusMachineEvent event) throws IOException {
        ServerStatus newStatus = StatusMachine.computeNewStatus(this.status, event);
        if (newStatus == ServerStatus.INVALID_STATUS) {
            Message msg = ReplicationMessages.ERR_RS_CANNOT_CHANGE_STATUS.get(this.getServiceId(), Integer.toString(this.serverId), this.status.toString(), event.toString());
            ErrorLogger.logError(msg);
            return newStatus;
        }
        ChangeStatusMsg csMsg = new ChangeStatusMsg(newStatus, ServerStatus.INVALID_STATUS);
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In RS " + this.replicationServerDomain.getReplicationServer().getServerId() + " Sending change status from status analyzer to " + this.getServerId() + " for baseDn " + this.getServiceId() + ":\n" + csMsg);
        }
        this.session.publish(csMsg);
        this.status = newStatus;
        return newStatus;
    }

    @Override
    public ArrayList<Attribute> getMonitorData() {
        List attributes = super.getMonitorData();
        ((ArrayList)attributes).add(Attributes.create("replica", this.serverURL));
        ((ArrayList)attributes).add(Attributes.create("connected-to", this.replicationServerDomain.getReplicationServer().getMonitorInstanceName()));
        MonitorData md = this.replicationServerDomain.getDomainMonitorData();
        Long approxFirstMissingDate = md.getApproxFirstMissingDate(this.serverId);
        if (approxFirstMissingDate != null && approxFirstMissingDate > 0L) {
            Date date = new Date(approxFirstMissingDate);
            ((ArrayList)attributes).add(Attributes.create("approx-older-change-not-synchronized", date.toString()));
            ((ArrayList)attributes).add(Attributes.create("approx-older-change-not-synchronized-millis", String.valueOf(approxFirstMissingDate)));
        }
        long missingChanges = md.getMissingChanges(this.serverId);
        ((ArrayList)attributes).add(Attributes.create("missing-changes", String.valueOf(missingChanges)));
        long delay = md.getApproxDelay(this.serverId);
        ((ArrayList)attributes).add(Attributes.create("approximate-delay", String.valueOf(delay)));
        AttributeBuilder builder = new AttributeBuilder("server-state");
        ServerState state = md.getLDAPServerState(this.serverId);
        if (state != null) {
            for (String str : state.toStringSet()) {
                builder.add(str);
            }
            ((ArrayList)attributes).add(builder.toAttribute());
        }
        return attributes;
    }

    @Override
    public String getMonitorInstanceName() {
        return "Connected directory server DS(" + this.serverId + ") " + this.serverURL + ",cn=" + this.replicationServerDomain.getMonitorInstanceName();
    }

    @Override
    public ServerStatus getStatus() {
        return this.status;
    }

    @Override
    public boolean isDataServer() {
        return true;
    }

    public ServerStatus processNewStatus(ChangeStatusMsg csMsg) {
        ServerStatus reqStatus = csMsg.getNewStatus();
        StatusMachineEvent event = StatusMachineEvent.statusToEvent(reqStatus);
        if (event == StatusMachineEvent.INVALID_EVENT) {
            Message msg = ReplicationMessages.ERR_RS_INVALID_NEW_STATUS.get(reqStatus.toString(), this.getServiceId(), Integer.toString(this.serverId));
            ErrorLogger.logError(msg);
            return ServerStatus.INVALID_STATUS;
        }
        ServerStatus newStatus = StatusMachine.computeNewStatus(this.status, event);
        if (newStatus == ServerStatus.INVALID_STATUS) {
            Message msg = ReplicationMessages.ERR_RS_CANNOT_CHANGE_STATUS.get(this.getServiceId(), Integer.toString(this.serverId), this.status.toString(), event.toString());
            ErrorLogger.logError(msg);
            return ServerStatus.INVALID_STATUS;
        }
        this.status = newStatus;
        return this.status;
    }

    public boolean processStartFromRemote(ServerStartMsg serverStartMsg) throws DirectoryException {
        this.session.setProtocolVersion(ProtocolVersion.getCompatibleVersion(serverStartMsg.getVersion()));
        this.tmpGenerationId = serverStartMsg.getGenerationId();
        this.serverId = serverStartMsg.getServerId();
        this.serverURL = serverStartMsg.getServerURL();
        this.groupId = serverStartMsg.getGroupId();
        this.heartbeatInterval = serverStartMsg.getHeartbeatInterval();
        this.setServiceIdAndDomain(serverStartMsg.getBaseDn(), true);
        this.setInitialServerState(serverStartMsg.getServerState());
        this.setSendWindowSize(serverStartMsg.getWindowSize());
        if (this.heartbeatInterval < 0L) {
            this.heartbeatInterval = 0L;
        }
        return serverStartMsg.getSSLEncryption();
    }

    private TopologyMsg sendTopoToRemoteDS() throws IOException {
        TopologyMsg outTopoMsg = this.replicationServerDomain.createTopologyMsgForDS(this.serverId);
        this.sendTopoInfo(outTopoMsg);
        return outTopoMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startFromRemoteDS(ServerStartMsg inServerStartMsg) {
        try {
            StartSessionMsg inStartSessionMsg;
            this.localGenerationId = -1L;
            this.oldGenerationId = -100L;
            boolean sessionInitiatorSSLEncryption = this.processStartFromRemote(inServerStartMsg);
            if (this.replicationServerDomain.getConnectedDSs().containsKey(inServerStartMsg.getServerId())) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception e) {
                    this.abortStart(null);
                    if (this.replicationServerDomain != null && this.replicationServerDomain.hasLock()) {
                        this.replicationServerDomain.release();
                    }
                    return;
                }
            }
            this.lockDomain(false);
            this.oldGenerationId = this.localGenerationId = this.replicationServerDomain.getGenerationId();
            if (!this.replicationServerDomain.checkForDuplicateDS(this)) {
                this.abortStart(null);
                return;
            }
            StartMsg outStartMsg = this.sendStartToRemote();
            this.logStartHandshakeRCVandSND(inServerStartMsg, outStartMsg);
            if (!sessionInitiatorSSLEncryption) {
                this.session.stopEncryption();
            }
            if ((inStartSessionMsg = this.waitAndProcessStartSessionFromRemoteDS()) == null) {
                this.logStopReceived();
                this.abortStart(null);
                return;
            }
            try {
                TopologyMsg outTopoMsg = this.sendTopoToRemoteDS();
                this.logStartSessionHandshake(inStartSessionMsg, outTopoMsg);
            }
            catch (IOException e) {
                Message errMessage = ReplicationMessages.ERR_DS_DISCONNECTED_DURING_HANDSHAKE.get(Integer.toString(inServerStartMsg.getServerId()), Integer.toString(this.replicationServerDomain.getReplicationServer().getServerId()));
                throw new DirectoryException(ResultCode.OTHER, errMessage);
            }
            catch (NotSupportedOldVersionPDUException e) {
                throw new DirectoryException(ResultCode.OTHER, null, null);
            }
            catch (Exception e) {
                throw new DirectoryException(ResultCode.OTHER, null, null);
            }
            this.createMonitoringPublisher();
            this.replicationServerDomain.register(this);
            Message message = ReplicationMessages.INFO_REPLICATION_SERVER_CONNECTION_FROM_DS.get(this.getReplicationServerId(), this.getServerId(), this.replicationServerDomain.getBaseDn(), this.session.getReadableRemoteAddress());
            ErrorLogger.logError(message);
            super.finalizeStart();
        }
        catch (DirectoryException de) {
            this.abortStart(de.getMessageObject());
        }
        catch (Exception e) {
            this.abortStart(null);
        }
        finally {
            if (this.replicationServerDomain != null && this.replicationServerDomain.hasLock()) {
                this.replicationServerDomain.release();
            }
        }
    }

    private StartMsg sendStartToRemote() throws IOException {
        StartMsg startMsg = this.getProtocolVersion() < 4 ? new ReplServerStartMsg(this.replicationServerId, this.replicationServerURL, this.getServiceId(), this.maxRcvWindow, this.replicationServerDomain.getDbServerState(), this.localGenerationId, this.sslEncryption, this.getLocalGroupId(), this.replicationServerDomain.getReplicationServer().getDegradedStatusThreshold()) : new ReplServerStartDSMsg(this.replicationServerId, this.replicationServerURL, this.getServiceId(), this.maxRcvWindow, this.replicationServerDomain.getDbServerState(), this.localGenerationId, this.sslEncryption, this.getLocalGroupId(), this.replicationServerDomain.getReplicationServer().getDegradedStatusThreshold(), this.replicationServer.getWeight(), this.replicationServerDomain.getConnectedLDAPservers().size());
        this.send(startMsg);
        return startMsg;
    }

    public DSInfo toDSInfo() {
        return new DSInfo(this.serverId, this.serverURL, this.replicationServerId, this.generationId, this.status, this.assuredFlag, this.assuredMode, this.safeDataLevel, this.groupId, this.refUrls, this.eclIncludes, this.eclIncludesForDeletes, this.getProtocolVersion());
    }

    public String toString() {
        if (this.serverId != 0) {
            StringBuilder builder = new StringBuilder("Replica DS(");
            builder.append(this.serverId);
            builder.append(") for domain \"");
            builder.append(this.replicationServerDomain.getBaseDn());
            builder.append("\"");
            return builder.toString();
        }
        return "Unknown server";
    }

    private StartSessionMsg waitAndProcessStartSessionFromRemoteDS() throws DirectoryException, IOException, ClassNotFoundException, DataFormatException, NotSupportedOldVersionPDUException {
        ReplicationMsg msg = this.session.receive();
        if (msg instanceof StopMsg) {
            return null;
        }
        if (!(msg instanceof StartSessionMsg)) {
            Message message = Message.raw("Protocol error: StartSessionMsg required." + msg + " received.", new Object[0]);
            this.abortStart(message);
            return null;
        }
        StartSessionMsg startSessionMsg = (StartSessionMsg)msg;
        this.status = startSessionMsg.getStatus();
        if (!StatusMachine.isValidInitialStatus(this.status)) {
            Message message = ReplicationMessages.ERR_RS_INVALID_INIT_STATUS.get(this.status.toString(), this.getServiceId(), Integer.toString(this.serverId));
            throw new DirectoryException(ResultCode.OTHER, message);
        }
        this.refUrls = startSessionMsg.getReferralsURLs();
        this.assuredFlag = startSessionMsg.isAssured();
        this.assuredMode = startSessionMsg.getAssuredMode();
        this.safeDataLevel = startSessionMsg.getSafeDataLevel();
        this.eclIncludes = startSessionMsg.getEclIncludes();
        this.eclIncludesForDeletes = startSessionMsg.getEclIncludesForDeletes();
        this.generationId = this.tmpGenerationId;
        if (this.localGenerationId > 0L) {
            if (this.generationId != this.localGenerationId) {
                Message message = ReplicationMessages.WARN_BAD_GENERATION_ID_FROM_DS.get(this.serverId, this.session.getReadableRemoteAddress(), this.generationId, this.getServiceId(), this.getReplicationServerId(), this.localGenerationId);
                ErrorLogger.logError(message);
            }
        } else if (this.generationId > 0L && !this.getServerState().isEmpty()) {
            Message message = ReplicationMessages.WARN_BAD_GENERATION_ID_FROM_DS.get(this.serverId, this.session.getReadableRemoteAddress(), this.generationId, this.getServiceId(), this.getReplicationServerId(), this.localGenerationId);
            ErrorLogger.logError(message);
        } else {
            this.oldGenerationId = this.replicationServerDomain.changeGenerationId(this.generationId, false);
        }
        return startSessionMsg;
    }

    public void receiveNewStatus(ChangeStatusMsg csMsg) {
        if (this.replicationServerDomain != null) {
            this.replicationServerDomain.processNewStatus(this, csMsg);
        }
    }
}

