/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opends.server.replication.common.AssuredMode;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.protocol.AckMsg;
import org.opends.server.replication.server.ServerHandler;

public abstract class ExpectedAcksInfo {
    private ServerHandler requesterServerHandler = null;
    private AssuredMode assuredMode = null;
    protected ChangeNumber changeNumber = null;
    private boolean completed = false;
    protected Map<Integer, Boolean> expectedServersAckStatus = new HashMap<Integer, Boolean>();
    protected List<Integer> serversInTimeout = null;

    protected ExpectedAcksInfo(ChangeNumber changeNumber, ServerHandler requesterServerHandler, AssuredMode assuredMode, List<Integer> expectedServers) {
        this.requesterServerHandler = requesterServerHandler;
        this.assuredMode = assuredMode;
        this.changeNumber = changeNumber;
        for (Integer serverId : expectedServers) {
            this.expectedServersAckStatus.put(serverId, false);
        }
    }

    public ServerHandler getRequesterServer() {
        return this.requesterServerHandler;
    }

    public List<Integer> getTimeoutServers() {
        return this.serversInTimeout;
    }

    public AssuredMode getAssuredMode() {
        return this.assuredMode;
    }

    public abstract boolean processReceivedAck(ServerHandler var1, AckMsg var2);

    public abstract AckMsg createAck(boolean var1);

    public boolean isCompleted() {
        return this.completed;
    }

    public void completed() {
        this.completed = true;
    }
}

