/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import java.io.IOException;
import org.opends.server.api.DirectoryThread;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.protocol.MonitorMsg;
import org.opends.server.replication.server.DataServerHandler;
import org.opends.server.replication.server.MonitorData;
import org.opends.server.replication.server.ReplicationServerDomain;

public class MonitoringPublisher
extends DirectoryThread {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final ReplicationServerDomain replicationServerDomain;
    private volatile long period;
    private final Object shutdownLock = new Object();

    public MonitoringPublisher(ReplicationServerDomain replicationServerDomain, long period) {
        super("Replication server RS(" + replicationServerDomain.getReplicationServer().getServerId() + ") monitor publisher for domain \"" + replicationServerDomain.getBaseDn() + "\"");
        this.replicationServerDomain = replicationServerDomain;
        this.period = period;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Monitoring publisher starting for dn " + this.replicationServerDomain.getBaseDn());
        }
        try {
            while (!this.isShutdownInitiated()) {
                MonitorData monitorData = this.replicationServerDomain.computeDomainMonitorData();
                int localServerId = this.replicationServerDomain.getReplicationServer().getServerId();
                MonitorMsg monitorMsg = this.replicationServerDomain.createGlobalTopologyMonitorMsg(localServerId, 0, monitorData);
                for (DataServerHandler serverHandler : this.replicationServerDomain.getConnectedDSs().values()) {
                    if (this.isShutdownInitiated()) break;
                    try {
                        serverHandler.send(monitorMsg);
                    }
                    catch (IOException e) {}
                }
                Object object = this.shutdownLock;
                synchronized (object) {
                    if (!this.isShutdownInitiated()) {
                        this.shutdownLock.wait(this.period);
                    }
                }
            }
        }
        catch (InterruptedException e) {
            TRACER.debugInfo("Monitoring publisher for dn " + this.replicationServerDomain.getBaseDn() + " in RS " + this.replicationServerDomain.getReplicationServer().getServerId() + " has been interrupted while sleeping.");
        }
        TRACER.debugInfo("Monitoring publisher for dn " + this.replicationServerDomain.getBaseDn() + " is terminated." + " This is in RS " + this.replicationServerDomain.getReplicationServer().getServerId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.initiateShutdown();
        Object object = this.shutdownLock;
        synchronized (object) {
            this.shutdownLock.notifyAll();
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Shutting down monitoring publisher for dn " + this.replicationServerDomain.getBaseDn() + " in RS " + this.replicationServerDomain.getReplicationServer().getServerId());
        }
    }

    public void waitForShutdown() {
        try {
            this.join(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void setPeriod(long period) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Monitoring publisher for dn " + this.replicationServerDomain.getBaseDn() + " changing period value to " + period);
        }
        this.period = period;
    }
}

