/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import java.io.IOException;
import org.opends.messages.ReplicationMessages;
import org.opends.server.api.DirectoryThread;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.common.ServerStatus;
import org.opends.server.replication.protocol.AckMsg;
import org.opends.server.replication.protocol.ChangeStatusMsg;
import org.opends.server.replication.protocol.ChangeTimeHeartbeatMsg;
import org.opends.server.replication.protocol.MonitorMsg;
import org.opends.server.replication.protocol.MonitorRequestMsg;
import org.opends.server.replication.protocol.NotSupportedOldVersionPDUException;
import org.opends.server.replication.protocol.ResetGenerationIdMsg;
import org.opends.server.replication.protocol.RoutableMsg;
import org.opends.server.replication.protocol.Session;
import org.opends.server.replication.protocol.StopMsg;
import org.opends.server.replication.protocol.TopologyMsg;
import org.opends.server.replication.protocol.UpdateMsg;
import org.opends.server.replication.protocol.WindowMsg;
import org.opends.server.replication.protocol.WindowProbeMsg;
import org.opends.server.replication.server.DataServerHandler;
import org.opends.server.replication.server.ReplicationServerHandler;
import org.opends.server.replication.server.ServerHandler;
import org.opends.server.util.StaticUtils;

public class ServerReader
extends DirectoryThread {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final Session session;
    private final ServerHandler handler;
    private final String remoteAddress;

    public ServerReader(Session session, ServerHandler handler) {
        super("Replication server RS(" + handler.getReplicationServerId() + ") reading from " + handler.toString() + " at " + session.getReadableRemoteAddress());
        this.session = session;
        this.handler = handler;
        this.remoteAddress = session.getReadableRemoteAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block54: {
            errMessage = null;
            if (DebugLogger.debugEnabled()) {
                ServerReader.TRACER.debugInfo(this.getName() + " starting");
            }
            try lbl-1000:
            // 3 sources

            {
                while (true) {
                    msg = this.session.receive();
                    if (DebugLogger.debugEnabled()) {
                        ServerReader.TRACER.debugInfo("In " + this.getName() + " receives " + msg);
                    }
                    if (msg instanceof AckMsg) {
                        ack = (AckMsg)msg;
                        this.handler.checkWindow();
                        this.handler.processAck(ack);
                    } else if (msg instanceof UpdateMsg) {
                        filtered = false;
                        if (this.handler.isDataServer()) {
                            dsStatus = this.handler.getStatus();
                            if (dsStatus == ServerStatus.BAD_GEN_ID_STATUS || dsStatus == ServerStatus.FULL_UPDATE_STATUS) {
                                referenceGenerationId = this.handler.getReferenceGenId();
                                if (dsStatus == ServerStatus.BAD_GEN_ID_STATUS) {
                                    ErrorLogger.logError(ReplicationMessages.WARN_IGNORING_UPDATE_FROM_DS_BADGENID.get(this.handler.getReplicationServerId(), ((UpdateMsg)msg).getChangeNumber().toString(), this.handler.getServiceId(), this.handler.getServerId(), this.session.getReadableRemoteAddress(), this.handler.getGenerationId(), referenceGenerationId));
                                }
                                if (dsStatus == ServerStatus.FULL_UPDATE_STATUS) {
                                    ErrorLogger.logError(ReplicationMessages.WARN_IGNORING_UPDATE_FROM_DS_FULLUP.get(this.handler.getReplicationServerId(), ((UpdateMsg)msg).getChangeNumber().toString(), this.handler.getServiceId(), this.handler.getServerId(), this.session.getReadableRemoteAddress()));
                                }
                                filtered = true;
                            }
                        } else {
                            referenceGenerationId = this.handler.getReferenceGenId();
                            if (referenceGenerationId > 0L && referenceGenerationId != this.handler.getGenerationId()) {
                                ErrorLogger.logError(ReplicationMessages.WARN_IGNORING_UPDATE_FROM_RS.get(this.handler.getReplicationServerId(), ((UpdateMsg)msg).getChangeNumber().toString(), this.handler.getServiceId(), this.handler.getServerId(), this.session.getReadableRemoteAddress(), this.handler.getGenerationId(), referenceGenerationId));
                                filtered = true;
                            }
                        }
                        if (!filtered) {
                            update = (UpdateMsg)msg;
                            this.handler.decAndCheckWindow();
                            this.handler.put(update);
                        }
                    } else if (msg instanceof WindowMsg) {
                        this.handler.updateWindow((WindowMsg)msg);
                    } else if (msg instanceof MonitorRequestMsg) {
                        this.handler.processMonitorRequestMsg((MonitorRequestMsg)msg);
                    } else if (msg instanceof MonitorMsg) {
                        this.handler.processMonitorMsg((MonitorMsg)msg);
                    } else if (msg instanceof RoutableMsg) {
                        this.handler.process((RoutableMsg)msg);
                    } else if (msg instanceof ResetGenerationIdMsg) {
                        genIdMsg = (ResetGenerationIdMsg)msg;
                        this.handler.processResetGenId(genIdMsg);
                    } else if (msg instanceof WindowProbeMsg) {
                        windowProbeMsg = (WindowProbeMsg)msg;
                        this.handler.process(windowProbeMsg);
                    } else if (msg instanceof TopologyMsg) {
                        topoMsg = (TopologyMsg)msg;
                        rsh = (ReplicationServerHandler)this.handler;
                        rsh.receiveTopoInfoFromRS(topoMsg);
                    } else if (msg instanceof ChangeStatusMsg) {
                        csMsg = (ChangeStatusMsg)msg;
                        try {
                            dsh = (DataServerHandler)this.handler;
                            dsh.receiveNewStatus(csMsg);
                        }
                        catch (Exception e) {
                            errMessage = ReplicationMessages.ERR_RECEIVED_CHANGE_STATUS_NOT_FROM_DS.get(this.handler.getServiceId(), Integer.toString(this.handler.getServerId()), csMsg.toString());
                            ErrorLogger.logError(errMessage);
                        }
                    } else if (msg instanceof ChangeTimeHeartbeatMsg) {
                        cthbMsg = (ChangeTimeHeartbeatMsg)msg;
                        this.handler.process(cthbMsg);
                    } else {
                        if (msg instanceof StopMsg) {
                            if (DebugLogger.debugEnabled()) {
                                ServerReader.TRACER.debugInfo(this.handler.toString() + " has properly " + "disconnected from this replication server " + Integer.toString(this.handler.getReplicationServerId()));
                            }
                            return;
                        }
                        if (msg == null) {
                            errMessage = ReplicationMessages.NOTE_READER_NULL_MSG.get(this.handler.toString());
                            ErrorLogger.logError(errMessage);
                            return;
                        }
                    }
                    continue;
                    break;
                }
            }
            catch (NotSupportedOldVersionPDUException e) {
                if (!DebugLogger.debugEnabled()) ** GOTO lbl-1000
                ServerReader.TRACER.debugInfo("In " + this.getName() + " " + StaticUtils.stackTraceToSingleLineString(e));
                ** continue;
            }
            {
                catch (IOException e) {
                    if (DebugLogger.debugEnabled()) {
                        ServerReader.TRACER.debugInfo("In " + this.getName() + " " + StaticUtils.stackTraceToSingleLineString(e));
                    }
                    if (!this.handler.shuttingDown()) {
                        errMessage = this.handler.isDataServer() != false ? ReplicationMessages.ERR_DS_BADLY_DISCONNECTED.get(this.handler.getReplicationServerId(), this.handler.getServerId(), this.remoteAddress, this.handler.getServiceId()) : ReplicationMessages.ERR_RS_BADLY_DISCONNECTED.get(this.handler.getReplicationServerId(), this.handler.getServerId(), this.remoteAddress, this.handler.getServiceId());
                        ErrorLogger.logError(errMessage);
                    }
                    if (DebugLogger.debugEnabled()) {
                        ServerReader.TRACER.debugInfo("In " + this.getName() + " closing the session");
                    }
                    this.session.close();
                    this.handler.doStop();
                    if (DebugLogger.debugEnabled()) {
                        ServerReader.TRACER.debugInfo(this.getName() + " stopped " + errMessage);
                    }
                    break block54;
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        ServerReader.TRACER.debugInfo("In " + this.getName() + " " + StaticUtils.stackTraceToSingleLineString(e));
                    }
                    errMessage = ReplicationMessages.NOTE_READER_EXCEPTION.get(this.handler.toString());
                    ErrorLogger.logError(errMessage);
                    break block54;
                }
            }
            finally {
                if (DebugLogger.debugEnabled()) {
                    ServerReader.TRACER.debugInfo("In " + this.getName() + " closing the session");
                }
                this.session.close();
                this.handler.doStop();
                if (DebugLogger.debugEnabled()) {
                    ServerReader.TRACER.debugInfo(this.getName() + " stopped " + errMessage);
                }
            }
        }
    }
}

