/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.opends.server.admin.std.server.MonitorProviderCfg;
import org.opends.server.api.MonitorProvider;
import org.opends.server.core.DirectoryServer;
import org.opends.server.replication.service.ReplicationDomain;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.Attributes;

public class ReplicationMonitor
extends MonitorProvider<MonitorProviderCfg> {
    private ReplicationDomain domain;

    public ReplicationMonitor(ReplicationDomain domain) {
        this.domain = domain;
    }

    @Override
    public void initializeMonitorProvider(MonitorProviderCfg configuration) {
    }

    @Override
    public String getMonitorInstanceName() {
        return "Directory server DS(" + this.domain.getServerId() + ") " + this.domain.getLocalUrl() + ",cn=" + this.domain.getServiceID().replace(',', '_').replace('=', '_') + ",cn=Replication";
    }

    public ArrayList<Attribute> getMonitorData() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Attribute attr = Attributes.create("domain-name", this.domain.getServiceID());
        attributes.add(attr);
        attr = Attributes.create("connected-to", this.domain.getReplicationServer());
        attributes.add(attr);
        ReplicationMonitor.addMonitorData(attributes, "lost-connections", this.domain.getNumLostConnections());
        ReplicationMonitor.addMonitorData(attributes, "received-updates", this.domain.getNumRcvdUpdates());
        ReplicationMonitor.addMonitorData(attributes, "sent-updates", this.domain.getNumSentUpdates());
        ReplicationMonitor.addMonitorData(attributes, "replayed-updates", this.domain.getNumProcessedUpdates());
        ReplicationMonitor.addMonitorData(attributes, "server-id", this.domain.getServerId());
        ReplicationMonitor.addMonitorData(attributes, "max-rcv-window", this.domain.getMaxRcvWindow());
        ReplicationMonitor.addMonitorData(attributes, "current-rcv-window", this.domain.getCurrentRcvWindow());
        ReplicationMonitor.addMonitorData(attributes, "max-send-window", this.domain.getMaxSendWindow());
        ReplicationMonitor.addMonitorData(attributes, "current-send-window", this.domain.getCurrentSendWindow());
        String ATTR_SERVER_STATE = "server-state";
        AttributeType type = DirectoryServer.getDefaultAttributeType("server-state");
        AttributeBuilder builder = new AttributeBuilder(type, "server-state");
        for (String str : this.domain.getServerState().toStringSet()) {
            builder.add(AttributeValues.create(type, str));
        }
        attributes.add(builder.toAttribute());
        attributes.add(Attributes.create("ssl-encryption", String.valueOf(this.domain.isSessionEncrypted())));
        attributes.add(Attributes.create("generation-id", String.valueOf(this.domain.getGenerationID())));
        if (this.domain.importInProgress()) {
            ReplicationMonitor.addMonitorData(attributes, "total-update", "import");
            ReplicationMonitor.addMonitorData(attributes, "total-update-entry-count", this.domain.getTotalEntryCount());
            ReplicationMonitor.addMonitorData(attributes, "total-update-entry-left", this.domain.getLeftEntryCount());
        }
        if (this.domain.exportInProgress()) {
            ReplicationMonitor.addMonitorData(attributes, "total-update", "export");
            ReplicationMonitor.addMonitorData(attributes, "total-update-entry-count", this.domain.getTotalEntryCount());
            ReplicationMonitor.addMonitorData(attributes, "total-update-entry-left", this.domain.getLeftEntryCount());
        }
        Collection<Attribute> additionalMonitoring = this.domain.getAdditionalMonitoring();
        attributes.addAll(additionalMonitoring);
        ReplicationMonitor.addMonitorData(attributes, "assured-sr-sent-updates", this.domain.getAssuredSrSentUpdates());
        ReplicationMonitor.addMonitorData(attributes, "assured-sr-acknowledged-updates", this.domain.getAssuredSrAcknowledgedUpdates());
        ReplicationMonitor.addMonitorData(attributes, "assured-sr-not-acknowledged-updates", this.domain.getAssuredSrNotAcknowledgedUpdates());
        ReplicationMonitor.addMonitorData(attributes, "assured-sr-timeout-updates", this.domain.getAssuredSrTimeoutUpdates());
        ReplicationMonitor.addMonitorData(attributes, "assured-sr-wrong-status-updates", this.domain.getAssuredSrWrongStatusUpdates());
        ReplicationMonitor.addMonitorData(attributes, "assured-sr-replay-error-updates", this.domain.getAssuredSrReplayErrorUpdates());
        String ATTR_ASS_SR_SRV = "assured-sr-server-not-acknowledged-updates";
        type = DirectoryServer.getDefaultAttributeType("assured-sr-server-not-acknowledged-updates");
        builder = new AttributeBuilder(type, "assured-sr-server-not-acknowledged-updates");
        Map<Integer, Integer> srSrvNotAckUps = this.domain.getAssuredSrServerNotAcknowledgedUpdates();
        if (srSrvNotAckUps.size() > 0) {
            for (Integer serverId : srSrvNotAckUps.keySet()) {
                String str = serverId + ":" + srSrvNotAckUps.get(serverId);
                builder.add(AttributeValues.create(type, str));
            }
            attributes.add(builder.toAttribute());
        }
        ReplicationMonitor.addMonitorData(attributes, "assured-sr-received-updates", this.domain.getAssuredSrReceivedUpdates());
        ReplicationMonitor.addMonitorData(attributes, "assured-sr-received-updates-acked", this.domain.getAssuredSrReceivedUpdatesAcked());
        ReplicationMonitor.addMonitorData(attributes, "assured-sr-received-updates-not-acked", this.domain.getAssuredSrReceivedUpdatesNotAcked());
        ReplicationMonitor.addMonitorData(attributes, "assured-sd-sent-updates", this.domain.getAssuredSdSentUpdates());
        ReplicationMonitor.addMonitorData(attributes, "assured-sd-acknowledged-updates", this.domain.getAssuredSdAcknowledgedUpdates());
        ReplicationMonitor.addMonitorData(attributes, "assured-sd-timeout-updates", this.domain.getAssuredSdTimeoutUpdates());
        String ATTR_ASS_SD_SRV = "assured-sd-server-timeout-updates";
        type = DirectoryServer.getDefaultAttributeType("assured-sd-server-timeout-updates");
        builder = new AttributeBuilder(type, "assured-sd-server-timeout-updates");
        Map<Integer, Integer> sdSrvTimUps = this.domain.getAssuredSdServerTimeoutUpdates();
        if (sdSrvTimUps.size() > 0) {
            for (Integer serverId : sdSrvTimUps.keySet()) {
                String str = serverId + ":" + sdSrvTimUps.get(serverId);
                builder.add(AttributeValues.create(type, str));
            }
            attributes.add(builder.toAttribute());
        }
        ReplicationMonitor.addMonitorData(attributes, "last-status-change-date", this.domain.getLastStatusChangeDate().toString());
        ReplicationMonitor.addMonitorData(attributes, "status", this.domain.getStatus().toString());
        return attributes;
    }

    public static void addMonitorData(ArrayList<Attribute> attributes, String name, int value) {
        AttributeType type = DirectoryServer.getDefaultAttributeType(name);
        attributes.add(Attributes.create(type, AttributeValues.create(type, String.valueOf(value))));
    }

    public static void addMonitorData(ArrayList<Attribute> attributes, String name, long value) {
        AttributeType type = DirectoryServer.getDefaultAttributeType(name);
        attributes.add(Attributes.create(type, AttributeValues.create(type, String.valueOf(value))));
    }

    public static void addMonitorData(ArrayList<Attribute> attributes, String name, String value) {
        AttributeType type = DirectoryServer.getDefaultAttributeType(name);
        attributes.add(Attributes.create(type, AttributeValues.create(type, value)));
    }
}

