/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Collection;
import java.util.Collections;
import org.opends.messages.Message;
import org.opends.messages.SchemaMessages;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;

class BitStringEqualityMatchingRule
extends EqualityMatchingRule {
    @Override
    public Collection<String> getAllNames() {
        return Collections.singleton(this.getName());
    }

    @Override
    public String getName() {
        return "bitStringMatch";
    }

    @Override
    public String getOID() {
        return "2.5.13.16";
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getSyntaxOID() {
        return "1.3.6.1.4.1.1466.115.121.1.6";
    }

    @Override
    public ByteString normalizeValue(ByteSequence value) throws DirectoryException {
        String valueString = ((Object)value).toString().toUpperCase();
        int length = valueString.length();
        if (length < 3) {
            Message message = SchemaMessages.WARN_ATTR_SYNTAX_BIT_STRING_TOO_SHORT.get(((Object)value).toString());
            switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                case REJECT: {
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                }
                case WARN: {
                    ErrorLogger.logError(message);
                    return ByteString.valueOf(valueString);
                }
            }
            return ByteString.valueOf(valueString);
        }
        if (valueString.charAt(0) != '\'' || valueString.charAt(length - 2) != '\'' || valueString.charAt(length - 1) != 'B') {
            Message message = SchemaMessages.WARN_ATTR_SYNTAX_BIT_STRING_NOT_QUOTED.get(((Object)value).toString());
            switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                case REJECT: {
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                }
                case WARN: {
                    ErrorLogger.logError(message);
                    return ByteString.valueOf(valueString);
                }
            }
            return ByteString.valueOf(valueString);
        }
        block15: for (int i = 1; i < length - 2; ++i) {
            switch (valueString.charAt(i)) {
                case '0': 
                case '1': {
                    continue block15;
                }
                default: {
                    Message message = SchemaMessages.WARN_ATTR_SYNTAX_BIT_STRING_INVALID_BIT.get(((Object)value).toString(), String.valueOf(valueString.charAt(i)));
                    switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                        case REJECT: {
                            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                        }
                        case WARN: {
                            ErrorLogger.logError(message);
                            return ByteString.valueOf(valueString);
                        }
                    }
                    return ByteString.valueOf(valueString);
                }
            }
        }
        return ByteString.valueOf(valueString);
    }
}

