/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Collection;
import java.util.Collections;
import org.opends.messages.Message;
import org.opends.messages.SchemaMessages;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.ServerConstants;

class CaseExactIA5SubstringMatchingRule
extends SubstringMatchingRule {
    @Override
    public Collection<String> getAllNames() {
        return Collections.singleton(this.getName());
    }

    @Override
    public String getName() {
        return "caseExactIA5SubstringsMatch";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.26027.1.4.902";
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getSyntaxOID() {
        return "1.3.6.1.4.1.1466.115.121.1.58";
    }

    @Override
    public ByteString normalizeValue(ByteSequence value) throws DirectoryException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(((Object)value).toString().trim());
        int bufferLength = buffer.length();
        if (bufferLength == 0) {
            if (value.length() > 0) {
                return ServerConstants.SINGLE_SPACE_VALUE;
            }
            return ByteString.empty();
        }
        boolean logged = false;
        block4: for (int pos = bufferLength - 1; pos > 0; --pos) {
            char c = buffer.charAt(pos);
            if (c == ' ') {
                if (buffer.charAt(pos - 1) != ' ') continue;
                buffer.delete(pos, pos + 1);
                continue;
            }
            if ((c & 0x7F) == c) continue;
            Message message = SchemaMessages.WARN_ATTR_SYNTAX_IA5_ILLEGAL_CHARACTER.get(((Object)value).toString(), String.valueOf(c));
            switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                case REJECT: {
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                }
                case WARN: {
                    if (!logged) {
                        ErrorLogger.logError(message);
                        logged = true;
                    }
                    buffer.delete(pos, pos + 1);
                    continue block4;
                }
                default: {
                    buffer.delete(pos, pos + 1);
                }
            }
        }
        return ByteString.valueOf(buffer.toString());
    }

    @Override
    public ByteString normalizeSubstring(ByteSequence substring) throws DirectoryException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(((Object)substring).toString());
        int bufferLength = buffer.length();
        if (bufferLength == 0) {
            if (substring.length() > 0) {
                return ServerConstants.SINGLE_SPACE_VALUE;
            }
            return substring.toByteString();
        }
        boolean logged = false;
        block4: for (int pos = bufferLength - 1; pos > 0; --pos) {
            char c = buffer.charAt(pos);
            if (c == ' ') {
                if (buffer.charAt(pos - 1) != ' ') continue;
                buffer.delete(pos, pos + 1);
                continue;
            }
            if ((c & 0x7F) == c) continue;
            Message message = SchemaMessages.WARN_ATTR_SYNTAX_IA5_ILLEGAL_CHARACTER.get(((Object)substring).toString(), String.valueOf(c));
            switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                case REJECT: {
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                }
                case WARN: {
                    if (!logged) {
                        ErrorLogger.logError(message);
                        logged = true;
                    }
                    buffer.delete(pos, pos + 1);
                    continue block4;
                }
                default: {
                    buffer.delete(pos, pos + 1);
                }
            }
        }
        return ByteString.valueOf(buffer.toString());
    }
}

