/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.SchemaMessages;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.CountryStringAttributeSyntaxCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.schema.PrintableString;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.ResultCode;

public class CountryStringSyntax
extends AttributeSyntax<CountryStringAttributeSyntaxCfg>
implements ConfigurationChangeListener<CountryStringAttributeSyntaxCfg> {
    private ApproximateMatchingRule defaultApproximateMatchingRule;
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;
    private volatile CountryStringAttributeSyntaxCfg config;

    @Override
    public void initializeSyntax(CountryStringAttributeSyntaxCfg configuration) throws ConfigException {
        this.defaultApproximateMatchingRule = DirectoryServer.getApproximateMatchingRule("1.3.6.1.4.1.26027.1.4.1");
        if (this.defaultApproximateMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_APPROXIMATE_MATCHING_RULE.get("1.3.6.1.4.1.26027.1.4.1", "CountryString"));
        }
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.2");
        if (this.defaultEqualityMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_EQUALITY_MATCHING_RULE.get("2.5.13.2", "CountryString"));
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.3");
        if (this.defaultOrderingMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_ORDERING_MATCHING_RULE.get("2.5.13.3", "CountryString"));
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.4");
        if (this.defaultSubstringMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_SUBSTRING_MATCHING_RULE.get("2.5.13.4", "CountryString"));
        }
        this.config = configuration;
        this.config.addCountryStringChangeListener(this);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(CountryStringAttributeSyntaxCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(CountryStringAttributeSyntaxCfg configuration) {
        this.config = configuration;
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }

    @Override
    public String getSyntaxName() {
        return "CountryString";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.1466.115.121.1.11";
    }

    @Override
    public String getDescription() {
        return "Country String";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        return this.defaultOrderingMatchingRule;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        return this.defaultApproximateMatchingRule;
    }

    @Override
    public boolean valueIsAcceptable(ByteSequence value, MessageBuilder invalidReason) {
        String stringValue = ((Object)value).toString();
        if (stringValue.length() != 2) {
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_COUNTRY_STRING_INVALID_LENGTH.get(stringValue));
            return false;
        }
        if (this.config.isStrictFormat()) {
            if (stringValue.charAt(0) < 'A' || stringValue.charAt(0) > 'Z' || stringValue.charAt(1) < 'A' || stringValue.charAt(1) > 'Z') {
                invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_COUNTRY_NO_VALID_ISO_CODE.get(((Object)value).toString()));
                return false;
            }
        } else if (!PrintableString.isPrintableCharacter(stringValue.charAt(0)) || !PrintableString.isPrintableCharacter(stringValue.charAt(1))) {
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_COUNTRY_STRING_NOT_PRINTABLE.get(stringValue));
            return false;
        }
        return true;
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    @Override
    public boolean isHumanReadable() {
        return true;
    }
}

