/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Collection;
import java.util.Collections;
import org.opends.server.api.AbstractMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.schema.GeneralizedTimeSyntax;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;

public class GeneralizedTimeOrderingMatchingRule
extends AbstractMatchingRule
implements OrderingMatchingRule {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final long serialVersionUID = -6343622924726948145L;

    @Override
    public Collection<String> getAllNames() {
        return Collections.singleton(this.getName());
    }

    @Override
    public String getName() {
        return "generalizedTimeOrderingMatch";
    }

    @Override
    public String getOID() {
        return "2.5.13.28";
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getSyntaxOID() {
        return "1.3.6.1.4.1.1466.115.121.1.24";
    }

    @Override
    public ByteString normalizeValue(ByteSequence value) throws DirectoryException {
        try {
            long timestamp = GeneralizedTimeSyntax.decodeGeneralizedTimeValue(value);
            return ByteString.valueOf(GeneralizedTimeSyntax.format(timestamp));
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                case REJECT: {
                    throw de;
                }
                case WARN: {
                    ErrorLogger.logError(de.getMessageObject());
                    return value.toByteString();
                }
            }
            return value.toByteString();
        }
    }

    @Override
    public int compareValues(ByteSequence value1, ByteSequence value2) {
        try {
            long time1 = GeneralizedTimeSyntax.decodeGeneralizedTimeValue(value1);
            long time2 = GeneralizedTimeSyntax.decodeGeneralizedTimeValue(value2);
            if (time1 == time2) {
                return 0;
            }
            if (time1 > time2) {
                return 1;
            }
            return -1;
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            return 0;
        }
    }

    @Override
    public int compare(byte[] b1, byte[] b2) {
        return this.compareValues(ByteString.wrap(b1), ByteString.wrap(b2));
    }
}

