/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Collection;
import java.util.Collections;
import org.opends.messages.Message;
import org.opends.messages.SchemaMessages;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.schema.StringPrepProfile;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

class NumericStringSubstringMatchingRule
extends SubstringMatchingRule {
    @Override
    public Collection<String> getAllNames() {
        return Collections.singleton(this.getName());
    }

    @Override
    public String getName() {
        return "numericStringSubstringsMatch";
    }

    @Override
    public String getOID() {
        return "2.5.13.10";
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getSyntaxOID() {
        return "1.3.6.1.4.1.1466.115.121.1.58";
    }

    @Override
    public ByteString normalizeValue(ByteSequence value) throws DirectoryException {
        StringBuilder buffer = new StringBuilder();
        StringPrepProfile.prepareUnicode(buffer, value, true, false);
        int bufferLength = buffer.length();
        boolean logged = false;
        block4: for (int pos = bufferLength - 1; pos > 0; --pos) {
            char c = buffer.charAt(pos);
            if (StaticUtils.isDigit(c)) continue;
            if (c == ' ') {
                buffer.delete(pos, pos + 1);
                continue;
            }
            Message message = SchemaMessages.WARN_ATTR_SYNTAX_NUMERIC_STRING_ILLEGAL_CHAR.get(((Object)value).toString(), String.valueOf(c), pos);
            switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                case REJECT: {
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                }
                case WARN: {
                    if (logged) continue block4;
                    ErrorLogger.logError(message);
                    logged = true;
                }
            }
        }
        if (buffer.length() == 0) {
            return ByteString.empty();
        }
        return ByteString.valueOf(((Object)value).toString());
    }

    @Override
    public ByteString normalizeSubstring(ByteSequence substring) throws DirectoryException {
        return this.normalizeValue(substring);
    }
}

