/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Collection;
import java.util.Collections;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.SchemaMessages;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.MatchingRule;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.NameForm;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

class ObjectIdentifierEqualityMatchingRule
extends EqualityMatchingRule {
    @Override
    public Collection<String> getAllNames() {
        return Collections.singleton(this.getName());
    }

    @Override
    public String getName() {
        return "objectIdentifierMatch";
    }

    @Override
    public String getOID() {
        return "2.5.13.0";
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getSyntaxOID() {
        return "1.3.6.1.4.1.1466.115.121.1.38";
    }

    @Override
    public ByteString normalizeValue(ByteSequence value) throws DirectoryException {
        NameForm nameForm;
        MatchingRule matchingRule;
        ObjectClass objectClass;
        StringBuilder buffer = new StringBuilder();
        StaticUtils.toLowerCase(value, buffer, true);
        String lowerValue = buffer.toString();
        String schemaName = null;
        AttributeType attributeType = DirectoryServer.getAttributeType(lowerValue);
        if (attributeType != null) {
            schemaName = attributeType.getNameOrOID();
        }
        if (schemaName == null && (objectClass = DirectoryServer.getObjectClass(lowerValue)) != null) {
            schemaName = objectClass.getNameOrOID();
        }
        if (schemaName == null && (matchingRule = DirectoryServer.getMatchingRule(lowerValue)) != null) {
            schemaName = matchingRule.getNameOrOID();
        }
        if (schemaName == null && (nameForm = DirectoryServer.getNameForm(lowerValue)) != null) {
            schemaName = nameForm.getNameOrOID();
        }
        if (schemaName != null) {
            return ByteString.valueOf(StaticUtils.toLowerCase(schemaName));
        }
        switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
            case REJECT: {
                MessageBuilder invalidReason = new MessageBuilder();
                if (StaticUtils.isValidSchemaElement(lowerValue, 0, lowerValue.length(), invalidReason)) {
                    return ByteString.valueOf(lowerValue);
                }
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_OID_INVALID_VALUE.get(lowerValue, invalidReason.toString());
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
            case WARN: {
                MessageBuilder invalidReason = new MessageBuilder();
                if (!StaticUtils.isValidSchemaElement(lowerValue, 0, lowerValue.length(), invalidReason)) {
                    Message message = SchemaMessages.ERR_ATTR_SYNTAX_OID_INVALID_VALUE.get(lowerValue, invalidReason.toString());
                    ErrorLogger.logError(message);
                }
                return ByteString.valueOf(lowerValue);
            }
        }
        return ByteString.valueOf(lowerValue);
    }

    @Override
    public boolean areEqual(ByteSequence value1, ByteSequence value2) {
        return ((Object)value1).equals(value2);
    }
}

