/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Collection;
import java.util.Collections;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.schema.UserPasswordSyntax;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;

class UserPasswordEqualityMatchingRule
extends EqualityMatchingRule {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    @Override
    public Collection<String> getAllNames() {
        return Collections.singleton(this.getName());
    }

    @Override
    public String getName() {
        return "ds-mr-user-password-equality";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.26027.1.4.3";
    }

    @Override
    public String getDescription() {
        return "user password matching rule";
    }

    @Override
    public String getSyntaxOID() {
        return "1.3.6.1.4.1.26027.1.3.1";
    }

    @Override
    public ByteString normalizeValue(ByteSequence value) throws DirectoryException {
        return value.toByteString();
    }

    @Override
    public ConditionResult valuesMatch(ByteSequence attributeValue, ByteSequence assertionValue) {
        String[] userPWComponents;
        try {
            userPWComponents = UserPasswordSyntax.decodeUserPassword(((Object)attributeValue).toString());
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return ConditionResult.FALSE;
        }
        PasswordStorageScheme storageScheme = DirectoryServer.getPasswordStorageScheme(userPWComponents[0]);
        if (storageScheme == null) {
            return ConditionResult.FALSE;
        }
        if (storageScheme.passwordMatches(assertionValue, ByteString.valueOf(userPWComponents[1]))) {
            return ConditionResult.TRUE;
        }
        return ConditionResult.FALSE;
    }

    @Override
    public int generateHashCode(ByteSequence attributeValue) {
        return 1;
    }
}

