/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tasks;

import java.util.List;
import org.opends.messages.Category;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.Severity;
import org.opends.messages.TaskMessages;
import org.opends.server.backends.task.Task;
import org.opends.server.backends.task.TaskState;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.plugin.LDAPReplicationDomain;
import org.opends.server.tasks.TaskUtils;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ResultCode;
import org.opends.server.util.TimeThread;

public class PurgeConflictsHistoricalTask
extends Task {
    public static final int DEFAULT_MAX_DURATION = 3600;
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private String domainString = null;
    private LDAPReplicationDomain domain = null;
    private int purgeTaskMaxDurationInSec = 3600;
    TaskState initState;
    int updateAttrPeriod = 0;
    ChangeNumber lastCN;
    int purgeCount;

    private static final void debugInfo(String s) {
        if (DebugLogger.debugEnabled()) {
            System.out.println(Message.raw(Category.SYNC, Severity.NOTICE, s, new Object[0]));
            TRACER.debugInfo(s);
        }
    }

    @Override
    public Message getDisplayName() {
        return TaskMessages.INFO_TASK_PURGE_CONFLICTS_HIST_NAME.get();
    }

    @Override
    public void initializeTask() throws DirectoryException {
        if (TaskState.isDone(this.getTaskState())) {
            return;
        }
        Entry taskEntry = this.getTaskEntry();
        AttributeType typeDomainBase = DirectoryServer.getAttributeType("ds-task-purge-conflicts-historical-domain-dn", true);
        List<Attribute> attrList = taskEntry.getAttribute(typeDomainBase);
        this.domainString = TaskUtils.getSingleValueString(attrList);
        try {
            DN dn = DN.decode(this.domainString);
            this.domain = LDAPReplicationDomain.retrievesReplicationDomain(dn);
        }
        catch (DirectoryException e) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(TaskMessages.ERR_TASK_INITIALIZE_INVALID_DN.get());
            mb.append(e.getMessage());
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, mb.toMessage());
        }
        AttributeType typeMaxDuration = DirectoryServer.getAttributeType("ds-task-purge-conflicts-historical-maximum-duration", true);
        attrList = taskEntry.getAttribute(typeMaxDuration);
        String maxDurationStringInSec = TaskUtils.getSingleValueString(attrList);
        if (maxDurationStringInSec != null) {
            try {
                this.purgeTaskMaxDurationInSec = Integer.decode(maxDurationStringInSec);
            }
            catch (Exception e) {
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, TaskMessages.ERR_TASK_INVALID_ATTRIBUTE_VALUE.get("ds-task-purge-conflicts-historical-maximum-duration", e.getLocalizedMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TaskState runTask() {
        Boolean purgeCompletedInTime = false;
        if (DebugLogger.debugEnabled()) {
            PurgeConflictsHistoricalTask.debugInfo("[PURGE] PurgeConflictsHistoricalTask is starting on domain: " + this.domain.getServiceID() + "max duration (sec):" + this.purgeTaskMaxDurationInSec);
        }
        try {
            this.replaceAttributeValue("ds-task-purge-conflicts-historical-purge-completed-in-time", purgeCompletedInTime.toString());
            this.domain.purgeConflictsHistorical(this, TimeThread.getTime() + (long)(this.purgeTaskMaxDurationInSec * 1000));
            purgeCompletedInTime = true;
            this.replaceAttributeValue("ds-task-purge-conflicts-historical-purge-completed-in-time", purgeCompletedInTime.toString());
            this.initState = TaskState.COMPLETED_SUCCESSFULLY;
        }
        catch (DirectoryException de) {
            PurgeConflictsHistoricalTask.debugInfo("[PURGE] PurgeConflictsHistoricalTask exception " + de.getLocalizedMessage());
            if (de.getResultCode() != ResultCode.ADMIN_LIMIT_EXCEEDED) {
                this.logError(de.getMessageObject());
                this.initState = TaskState.STOPPED_BY_ERROR;
            } else {
                this.initState = TaskState.COMPLETED_SUCCESSFULLY;
            }
        }
        finally {
            try {
                this.replaceAttributeValue("ds-task-purge-conflicts-historical-purged-values-count", String.valueOf(this.purgeCount));
                this.replaceAttributeValue("ds-task-purge-conflicts-historical-last-purged-changenumber", this.lastCN.toStringUI());
                PurgeConflictsHistoricalTask.debugInfo("[PURGE] PurgeConflictsHistoricalTask write  attrs ");
            }
            catch (Exception e) {
                PurgeConflictsHistoricalTask.debugInfo("[PURGE] PurgeConflictsHistoricalTask exception " + e.getLocalizedMessage());
                this.initState = TaskState.STOPPED_BY_ERROR;
            }
        }
        if (DebugLogger.debugEnabled()) {
            PurgeConflictsHistoricalTask.debugInfo("[PURGE] PurgeConflictsHistoricalTask is ending with state:" + this.initState.toString() + " completedInTime:" + purgeCompletedInTime);
        }
        return this.initState;
    }

    public void setProgressStats(ChangeNumber lastCN, int purgeCount) {
        try {
            if (purgeCount == 0) {
                this.replaceAttributeValue("ds-task-purge-conflicts-historical-first-purged-changenumber", lastCN.toStringUI());
            }
            this.purgeCount = purgeCount;
            this.lastCN = lastCN;
            if (++this.updateAttrPeriod % 100 == 0) {
                this.replaceAttributeValue("ds-task-purge-conflicts-historical-purged-values-count", String.valueOf(purgeCount));
                this.replaceAttributeValue("ds-task-purge-conflicts-historical-last-purged-changenumber", lastCN.toStringUI());
                PurgeConflictsHistoricalTask.debugInfo("[PURGE] PurgeConflictsHistoricalTask write  attrs " + purgeCount);
            }
        }
        catch (DirectoryException de) {
            PurgeConflictsHistoricalTask.debugInfo("[PURGE] PurgeConflictsHistoricalTask exception " + de.getLocalizedMessage());
            this.initState = TaskState.STOPPED_BY_ERROR;
        }
    }
}

