/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.server.BackendCfg;
import org.opends.server.admin.std.server.LDIFBackendCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.admin.std.server.TrustStoreBackendCfg;
import org.opends.server.api.Backend;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.api.plugin.PluginType;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.CoreConfigManager;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PasswordStorageSchemeConfigManager;
import org.opends.server.crypto.CryptoManagerSync;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.schema.AuthPasswordSyntax;
import org.opends.server.schema.UserPasswordSyntax;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.NullOutputStream;
import org.opends.server.types.WritabilityMode;
import org.opends.server.util.BuildVersion;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.FileBasedArgument;
import org.opends.server.util.args.StringArgument;

public class EncodePassword {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    public static void main(String[] args) {
        int returnCode = EncodePassword.encodePassword(args, true, System.out, System.err);
        if (returnCode != 0) {
            System.exit(StaticUtils.filterExitCode(returnCode));
        }
    }

    public static int encodePassword(String[] args) {
        return EncodePassword.encodePassword(args, true, System.out, System.err);
    }

    public static int encodePassword(String[] args, boolean initializeServer, OutputStream outStream, OutputStream errStream) {
        Message message;
        String scheme;
        PasswordStorageScheme storageScheme;
        boolean compareMode;
        PrintStream out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
        PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        BooleanArgument authPasswordSyntax = null;
        BooleanArgument useCompareResultCode = null;
        BooleanArgument listSchemes = null;
        BooleanArgument showUsage = null;
        BooleanArgument interactivePassword = null;
        StringArgument clearPassword = null;
        FileBasedArgument clearPasswordFile = null;
        StringArgument encodedPassword = null;
        FileBasedArgument encodedPasswordFile = null;
        StringArgument configClass = null;
        StringArgument configFile = null;
        StringArgument schemeName = null;
        Message toolDescription = ToolMessages.INFO_ENCPW_TOOL_DESCRIPTION.get();
        ArgumentParser argParser = new ArgumentParser("org.opends.server.tools.EncodePassword", toolDescription, false);
        try {
            listSchemes = new BooleanArgument("listschemes", Character.valueOf('l'), "listSchemes", ToolMessages.INFO_ENCPW_DESCRIPTION_LISTSCHEMES.get());
            argParser.addArgument(listSchemes);
            interactivePassword = new BooleanArgument("interactivePassword", Character.valueOf('i'), "interactivePassword", ToolMessages.INFO_ENCPW_DESCRIPTION_INPUT_PW.get());
            argParser.addArgument(interactivePassword);
            clearPassword = new StringArgument("clearpw", Character.valueOf('c'), "clearPassword", false, false, true, ToolMessages.INFO_CLEAR_PWD.get(), null, null, ToolMessages.INFO_ENCPW_DESCRIPTION_CLEAR_PW.get());
            argParser.addArgument(clearPassword);
            clearPasswordFile = new FileBasedArgument("clearpwfile", Character.valueOf('f'), "clearPasswordFile", false, false, ToolMessages.INFO_FILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_ENCPW_DESCRIPTION_CLEAR_PW_FILE.get());
            argParser.addArgument(clearPasswordFile);
            encodedPassword = new StringArgument("encodedpw", Character.valueOf('e'), "encodedPassword", false, false, true, ToolMessages.INFO_ENCODED_PWD_PLACEHOLDER.get(), null, null, ToolMessages.INFO_ENCPW_DESCRIPTION_ENCODED_PW.get());
            argParser.addArgument(encodedPassword);
            encodedPasswordFile = new FileBasedArgument("encodedpwfile", Character.valueOf('E'), "encodedPasswordFile", false, false, ToolMessages.INFO_FILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_ENCPW_DESCRIPTION_ENCODED_PW_FILE.get());
            argParser.addArgument(encodedPasswordFile);
            configClass = new StringArgument("configclass", Character.valueOf('C'), "configClass", true, false, true, ToolMessages.INFO_CONFIGCLASS_PLACEHOLDER.get(), ConfigFileHandler.class.getName(), null, ToolMessages.INFO_DESCRIPTION_CONFIG_CLASS.get());
            configClass.setHidden(true);
            argParser.addArgument(configClass);
            configFile = new StringArgument("configfile", Character.valueOf('F'), "configFile", true, false, true, ToolMessages.INFO_CONFIGFILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_CONFIG_FILE.get());
            configFile.setHidden(true);
            argParser.addArgument(configFile);
            schemeName = new StringArgument("scheme", Character.valueOf('s'), "storageScheme", false, false, true, ToolMessages.INFO_STORAGE_SCHEME_PLACEHOLDER.get(), null, null, ToolMessages.INFO_ENCPW_DESCRIPTION_SCHEME.get());
            argParser.addArgument(schemeName);
            authPasswordSyntax = new BooleanArgument("authpasswordsyntax", Character.valueOf('a'), "authPasswordSyntax", ToolMessages.INFO_ENCPW_DESCRIPTION_AUTHPW.get());
            argParser.addArgument(authPasswordSyntax);
            useCompareResultCode = new BooleanArgument("usecompareresultcode", Character.valueOf('r'), "useCompareResultCode", ToolMessages.INFO_ENCPW_DESCRIPTION_USE_COMPARE_RESULT.get());
            argParser.addArgument(useCompareResultCode);
            showUsage = new BooleanArgument("usage", Character.valueOf('H'), "help", ToolMessages.INFO_DESCRIPTION_USAGE.get());
            argParser.addArgument(showUsage);
            argParser.setUsageArgument(showUsage, out);
        }
        catch (ArgumentException ae) {
            Message message2 = ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(ae.getMessage());
            err.println(StaticUtils.wrapText(message2, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            Message message3 = ToolMessages.ERR_ERROR_PARSING_ARGS.get(ae.getMessage());
            err.println(StaticUtils.wrapText(message3, ServerConstants.MAX_LINE_WIDTH));
            err.println(argParser.getUsage());
            return 1;
        }
        if (argParser.usageOrVersionDisplayed()) {
            return 0;
        }
        try {
            BuildVersion.checkVersionMismatch();
        }
        catch (InitializationException e) {
            err.println(StaticUtils.wrapText(e.getMessage(), ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        if (clearPassword.isPresent() && clearPasswordFile.isPresent()) {
            Message message4 = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(clearPassword.getLongIdentifier(), clearPasswordFile.getLongIdentifier());
            err.println(StaticUtils.wrapText(message4, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        if (clearPassword.isPresent() && interactivePassword.isPresent()) {
            Message message5 = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(clearPassword.getLongIdentifier(), interactivePassword.getLongIdentifier());
            err.println(StaticUtils.wrapText(message5, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        if (clearPasswordFile.isPresent() && interactivePassword.isPresent()) {
            Message message6 = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(clearPasswordFile.getLongIdentifier(), interactivePassword.getLongIdentifier());
            err.println(StaticUtils.wrapText(message6, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        if (encodedPassword.isPresent() && encodedPasswordFile.isPresent()) {
            Message message7 = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(encodedPassword.getLongIdentifier(), encodedPasswordFile.getLongIdentifier());
            err.println(StaticUtils.wrapText(message7, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        ByteString clearPW = null;
        if (!(listSchemes.isPresent() || encodedPassword.isPresent() || encodedPasswordFile.isPresent() || schemeName.isPresent())) {
            Message message8 = ToolMessages.ERR_ENCPW_NO_SCHEME.get(schemeName.getLongIdentifier());
            err.println(StaticUtils.wrapText(message8, ServerConstants.MAX_LINE_WIDTH));
            err.println(argParser.getUsage());
            return 1;
        }
        ByteString encodedPW = null;
        if (encodedPassword.hasValue()) {
            compareMode = true;
            encodedPW = ByteString.valueOf(encodedPassword.getValue());
        } else if (encodedPasswordFile.hasValue()) {
            compareMode = true;
            encodedPW = ByteString.valueOf(encodedPasswordFile.getValue());
        } else {
            compareMode = false;
        }
        DirectoryServer directoryServer = DirectoryServer.getInstance();
        if (initializeServer) {
            try {
                DirectoryServer.bootstrapClient();
                DirectoryServer.initializeJMX();
            }
            catch (Exception e) {
                Message message9 = ToolMessages.ERR_SERVER_BOOTSTRAP_ERROR.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message9, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                directoryServer.initializeConfiguration(configClass.getValue(), configFile.getValue());
            }
            catch (InitializationException ie) {
                Message message10 = ToolMessages.ERR_CANNOT_LOAD_CONFIG.get(ie.getMessage());
                err.println(StaticUtils.wrapText(message10, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                Message message11 = ToolMessages.ERR_CANNOT_LOAD_CONFIG.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message11, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                directoryServer.initializeSchema();
            }
            catch (ConfigException ce) {
                Message message12 = ToolMessages.ERR_CANNOT_LOAD_SCHEMA.get(ce.getMessage());
                err.println(StaticUtils.wrapText(message12, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                Message message13 = ToolMessages.ERR_CANNOT_LOAD_SCHEMA.get(ie.getMessage());
                err.println(StaticUtils.wrapText(message13, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                Message message14 = ToolMessages.ERR_CANNOT_LOAD_SCHEMA.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message14, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                CoreConfigManager coreConfigManager = new CoreConfigManager();
                coreConfigManager.initializeCoreConfig();
            }
            catch (ConfigException ce) {
                Message message15 = ToolMessages.ERR_CANNOT_INITIALIZE_CORE_CONFIG.get(ce.getMessage());
                err.println(StaticUtils.wrapText(message15, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                Message message16 = ToolMessages.ERR_CANNOT_INITIALIZE_CORE_CONFIG.get(ie.getMessage());
                err.println(StaticUtils.wrapText(message16, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                Message message17 = ToolMessages.ERR_CANNOT_INITIALIZE_CORE_CONFIG.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message17, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            if (!EncodePassword.initializeServerComponents(directoryServer, err)) {
                return -1;
            }
            try {
                PasswordStorageSchemeConfigManager storageSchemeConfigManager = new PasswordStorageSchemeConfigManager();
                storageSchemeConfigManager.initializePasswordStorageSchemes();
            }
            catch (ConfigException ce) {
                Message message18 = ToolMessages.ERR_ENCPW_CANNOT_INITIALIZE_STORAGE_SCHEMES.get(ce.getMessage());
                err.println(StaticUtils.wrapText(message18, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                Message message19 = ToolMessages.ERR_ENCPW_CANNOT_INITIALIZE_STORAGE_SCHEMES.get(ie.getMessage());
                err.println(StaticUtils.wrapText(message19, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                Message message20 = ToolMessages.ERR_ENCPW_CANNOT_INITIALIZE_STORAGE_SCHEMES.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message20, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        }
        if (listSchemes.isPresent()) {
            ConcurrentHashMap<String, PasswordStorageScheme> storageSchemes;
            if (authPasswordSyntax.isPresent()) {
                storageSchemes = DirectoryServer.getAuthPasswordStorageSchemes();
                if (storageSchemes.isEmpty()) {
                    Message message21 = ToolMessages.ERR_ENCPW_NO_STORAGE_SCHEMES.get();
                    err.println(StaticUtils.wrapText(message21, ServerConstants.MAX_LINE_WIDTH));
                } else {
                    int size = storageSchemes.size();
                    ArrayList<String> nameList = new ArrayList<String>(size);
                    for (PasswordStorageScheme s : storageSchemes.values()) {
                        nameList.add(s.getAuthPasswordSchemeName());
                    }
                    Object[] nameArray = new String[size];
                    nameList.toArray(nameArray);
                    Arrays.sort(nameArray);
                    for (Object storageSchemeName : nameArray) {
                        out.println((String)storageSchemeName);
                    }
                }
                return 0;
            }
            storageSchemes = DirectoryServer.getPasswordStorageSchemes();
            if (storageSchemes.isEmpty()) {
                Message message22 = ToolMessages.ERR_ENCPW_NO_STORAGE_SCHEMES.get();
                err.println(StaticUtils.wrapText(message22, ServerConstants.MAX_LINE_WIDTH));
            } else {
                int size = storageSchemes.size();
                ArrayList<String> nameList = new ArrayList<String>(size);
                for (PasswordStorageScheme s : storageSchemes.values()) {
                    nameList.add(s.getStorageSchemeName());
                }
                Object[] nameArray = new String[size];
                nameList.toArray(nameArray);
                Arrays.sort(nameArray);
                for (Object storageSchemeName : nameArray) {
                    out.println((String)storageSchemeName);
                }
            }
            return 0;
        }
        if (compareMode) {
            String encodedPWString;
            block75: {
                if (authPasswordSyntax.isPresent()) {
                    String authValue;
                    String authInfo;
                    String scheme2;
                    try {
                        StringBuilder[] authPWElements = AuthPasswordSyntax.decodeAuthPassword(encodedPW.toString());
                        scheme2 = authPWElements[0].toString();
                        authInfo = authPWElements[1].toString();
                        authValue = authPWElements[2].toString();
                    }
                    catch (DirectoryException de) {
                        Message message23 = ToolMessages.ERR_ENCPW_INVALID_ENCODED_AUTHPW.get(de.getMessageObject());
                        err.println(StaticUtils.wrapText(message23, ServerConstants.MAX_LINE_WIDTH));
                        return 1;
                    }
                    catch (Exception e) {
                        Message message24 = ToolMessages.ERR_ENCPW_INVALID_ENCODED_AUTHPW.get(String.valueOf(e));
                        err.println(StaticUtils.wrapText(message24, ServerConstants.MAX_LINE_WIDTH));
                        return 1;
                    }
                    PasswordStorageScheme storageScheme2 = DirectoryServer.getAuthPasswordStorageScheme(scheme2);
                    if (storageScheme2 == null) {
                        Message message25 = ToolMessages.ERR_ENCPW_NO_SUCH_AUTH_SCHEME.get(scheme2);
                        err.println(StaticUtils.wrapText(message25, ServerConstants.MAX_LINE_WIDTH));
                        return 1;
                    }
                    if (clearPW == null && (clearPW = EncodePassword.getClearPW(out, err, argParser, clearPassword, clearPasswordFile, interactivePassword)) == null) {
                        return 1;
                    }
                    boolean authPasswordMatches = storageScheme2.authPasswordMatches(clearPW, authInfo, authValue);
                    out.println(EncodePassword.getOutputMessage(authPasswordMatches));
                    if (useCompareResultCode.isPresent()) {
                        return authPasswordMatches ? 6 : 5;
                    }
                    return 0;
                }
                if (UserPasswordSyntax.isEncoded(encodedPW)) {
                    try {
                        String[] userPWElements = UserPasswordSyntax.decodeUserPassword(encodedPW.toString());
                        encodedPWString = userPWElements[1];
                        storageScheme = DirectoryServer.getPasswordStorageScheme(userPWElements[0]);
                        if (storageScheme == null) {
                            Message message26 = ToolMessages.ERR_ENCPW_NO_SUCH_SCHEME.get(userPWElements[0]);
                            err.println(StaticUtils.wrapText(message26, ServerConstants.MAX_LINE_WIDTH));
                            return 1;
                        }
                        break block75;
                    }
                    catch (DirectoryException de) {
                        Message message27 = ToolMessages.ERR_ENCPW_INVALID_ENCODED_USERPW.get(de.getMessageObject());
                        err.println(StaticUtils.wrapText(message27, ServerConstants.MAX_LINE_WIDTH));
                        return 1;
                    }
                    catch (Exception e) {
                        Message message28 = ToolMessages.ERR_ENCPW_INVALID_ENCODED_USERPW.get(String.valueOf(e));
                        err.println(StaticUtils.wrapText(message28, ServerConstants.MAX_LINE_WIDTH));
                        return 1;
                    }
                }
                if (!schemeName.isPresent()) {
                    Message message29 = ToolMessages.ERR_ENCPW_NO_SCHEME.get(schemeName.getLongIdentifier());
                    err.println(StaticUtils.wrapText(message29, ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
                encodedPWString = encodedPW.toString();
                String scheme3 = StaticUtils.toLowerCase(schemeName.getValue());
                storageScheme = DirectoryServer.getPasswordStorageScheme(scheme3);
                if (storageScheme == null) {
                    Message message30 = ToolMessages.ERR_ENCPW_NO_SUCH_SCHEME.get(scheme3);
                    err.println(StaticUtils.wrapText(message30, ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
            }
            if (clearPW == null && (clearPW = EncodePassword.getClearPW(out, err, argParser, clearPassword, clearPasswordFile, interactivePassword)) == null) {
                return 1;
            }
            boolean passwordMatches = storageScheme.passwordMatches(clearPW, ByteString.valueOf(encodedPWString));
            out.println(EncodePassword.getOutputMessage(passwordMatches));
            if (useCompareResultCode.isPresent()) {
                return passwordMatches ? 6 : 5;
            }
            return 0;
        }
        if (authPasswordSyntax.isPresent()) {
            scheme = schemeName.getValue();
            storageScheme = DirectoryServer.getAuthPasswordStorageScheme(scheme);
            if (storageScheme == null) {
                Message message31 = ToolMessages.ERR_ENCPW_NO_SUCH_AUTH_SCHEME.get(scheme);
                err.println(StaticUtils.wrapText(message31, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        } else {
            scheme = StaticUtils.toLowerCase(schemeName.getValue());
            storageScheme = DirectoryServer.getPasswordStorageScheme(scheme);
            if (storageScheme == null) {
                Message message32 = ToolMessages.ERR_ENCPW_NO_SUCH_SCHEME.get(scheme);
                err.println(StaticUtils.wrapText(message32, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        }
        if (authPasswordSyntax.isPresent()) {
            try {
                if (clearPW == null && (clearPW = EncodePassword.getClearPW(out, err, argParser, clearPassword, clearPasswordFile, interactivePassword)) == null) {
                    return 1;
                }
                encodedPW = storageScheme.encodeAuthPassword(clearPW);
                message = ToolMessages.ERR_ENCPW_ENCODED_PASSWORD.get(encodedPW.toString());
                out.println(message);
            }
            catch (DirectoryException de) {
                Message message33 = ToolMessages.ERR_ENCPW_CANNOT_ENCODE.get(de.getMessageObject());
                err.println(StaticUtils.wrapText(message33, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                Message message34 = ToolMessages.ERR_ENCPW_CANNOT_ENCODE.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message34, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        }
        try {
            if (clearPW == null && (clearPW = EncodePassword.getClearPW(out, err, argParser, clearPassword, clearPasswordFile, interactivePassword)) == null) {
                return 1;
            }
            encodedPW = storageScheme.encodePasswordWithScheme(clearPW);
            message = ToolMessages.ERR_ENCPW_ENCODED_PASSWORD.get(encodedPW.toString());
            out.println(message);
        }
        catch (DirectoryException de) {
            Message message35 = ToolMessages.ERR_ENCPW_CANNOT_ENCODE.get(de.getMessageObject());
            err.println(StaticUtils.wrapText(message35, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        catch (Exception e) {
            Message message36 = ToolMessages.ERR_ENCPW_CANNOT_ENCODE.get(StaticUtils.getExceptionMessage(e));
            err.println(StaticUtils.wrapText(message36, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        return 0;
    }

    private static Message getOutputMessage(boolean passwordMatches) {
        if (passwordMatches) {
            return ToolMessages.INFO_ENCPW_PASSWORDS_MATCH.get();
        }
        return ToolMessages.INFO_ENCPW_PASSWORDS_DO_NOT_MATCH.get();
    }

    private static boolean initializeServerComponents(DirectoryServer directoryServer, PrintStream err) {
        try {
            directoryServer.initializeCryptoManager();
        }
        catch (ConfigException ce) {
            Message message = ToolMessages.ERR_CANNOT_INITIALIZE_CRYPTO_MANAGER.get(ce.getMessage());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return false;
        }
        catch (InitializationException ie) {
            Message message = ToolMessages.ERR_CANNOT_INITIALIZE_CRYPTO_MANAGER.get(ie.getMessage());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return false;
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_CANNOT_INITIALIZE_CRYPTO_MANAGER.get(StaticUtils.getExceptionMessage(e));
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return false;
        }
        try {
            directoryServer.initializeRootDNConfigManager();
            HashSet<PluginType> pluginTypes = new HashSet<PluginType>(1);
            directoryServer.initializePlugins(pluginTypes);
            EncodePassword.initializeServerBackends(directoryServer);
            directoryServer.initializeSubentryManager();
            directoryServer.initializeAuthenticationPolicyComponents();
            new CryptoManagerSync();
        }
        catch (InitializationException ie) {
            Message message = ToolMessages.ERR_ENCPW_CANNOT_INITIALIZE_SERVER_COMPONENTS.get(StaticUtils.getExceptionMessage(ie));
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return false;
        }
        catch (ConfigException ce) {
            Message message = ToolMessages.ERR_ENCPW_CANNOT_INITIALIZE_SERVER_COMPONENTS.get(StaticUtils.getExceptionMessage(ce));
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return false;
        }
        return true;
    }

    private static void initializeServerBackends(DirectoryServer directoryServer) throws InitializationException, ConfigException {
        ConfigEntry backendRoot;
        directoryServer.initializeRootDSE();
        ServerManagementContext context = ServerManagementContext.getInstance();
        RootCfg root = context.getRootConfiguration();
        try {
            DN configEntryDN = DN.decode("cn=Backends,cn=config");
            backendRoot = DirectoryServer.getConfigEntry(configEntryDN);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ConfigMessages.ERR_CONFIG_BACKEND_CANNOT_GET_CONFIG_BASE.get(StaticUtils.getExceptionMessage(e));
            throw new ConfigException(message, (Throwable)e);
        }
        if (backendRoot == null) {
            Message message = ConfigMessages.ERR_CONFIG_BACKEND_BASE_DOES_NOT_EXIST.get();
            throw new ConfigException(message);
        }
        for (String name : root.listBackends()) {
            Message message;
            Backend backend;
            BackendCfg backendCfg = root.getBackend(name);
            String backendID = backendCfg.getBackendId();
            if (!(backendCfg instanceof TrustStoreBackendCfg) && !(backendCfg instanceof LDIFBackendCfg) || !backendCfg.isEnabled()) continue;
            String className = backendCfg.getJavaClass();
            try {
                Class<?> backendClass = DirectoryServer.loadClass(className);
                backend = (Backend)backendClass.newInstance();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                message = ConfigMessages.ERR_CONFIG_BACKEND_CANNOT_INSTANTIATE.get(String.valueOf(className), String.valueOf(backendCfg.dn()), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                continue;
            }
            backend.setBackendID(backendID);
            backend.setWritabilityMode(WritabilityMode.INTERNAL_ONLY);
            try {
                backend.configureBackend(backendCfg);
                backend.initializeBackend();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                message = ConfigMessages.ERR_CONFIG_BACKEND_CANNOT_INITIALIZE.get(String.valueOf(className), String.valueOf(backendCfg.dn()), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
            }
            try {
                DirectoryServer.registerBackend(backend);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                message = ConfigMessages.WARN_CONFIG_BACKEND_CANNOT_REGISTER_BACKEND.get(backendCfg.getBackendId(), StaticUtils.getExceptionMessage(e));
                ErrorLogger.logError(message);
            }
        }
    }

    private static ByteString getClearPW(PrintStream out, PrintStream err, ArgumentParser argParser, StringArgument clearPassword, FileBasedArgument clearPasswordFile, BooleanArgument interactivePassword) {
        ByteString clearPW = null;
        if (clearPassword.hasValue()) {
            clearPW = ByteString.valueOf(clearPassword.getValue());
        } else if (clearPasswordFile.hasValue()) {
            clearPW = ByteString.valueOf(clearPasswordFile.getValue());
        } else if (interactivePassword.isPresent()) {
            EncodePassword encodePassword = new EncodePassword();
            try {
                Message msg = ToolMessages.INFO_ENCPW_INPUT_PWD_1.get();
                String pwd1 = encodePassword.getPassword(out, msg.toString());
                msg = ToolMessages.INFO_ENCPW_INPUT_PWD_2.get();
                String pwd2 = encodePassword.getPassword(out, msg.toString());
                if (!pwd1.equals(pwd2)) {
                    Message message = ToolMessages.ERR_ENCPW_NOT_SAME_PW.get();
                    err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                    return null;
                }
                clearPW = ByteString.valueOf(pwd1);
            }
            catch (IOException e) {
                Message message = ToolMessages.ERR_ENCPW_CANNOT_READ_PW.get(e.getMessage());
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return null;
            }
        } else {
            Message message = ToolMessages.ERR_ENCPW_NO_CLEAR_PW.get(clearPassword.getLongIdentifier(), clearPasswordFile.getLongIdentifier(), interactivePassword.getLongIdentifier());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            err.println(argParser.getUsage());
            return null;
        }
        return clearPW;
    }

    private String getPassword(PrintStream out, String prompt) throws IOException {
        String password;
        try {
            Method constructor = System.class.getDeclaredMethod("console", new Class[0]);
            Object console = constructor.invoke(null, new Object[0]);
            if (console == null) {
                throw new IOException("No console");
            }
            Class<?> c = Class.forName("java.io.Console");
            Object[] args = new Object[]{prompt, new Object[0]};
            Method m = c.getDeclaredMethod("readPassword", String.class, args.getClass());
            password = new String((char[])m.invoke(console, args));
        }
        catch (Exception e) {
            ErasingThread erasingThread = new ErasingThread(out, prompt);
            erasingThread.start();
            password = "";
            while (true) {
                char c = (char)System.in.read();
                erasingThread.stopMasking();
                if (c == '\r') {
                    c = (char)System.in.read();
                    if (c != '\n') continue;
                    break;
                }
                if (c == '\n') break;
                password = password + c;
            }
        }
        return password;
    }

    private class ErasingThread
    extends Thread {
        private boolean stop = false;
        private String prompt;

        public ErasingThread(PrintStream out, String prompt) {
            this.prompt = prompt;
        }

        @Override
        public void run() {
            while (!this.stop) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException iex) {
                    iex.printStackTrace();
                }
                if (!this.stop) {
                    System.out.print("\r" + this.prompt + " \r" + this.prompt);
                }
                System.out.flush();
            }
        }

        public void stopMasking() {
            this.stop = true;
        }
    }
}

