/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeMap;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ExistingFileBehavior;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.NullOutputStream;
import org.opends.server.types.ObjectClass;
import org.opends.server.util.LDIFReader;
import org.opends.server.util.LDIFWriter;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.StringArgument;

public class LDIFDiff {
    private static final String CLASS_NAME = "org.opends.server.tools.LDIFDiff";

    public static void main(String[] args) {
        int exitCode = LDIFDiff.mainDiff(args, false, System.out, System.err);
        if (exitCode != 0) {
            System.exit(StaticUtils.filterExitCode(exitCode));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int mainDiff(String[] args, boolean serverInitialized, OutputStream outStream, OutputStream errStream) {
        LDIFWriter writer;
        LDIFReader reader;
        String line;
        boolean checkSchema;
        BooleanArgument useCompareResultCode;
        StringArgument configClass;
        StringArgument configFile;
        BooleanArgument doCheckSchema;
        BooleanArgument singleValueChanges;
        BooleanArgument overwriteExisting;
        StringArgument ignoreEntriesFile;
        StringArgument ignoreAttrsFile;
        StringArgument outputLDIF;
        StringArgument targetLDIF;
        StringArgument sourceLDIF;
        PrintStream out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
        PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        Message toolDescription = ToolMessages.INFO_LDIFDIFF_TOOL_DESCRIPTION.get();
        ArgumentParser argParser = new ArgumentParser(CLASS_NAME, toolDescription, false);
        try {
            sourceLDIF = new StringArgument("sourceldif", Character.valueOf('s'), "sourceLDIF", true, false, true, ToolMessages.INFO_FILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDIFDIFF_DESCRIPTION_SOURCE_LDIF.get());
            argParser.addArgument(sourceLDIF);
            targetLDIF = new StringArgument("targetldif", Character.valueOf('t'), "targetLDIF", true, false, true, ToolMessages.INFO_FILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDIFDIFF_DESCRIPTION_TARGET_LDIF.get());
            argParser.addArgument(targetLDIF);
            outputLDIF = new StringArgument("outputldif", Character.valueOf('o'), "outputLDIF", false, false, true, ToolMessages.INFO_FILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDIFDIFF_DESCRIPTION_OUTPUT_LDIF.get());
            argParser.addArgument(outputLDIF);
            ignoreAttrsFile = new StringArgument("ignoreattrs", Character.valueOf('a'), "ignoreAttrs", false, false, true, ToolMessages.INFO_FILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDIFDIFF_DESCRIPTION_IGNORE_ATTRS.get());
            argParser.addArgument(ignoreAttrsFile);
            ignoreEntriesFile = new StringArgument("ignoreentries", Character.valueOf('e'), "ignoreEntries", false, false, true, ToolMessages.INFO_FILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDIFDIFF_DESCRIPTION_IGNORE_ENTRIES.get());
            argParser.addArgument(ignoreEntriesFile);
            overwriteExisting = new BooleanArgument("overwriteexisting", Character.valueOf('O'), "overwriteExisting", ToolMessages.INFO_LDIFDIFF_DESCRIPTION_OVERWRITE_EXISTING.get());
            argParser.addArgument(overwriteExisting);
            singleValueChanges = new BooleanArgument("singlevaluechanges", Character.valueOf('S'), "singleValueChanges", ToolMessages.INFO_LDIFDIFF_DESCRIPTION_SINGLE_VALUE_CHANGES.get());
            argParser.addArgument(singleValueChanges);
            doCheckSchema = new BooleanArgument("checkschema", null, "checkSchema", ToolMessages.INFO_LDIFDIFF_DESCRIPTION_CHECK_SCHEMA.get());
            argParser.addArgument(doCheckSchema);
            configFile = new StringArgument("configfile", Character.valueOf('c'), "configFile", false, false, true, ToolMessages.INFO_CONFIGFILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_CONFIG_FILE.get());
            configFile.setHidden(true);
            argParser.addArgument(configFile);
            configClass = new StringArgument("configclass", Character.valueOf('C'), "configClass", false, false, true, ToolMessages.INFO_CONFIGCLASS_PLACEHOLDER.get(), ConfigFileHandler.class.getName(), null, ToolMessages.INFO_DESCRIPTION_CONFIG_CLASS.get());
            configClass.setHidden(true);
            argParser.addArgument(configClass);
            BooleanArgument showUsage = new BooleanArgument("showusage", Character.valueOf('H'), "help", ToolMessages.INFO_DESCRIPTION_USAGE.get());
            argParser.addArgument(showUsage);
            useCompareResultCode = new BooleanArgument("usecompareresultcode", Character.valueOf('r'), "useCompareResultCode", ToolMessages.INFO_LDIFDIFF_DESCRIPTION_USE_COMPARE_RESULT.get());
            argParser.addArgument(useCompareResultCode);
            argParser.setUsageArgument(showUsage);
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(ae.getMessage());
            err.println(message);
            return 1;
        }
        try {
            argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_ERROR_PARSING_ARGS.get(ae.getMessage());
            err.println(message);
            err.println(argParser.getUsage());
            return 89;
        }
        if (argParser.usageOrVersionDisplayed()) {
            return 0;
        }
        if (doCheckSchema.isPresent() && !configFile.isPresent()) {
            String scriptName = System.getProperty("org.opends.server.scriptName");
            if (scriptName == null) {
                scriptName = "ldif-diff";
            }
            Message message = ToolMessages.WARN_LDIFDIFF_NO_CONFIG_FILE.get(scriptName);
            err.println(message);
        }
        boolean bl = checkSchema = configFile.isPresent() && doCheckSchema.isPresent();
        if (!serverInitialized) {
            DirectoryServer directoryServer = DirectoryServer.getInstance();
            DirectoryServer.bootstrapClient();
            if (checkSchema) {
                try {
                    DirectoryServer.initializeJMX();
                }
                catch (Exception e) {
                    Message message = ToolMessages.ERR_LDIFDIFF_CANNOT_INITIALIZE_JMX.get(String.valueOf(configFile.getValue()), e.getMessage());
                    err.println(message);
                    return 1;
                }
                try {
                    directoryServer.initializeConfiguration(configClass.getValue(), configFile.getValue());
                }
                catch (Exception e) {
                    Message message = ToolMessages.ERR_LDIFDIFF_CANNOT_INITIALIZE_CONFIG.get(String.valueOf(configFile.getValue()), e.getMessage());
                    err.println(message);
                    return 1;
                }
                try {
                    directoryServer.initializeSchema();
                }
                catch (Exception e) {
                    Message message = ToolMessages.ERR_LDIFDIFF_CANNOT_INITIALIZE_SCHEMA.get(String.valueOf(configFile.getValue()), e.getMessage());
                    err.println(message);
                    return 1;
                }
            }
        }
        BufferedReader ignReader = null;
        HashSet<DN> ignoreEntries = new HashSet<DN>();
        HashSet<String> ignoreAttrs = new HashSet<String>();
        if (ignoreAttrsFile.getValue() != null) {
            try {
                ignReader = new BufferedReader(new FileReader(ignoreAttrsFile.getValue()));
                line = null;
                while ((line = ignReader.readLine()) != null) {
                    ignoreAttrs.add(line.toLowerCase());
                }
                ignReader.close();
            }
            catch (Exception e) {
                Message message = ToolMessages.ERR_LDIFDIFF_CANNOT_READ_FILE_IGNORE_ATTRIBS.get(ignoreAttrsFile.getValue(), String.valueOf(e));
                err.println(message);
                int n = 1;
                return n;
            }
            finally {
                try {
                    ignReader.close();
                }
                catch (Exception e) {}
            }
        }
        if (ignoreEntriesFile.getValue() != null) {
            try {
                ignReader = new BufferedReader(new FileReader(ignoreEntriesFile.getValue()));
                line = null;
                while ((line = ignReader.readLine()) != null) {
                    try {
                        DN dn = DN.decode(line);
                        ignoreEntries.add(dn);
                    }
                    catch (DirectoryException e) {
                        Message message2 = ToolMessages.INFO_LDIFDIFF_CANNOT_PARSE_STRING_AS_DN.get(line, ignoreEntriesFile.getValue());
                        err.println(message2);
                    }
                }
                ignReader.close();
            }
            catch (Exception e) {
                Message message = ToolMessages.ERR_LDIFDIFF_CANNOT_READ_FILE_IGNORE_ENTRIES.get(ignoreEntriesFile.getValue(), String.valueOf(e));
                err.println(message);
                int message2 = 1;
                return message2;
            }
            finally {
                try {
                    ignReader.close();
                }
                catch (Exception e) {}
            }
        }
        LDIFImportConfig importConfig = new LDIFImportConfig(sourceLDIF.getValue());
        try {
            reader = new LDIFReader(importConfig);
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_LDIFDIFF_CANNOT_OPEN_SOURCE_LDIF.get(sourceLDIF.getValue(), String.valueOf(e));
            err.println(message);
            return 1;
        }
        TreeMap<DN, Entry> sourceMap = new TreeMap<DN, Entry>();
        try {
            Entry entry;
            while ((entry = reader.readEntry(checkSchema)) != null) {
                if (ignoreEntries.contains(entry.getDN())) continue;
                sourceMap.put(entry.getDN(), entry);
            }
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_LDIFDIFF_ERROR_READING_SOURCE_LDIF.get(sourceLDIF.getValue(), String.valueOf(e));
            err.println(message);
            int e2 = 1;
            return e2;
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception e3) {}
        }
        importConfig = new LDIFImportConfig(targetLDIF.getValue());
        try {
            reader = new LDIFReader(importConfig);
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_LDIFDIFF_CANNOT_OPEN_TARGET_LDIF.get(targetLDIF.getValue(), String.valueOf(e));
            err.println(message);
            return 1;
        }
        TreeMap<DN, Entry> targetMap = new TreeMap<DN, Entry>();
        try {
            Entry entry;
            while ((entry = reader.readEntry(checkSchema)) != null) {
                if (ignoreEntries.contains(entry.getDN())) continue;
                targetMap.put(entry.getDN(), entry);
            }
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_LDIFDIFF_ERROR_READING_TARGET_LDIF.get(targetLDIF.getValue(), String.valueOf(e));
            err.println(message);
            int e3 = 1;
            return e3;
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception e) {}
        }
        try {
            LDIFExportConfig exportConfig = outputLDIF.isPresent() ? (overwriteExisting.isPresent() ? new LDIFExportConfig(outputLDIF.getValue(), ExistingFileBehavior.OVERWRITE) : new LDIFExportConfig(outputLDIF.getValue(), ExistingFileBehavior.APPEND)) : new LDIFExportConfig(out);
            writer = new LDIFWriter(exportConfig);
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_LDIFDIFF_CANNOT_OPEN_OUTPUT.get(String.valueOf(e));
            err.println(message);
            return 1;
        }
        try {
            boolean differenceFound;
            block113: {
                Iterator sourceIterator;
                if (sourceMap.isEmpty()) {
                    if (targetMap.isEmpty()) {
                        differenceFound = false;
                    } else {
                        Iterator targetIterator = targetMap.keySet().iterator();
                        while (targetIterator.hasNext()) {
                            LDIFDiff.writeAdd(writer, (Entry)targetMap.get(targetIterator.next()));
                        }
                        differenceFound = true;
                    }
                } else if (targetMap.isEmpty()) {
                    sourceIterator = sourceMap.keySet().iterator();
                    while (sourceIterator.hasNext()) {
                        LDIFDiff.writeDelete(writer, (Entry)sourceMap.get(sourceIterator.next()));
                    }
                    differenceFound = true;
                } else {
                    differenceFound = false;
                    sourceIterator = sourceMap.keySet().iterator();
                    Iterator targetIterator = targetMap.keySet().iterator();
                    DN sourceDN = (DN)sourceIterator.next();
                    DN targetDN = (DN)targetIterator.next();
                    Entry sourceEntry = (Entry)sourceMap.get(sourceDN);
                    Entry targetEntry = (Entry)targetMap.get(targetDN);
                    while (true) {
                        int comparatorValue;
                        if ((comparatorValue = sourceDN.compareTo(targetDN)) < 0) {
                            LDIFDiff.writeDelete(writer, sourceEntry);
                            differenceFound = true;
                            if (sourceIterator.hasNext()) {
                                sourceDN = (DN)sourceIterator.next();
                                sourceEntry = (Entry)sourceMap.get(sourceDN);
                                continue;
                            }
                            LDIFDiff.writeAdd(writer, targetEntry);
                            while (targetIterator.hasNext()) {
                                targetDN = (DN)targetIterator.next();
                                targetEntry = (Entry)targetMap.get(targetDN);
                                LDIFDiff.writeAdd(writer, targetEntry);
                                differenceFound = true;
                            }
                            break block113;
                        }
                        if (comparatorValue > 0) {
                            LDIFDiff.writeAdd(writer, targetEntry);
                            differenceFound = true;
                            if (targetIterator.hasNext()) {
                                targetDN = (DN)targetIterator.next();
                                targetEntry = (Entry)targetMap.get(targetDN);
                                continue;
                            }
                            LDIFDiff.writeDelete(writer, sourceEntry);
                            differenceFound = true;
                            while (sourceIterator.hasNext()) {
                                sourceDN = (DN)sourceIterator.next();
                                sourceEntry = (Entry)sourceMap.get(sourceDN);
                                LDIFDiff.writeDelete(writer, sourceEntry);
                            }
                            break block113;
                        }
                        if (LDIFDiff.writeModify(writer, sourceEntry, targetEntry, ignoreAttrs, singleValueChanges.isPresent())) {
                            differenceFound = true;
                        }
                        if (!sourceIterator.hasNext()) {
                            while (targetIterator.hasNext()) {
                                targetDN = (DN)targetIterator.next();
                                targetEntry = (Entry)targetMap.get(targetDN);
                                LDIFDiff.writeAdd(writer, targetEntry);
                                differenceFound = true;
                            }
                            break block113;
                        }
                        sourceDN = (DN)sourceIterator.next();
                        sourceEntry = (Entry)sourceMap.get(sourceDN);
                        if (!targetIterator.hasNext()) break;
                        targetDN = (DN)targetIterator.next();
                        targetEntry = (Entry)targetMap.get(targetDN);
                    }
                    LDIFDiff.writeDelete(writer, sourceEntry);
                    differenceFound = true;
                    while (sourceIterator.hasNext()) {
                        sourceDN = (DN)sourceIterator.next();
                        sourceEntry = (Entry)sourceMap.get(sourceDN);
                        LDIFDiff.writeDelete(writer, sourceEntry);
                    }
                }
            }
            if (!differenceFound) {
                Message message = ToolMessages.INFO_LDIFDIFF_NO_DIFFERENCES.get();
                writer.writeComment(message, 0);
            }
            if (useCompareResultCode.isPresent()) {
                int message = !differenceFound ? 6 : 5;
                return message;
            }
        }
        catch (IOException e) {
            Message message = ToolMessages.ERR_LDIFDIFF_ERROR_WRITING_OUTPUT.get(String.valueOf(e));
            err.println(message);
            int n = 1;
            return n;
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception e) {}
        }
        return 0;
    }

    private static void writeAdd(LDIFWriter writer, Entry entry) throws IOException {
        writer.writeAddChangeRecord(entry);
        writer.flush();
    }

    private static void writeDelete(LDIFWriter writer, Entry entry) throws IOException {
        writer.writeDeleteChangeRecord(entry, true);
        writer.flush();
    }

    private static boolean writeModify(LDIFWriter writer, Entry sourceEntry, Entry targetEntry, Collection ignoreAttrs, boolean singleValueChanges) throws IOException {
        List<Attribute> targetAttrs;
        AttributeBuilder builder;
        AttributeType attrType;
        LinkedList<Modification> modifications = new LinkedList<Modification>();
        LinkedHashSet<ObjectClass> sourceClasses = new LinkedHashSet<ObjectClass>(sourceEntry.getObjectClasses().keySet());
        LinkedHashSet<ObjectClass> targetClasses = new LinkedHashSet<ObjectClass>(targetEntry.getObjectClasses().keySet());
        Iterator sourceClassIterator = sourceClasses.iterator();
        while (sourceClassIterator.hasNext()) {
            ObjectClass sourceClass = (ObjectClass)sourceClassIterator.next();
            if (!targetClasses.remove(sourceClass)) continue;
            sourceClassIterator.remove();
        }
        if (!sourceClasses.isEmpty()) {
            attrType = DirectoryServer.getObjectClassAttributeType();
            builder = new AttributeBuilder(attrType);
            for (ObjectClass oc : sourceClasses) {
                builder.add(AttributeValues.create(attrType, oc.getNameOrOID()));
            }
            modifications.add(new Modification(ModificationType.DELETE, builder.toAttribute()));
        }
        if (!targetClasses.isEmpty()) {
            attrType = DirectoryServer.getObjectClassAttributeType();
            builder = new AttributeBuilder(attrType);
            for (ObjectClass oc : targetClasses) {
                builder.add(AttributeValues.create(attrType, oc.getNameOrOID()));
            }
            modifications.add(new Modification(ModificationType.ADD, builder.toAttribute()));
        }
        LinkedHashSet<AttributeType> sourceTypes = new LinkedHashSet<AttributeType>(sourceEntry.getUserAttributes().keySet());
        for (AttributeType type : sourceTypes) {
            List<Attribute> sourceAttrs = sourceEntry.getUserAttribute(type);
            targetAttrs = targetEntry.getUserAttribute(type);
            sourceEntry.removeAttribute(type);
            if (targetAttrs == null) {
                for (Attribute a : sourceAttrs) {
                    modifications.add(new Modification(ModificationType.DELETE, a));
                }
                continue;
            }
            targetEntry.removeAttribute(type);
            for (Attribute sourceAttr : sourceAttrs) {
                Attribute targetAttr = null;
                Iterator<Attribute> attrIterator = targetAttrs.iterator();
                while (attrIterator.hasNext()) {
                    Attribute a = attrIterator.next();
                    if (!a.optionsEqual(sourceAttr.getOptions())) continue;
                    targetAttr = a;
                    attrIterator.remove();
                    break;
                }
                if (targetAttr == null) {
                    modifications.add(new Modification(ModificationType.DELETE, sourceAttr));
                    continue;
                }
                AttributeBuilder addedValuesBuilder = new AttributeBuilder(targetAttr);
                addedValuesBuilder.removeAll(sourceAttr);
                Attribute addedValues = addedValuesBuilder.toAttribute();
                if (!addedValues.isEmpty()) {
                    modifications.add(new Modification(ModificationType.ADD, addedValues));
                }
                AttributeBuilder deletedValuesBuilder = new AttributeBuilder(sourceAttr);
                deletedValuesBuilder.removeAll(targetAttr);
                Attribute deletedValues = deletedValuesBuilder.toAttribute();
                if (deletedValues.isEmpty()) continue;
                modifications.add(new Modification(ModificationType.DELETE, deletedValues));
            }
            for (Attribute targetAttr : targetAttrs) {
                modifications.add(new Modification(ModificationType.ADD, targetAttr));
            }
        }
        for (AttributeType type : targetEntry.getUserAttributes().keySet()) {
            targetAttrs = targetEntry.getUserAttribute(type);
            for (Attribute a : targetAttrs) {
                modifications.add(new Modification(ModificationType.ADD, a));
            }
        }
        if (!ignoreAttrs.isEmpty()) {
            ListIterator modIter = modifications.listIterator();
            while (modIter.hasNext()) {
                String name = ((Modification)modIter.next()).getAttribute().getName().toLowerCase();
                if (!ignoreAttrs.contains(name)) continue;
                modIter.remove();
            }
        }
        if (modifications.isEmpty()) {
            return false;
        }
        if (singleValueChanges) {
            for (Modification m : modifications) {
                LinkedList<Modification> attrMods;
                Attribute a = m.getAttribute();
                if (a.isEmpty()) {
                    attrMods = new LinkedList<Modification>();
                    attrMods.add(m);
                    writer.writeModifyChangeRecord(sourceEntry.getDN(), attrMods);
                    continue;
                }
                attrMods = new LinkedList();
                for (AttributeValue v : a) {
                    AttributeBuilder builder2 = new AttributeBuilder(a, true);
                    builder2.add(v);
                    Attribute attr = builder2.toAttribute();
                    attrMods.clear();
                    attrMods.add(new Modification(m.getModificationType(), attr));
                    writer.writeModifyChangeRecord(sourceEntry.getDN(), attrMods);
                }
            }
        } else {
            writer.writeModifyChangeRecord(sourceEntry.getDN(), modifications);
        }
        return true;
    }
}

