/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.dsconfig;

import java.io.PrintStream;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.opends.messages.DSConfigMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ToolMessages;
import org.opends.messages.UtilityMessages;
import org.opends.server.admin.AbsoluteInheritedDefaultBehaviorProvider;
import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.AggregationPropertyDefinition;
import org.opends.server.admin.AliasDefaultBehaviorProvider;
import org.opends.server.admin.DefaultBehaviorProviderVisitor;
import org.opends.server.admin.DefinedDefaultBehaviorProvider;
import org.opends.server.admin.EnumPropertyDefinition;
import org.opends.server.admin.ManagedObjectOption;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyDefinitionUsageBuilder;
import org.opends.server.admin.PropertyDefinitionVisitor;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.RelativeInheritedDefaultBehaviorProvider;
import org.opends.server.admin.StringPropertyDefinition;
import org.opends.server.admin.Tag;
import org.opends.server.admin.UndefinedDefaultBehaviorProvider;
import org.opends.server.admin.UnknownPropertyDefinitionException;
import org.opends.server.tools.ClientException;
import org.opends.server.tools.dsconfig.ArgumentExceptionFactory;
import org.opends.server.tools.dsconfig.ManagementContextFactory;
import org.opends.server.tools.dsconfig.PropertyValuePrinter;
import org.opends.server.tools.dsconfig.SubCommandHandler;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.StringArgument;
import org.opends.server.util.args.SubCommand;
import org.opends.server.util.args.SubCommandArgumentParser;
import org.opends.server.util.cli.CLIException;
import org.opends.server.util.cli.ConsoleApplication;
import org.opends.server.util.cli.MenuResult;
import org.opends.server.util.cli.OutputStreamConsoleApplication;
import org.opends.server.util.table.TableBuilder;
import org.opends.server.util.table.TablePrinter;
import org.opends.server.util.table.TextTablePrinter;

final class HelpSubCommandHandler
extends SubCommandHandler {
    private static final String HEADING_SEPARATOR = " : ";
    private static final int HEADING_WIDTH;
    private static final String OPTION_DSCFG_LONG_CATEGORY = "category";
    private static final String OPTION_DSCFG_LONG_INHERITED = "inherited";
    private static final String OPTION_DSCFG_LONG_TYPE = "type";
    private static final Character OPTION_DSCFG_SHORT_CATEGORY;
    private static final Character OPTION_DSCFG_SHORT_INHERITED;
    private static final Character OPTION_DSCFG_SHORT_TYPE;
    private final StringArgument categoryArgument;
    private final Map<String, Map<String, AbstractManagedObjectDefinition<?, ?>>> categoryMap;
    private BooleanArgument inheritedModeArgument;
    private final SubCommand subCommand;
    private final Map<Tag, Map<String, AbstractManagedObjectDefinition<?, ?>>> tagMap;
    private final StringArgument typeArgument;

    public static HelpSubCommandHandler create(SubCommandArgumentParser parser) throws ArgumentException {
        return new HelpSubCommandHandler(parser);
    }

    public static void displaySingleComponent(ConsoleApplication app, AbstractManagedObjectDefinition<?, ?> d, Collection<PropertyDefinition<?>> c) {
        app.println(DSConfigMessages.INFO_DSCFG_HELP_HEADING_COMPONENT.get(d.getUserFriendlyName()));
        app.println();
        app.println(d.getSynopsis());
        if (d.getDescription() != null) {
            app.println();
            app.println(d.getDescription());
        }
        app.println();
        app.println();
        HelpSubCommandHandler.displayPropertyOptionKey(app);
        app.println();
        app.println();
        TableBuilder builder = new TableBuilder();
        builder.appendHeading(DSConfigMessages.INFO_DSCFG_HEADING_PROPERTY_NAME.get());
        builder.appendHeading(DSConfigMessages.INFO_DSCFG_HEADING_PROPERTY_OPTIONS.get());
        builder.appendHeading(DSConfigMessages.INFO_DSCFG_HEADING_PROPERTY_SYNTAX.get());
        builder.addSortKey(0);
        for (PropertyDefinition<?> pd : c) {
            builder.startRow();
            builder.appendCell(pd.getName());
            builder.appendCell(HelpSubCommandHandler.getPropertyOptionSummary(pd));
            PropertyDefinitionUsageBuilder v = new PropertyDefinitionUsageBuilder(false);
            builder.appendCell(v.getUsage(pd));
        }
        TextTablePrinter printer = new TextTablePrinter(app.getErrorStream());
        builder.print(printer);
    }

    public static void displayVerboseSingleProperty(ConsoleApplication app, AbstractManagedObjectDefinition<?, ?> d, String name) {
        AggregationPropertyDefinition apd;
        PropertyDefinition<?> pd = d.getPropertyDefinition(name);
        app.println(DSConfigMessages.INFO_DSCFG_HELP_HEADING_PROPERTY.get(name));
        app.println();
        app.printErrln(pd.getSynopsis(), 4);
        if (pd.getDescription() != null) {
            app.println();
            app.printErrln(pd.getDescription(), 4);
        }
        if (pd instanceof AggregationPropertyDefinition && (apd = (AggregationPropertyDefinition)pd).getSourceConstraintSynopsis() != null) {
            app.println();
            app.println(apd.getSourceConstraintSynopsis(), 4);
        }
        app.println();
        SyntaxPrinter syntaxPrinter = new SyntaxPrinter();
        syntaxPrinter.print(app.getErrorStream(), pd);
        app.println();
        TableBuilder builder = new TableBuilder();
        DefaultBehaviorPrinter defaultPrinter = new DefaultBehaviorPrinter();
        builder.startRow();
        builder.appendCell(DSConfigMessages.INFO_DSCFG_HELP_HEADING_DEFAULT.get());
        builder.appendCell(HEADING_SEPARATOR);
        builder.appendCell(defaultPrinter.print(pd));
        builder.startRow();
        builder.appendCell(DSConfigMessages.INFO_DSCFG_HELP_HEADING_ADVANCED.get());
        builder.appendCell(HEADING_SEPARATOR);
        if (pd.hasOption(PropertyOption.ADVANCED)) {
            builder.appendCell(UtilityMessages.INFO_GENERAL_YES.get());
        } else {
            builder.appendCell(UtilityMessages.INFO_GENERAL_NO.get());
        }
        builder.startRow();
        builder.appendCell(DSConfigMessages.INFO_DSCFG_HELP_HEADING_MULTI_VALUED.get());
        builder.appendCell(HEADING_SEPARATOR);
        if (pd.hasOption(PropertyOption.MULTI_VALUED)) {
            builder.appendCell(UtilityMessages.INFO_GENERAL_YES.get());
        } else {
            builder.appendCell(UtilityMessages.INFO_GENERAL_NO.get());
        }
        builder.startRow();
        builder.appendCell(DSConfigMessages.INFO_DSCFG_HELP_HEADING_MANDATORY.get());
        builder.appendCell(HEADING_SEPARATOR);
        if (pd.hasOption(PropertyOption.MANDATORY)) {
            builder.appendCell(UtilityMessages.INFO_GENERAL_YES.get());
        } else {
            builder.appendCell(UtilityMessages.INFO_GENERAL_NO.get());
        }
        builder.startRow();
        builder.appendCell(DSConfigMessages.INFO_DSCFG_HELP_HEADING_READ_ONLY.get());
        builder.appendCell(HEADING_SEPARATOR);
        if (pd.hasOption(PropertyOption.MONITORING)) {
            builder.appendCell(DSConfigMessages.INFO_DSCFG_HELP_FIELD_MONITORING.get());
        } else if (pd.hasOption(PropertyOption.READ_ONLY)) {
            builder.appendCell(DSConfigMessages.INFO_DSCFG_HELP_FIELD_READ_ONLY.get(d.getUserFriendlyName()));
        } else {
            builder.appendCell(UtilityMessages.INFO_GENERAL_NO.get());
        }
        TextTablePrinter factory = new TextTablePrinter(app.getErrorStream());
        factory.setDisplayHeadings(false);
        factory.setColumnWidth(0, HEADING_WIDTH);
        factory.setColumnWidth(2, 0);
        factory.setPadding(0);
        builder.print(factory);
        AdministratorAction action = pd.getAdministratorAction();
        Message synopsis = action.getSynopsis();
        if (synopsis == null) {
            switch (action.getType()) {
                case COMPONENT_RESTART: {
                    synopsis = DSConfigMessages.INFO_DSCFG_HELP_FIELD_COMPONENT_RESTART.get(d.getUserFriendlyName());
                    break;
                }
                case SERVER_RESTART: {
                    synopsis = DSConfigMessages.INFO_DSCFG_HELP_FIELD_SERVER_RESTART.get();
                    break;
                }
            }
        }
        if (synopsis != null) {
            app.println();
            app.println(synopsis);
        }
    }

    private static void displayPropertyOptionKey(ConsoleApplication app) {
        app.println(DSConfigMessages.INFO_DSCFG_HELP_DESCRIPTION_OPTION.get());
        app.println();
        MessageBuilder builder = new MessageBuilder();
        builder.append(" r -- ");
        builder.append(DSConfigMessages.INFO_DSCFG_HELP_DESCRIPTION_READ.get());
        app.println(builder.toMessage());
        builder = new MessageBuilder();
        builder.append(" w -- ");
        builder.append(DSConfigMessages.INFO_DSCFG_HELP_DESCRIPTION_WRITE.get());
        app.println(builder.toMessage());
        builder = new MessageBuilder();
        builder.append(" m -- ");
        builder.append(DSConfigMessages.INFO_DSCFG_HELP_DESCRIPTION_MANDATORY.get());
        app.println(builder.toMessage());
        builder = new MessageBuilder();
        builder.append(" s -- ");
        builder.append(DSConfigMessages.INFO_DSCFG_HELP_DESCRIPTION_SINGLE_VALUED.get());
        app.println(builder.toMessage());
        builder = new MessageBuilder();
        builder.append(" a -- ");
        builder.append(DSConfigMessages.INFO_DSCFG_HELP_DESCRIPTION_ADMIN_ACTION.get());
        app.println(builder.toMessage());
    }

    private static String getPropertyOptionSummary(PropertyDefinition<?> pd) {
        StringBuilder b = new StringBuilder();
        if (pd.hasOption(PropertyOption.MONITORING) || pd.hasOption(PropertyOption.READ_ONLY)) {
            b.append("r-");
        } else {
            b.append("rw");
        }
        if (pd.hasOption(PropertyOption.MANDATORY)) {
            b.append('m');
        } else {
            b.append('-');
        }
        if (pd.hasOption(PropertyOption.MULTI_VALUED)) {
            b.append('-');
        } else {
            b.append('s');
        }
        AdministratorAction action = pd.getAdministratorAction();
        if (action.getType() != AdministratorAction.Type.NONE) {
            b.append('a');
        } else {
            b.append('-');
        }
        return b.toString();
    }

    private HelpSubCommandHandler(SubCommandArgumentParser parser) throws ArgumentException {
        String name = "list-properties";
        Message desc = DSConfigMessages.INFO_DSCFG_DESCRIPTION_SUBCMD_HELPPROP.get();
        this.subCommand = new SubCommand(parser, name, false, 0, 0, null, desc);
        this.categoryArgument = new StringArgument(OPTION_DSCFG_LONG_CATEGORY, OPTION_DSCFG_SHORT_CATEGORY, OPTION_DSCFG_LONG_CATEGORY, false, false, true, ToolMessages.INFO_CATEGORY_PLACEHOLDER.get(), null, null, DSConfigMessages.INFO_DSCFG_DESCRIPTION_HELP_CATEGORY.get());
        this.subCommand.addArgument(this.categoryArgument);
        this.typeArgument = new StringArgument(OPTION_DSCFG_LONG_TYPE, OPTION_DSCFG_SHORT_TYPE, OPTION_DSCFG_LONG_TYPE, false, false, true, ToolMessages.INFO_TYPE_PLACEHOLDER.get(), null, null, DSConfigMessages.INFO_DSCFG_DESCRIPTION_HELP_TYPE.get());
        this.subCommand.addArgument(this.typeArgument);
        this.inheritedModeArgument = new BooleanArgument(OPTION_DSCFG_LONG_INHERITED, OPTION_DSCFG_SHORT_INHERITED, OPTION_DSCFG_LONG_INHERITED, DSConfigMessages.INFO_DSCFG_DESCRIPTION_HELP_INHERITED.get());
        this.subCommand.addArgument(this.inheritedModeArgument);
        this.registerPropertyNameArgument(this.subCommand);
        this.categoryMap = new TreeMap();
        this.tagMap = new HashMap();
        this.setCommandBuilderUseful(false);
    }

    @Override
    public SubCommand getSubCommand() {
        return this.subCommand;
    }

    public void registerManagedObjectDefinition(AbstractManagedObjectDefinition<?, ?> d) {
        AbstractManagedObjectDefinition<?, ?> parent = d;
        while (!parent.getParent().isTop()) {
            parent = parent.getParent();
        }
        String baseName = parent.getName();
        String typeName = null;
        if (parent == d) {
            typeName = "generic";
        } else {
            String suffix = "-" + baseName;
            typeName = d.getName();
            if (typeName.endsWith(suffix)) {
                typeName = typeName.substring(0, typeName.length() - suffix.length());
            }
        }
        Map<String, AbstractManagedObjectDefinition<?, ?>> subTypes = this.categoryMap.get(baseName);
        if (subTypes == null) {
            subTypes = new TreeMap();
            this.categoryMap.put(baseName, subTypes);
        }
        subTypes.put(typeName, d);
        for (Tag tag : d.getAllTags()) {
            subTypes = this.tagMap.get(tag);
            if (subTypes == null) {
                subTypes = new TreeMap();
                this.tagMap.put(tag, subTypes);
            }
            subTypes.put(typeName, d);
        }
    }

    @Override
    public MenuResult<Integer> run(ConsoleApplication app, ManagementContextFactory factory) throws ArgumentException, ClientException, CLIException {
        String categoryName = this.categoryArgument.getValue();
        String typeName = this.typeArgument.getValue();
        Tag tag = null;
        Set<String> propertyNames = this.getPropertyNames();
        this.getCommandBuilder().clearArguments();
        this.updateCommandBuilderWithSubCommand();
        LinkedList dlist = new LinkedList();
        AbstractManagedObjectDefinition<?, ?> tmp = null;
        if (categoryName != null) {
            Map<String, AbstractManagedObjectDefinition<?, ?>> subTypes = this.categoryMap.get(categoryName);
            if (subTypes == null) {
                try {
                    tag = Tag.valueOf(categoryName);
                }
                catch (IllegalArgumentException e) {
                    throw ArgumentExceptionFactory.unknownCategory(categoryName);
                }
                subTypes = this.tagMap.get(tag);
                if (subTypes == null) {
                    throw ArgumentExceptionFactory.unknownCategory(categoryName);
                }
            } else {
                tmp = subTypes.get("generic");
            }
            if (typeName != null) {
                AbstractManagedObjectDefinition<?, ?> d = subTypes.get(typeName);
                if (d == null) {
                    throw ArgumentExceptionFactory.unknownTypeForCategory(typeName, categoryName);
                }
                dlist.add(d);
                tmp = d;
            } else {
                dlist.addAll(subTypes.values());
            }
        } else if (typeName != null) {
            boolean isFound = false;
            for (Map<String, AbstractManagedObjectDefinition<?, ?>> subTypes : this.categoryMap.values()) {
                AbstractManagedObjectDefinition<?, ?> d = subTypes.get(typeName);
                if (d == null) continue;
                dlist.add(d);
                isFound = true;
            }
            if (!isFound) {
                throw ArgumentExceptionFactory.unknownTypeForCategory(typeName, categoryName);
            }
        } else {
            for (Map<String, AbstractManagedObjectDefinition<?, ?>> subTypes : this.categoryMap.values()) {
                dlist.addAll(subTypes.values());
            }
        }
        if (dlist.size() == 1) {
            tmp = (AbstractManagedObjectDefinition<?, ?>)dlist.get(0);
        }
        for (String propertyName : propertyNames) {
            boolean isFound = false;
            for (AbstractManagedObjectDefinition abstractManagedObjectDefinition : dlist) {
                try {
                    abstractManagedObjectDefinition.getPropertyDefinition(propertyName);
                    isFound = true;
                }
                catch (IllegalArgumentException e) {}
            }
            if (isFound) continue;
            if (tmp != null) {
                throw ArgumentExceptionFactory.unknownProperty(tmp, propertyName);
            }
            throw ArgumentExceptionFactory.unknownProperty(propertyName);
        }
        if (!(app = new OutputStreamConsoleApplication(app)).isVerbose()) {
            this.displayNonVerbose(app, categoryName, typeName, tag, propertyNames);
        } else {
            this.displayVerbose(app, categoryName, typeName, tag, propertyNames);
        }
        return MenuResult.success(0);
    }

    private void displayNonVerbose(ConsoleApplication app, String categoryName, String typeName, Tag tag, Set<String> propertyNames) {
        if (!app.isScriptFriendly()) {
            HelpSubCommandHandler.displayPropertyOptionKey(app);
            app.println();
            app.println();
        }
        TableBuilder builder = new TableBuilder();
        builder.appendHeading(DSConfigMessages.INFO_DSCFG_HEADING_COMPONENT_NAME.get());
        builder.appendHeading(DSConfigMessages.INFO_DSCFG_HEADING_COMPONENT_TYPE.get());
        builder.appendHeading(DSConfigMessages.INFO_DSCFG_HEADING_PROPERTY_NAME.get());
        builder.appendHeading(DSConfigMessages.INFO_DSCFG_HEADING_PROPERTY_OPTIONS.get());
        builder.appendHeading(DSConfigMessages.INFO_DSCFG_HEADING_PROPERTY_SYNTAX.get());
        builder.addSortKey(0);
        builder.addSortKey(1);
        builder.addSortKey(2);
        for (String category : this.categoryMap.keySet()) {
            if (categoryName != null && !categoryName.equals(category)) continue;
            Map<String, AbstractManagedObjectDefinition<?, ?>> subTypes = this.categoryMap.get(category);
            for (String type : subTypes.keySet()) {
                AbstractManagedObjectDefinition<?, ?> mod;
                if (typeName != null && !typeName.equals(type) || (mod = subTypes.get(type)).hasOption(ManagedObjectOption.HIDDEN) || !app.isAdvancedMode() && mod.hasOption(ManagedObjectOption.ADVANCED) || tag != null && !mod.hasTag(tag)) continue;
                TreeSet pds = new TreeSet();
                if (this.inheritedModeArgument.isPresent()) {
                    pds.addAll(mod.getAllPropertyDefinitions());
                } else {
                    pds.addAll(mod.getPropertyDefinitions());
                    if (mod.getParent() != null) {
                        pds.removeAll(mod.getParent().getAllPropertyDefinitions());
                    }
                }
                for (PropertyDefinition propertyDefinition : pds) {
                    if (propertyDefinition.hasOption(PropertyOption.HIDDEN) || !app.isAdvancedMode() && propertyDefinition.hasOption(PropertyOption.ADVANCED) || !propertyNames.isEmpty() && !propertyNames.contains(propertyDefinition.getName())) continue;
                    builder.startRow();
                    builder.appendCell(category);
                    builder.appendCell(type);
                    builder.appendCell(propertyDefinition.getName());
                    builder.appendCell(HelpSubCommandHandler.getPropertyOptionSummary(propertyDefinition));
                    PropertyDefinitionUsageBuilder v = new PropertyDefinitionUsageBuilder(false);
                    builder.appendCell(v.getUsage(propertyDefinition));
                }
            }
        }
        TablePrinter printer = app.isScriptFriendly() ? this.createScriptFriendlyTablePrinter(app.getOutputStream()) : new TextTablePrinter(app.getOutputStream());
        builder.print(printer);
    }

    private void displayVerbose(ConsoleApplication app, String categoryName, String typeName, Tag tag, Set<String> propertyNames) {
        MessageBuilder mb = new MessageBuilder();
        for (int i = 0; i < ServerConstants.MAX_LINE_WIDTH; ++i) {
            mb.append('=');
        }
        Message c1 = mb.toMessage();
        mb = new MessageBuilder();
        for (int i = 0; i < ServerConstants.MAX_LINE_WIDTH; ++i) {
            mb.append('-');
        }
        Message c2 = mb.toMessage();
        boolean isFirstManagedObject = true;
        for (String category : this.categoryMap.keySet()) {
            if (categoryName != null && !categoryName.equals(category)) continue;
            Map<String, AbstractManagedObjectDefinition<?, ?>> subTypes = this.categoryMap.get(category);
            for (String type : subTypes.keySet()) {
                AbstractManagedObjectDefinition<?, ?> mod;
                if (typeName != null && !typeName.equals(type) || (mod = subTypes.get(type)).hasOption(ManagedObjectOption.HIDDEN) || !app.isAdvancedMode() && mod.hasOption(ManagedObjectOption.ADVANCED) || tag != null && !mod.hasTag(tag)) continue;
                TreeSet pds = new TreeSet();
                if (this.inheritedModeArgument.isPresent()) {
                    pds.addAll(mod.getAllPropertyDefinitions());
                } else {
                    pds.addAll(mod.getPropertyDefinitions());
                    if (mod.getParent() != null) {
                        pds.removeAll(mod.getParent().getAllPropertyDefinitions());
                    }
                }
                boolean isFirstProperty = true;
                for (PropertyDefinition propertyDefinition : pds) {
                    if (propertyDefinition.hasOption(PropertyOption.HIDDEN) || !app.isAdvancedMode() && propertyDefinition.hasOption(PropertyOption.ADVANCED) || !propertyNames.isEmpty() && !propertyNames.contains(propertyDefinition.getName())) continue;
                    if (isFirstProperty) {
                        if (!isFirstManagedObject) {
                            app.println();
                            app.println(c1);
                            app.println();
                        } else {
                            isFirstManagedObject = false;
                        }
                        app.println(DSConfigMessages.INFO_DSCFG_HELP_HEADING_COMPONENT.get(mod.getUserFriendlyName()));
                        app.println();
                        app.println(mod.getSynopsis());
                        if (mod.getDescription() != null) {
                            app.println();
                            app.println(mod.getDescription());
                        }
                    }
                    app.println();
                    app.println(c2);
                    app.println();
                    HelpSubCommandHandler.displayVerboseSingleProperty(app, mod, propertyDefinition.getName());
                    isFirstProperty = false;
                }
            }
        }
    }

    static {
        OPTION_DSCFG_SHORT_CATEGORY = Character.valueOf('c');
        OPTION_DSCFG_SHORT_INHERITED = null;
        OPTION_DSCFG_SHORT_TYPE = Character.valueOf('t');
        int tmp = DSConfigMessages.INFO_DSCFG_HELP_HEADING_SYNTAX.get().length();
        tmp = Math.max(tmp, DSConfigMessages.INFO_DSCFG_HELP_HEADING_DEFAULT.get().length());
        tmp = Math.max(tmp, DSConfigMessages.INFO_DSCFG_HELP_HEADING_MULTI_VALUED.get().length());
        tmp = Math.max(tmp, DSConfigMessages.INFO_DSCFG_HELP_HEADING_MANDATORY.get().length());
        HEADING_WIDTH = tmp = Math.max(tmp, DSConfigMessages.INFO_DSCFG_HELP_HEADING_READ_ONLY.get().length());
    }

    private static class SyntaxPrinter {
        private final Visitor pimpl = new Visitor();

        public void print(PrintStream out, PropertyDefinition<?> pd) {
            pd.accept(this.pimpl, out);
        }

        private static class Visitor
        extends PropertyDefinitionVisitor<Void, PrintStream> {
            private Visitor() {
            }

            @Override
            public <E extends Enum<E>> Void visitEnum(EnumPropertyDefinition<E> d, PrintStream p) {
                this.displayUsage(p, DSConfigMessages.INFO_DSCFG_HELP_FIELD_ENUM.get());
                p.println();
                TableBuilder builder = new TableBuilder();
                boolean isFirst = true;
                for (Enum value : EnumSet.allOf(d.getEnumClass())) {
                    if (!isFirst) {
                        builder.startRow();
                    }
                    builder.startRow();
                    builder.appendCell();
                    builder.appendCell();
                    builder.appendCell(value.toString());
                    builder.appendCell(HelpSubCommandHandler.HEADING_SEPARATOR);
                    builder.appendCell(d.getValueSynopsis(value));
                    isFirst = false;
                }
                TextTablePrinter factory = new TextTablePrinter(p);
                factory.setDisplayHeadings(false);
                factory.setColumnWidth(0, HEADING_WIDTH);
                factory.setColumnWidth(1, HelpSubCommandHandler.HEADING_SEPARATOR.length());
                factory.setColumnWidth(4, 0);
                factory.setPadding(0);
                builder.print(factory);
                return null;
            }

            @Override
            public Void visitString(StringPropertyDefinition d, PrintStream p) {
                PropertyDefinitionUsageBuilder usageBuilder = new PropertyDefinitionUsageBuilder(false);
                TableBuilder builder = new TableBuilder();
                builder.startRow();
                builder.appendCell(DSConfigMessages.INFO_DSCFG_HELP_HEADING_SYNTAX.get());
                builder.appendCell(HelpSubCommandHandler.HEADING_SEPARATOR);
                builder.appendCell(usageBuilder.getUsage(d));
                if (d.getPattern() != null) {
                    builder.startRow();
                    builder.startRow();
                    builder.appendCell();
                    builder.appendCell();
                    builder.appendCell(d.getPatternSynopsis());
                }
                TextTablePrinter factory = new TextTablePrinter(p);
                factory.setDisplayHeadings(false);
                factory.setColumnWidth(0, HEADING_WIDTH);
                factory.setColumnWidth(2, 0);
                factory.setPadding(0);
                builder.print(factory);
                return null;
            }

            @Override
            public <T> Void visitUnknown(PropertyDefinition<T> d, PrintStream p) throws UnknownPropertyDefinitionException {
                PropertyDefinitionUsageBuilder usageBuilder = new PropertyDefinitionUsageBuilder(true);
                this.displayUsage(p, usageBuilder.getUsage(d));
                return null;
            }

            private void displayUsage(PrintStream p, Message usage) {
                TableBuilder builder = new TableBuilder();
                builder.startRow();
                builder.appendCell(DSConfigMessages.INFO_DSCFG_HELP_HEADING_SYNTAX.get());
                builder.appendCell(HelpSubCommandHandler.HEADING_SEPARATOR);
                builder.appendCell(usage);
                TextTablePrinter factory = new TextTablePrinter(p);
                factory.setDisplayHeadings(false);
                factory.setColumnWidth(0, HEADING_WIDTH);
                factory.setColumnWidth(2, 0);
                factory.setPadding(0);
                builder.print(factory);
            }
        }
    }

    private static class DefaultBehaviorPrinter {
        public <T> Message print(PropertyDefinition<T> pd) {
            DefaultVisitor v = new DefaultVisitor();
            return (Message)pd.getDefaultBehaviorProvider().accept(v, pd);
        }

        private static class DefaultVisitor<T>
        implements DefaultBehaviorProviderVisitor<T, Message, PropertyDefinition<T>> {
            private DefaultVisitor() {
            }

            @Override
            public Message visitAbsoluteInherited(AbsoluteInheritedDefaultBehaviorProvider<T> d, PropertyDefinition<T> p) {
                return DSConfigMessages.INFO_DSCFG_HELP_FIELD_INHERITED_ABS.get(d.getPropertyName(), d.getManagedObjectPath().getRelationDefinition().getUserFriendlyName());
            }

            @Override
            public Message visitAlias(AliasDefaultBehaviorProvider<T> d, PropertyDefinition<T> p) {
                return d.getSynopsis();
            }

            @Override
            public Message visitDefined(DefinedDefaultBehaviorProvider<T> d, PropertyDefinition<T> p) {
                MessageBuilder builder = new MessageBuilder();
                PropertyValuePrinter printer = new PropertyValuePrinter(null, null, false);
                boolean isFirst = true;
                for (String s : d.getDefaultValues()) {
                    if (!isFirst) {
                        builder.append(", ");
                    }
                    T value = p.decodeValue(s);
                    builder.append(printer.print(p, value));
                }
                return builder.toMessage();
            }

            @Override
            public Message visitRelativeInherited(RelativeInheritedDefaultBehaviorProvider<T> d, PropertyDefinition<T> p) {
                if (d.getRelativeOffset() == 0) {
                    return DSConfigMessages.INFO_DSCFG_HELP_FIELD_INHERITED_THIS.get(d.getPropertyName(), d.getManagedObjectDefinition().getUserFriendlyName());
                }
                return DSConfigMessages.INFO_DSCFG_HELP_FIELD_INHERITED_PARENT.get(d.getPropertyName(), d.getManagedObjectDefinition().getUserFriendlyName());
            }

            @Override
            public Message visitUndefined(UndefinedDefaultBehaviorProvider<T> d, PropertyDefinition<T> p) {
                return DSConfigMessages.INFO_DSCFG_HELP_FIELD_UNDEFINED.get();
            }
        }
    }
}

