/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.dsconfig;

import java.util.SortedSet;
import java.util.TreeSet;
import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.ConfigurationClient;
import org.opends.server.admin.InstantiableRelationDefinition;
import org.opends.server.admin.ManagedObjectPath;
import org.opends.server.admin.OptionalRelationDefinition;
import org.opends.server.admin.RelationDefinition;
import org.opends.server.admin.RelationDefinitionVisitor;
import org.opends.server.admin.RelationOption;
import org.opends.server.admin.SetRelationDefinition;
import org.opends.server.admin.SingletonRelationDefinition;
import org.opends.server.tools.dsconfig.CreateSubCommandHandler;
import org.opends.server.tools.dsconfig.DeleteSubCommandHandler;
import org.opends.server.tools.dsconfig.GetPropSubCommandHandler;
import org.opends.server.tools.dsconfig.HelpSubCommandHandler;
import org.opends.server.tools.dsconfig.ListSubCommandHandler;
import org.opends.server.tools.dsconfig.SetPropSubCommandHandler;
import org.opends.server.tools.dsconfig.SubCommandHandler;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.SubCommandArgumentParser;

final class SubCommandHandlerFactory {
    private final SortedSet<SubCommandHandler> allHandlers = new TreeSet<SubCommandHandler>();
    private final SortedSet<CreateSubCommandHandler<?, ?>> createHandlers = new TreeSet();
    private final SortedSet<DeleteSubCommandHandler> deleteHandlers = new TreeSet<DeleteSubCommandHandler>();
    private ArgumentException exception = null;
    private final SortedSet<GetPropSubCommandHandler> getPropHandlers = new TreeSet<GetPropSubCommandHandler>();
    private HelpSubCommandHandler helpHandler = null;
    private final SortedSet<ListSubCommandHandler> listHandlers = new TreeSet<ListSubCommandHandler>();
    private final SubCommandArgumentParser parser;
    private final SortedSet<SetPropSubCommandHandler> setPropHandlers = new TreeSet<SetPropSubCommandHandler>();
    private final Visitor visitor = new Visitor();

    public SubCommandHandlerFactory(SubCommandArgumentParser parser) throws ArgumentException {
        this.parser = parser;
        this.helpHandler = HelpSubCommandHandler.create(parser);
        this.processPath(ManagedObjectPath.emptyPath());
        this.allHandlers.add(this.helpHandler);
        this.allHandlers.addAll(this.createHandlers);
        this.allHandlers.addAll(this.deleteHandlers);
        this.allHandlers.addAll(this.listHandlers);
        this.allHandlers.addAll(this.getPropHandlers);
        this.allHandlers.addAll(this.setPropHandlers);
        if (this.exception != null) {
            throw this.exception;
        }
    }

    public SortedSet<SubCommandHandler> getAllSubCommandHandlers() {
        return this.allHandlers;
    }

    public SortedSet<CreateSubCommandHandler<?, ?>> getCreateSubCommandHandlers() {
        return this.createHandlers;
    }

    public SortedSet<DeleteSubCommandHandler> getDeleteSubCommandHandlers() {
        return this.deleteHandlers;
    }

    public SortedSet<GetPropSubCommandHandler> getGetPropSubCommandHandlers() {
        return this.getPropHandlers;
    }

    public SortedSet<ListSubCommandHandler> getListSubCommandHandlers() {
        return this.listHandlers;
    }

    public SortedSet<SetPropSubCommandHandler> getSetPropSubCommandHandlers() {
        return this.setPropHandlers;
    }

    private void processPath(ManagedObjectPath<?, ?> path) {
        AbstractManagedObjectDefinition<?, ?> d = path.getManagedObjectDefinition();
        for (RelationDefinition<?, ?> r : d.getRelationDefinitions()) {
            if (r.hasOption(RelationOption.HIDDEN)) continue;
            r.accept(this.visitor, path);
        }
    }

    private <C extends ConfigurationClient, S extends Configuration> void processRelation(ManagedObjectPath<?, ?> path, InstantiableRelationDefinition<C, S> r) {
        AbstractManagedObjectDefinition d = r.getChildDefinition();
        this.helpHandler.registerManagedObjectDefinition(d);
        this.processPath(path.child(r, d, "DUMMY"));
        for (AbstractManagedObjectDefinition c : d.getAllChildren()) {
            this.helpHandler.registerManagedObjectDefinition(c);
            this.processPath(path.child(r, c, "DUMMY"));
        }
    }

    private <C extends ConfigurationClient, S extends Configuration> void processRelation(ManagedObjectPath<?, ?> path, OptionalRelationDefinition<C, S> r) {
        AbstractManagedObjectDefinition d = r.getChildDefinition();
        this.helpHandler.registerManagedObjectDefinition(d);
        this.processPath(path.child(r, d));
        for (AbstractManagedObjectDefinition c : d.getAllChildren()) {
            this.helpHandler.registerManagedObjectDefinition(c);
            this.processPath(path.child(r, c));
        }
    }

    private <C extends ConfigurationClient, S extends Configuration> void processRelation(ManagedObjectPath<?, ?> path, SetRelationDefinition<C, S> r) {
        AbstractManagedObjectDefinition d = r.getChildDefinition();
        this.helpHandler.registerManagedObjectDefinition(d);
        this.processPath(path.child(r, d));
        for (AbstractManagedObjectDefinition c : d.getAllChildren()) {
            this.helpHandler.registerManagedObjectDefinition(c);
            this.processPath(path.child(r, c));
        }
    }

    private <C extends ConfigurationClient, S extends Configuration> void processRelation(ManagedObjectPath<?, ?> path, SingletonRelationDefinition<C, S> r) {
        AbstractManagedObjectDefinition d = r.getChildDefinition();
        this.helpHandler.registerManagedObjectDefinition(d);
        this.processPath(path.child(r, d));
        for (AbstractManagedObjectDefinition c : d.getAllChildren()) {
            this.helpHandler.registerManagedObjectDefinition(c);
            this.processPath(path.child(r, c));
        }
    }

    private final class Visitor
    implements RelationDefinitionVisitor<Void, ManagedObjectPath<?, ?>> {
        private Visitor() {
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> Void visitInstantiable(InstantiableRelationDefinition<C, S> rd, ManagedObjectPath<?, ?> p) {
            try {
                SubCommandHandlerFactory.this.createHandlers.add(CreateSubCommandHandler.create(SubCommandHandlerFactory.this.parser, p, rd));
                SubCommandHandlerFactory.this.deleteHandlers.add(DeleteSubCommandHandler.create(SubCommandHandlerFactory.this.parser, p, rd));
                SubCommandHandlerFactory.this.listHandlers.add(ListSubCommandHandler.create(SubCommandHandlerFactory.this.parser, p, rd));
                SubCommandHandlerFactory.this.getPropHandlers.add(GetPropSubCommandHandler.create(SubCommandHandlerFactory.this.parser, p, rd));
                SubCommandHandlerFactory.this.setPropHandlers.add(SetPropSubCommandHandler.create(SubCommandHandlerFactory.this.parser, p, rd));
                SubCommandHandlerFactory.this.processRelation(p, rd);
            }
            catch (ArgumentException e) {
                SubCommandHandlerFactory.this.exception = e;
            }
            return null;
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> Void visitOptional(OptionalRelationDefinition<C, S> rd, ManagedObjectPath<?, ?> p) {
            try {
                SubCommandHandlerFactory.this.createHandlers.add(CreateSubCommandHandler.create(SubCommandHandlerFactory.this.parser, p, rd));
                SubCommandHandlerFactory.this.deleteHandlers.add(DeleteSubCommandHandler.create(SubCommandHandlerFactory.this.parser, p, rd));
                SubCommandHandlerFactory.this.listHandlers.add(ListSubCommandHandler.create(SubCommandHandlerFactory.this.parser, p, rd));
                SubCommandHandlerFactory.this.getPropHandlers.add(GetPropSubCommandHandler.create(SubCommandHandlerFactory.this.parser, p, rd));
                SubCommandHandlerFactory.this.setPropHandlers.add(SetPropSubCommandHandler.create(SubCommandHandlerFactory.this.parser, p, rd));
                SubCommandHandlerFactory.this.processRelation(p, rd);
            }
            catch (ArgumentException e) {
                SubCommandHandlerFactory.this.exception = e;
            }
            return null;
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> Void visitSet(SetRelationDefinition<C, S> rd, ManagedObjectPath<?, ?> p) {
            try {
                SubCommandHandlerFactory.this.createHandlers.add(CreateSubCommandHandler.create(SubCommandHandlerFactory.this.parser, p, rd));
                SubCommandHandlerFactory.this.deleteHandlers.add(DeleteSubCommandHandler.create(SubCommandHandlerFactory.this.parser, p, rd));
                SubCommandHandlerFactory.this.listHandlers.add(ListSubCommandHandler.create(SubCommandHandlerFactory.this.parser, p, rd));
                SubCommandHandlerFactory.this.getPropHandlers.add(GetPropSubCommandHandler.create(SubCommandHandlerFactory.this.parser, p, rd));
                SubCommandHandlerFactory.this.setPropHandlers.add(SetPropSubCommandHandler.create(SubCommandHandlerFactory.this.parser, p, rd));
                SubCommandHandlerFactory.this.processRelation(p, rd);
            }
            catch (ArgumentException e) {
                SubCommandHandlerFactory.this.exception = e;
            }
            return null;
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> Void visitSingleton(SingletonRelationDefinition<C, S> rd, ManagedObjectPath<?, ?> p) {
            try {
                SubCommandHandlerFactory.this.getPropHandlers.add(GetPropSubCommandHandler.create(SubCommandHandlerFactory.this.parser, p, rd));
                SubCommandHandlerFactory.this.setPropHandlers.add(SetPropSubCommandHandler.create(SubCommandHandlerFactory.this.parser, p, rd));
                SubCommandHandlerFactory.this.processRelation(p, rd);
            }
            catch (ArgumentException e) {
                SubCommandHandlerFactory.this.exception = e;
            }
            return null;
        }
    }
}

