/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.makeldif;

import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.core.DirectoryServer;
import org.opends.server.tools.makeldif.Branch;
import org.opends.server.tools.makeldif.Tag;
import org.opends.server.tools.makeldif.TagResult;
import org.opends.server.tools.makeldif.Template;
import org.opends.server.tools.makeldif.TemplateEntry;
import org.opends.server.tools.makeldif.TemplateFile;
import org.opends.server.tools.makeldif.TemplateValue;
import org.opends.server.types.AttributeType;
import org.opends.server.types.InitializationException;
import org.opends.server.util.StaticUtils;

public class AttributeValueTag
extends Tag {
    private AttributeType attributeType = null;
    private int numCharacters = 0;

    @Override
    public String getName() {
        return "AttributeValue";
    }

    @Override
    public boolean allowedInBranch() {
        return true;
    }

    @Override
    public void initializeForBranch(TemplateFile templateFile, Branch branch, String[] arguments, int lineNumber, List<Message> warnings) throws InitializationException {
        block6: {
            if (arguments.length < 1 || arguments.length > 2) {
                Message message = ToolMessages.ERR_MAKELDIF_TAG_INVALID_ARGUMENT_RANGE_COUNT.get(this.getName(), lineNumber, 1, 2, arguments.length);
                throw new InitializationException(message);
            }
            String lowerName = StaticUtils.toLowerCase(arguments[0]);
            this.attributeType = DirectoryServer.getAttributeType(lowerName, true);
            if (!branch.hasAttribute(this.attributeType)) {
                Message message = ToolMessages.ERR_MAKELDIF_TAG_UNDEFINED_ATTRIBUTE.get(arguments[0], lineNumber);
                throw new InitializationException(message);
            }
            if (arguments.length == 2) {
                try {
                    this.numCharacters = Integer.parseInt(arguments[1]);
                    if (this.numCharacters < 0) {
                        Message message = ToolMessages.ERR_MAKELDIF_TAG_INTEGER_BELOW_LOWER_BOUND.get(this.numCharacters, 0, this.getName(), lineNumber);
                        throw new InitializationException(message);
                    }
                    break block6;
                }
                catch (NumberFormatException nfe) {
                    Message message = ToolMessages.ERR_MAKELDIF_TAG_CANNOT_PARSE_AS_INTEGER.get(arguments[1], this.getName(), lineNumber);
                    throw new InitializationException(message);
                }
            }
            this.numCharacters = 0;
        }
    }

    @Override
    public void initializeForTemplate(TemplateFile templateFile, Template template, String[] arguments, int lineNumber, List<Message> warnings) throws InitializationException {
        block6: {
            if (arguments.length < 1 || arguments.length > 2) {
                Message message = ToolMessages.ERR_MAKELDIF_TAG_INVALID_ARGUMENT_RANGE_COUNT.get(this.getName(), lineNumber, 1, 2, arguments.length);
                throw new InitializationException(message);
            }
            String lowerName = StaticUtils.toLowerCase(arguments[0]);
            this.attributeType = DirectoryServer.getAttributeType(lowerName, true);
            if (!template.hasAttribute(this.attributeType)) {
                Message message = ToolMessages.ERR_MAKELDIF_TAG_UNDEFINED_ATTRIBUTE.get(arguments[0], lineNumber);
                throw new InitializationException(message);
            }
            if (arguments.length == 2) {
                try {
                    this.numCharacters = Integer.parseInt(arguments[1]);
                    if (this.numCharacters < 0) {
                        Message message = ToolMessages.ERR_MAKELDIF_TAG_INTEGER_BELOW_LOWER_BOUND.get(this.numCharacters, 0, this.getName(), lineNumber);
                        throw new InitializationException(message);
                    }
                    break block6;
                }
                catch (NumberFormatException nfe) {
                    Message message = ToolMessages.ERR_MAKELDIF_TAG_CANNOT_PARSE_AS_INTEGER.get(arguments[1], this.getName(), lineNumber);
                    throw new InitializationException(message);
                }
            }
            this.numCharacters = 0;
        }
    }

    @Override
    public TagResult generateValue(TemplateEntry templateEntry, TemplateValue templateValue) {
        TemplateValue v = templateEntry.getValue(this.attributeType);
        if (v == null) {
            return TagResult.SUCCESS_RESULT;
        }
        if (this.numCharacters > 0) {
            String valueString = v.getValue().toString();
            if (valueString.length() > this.numCharacters) {
                templateValue.append(valueString.substring(0, this.numCharacters));
            } else {
                templateValue.append(valueString);
            }
        } else {
            templateValue.getValue().append((CharSequence)v.getValue());
        }
        return TagResult.SUCCESS_RESULT;
    }
}

