/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.status;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import org.opends.admin.ads.util.ApplicationTrustManager;
import org.opends.guitools.controlpanel.datamodel.BackendDescriptor;
import org.opends.guitools.controlpanel.datamodel.BaseDNDescriptor;
import org.opends.guitools.controlpanel.datamodel.BaseDNTableModel;
import org.opends.guitools.controlpanel.datamodel.ConfigReadException;
import org.opends.guitools.controlpanel.datamodel.ConnectionHandlerDescriptor;
import org.opends.guitools.controlpanel.datamodel.ConnectionHandlerTableModel;
import org.opends.guitools.controlpanel.datamodel.ConnectionProtocolPolicy;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.datamodel.ServerDescriptor;
import org.opends.guitools.controlpanel.util.ControlPanelLog;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.QuickSetupMessages;
import org.opends.messages.ToolMessages;
import org.opends.quicksetup.util.Utils;
import org.opends.server.admin.client.ManagementContext;
import org.opends.server.admin.client.cli.DsFrameworkCliReturnCode;
import org.opends.server.admin.client.cli.SecureConnectionCliArgs;
import org.opends.server.config.ConfigException;
import org.opends.server.tools.ClientException;
import org.opends.server.tools.dsconfig.LDAPManagementContextFactory;
import org.opends.server.tools.status.StatusCliArgumentParser;
import org.opends.server.types.DN;
import org.opends.server.types.InitializationException;
import org.opends.server.types.NullOutputStream;
import org.opends.server.types.OpenDsException;
import org.opends.server.util.BuildVersion;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.cli.ConsoleApplication;
import org.opends.server.util.cli.LDAPConnectionConsoleInteraction;
import org.opends.server.util.table.TableBuilder;
import org.opends.server.util.table.TextTablePrinter;

class StatusCli
extends ConsoleApplication {
    private boolean displayMustAuthenticateLegend;
    private boolean displayMustStartLegend;
    public static final String LOG_FILE_PREFIX = "opendj-status-";
    public static final String LOG_FILE_SUFFIX = ".log";
    private ApplicationTrustManager interactiveTrustManager;
    private boolean useInteractiveTrustManager;
    private final boolean alwaysSSL = true;
    private static final Logger LOG = Logger.getLogger(StatusCli.class.getName());
    private StatusCliArgumentParser argParser;

    public StatusCli(PrintStream out, PrintStream err, InputStream in) {
        super(in, (OutputStream)out, (OutputStream)err);
    }

    public static void main(String[] args) {
        int retCode = StatusCli.mainCLI(args, true, System.out, System.err, System.in);
        if (retCode != 0) {
            System.exit(retCode);
        }
    }

    public static int mainCLI(String[] args) {
        return StatusCli.mainCLI(args, true, System.out, System.err, System.in);
    }

    public static int mainCLI(String[] args, boolean initializeServer, OutputStream outStream, OutputStream errStream, InputStream inStream) {
        PrintStream out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
        PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        try {
            ControlPanelLog.initLogFileHandler(File.createTempFile(LOG_FILE_PREFIX, LOG_FILE_SUFFIX));
            ControlPanelLog.initPackage("org.opends.server.tools.status");
        }
        catch (Throwable t) {
            System.err.println("Unable to initialize log");
            t.printStackTrace();
        }
        StatusCli statusCli = new StatusCli(out, err, inStream);
        return statusCli.execute(args, initializeServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(String[] args, boolean initializeServer) {
        block53: {
            this.argParser = new StatusCliArgumentParser(StatusCli.class.getName());
            try {
                this.argParser.initializeGlobalArguments(this.getOutputStream());
            }
            catch (ArgumentException ae) {
                Message message = ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(ae.getMessage());
                this.println(message);
                return ErrorReturnCode.ERROR_UNEXPECTED.getReturnCode();
            }
            try {
                this.argParser.getSecureArgsList().initArgumentsWithConfiguration();
            }
            catch (ConfigException ce) {
                // empty catch block
            }
            try {
                this.argParser.parseArguments(args);
            }
            catch (ArgumentException ae) {
                Message message = ToolMessages.ERR_ERROR_PARSING_ARGS.get(ae.getMessage());
                this.println(message);
                this.println();
                this.println(Message.raw(this.argParser.getUsage(), new Object[0]));
                return ErrorReturnCode.ERROR_PARSING_ARGS.getReturnCode();
            }
            if (this.argParser.usageOrVersionDisplayed()) {
                return ErrorReturnCode.SUCCESSFUL_NOP.getReturnCode();
            }
            try {
                BuildVersion.checkVersionMismatch();
            }
            catch (InitializationException e) {
                this.println(e.getMessageObject());
                return 1;
            }
            int v = this.argParser.validateGlobalOptions(this.getErrorStream());
            if (v != DsFrameworkCliReturnCode.SUCCESSFUL_NOP.getReturnCode()) {
                this.println(Message.raw(this.argParser.getUsage(), new Object[0]));
                return v;
            }
            ControlPanelInfo controlInfo = ControlPanelInfo.getInstance();
            controlInfo.setTrustManager(this.getTrustManager());
            controlInfo.setConnectTimeout(this.argParser.getConnectTimeout());
            controlInfo.regenerateDescriptor();
            boolean authProvided = false;
            if (controlInfo.getServerDescriptor().getStatus() == ServerDescriptor.ServerStatus.STARTED) {
                String bindPwd;
                String bindDn;
                Object ctx;
                if (this.argParser.isInteractive()) {
                    ctx = null;
                    SecureConnectionCliArgs secureArgsList = this.argParser.getSecureArgsList();
                    int port = 4444;
                    controlInfo.setConnectionPolicy(ConnectionProtocolPolicy.USE_ADMIN);
                    String ldapUrl = controlInfo.getURLToConnect();
                    try {
                        URI uri = new URI(ldapUrl);
                        port = uri.getPort();
                    }
                    catch (Throwable t) {
                        LOG.log(Level.SEVERE, "Error parsing url: " + ldapUrl);
                    }
                    secureArgsList.hostNameArg.setPresent(true);
                    secureArgsList.portArg.setPresent(true);
                    secureArgsList.hostNameArg.addValue(secureArgsList.hostNameArg.getDefaultValue());
                    secureArgsList.portArg.addValue(Integer.toString(port));
                    LDAPConnectionConsoleInteraction ci = new LDAPConnectionConsoleInteraction(this, this.argParser.getSecureArgsList());
                    try {
                        ci.run(true, false);
                        bindDn = ci.getBindDN();
                        bindPwd = ci.getBindPassword();
                        LDAPManagementContextFactory factory = new LDAPManagementContextFactory(true);
                        ctx = factory.getManagementContext(this, ci);
                        this.interactiveTrustManager = ci.getTrustManager();
                        controlInfo.setTrustManager(this.interactiveTrustManager);
                        this.useInteractiveTrustManager = true;
                    }
                    catch (ArgumentException e) {
                        this.println(e.getMessageObject());
                        int n = ErrorReturnCode.USER_CANCELLED_OR_DATA_ERROR.getReturnCode();
                        return n;
                    }
                    catch (ClientException e) {
                        this.println(e.getMessageObject());
                        this.writeStatus(controlInfo);
                        int n = ErrorReturnCode.USER_CANCELLED_OR_DATA_ERROR.getReturnCode();
                        return n;
                    }
                    finally {
                        if (ctx != null) {
                            try {
                                ((ManagementContext)ctx).close();
                            }
                            catch (Throwable t) {}
                        }
                    }
                }
                bindDn = this.argParser.getBindDN();
                bindPwd = this.argParser.getBindPassword();
                boolean bl = authProvided = bindPwd != null;
                if (bindDn == null) {
                    bindDn = "";
                }
                if (bindPwd == null) {
                    bindPwd = "";
                }
                if (authProvided) {
                    int n;
                    ctx = null;
                    try {
                        ctx = Utilities.getAdminDirContext(controlInfo, bindDn, bindPwd);
                        controlInfo.setDirContext((InitialLdapContext)ctx);
                        controlInfo.regenerateDescriptor();
                        this.writeStatus(controlInfo);
                        if (!controlInfo.getServerDescriptor().getExceptions().isEmpty()) {
                            int secureArgsList = ErrorReturnCode.ERROR_READING_CONFIGURATION_WITH_LDAP.getReturnCode();
                            return secureArgsList;
                        }
                        break block53;
                    }
                    catch (NamingException ne) {
                        this.println();
                        this.println(QuickSetupMessages.INFO_ERROR_READING_SERVER_CONFIGURATION.get(ne.toString()));
                        n = ErrorReturnCode.ERROR_READING_CONFIGURATION_WITH_LDAP.getReturnCode();
                        return n;
                    }
                    catch (ConfigReadException cre) {
                        this.println();
                        this.println(cre.getMessageObject());
                        n = ErrorReturnCode.ERROR_READING_CONFIGURATION_WITH_LDAP.getReturnCode();
                        return n;
                    }
                    finally {
                        if (ctx != null) {
                            try {
                                ((InitialContext)ctx).close();
                            }
                            catch (Throwable t) {}
                        }
                    }
                }
                this.writeStatus(controlInfo);
            } else {
                this.writeStatus(controlInfo);
            }
        }
        return ErrorReturnCode.SUCCESSFUL.getReturnCode();
    }

    private void writeStatus(ControlPanelInfo controlInfo) {
        if (controlInfo.getServerDescriptor() == null) {
            controlInfo.regenerateDescriptor();
        }
        this.writeStatus(controlInfo.getServerDescriptor());
        int period = this.argParser.getRefreshPeriod();
        boolean first = true;
        while (period > 0) {
            long timeToSleep = period * 1000;
            if (!first) {
                long t1 = System.currentTimeMillis();
                controlInfo.regenerateDescriptor();
                long t2 = System.currentTimeMillis();
                timeToSleep = timeToSleep - t2 + t1;
            }
            if (timeToSleep > 0L) {
                try {
                    Thread.sleep(timeToSleep);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            this.getOutputStream().println();
            this.getOutputStream().println("          ---------------------");
            this.getOutputStream().println();
            this.writeStatus(controlInfo.getServerDescriptor());
            first = false;
        }
    }

    private void writeStatus(ServerDescriptor desc) {
        Message[] labels = new Message[]{AdminToolMessages.INFO_SERVER_STATUS_LABEL.get(), AdminToolMessages.INFO_CONNECTIONS_LABEL.get(), AdminToolMessages.INFO_HOSTNAME_LABEL.get(), AdminToolMessages.INFO_ADMINISTRATIVE_USERS_LABEL.get(), AdminToolMessages.INFO_INSTALLATION_PATH_LABEL.get(), AdminToolMessages.INFO_OPENDS_VERSION_LABEL.get(), AdminToolMessages.INFO_JAVA_VERSION_LABEL.get(), AdminToolMessages.INFO_CTRL_PANEL_ADMIN_CONNECTOR_LABEL.get()};
        int labelWidth = 0;
        Message title = AdminToolMessages.INFO_SERVER_STATUS_TITLE.get();
        if (!this.isScriptFriendly()) {
            for (Message label : labels) {
                labelWidth = Math.max(labelWidth, label.length());
            }
            this.getOutputStream().println();
            this.getOutputStream().println(this.centerTitle(title));
        }
        this.writeStatusContents(desc, labelWidth);
        this.writeCurrentConnectionContents(desc, labelWidth);
        if (!this.isScriptFriendly()) {
            this.getOutputStream().println();
        }
        title = AdminToolMessages.INFO_SERVER_DETAILS_TITLE.get();
        if (!this.isScriptFriendly()) {
            this.getOutputStream().println(this.centerTitle(title));
        }
        this.writeHostnameContents(desc, labelWidth);
        this.writeAdministrativeUserContents(desc, labelWidth);
        this.writeInstallPathContents(desc, labelWidth);
        boolean sameInstallAndInstance = desc.sameInstallAndInstance();
        if (!sameInstallAndInstance) {
            this.writeInstancePathContents(desc, labelWidth);
        }
        this.writeVersionContents(desc, labelWidth);
        this.writeJavaVersionContents(desc, labelWidth);
        this.writeAdminConnectorContents(desc, labelWidth);
        if (!this.isScriptFriendly()) {
            this.getOutputStream().println();
        }
        this.writeListenerContents(desc);
        if (!this.isScriptFriendly()) {
            this.getOutputStream().println();
        }
        this.writeBaseDNContents(desc);
        this.writeErrorContents(desc);
        if (!this.isScriptFriendly()) {
            if (this.displayMustStartLegend) {
                this.getOutputStream().println();
                this.getOutputStream().println(this.wrapText(AdminToolMessages.INFO_NOT_AVAILABLE_SERVER_DOWN_CLI_LEGEND.get()));
            } else if (this.displayMustAuthenticateLegend) {
                this.getOutputStream().println();
                this.getOutputStream().println(this.wrapText(AdminToolMessages.INFO_NOT_AVAILABLE_AUTHENTICATION_REQUIRED_CLI_LEGEND.get()));
            }
        }
        this.getOutputStream().println();
    }

    private void writeStatusContents(ServerDescriptor desc, int maxLabelWidth) {
        Message status;
        switch (desc.getStatus()) {
            case STARTED: {
                status = AdminToolMessages.INFO_SERVER_STARTED_LABEL.get();
                break;
            }
            case STOPPED: {
                status = AdminToolMessages.INFO_SERVER_STOPPED_LABEL.get();
                break;
            }
            case STARTING: {
                status = AdminToolMessages.INFO_SERVER_STARTING_LABEL.get();
                break;
            }
            case STOPPING: {
                status = AdminToolMessages.INFO_SERVER_STOPPING_LABEL.get();
                break;
            }
            case NOT_CONNECTED_TO_REMOTE: {
                status = AdminToolMessages.INFO_SERVER_NOT_CONNECTED_TO_REMOTE_STATUS_LABEL.get();
                break;
            }
            case UNKNOWN: {
                status = AdminToolMessages.INFO_SERVER_UNKNOWN_STATUS_LABEL.get();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown status: " + (Object)((Object)desc.getStatus()));
            }
        }
        this.writeLabelValue(AdminToolMessages.INFO_SERVER_STATUS_LABEL.get(), status, maxLabelWidth);
    }

    private void writeCurrentConnectionContents(ServerDescriptor desc, int maxLabelWidth) {
        int nConn;
        Message text = desc.getStatus() == ServerDescriptor.ServerStatus.STARTED ? ((nConn = desc.getOpenConnections()) >= 0 ? Message.raw(String.valueOf(nConn), new Object[0]) : (!desc.isAuthenticated() || !desc.getExceptions().isEmpty() ? this.getNotAvailableBecauseAuthenticationIsRequiredText() : this.getNotAvailableText())) : this.getNotAvailableBecauseServerIsDownText();
        this.writeLabelValue(AdminToolMessages.INFO_CONNECTIONS_LABEL.get(), text, maxLabelWidth);
    }

    private void writeHostnameContents(ServerDescriptor desc, int maxLabelWidth) {
        this.writeLabelValue(AdminToolMessages.INFO_HOSTNAME_LABEL.get(), Message.raw(desc.getHostname(), new Object[0]), maxLabelWidth);
    }

    private void writeAdministrativeUserContents(ServerDescriptor desc, int maxLabelWidth) {
        Set<DN> administrators = desc.getAdministrativeUsers();
        if (administrators.size() > 0) {
            TreeSet<DN> ordered = new TreeSet<DN>();
            ordered.addAll(administrators);
            DN first = (DN)ordered.iterator().next();
            this.writeLabelValue(AdminToolMessages.INFO_ADMINISTRATIVE_USERS_LABEL.get(), Message.raw(first.toString(), new Object[0]), maxLabelWidth);
            Iterator it = ordered.iterator();
            it.next();
            while (it.hasNext()) {
                this.writeLabelValue(AdminToolMessages.INFO_ADMINISTRATIVE_USERS_LABEL.get(), Message.raw(((DN)it.next()).toString(), new Object[0]), maxLabelWidth);
            }
        } else {
            Message text = desc.getStatus() == ServerDescriptor.ServerStatus.STARTED ? (!desc.isAuthenticated() || !desc.getExceptions().isEmpty() ? this.getNotAvailableBecauseAuthenticationIsRequiredText() : this.getNotAvailableText()) : this.getNotAvailableText();
            this.writeLabelValue(AdminToolMessages.INFO_ADMINISTRATIVE_USERS_LABEL.get(), text, maxLabelWidth);
        }
    }

    private void writeInstallPathContents(ServerDescriptor desc, int maxLabelWidth) {
        this.writeLabelValue(AdminToolMessages.INFO_INSTALLATION_PATH_LABEL.get(), Message.raw(desc.getInstallPath(), new Object[0]), maxLabelWidth);
    }

    private void writeInstancePathContents(ServerDescriptor desc, int maxLabelWidth) {
        this.writeLabelValue(AdminToolMessages.INFO_CTRL_PANEL_INSTANCE_PATH_LABEL.get(), Message.raw(desc.getInstancePath(), new Object[0]), maxLabelWidth);
    }

    private void writeVersionContents(ServerDescriptor desc, int maxLabelWidth) {
        String openDSVersion = desc.getOpenDSVersion();
        this.writeLabelValue(AdminToolMessages.INFO_OPENDS_VERSION_LABEL.get(), Message.raw(openDSVersion, new Object[0]), maxLabelWidth);
    }

    private void writeJavaVersionContents(ServerDescriptor desc, int maxLabelWidth) {
        Message text;
        if (desc.getStatus() == ServerDescriptor.ServerStatus.STARTED) {
            text = Message.raw(desc.getJavaVersion(), new Object[0]);
            if (text == null) {
                text = !desc.isAuthenticated() || !desc.getExceptions().isEmpty() ? this.getNotAvailableBecauseAuthenticationIsRequiredText() : this.getNotAvailableText();
            }
        } else {
            text = this.getNotAvailableBecauseServerIsDownText();
        }
        this.writeLabelValue(AdminToolMessages.INFO_JAVA_VERSION_LABEL.get(), text, maxLabelWidth);
    }

    private void writeAdminConnectorContents(ServerDescriptor desc, int maxLabelWidth) {
        ConnectionHandlerDescriptor adminConnector = desc.getAdminConnector();
        if (adminConnector != null) {
            Message text = AdminToolMessages.INFO_CTRL_PANEL_ADMIN_CONNECTOR_DESCRIPTION.get(adminConnector.getPort());
            this.writeLabelValue(AdminToolMessages.INFO_CTRL_PANEL_ADMIN_CONNECTOR_LABEL.get(), text, maxLabelWidth);
        } else {
            this.writeLabelValue(AdminToolMessages.INFO_CTRL_PANEL_ADMIN_CONNECTOR_LABEL.get(), AdminToolMessages.INFO_NOT_AVAILABLE_SHORT_LABEL.get(), maxLabelWidth);
        }
    }

    private void writeListenerContents(ServerDescriptor desc) {
        Set<ConnectionHandlerDescriptor> allHandlers;
        if (!this.isScriptFriendly()) {
            Message title = AdminToolMessages.INFO_LISTENERS_TITLE.get();
            this.getOutputStream().println(this.centerTitle(title));
        }
        if ((allHandlers = desc.getConnectionHandlers()).size() == 0) {
            if (desc.getStatus() == ServerDescriptor.ServerStatus.STARTED) {
                if (!desc.isAuthenticated()) {
                    this.getOutputStream().println(this.wrapText(AdminToolMessages.INFO_NOT_AVAILABLE_AUTHENTICATION_REQUIRED_CLI_LABEL.get()));
                } else {
                    this.getOutputStream().println(this.wrapText(AdminToolMessages.INFO_NO_LISTENERS_FOUND.get()));
                }
            } else {
                this.getOutputStream().println(this.wrapText(AdminToolMessages.INFO_NO_LISTENERS_FOUND.get()));
            }
        } else {
            ConnectionHandlerTableModel connHandlersTableModel = new ConnectionHandlerTableModel(false);
            connHandlersTableModel.setData(allHandlers);
            this.writeConnectionHandlersTableModel(connHandlersTableModel, desc);
        }
    }

    private void writeBaseDNContents(ServerDescriptor desc) {
        Message title = AdminToolMessages.INFO_DATABASES_TITLE.get();
        if (!this.isScriptFriendly()) {
            this.getOutputStream().println(this.centerTitle(title));
        }
        HashSet<BaseDNDescriptor> replicas = new HashSet<BaseDNDescriptor>();
        Set<BackendDescriptor> bs = desc.getBackends();
        for (BackendDescriptor backend : bs) {
            if (backend.isConfigBackend()) continue;
            replicas.addAll(backend.getBaseDns());
        }
        if (replicas.size() == 0) {
            if (desc.getStatus() == ServerDescriptor.ServerStatus.STARTED) {
                if (!desc.isAuthenticated()) {
                    this.getOutputStream().println(this.wrapText(AdminToolMessages.INFO_NOT_AVAILABLE_AUTHENTICATION_REQUIRED_CLI_LABEL.get()));
                } else {
                    this.getOutputStream().println(this.wrapText(AdminToolMessages.INFO_NO_DBS_FOUND.get()));
                }
            } else {
                this.getOutputStream().println(this.wrapText(AdminToolMessages.INFO_NO_DBS_FOUND.get()));
            }
        } else {
            BaseDNTableModel baseDNTableModel = new BaseDNTableModel(true, false);
            baseDNTableModel.setData(replicas, desc.getStatus(), desc.isAuthenticated());
            this.writeBaseDNTableModel(baseDNTableModel, desc);
        }
    }

    private void writeErrorContents(ServerDescriptor desc) {
        for (OpenDsException ex : desc.getExceptions()) {
            Message errorMsg = ex.getMessageObject();
            if (errorMsg == null) continue;
            this.getOutputStream().println();
            this.getOutputStream().println(this.wrapText(errorMsg));
        }
    }

    private Message getNotAvailableBecauseServerIsDownText() {
        this.displayMustStartLegend = true;
        return AdminToolMessages.INFO_NOT_AVAILABLE_SERVER_DOWN_CLI_LABEL.get();
    }

    private Message getNotAvailableBecauseAuthenticationIsRequiredText() {
        this.displayMustAuthenticateLegend = true;
        return AdminToolMessages.INFO_NOT_AVAILABLE_AUTHENTICATION_REQUIRED_CLI_LABEL.get();
    }

    private Message getNotAvailableText() {
        return QuickSetupMessages.INFO_NOT_AVAILABLE_LABEL.get();
    }

    private void writeConnectionHandlersTableModel(ConnectionHandlerTableModel tableModel, ServerDescriptor desc) {
        if (this.isScriptFriendly()) {
            for (int i = 0; i < tableModel.getRowCount(); ++i) {
                String[] hostNames;
                for (String hostName : hostNames = this.getHostNames(tableModel, i)) {
                    this.getOutputStream().println("-");
                    for (int j = 0; j < tableModel.getColumnCount(); ++j) {
                        MessageBuilder line = new MessageBuilder();
                        line.append(tableModel.getColumnName(j) + ": ");
                        if (j == 0) {
                            line.append(this.getCellValue(hostName, desc));
                        } else {
                            line.append(this.getCellValue(tableModel.getValueAt(i, j), desc));
                        }
                        this.getOutputStream().println(this.wrapText(line.toMessage()));
                    }
                }
            }
        } else {
            int i;
            TableBuilder table = new TableBuilder();
            for (i = 0; i < tableModel.getColumnCount(); ++i) {
                table.appendHeading(Message.raw(tableModel.getColumnName(i), new Object[0]));
            }
            for (i = 0; i < tableModel.getRowCount(); ++i) {
                String[] hostNames;
                for (String hostName : hostNames = this.getHostNames(tableModel, i)) {
                    table.startRow();
                    for (int j = 0; j < tableModel.getColumnCount(); ++j) {
                        if (j == 0) {
                            table.appendCell(this.getCellValue(hostName, desc));
                            continue;
                        }
                        table.appendCell(this.getCellValue(tableModel.getValueAt(i, j), desc));
                    }
                }
            }
            TextTablePrinter printer = new TextTablePrinter(this.getOutputStream());
            printer.setColumnSeparator(":");
            table.print(printer);
        }
    }

    private String[] getHostNames(ConnectionHandlerTableModel tableModel, int row) {
        String v = (String)tableModel.getValueAt(row, 0);
        String htmlTag = "<html>";
        if (v.toLowerCase().startsWith(htmlTag)) {
            v = v.substring(htmlTag.length());
        }
        return v.split("<br>");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Message getCellValue(Object v, ServerDescriptor desc) {
        Message s = null;
        if (v == null) return this.getNotAvailableText();
        if (v instanceof String) {
            return Message.raw((String)v, new Object[0]);
        }
        if (!(v instanceof Integer)) throw new IllegalStateException("Unknown object type: " + v);
        int nEntries = (Integer)v;
        if (nEntries >= 0) {
            return Message.raw(String.valueOf(nEntries), new Object[0]);
        }
        if (!desc.isAuthenticated()) return this.getNotAvailableBecauseAuthenticationIsRequiredText();
        if (desc.getExceptions().isEmpty()) return this.getNotAvailableText();
        return this.getNotAvailableBecauseAuthenticationIsRequiredText();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeBaseDNTableModel(BaseDNTableModel tableModel, ServerDescriptor desc) {
        boolean isRunning = desc.getStatus() == ServerDescriptor.ServerStatus.STARTED;
        int labelWidth = 0;
        int labelWidthWithoutReplicated = 0;
        Message[] labels = new Message[tableModel.getColumnCount()];
        for (int i = 0; i < tableModel.getColumnCount(); ++i) {
            Message header = Message.raw(tableModel.getColumnName(i), new Object[0]);
            labels[i] = new MessageBuilder(header).append(":").toMessage();
            labelWidth = Math.max(labelWidth, labels[i].length());
            if (i == 4 || i == 5) continue;
            labelWidthWithoutReplicated = Math.max(labelWidthWithoutReplicated, labels[i].length());
        }
        Message replicatedLabel = AdminToolMessages.INFO_BASEDN_REPLICATED_LABEL.get();
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            if (this.isScriptFriendly()) {
                this.getOutputStream().println("-");
            } else if (i > 0) {
                this.getOutputStream().println();
            }
            for (int j = 0; j < tableModel.getColumnCount(); ++j) {
                Message value;
                Object v = tableModel.getValueAt(i, j);
                if (v != null) {
                    if (v == BaseDNTableModel.NOT_AVAILABLE_SERVER_DOWN) {
                        value = this.getNotAvailableBecauseServerIsDownText();
                    } else if (v == BaseDNTableModel.NOT_AVAILABLE_AUTHENTICATION_REQUIRED) {
                        value = this.getNotAvailableBecauseAuthenticationIsRequiredText();
                    } else if (v == BaseDNTableModel.NOT_AVAILABLE) {
                        value = this.getNotAvailableText();
                    } else if (v instanceof String) {
                        value = Message.raw((String)v, new Object[0]);
                    } else if (v instanceof Message) {
                        value = (Message)v;
                    } else {
                        if (!(v instanceof Integer)) throw new IllegalStateException("Unknown object type: " + v);
                        int nEntries = (Integer)v;
                        if (nEntries >= 0) {
                            value = Message.raw(String.valueOf(nEntries), new Object[0]);
                        } else {
                            if (!isRunning) {
                                value = this.getNotAvailableBecauseServerIsDownText();
                            }
                            value = !desc.isAuthenticated() || !desc.getExceptions().isEmpty() ? this.getNotAvailableBecauseAuthenticationIsRequiredText() : this.getNotAvailableText();
                        }
                    }
                } else {
                    value = Message.EMPTY;
                }
                if (value.equals(this.getNotAvailableText())) {
                    if (!isRunning) {
                        value = this.getNotAvailableBecauseServerIsDownText();
                    }
                    if (!desc.isAuthenticated() || !desc.getExceptions().isEmpty()) {
                        value = this.getNotAvailableBecauseAuthenticationIsRequiredText();
                    }
                }
                boolean doWrite = true;
                boolean isReplicated = replicatedLabel.toString().equals(String.valueOf(tableModel.getValueAt(i, 3)));
                if (j == 4 || j == 5) {
                    doWrite = isReplicated;
                }
                if (!doWrite) continue;
                this.writeLabelValue(labels[j], value, isReplicated ? labelWidth : labelWidthWithoutReplicated);
            }
        }
    }

    private void writeLabelValue(Message label, Message value, int maxLabelWidth) {
        MessageBuilder buf = new MessageBuilder();
        buf.append(label);
        int extra = maxLabelWidth - label.length();
        for (int i = 0; i < extra; ++i) {
            buf.append(" ");
        }
        buf.append(" ").append(String.valueOf(value));
        this.getOutputStream().println(this.wrapText(buf.toMessage()));
    }

    private Message centerTitle(Message text) {
        Message centered;
        if (text.length() <= Utils.getCommandLineMaxLineWidth() - 8) {
            MessageBuilder buf = new MessageBuilder();
            int extra = Math.min(10, (Utils.getCommandLineMaxLineWidth() - 8 - text.length()) / 2);
            for (int i = 0; i < extra; ++i) {
                buf.append(" ");
            }
            buf.append("--- " + text + " ---");
            centered = buf.toMessage();
        } else {
            centered = text;
        }
        return centered;
    }

    private ApplicationTrustManager getTrustManager() {
        if (this.useInteractiveTrustManager) {
            return this.interactiveTrustManager;
        }
        return this.argParser.getTrustManager();
    }

    @Override
    public boolean isAdvancedMode() {
        return false;
    }

    @Override
    public boolean isInteractive() {
        return this.argParser.isInteractive();
    }

    @Override
    public boolean isMenuDrivenMode() {
        return true;
    }

    @Override
    public boolean isQuiet() {
        return false;
    }

    @Override
    public boolean isScriptFriendly() {
        return this.argParser.isScriptFriendly();
    }

    @Override
    public boolean isVerbose() {
        return true;
    }

    private Message wrapText(Message text) {
        return Message.raw(StaticUtils.wrapText(text, Utils.getCommandLineMaxLineWidth()), new Object[0]);
    }

    static enum ErrorReturnCode {
        SUCCESSFUL(0),
        SUCCESSFUL_NOP(0),
        ERROR_UNEXPECTED(1),
        ERROR_PARSING_ARGS(2),
        USER_CANCELLED_OR_DATA_ERROR(3),
        ERROR_READING_CONFIGURATION_WITH_LDAP(4);

        private int returnCode;

        private ErrorReturnCode(int returnCode) {
            this.returnCode = returnCode;
        }

        public int getReturnCode() {
            return this.returnCode;
        }
    }
}

