/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.upgrade;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.tools.ClientException;
import org.opends.server.tools.ToolConstants;
import org.opends.server.tools.upgrade.FormattedNotificationCallback;
import org.opends.server.tools.upgrade.ProgressNotificationCallback;
import org.opends.server.tools.upgrade.Upgrade;
import org.opends.server.tools.upgrade.UpgradeContext;
import org.opends.server.tools.upgrade.UpgradeLog;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.StringArgument;
import org.opends.server.util.args.SubCommandArgumentParser;
import org.opends.server.util.cli.CLIException;
import org.opends.server.util.cli.ConsoleApplication;

public final class UpgradeCli
extends ConsoleApplication
implements CallbackHandler {
    private static final Logger LOG = Logger.getLogger(UpgradeCli.class.getName());
    private final SubCommandArgumentParser parser = new SubCommandArgumentParser(this.getClass().getName(), ToolMessages.INFO_UPGRADE_DESCRIPTION_CLI.get(), false);
    private StringArgument configClass;
    private StringArgument configFile;
    private BooleanArgument noPrompt;
    private BooleanArgument ignoreErrors;
    private BooleanArgument force;
    private BooleanArgument quietMode;
    private BooleanArgument verbose;
    private BooleanArgument acceptLicense;
    private BooleanArgument showUsageArgument;
    private boolean globalArgumentsInitialized = false;

    private UpgradeCli(InputStream in, OutputStream out, OutputStream err) {
        super(in, out, err);
    }

    public static void main(String[] args) {
        int exitCode = UpgradeCli.main(args, true, System.out, System.err);
        if (exitCode != 0) {
            System.exit(StaticUtils.filterExitCode(exitCode));
        }
    }

    public static int main(String[] args, boolean initializeServer, OutputStream outStream, OutputStream errStream) {
        UpgradeCli app = new UpgradeCli(System.in, outStream, errStream);
        return app.run(args, initializeServer);
    }

    @Override
    public boolean isAdvancedMode() {
        return false;
    }

    @Override
    public boolean isInteractive() {
        return !this.noPrompt.isPresent();
    }

    @Override
    public boolean isMenuDrivenMode() {
        return false;
    }

    @Override
    public boolean isQuiet() {
        return this.quietMode.isPresent();
    }

    @Override
    public boolean isScriptFriendly() {
        return false;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose.isPresent();
    }

    private boolean isForceUpgrade() {
        return this.force.isPresent();
    }

    private boolean isIgnoreErrors() {
        return this.ignoreErrors.isPresent();
    }

    private boolean isAcceptLicense() {
        return this.acceptLicense.isPresent();
    }

    private void displayMessageAndUsageReference(Message message) {
        this.println(message);
        this.println();
        this.println(this.parser.getHelpUsageReference());
    }

    private void initializeGlobalArguments() throws ArgumentException {
        if (!this.globalArgumentsInitialized) {
            this.configClass = new StringArgument("configclass", Character.valueOf('C'), "configClass", true, false, true, ToolMessages.INFO_CONFIGCLASS_PLACEHOLDER.get(), ConfigFileHandler.class.getName(), null, ToolMessages.INFO_DESCRIPTION_CONFIG_CLASS.get());
            this.configClass.setHidden(true);
            this.configFile = new StringArgument("configfile", Character.valueOf('f'), "configFile", true, false, true, ToolMessages.INFO_CONFIGFILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_CONFIG_FILE.get());
            this.configFile.setHidden(true);
            this.noPrompt = new BooleanArgument("no-prompt", ToolConstants.OPTION_SHORT_NO_PROMPT, "no-prompt", ToolMessages.INFO_UPGRADE_DESCRIPTION_NO_PROMPT.get());
            this.verbose = new BooleanArgument("verbose", ToolConstants.OPTION_SHORT_VERBOSE, "verbose", ToolMessages.INFO_DESCRIPTION_VERBOSE.get());
            this.quietMode = new BooleanArgument("quiet", ToolConstants.OPTION_SHORT_QUIET, "quiet", ToolMessages.INFO_DESCRIPTION_QUIET.get());
            this.ignoreErrors = new BooleanArgument("ignoreErrors", null, "ignoreErrors", ToolMessages.INFO_UPGRADE_OPTION_IGNORE_ERRORS.get());
            this.force = new BooleanArgument("force", null, "force", ToolMessages.INFO_UPGRADE_OPTION_FORCE.get("no-prompt"));
            this.acceptLicense = new BooleanArgument("acceptLicense", null, "acceptLicense", ToolMessages.INFO_OPTION_ACCEPT_LICENSE.get());
            this.showUsageArgument = new BooleanArgument("help", Character.valueOf('H'), "help", ToolMessages.INFO_DESCRIPTION_USAGE.get());
            this.parser.addGlobalArgument(this.showUsageArgument);
            this.parser.setUsageArgument(this.showUsageArgument, this.getOutputStream());
            this.parser.addGlobalArgument(this.configClass);
            this.parser.addGlobalArgument(this.configFile);
            this.parser.addGlobalArgument(this.noPrompt);
            this.parser.addGlobalArgument(this.verbose);
            this.parser.addGlobalArgument(this.quietMode);
            this.parser.addGlobalArgument(this.force);
            this.parser.addGlobalArgument(this.ignoreErrors);
            this.parser.addGlobalArgument(this.acceptLicense);
            this.globalArgumentsInitialized = true;
        }
    }

    private int run(String[] args, boolean initializeServer) {
        try {
            this.initializeGlobalArguments();
        }
        catch (ArgumentException e) {
            Message message = ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(e.getMessage());
            this.getOutputStream().print(message);
            return 1;
        }
        try {
            this.parser.parseArguments(args);
            if (this.isInteractive() && this.isQuiet()) {
                Message message = ToolMessages.ERR_UPGRADE_INCOMPATIBLE_ARGS.get("quiet", "interactive mode");
                this.getOutputStream().println(message);
                return 1;
            }
            if (this.isInteractive() && this.isForceUpgrade()) {
                Message message = ToolMessages.ERR_UPGRADE_INCOMPATIBLE_ARGS.get("force", "interactive mode");
                this.getOutputStream().println(message);
                return 1;
            }
            if (this.isQuiet() && this.isVerbose()) {
                Message message = ToolMessages.ERR_UPGRADE_INCOMPATIBLE_ARGS.get("quiet", "verbose");
                this.getOutputStream().println(message);
                return 1;
            }
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_ERROR_PARSING_ARGS.get(ae.getMessage());
            this.displayMessageAndUsageReference(message);
            return 1;
        }
        if (this.parser.usageOrVersionDisplayed()) {
            return 0;
        }
        try {
            UpgradeLog.initLogFileHandler();
            UpgradeContext context = new UpgradeContext(this).setIgnoreErrorsMode(this.isIgnoreErrors()).setAcceptLicenseMode(this.isAcceptLicense()).setInteractiveMode(this.isInteractive()).setForceUpgradeMode(this.isForceUpgrade());
            Upgrade.upgrade(context);
        }
        catch (ClientException ex) {
            return ex.getExitCode();
        }
        catch (Exception ex) {
            this.println(ConsoleApplication.Style.ERROR, ToolMessages.ERR_UPGRADE_MAIN_UPGRADE_PROCESS.get(ex.getMessage()), 0);
            return 1;
        }
        return 0;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        block9: for (Callback c : callbacks) {
            if (c instanceof ProgressNotificationCallback) {
                ProgressNotificationCallback pnc = (ProgressNotificationCallback)c;
                Message msg = Message.raw("  " + pnc.getMessage(), new Object[0]);
                this.printProgress(msg);
                this.printProgressBar(msg.length(), pnc.getProgress());
                continue;
            }
            if (c instanceof FormattedNotificationCallback) {
                FormattedNotificationCallback fnc = (FormattedNotificationCallback)c;
                switch (fnc.getMessageSubType()) {
                    case 5: {
                        this.println(ConsoleApplication.Style.TITLE, Message.raw(fnc.getMessage(), new Object[0]), 0);
                        LOG.log(Level.INFO, fnc.getMessage());
                        break;
                    }
                    case 6: {
                        this.println(ConsoleApplication.Style.SUBTITLE, Message.raw(fnc.getMessage(), new Object[0]), 4);
                        LOG.log(Level.INFO, fnc.getMessage());
                        break;
                    }
                    case 7: {
                        this.println(ConsoleApplication.Style.NOTICE, Message.raw(fnc.getMessage(), new Object[0]), 1);
                        LOG.log(Level.INFO, fnc.getMessage());
                        break;
                    }
                    case 8: {
                        this.println(ConsoleApplication.Style.ERROR, Message.raw(fnc.getMessage(), new Object[0]), 1);
                        LOG.log(Level.SEVERE, fnc.getMessage());
                        break;
                    }
                    case 1: {
                        this.println(ConsoleApplication.Style.WARNING, Message.raw(fnc.getMessage(), new Object[0]), 2);
                        LOG.log(Level.WARNING, fnc.getMessage());
                        break;
                    }
                    default: {
                        LOG.log(Level.SEVERE, "Unsupported message type: " + fnc.getMessage());
                        throw new IOException("Unsupported message type: ");
                    }
                }
                continue;
            }
            if (c instanceof TextOutputCallback) {
                TextOutputCallback toc = (TextOutputCallback)c;
                if (toc.getMessageType() == 0) {
                    LOG.log(Level.INFO, toc.getMessage());
                    this.printlnProgress(Message.raw(toc.getMessage(), new Object[0]));
                    continue;
                }
                LOG.log(Level.SEVERE, "Unsupported message type: " + toc.getMessage());
                throw new IOException("Unsupported message type: ");
            }
            if (c instanceof ConfirmationCallback) {
                ConfirmationCallback cc = (ConfirmationCallback)c;
                ArrayList<String> choices = new ArrayList<String>();
                String defaultOption = UpgradeCli.getDefaultOption(cc.getDefaultOption());
                StringBuilder prompt = new StringBuilder(StaticUtils.wrapText(cc.getPrompt(), ServerConstants.MAX_LINE_WIDTH, 2));
                ArrayList<String> yesNoDefaultResponses = StaticUtils.arrayToList(new String[]{ToolMessages.INFO_PROMPT_YES_COMPLETE_ANSWER.get().toString(), ToolMessages.INFO_PROMPT_YES_FIRST_LETTER_ANSWER.get().toString(), ToolMessages.INFO_PROMPT_NO_COMPLETE_ANSWER.get().toString(), ToolMessages.INFO_PROMPT_NO_FIRST_LETTER_ANSWER.get().toString()});
                prompt.append(" ").append("(");
                if (cc.getOptionType() == 0) {
                    choices.addAll(yesNoDefaultResponses);
                    prompt.append(ToolMessages.INFO_PROMPT_YES_COMPLETE_ANSWER.get().toString()).append("/").append(ToolMessages.INFO_PROMPT_NO_COMPLETE_ANSWER.get().toString());
                } else if (cc.getOptionType() == 1) {
                    choices.addAll(yesNoDefaultResponses);
                    choices.addAll(StaticUtils.arrayToList(new String[]{ToolMessages.INFO_TASKINFO_CMD_CANCEL_CHAR.get().toString()}));
                    prompt.append(" ").append("(").append(ToolMessages.INFO_PROMPT_YES_COMPLETE_ANSWER.get().toString()).append("/").append(ToolMessages.INFO_PROMPT_NO_COMPLETE_ANSWER.get().toString()).append("/").append(ToolMessages.INFO_TASKINFO_CMD_CANCEL_CHAR.get().toString());
                }
                prompt.append(")");
                LOG.log(Level.INFO, cc.getPrompt());
                if (this.isInteractive()) {
                    while (true) {
                        String value = null;
                        try {
                            value = this.readInput(Message.raw(prompt, new Object[0]), defaultOption, ConsoleApplication.Style.SUBTITLE);
                        }
                        catch (CLIException e) {
                            LOG.log(Level.SEVERE, e.getMessage());
                            continue block9;
                        }
                        if ((value.toLowerCase().equals(ToolMessages.INFO_PROMPT_YES_FIRST_LETTER_ANSWER.get().toString()) || value.toLowerCase().equals(ToolMessages.INFO_PROMPT_YES_COMPLETE_ANSWER.get().toString())) && choices.contains(value)) {
                            cc.setSelectedIndex(0);
                            continue block9;
                        }
                        if ((value.toLowerCase().equals(ToolMessages.INFO_PROMPT_NO_FIRST_LETTER_ANSWER.get().toString()) || value.toLowerCase().equals(ToolMessages.INFO_PROMPT_NO_COMPLETE_ANSWER.get().toString())) && choices.contains(value)) {
                            cc.setSelectedIndex(1);
                            continue block9;
                        }
                        if (value.toLowerCase().equals(ToolMessages.INFO_TASKINFO_CMD_CANCEL_CHAR.get().toString()) && choices.contains(value)) {
                            cc.setSelectedIndex(2);
                            continue block9;
                        }
                        LOG.log(Level.INFO, value);
                    }
                }
                if (this.isForceUpgrade()) {
                    cc.setSelectedIndex(0);
                } else {
                    cc.setSelectedIndex(cc.getDefaultOption());
                }
                prompt.append(" ").append(UpgradeCli.getDefaultOption(cc.getSelectedIndex()));
                this.println(ConsoleApplication.Style.SUBTITLE, Message.raw(prompt, new Object[0]), 0);
                LOG.log(Level.INFO, UpgradeCli.getDefaultOption(cc.getSelectedIndex()));
                continue;
            }
            LOG.log(Level.SEVERE, "Unrecognized Callback");
            throw new UnsupportedCallbackException(c, "Unrecognized Callback");
        }
    }

    private static String getDefaultOption(int defaultOption) {
        if (defaultOption == 0) {
            return ToolMessages.INFO_PROMPT_YES_COMPLETE_ANSWER.get().toString();
        }
        if (defaultOption == 1) {
            return ToolMessages.INFO_PROMPT_NO_COMPLETE_ANSWER.get().toString();
        }
        if (defaultOption == 2) {
            return ToolMessages.INFO_TASKINFO_CMD_CANCEL_CHAR.get().toString();
        }
        return null;
    }
}

