/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.upgrade;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.schema.UnknownSchemaElementException;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.tools.ClientException;
import org.opends.server.tools.RebuildIndex;
import org.opends.server.tools.upgrade.AbstractUpgradeTask;
import org.opends.server.tools.upgrade.FileManager;
import org.opends.server.tools.upgrade.ProgressNotificationCallback;
import org.opends.server.tools.upgrade.Upgrade;
import org.opends.server.tools.upgrade.UpgradeCli;
import org.opends.server.tools.upgrade.UpgradeContext;
import org.opends.server.tools.upgrade.UpgradeLog;
import org.opends.server.tools.upgrade.UpgradeTask;
import org.opends.server.tools.upgrade.UpgradeUtils;
import org.opends.server.util.BuildVersion;
import org.opends.server.util.ChangeOperationType;

public final class UpgradeTasks {
    static int countErrors = 0;
    private static final Logger LOG = Logger.getLogger(UpgradeCli.class.getName());
    static Set<String> indexesListToRebuild = new HashSet<String>();
    static boolean isRebuildAllIndexesIsPresent = false;
    static boolean isRebuildAllIndexesTaskAccepted = false;

    public static UpgradeTask addConfigEntry(Message summary, String ... ldif) {
        return UpgradeTasks.addConfigEntry0(summary, summary, false, ldif);
    }

    public static UpgradeTask addConfigEntryOptional(Message summary, Message description, String ... ldif) {
        return UpgradeTasks.addConfigEntry0(summary, description, true, ldif);
    }

    public static UpgradeTask copySchemaFile(final String fileName) {
        return new AbstractUpgradeTask(){

            @Override
            public void perform(UpgradeContext context) throws ClientException {
                Message msg = ToolMessages.INFO_UPGRADE_TASK_REPLACE_SCHEMA_FILE.get(fileName);
                LOG.log(Level.INFO, msg.toString());
                ProgressNotificationCallback pnc = new ProgressNotificationCallback(0, msg, 0);
                File schemaFileTemplate = new File(UpgradeUtils.templateConfigSchemaDirectory, fileName);
                try {
                    context.notifyProgress(pnc.setProgress(20));
                    if (!schemaFileTemplate.exists() || schemaFileTemplate.length() == 0L) {
                        throw new IOException(ToolMessages.ERR_UPGRADE_CORRUPTED_TEMPLATE.get(schemaFileTemplate.getPath()).toString());
                    }
                    FileManager.copy(schemaFileTemplate, UpgradeUtils.configSchemaDirectory, true);
                    context.notifyProgress(pnc.setProgress(100));
                }
                catch (IOException e) {
                    UpgradeTasks.manageTaskException(context, ToolMessages.ERR_UPGRADE_COPYSCHEMA_FAILS.get(schemaFileTemplate.getName(), e.getMessage()), pnc);
                }
            }
        };
    }

    public static UpgradeTask addConfigFile(final String fileName) {
        return new AbstractUpgradeTask(){

            @Override
            public void perform(UpgradeContext context) throws ClientException {
                Message msg = ToolMessages.INFO_UPGRADE_TASK_ADD_CONFIG_FILE.get(fileName);
                LOG.log(Level.INFO, msg.toString());
                ProgressNotificationCallback pnc = new ProgressNotificationCallback(0, msg, 0);
                File configFile = new File(UpgradeUtils.templateConfigDirectory, fileName);
                try {
                    context.notifyProgress(pnc.setProgress(20));
                    FileManager.copy(configFile, UpgradeUtils.configDirectory, true);
                    context.notifyProgress(pnc.setProgress(100));
                }
                catch (IOException e) {
                    UpgradeTasks.manageTaskException(context, ToolMessages.ERR_UPGRADE_ADD_CONFIG_FILE_FAILS.get(configFile.getName(), e.getMessage()), pnc);
                }
            }
        };
    }

    public static UpgradeTask modifyConfigEntry(Message summary, String filter, String ... ldif) {
        return UpgradeTasks.modifyConfigEntry(summary, summary, false, filter, ldif);
    }

    public static UpgradeTask modifyConfigEntryOptional(Message summary, Message description, String filter, String ... ldif) {
        return UpgradeTasks.modifyConfigEntry(summary, description, true, filter, ldif);
    }

    public static UpgradeTask newAttributeTypes(final Message summary, final String fileName, final String ... names) {
        return new AbstractUpgradeTask(){

            @Override
            public void perform(UpgradeContext context) throws ClientException {
                LOG.log(Level.INFO, summary.toString());
                ProgressNotificationCallback pnc = new ProgressNotificationCallback(0, summary, 20);
                context.notifyProgress(pnc);
                File schemaFileTemplate = new File(UpgradeUtils.templateConfigSchemaDirectory, fileName);
                File pathDestination = new File(UpgradeUtils.configSchemaDirectory, fileName);
                try {
                    int changeCount = UpgradeUtils.updateSchemaFile(schemaFileTemplate, pathDestination, names, null);
                    UpgradeTasks.displayChangeCount(pathDestination.getPath(), changeCount);
                    context.notifyProgress(pnc.setProgress(100));
                }
                catch (IOException e) {
                    UpgradeTasks.manageTaskException(context, ToolMessages.ERR_UPGRADE_ADDATTRIBUTE_FAILS.get(schemaFileTemplate.getName(), e.getMessage()), pnc);
                }
                catch (UnknownSchemaElementException e) {
                    UpgradeTasks.manageTaskException(context, ToolMessages.ERR_UPGRADE_ADDATTRIBUTE_FAILS.get(schemaFileTemplate.getName(), e.getMessage()), pnc);
                }
            }
        };
    }

    public static UpgradeTask newObjectClasses(final Message summary, final String fileName, final String ... names) {
        return new AbstractUpgradeTask(){

            @Override
            public void perform(UpgradeContext context) throws ClientException {
                LOG.log(Level.INFO, summary.toString());
                ProgressNotificationCallback pnc = new ProgressNotificationCallback(0, summary, 20);
                context.notifyProgress(pnc);
                File schemaFileTemplate = new File(UpgradeUtils.templateConfigSchemaDirectory, fileName);
                File pathDestination = new File(UpgradeUtils.configSchemaDirectory, fileName);
                context.notifyProgress(pnc.setProgress(20));
                try {
                    int changeCount = UpgradeUtils.updateSchemaFile(schemaFileTemplate, pathDestination, null, names);
                    UpgradeTasks.displayChangeCount(pathDestination.getPath(), changeCount);
                    context.notifyProgress(pnc.setProgress(100));
                }
                catch (IOException e) {
                    UpgradeTasks.manageTaskException(context, ToolMessages.ERR_UPGRADE_ADDOBJECTCLASS_FAILS.get(schemaFileTemplate.getName(), e.getMessage()), pnc);
                }
                catch (UnknownSchemaElementException e) {
                    UpgradeTasks.manageTaskException(context, ToolMessages.ERR_UPGRADE_ADDOBJECTCLASS_FAILS.get(schemaFileTemplate.getName(), e.getMessage()), pnc);
                }
            }
        };
    }

    public static UpgradeTask regressionInVersion(String versionString, final UpgradeTask ... tasks) {
        final BuildVersion version = BuildVersion.valueOf(versionString);
        return new AbstractUpgradeTask(){

            @Override
            public void verify(UpgradeContext context) throws ClientException {
                if (this.currentVersionEqualToOrMoreRecentThan(context, version)) {
                    for (UpgradeTask task : tasks) {
                        task.verify(context);
                    }
                }
            }

            @Override
            public void interact(UpgradeContext context) throws ClientException {
                if (this.currentVersionEqualToOrMoreRecentThan(context, version)) {
                    for (UpgradeTask task : tasks) {
                        task.interact(context);
                    }
                }
            }

            @Override
            public void perform(UpgradeContext context) throws ClientException {
                if (this.currentVersionEqualToOrMoreRecentThan(context, version)) {
                    for (UpgradeTask task : tasks) {
                        task.perform(context);
                    }
                }
            }

            @Override
            public void postUpgrade(UpgradeContext context) throws ClientException {
                if (this.currentVersionEqualToOrMoreRecentThan(context, version)) {
                    boolean isOk = true;
                    for (UpgradeTask task : tasks) {
                        if (isOk) {
                            try {
                                task.postUpgrade(context);
                            }
                            catch (ClientException e) {
                                LOG.log(Level.SEVERE, e.getMessage());
                                isOk = false;
                            }
                            continue;
                        }
                        task.postponePostUpgrade(context);
                    }
                }
            }

            private boolean currentVersionEqualToOrMoreRecentThan(UpgradeContext context, BuildVersion version2) {
                return context.getFromVersion().compareTo(version2) >= 0;
            }
        };
    }

    public static UpgradeTask rebuildAllIndexes(final Message summary) {
        return new AbstractUpgradeTask(){
            private boolean isATaskToPerform = false;

            @Override
            public void interact(UpgradeContext context) throws ClientException {
                Upgrade.setHasPostUpgradeTask(true);
                int answer = context.confirmYN(summary, 1);
                this.isATaskToPerform = answer == 0;
                isRebuildAllIndexesIsPresent = true;
                isRebuildAllIndexesTaskAccepted = this.isATaskToPerform;
            }

            @Override
            public void postUpgrade(UpgradeContext context) throws ClientException {
                if (!this.isATaskToPerform) {
                    this.postponePostUpgrade(context);
                }
            }

            @Override
            public void postponePostUpgrade(UpgradeContext context) throws ClientException {
                context.notify(ToolMessages.INFO_UPGRADE_ALL_REBUILD_INDEX_DECLINED.get(), 1);
            }
        };
    }

    public static UpgradeTask rebuildSingleIndex(final Message summary, final String index) {
        return new AbstractUpgradeTask(){
            private boolean isATaskToPerform = false;

            @Override
            public void interact(UpgradeContext context) throws ClientException {
                Upgrade.setHasPostUpgradeTask(true);
                int answer = context.confirmYN(summary, 1);
                this.isATaskToPerform = answer == 0;
            }

            @Override
            public void postUpgrade(UpgradeContext context) throws ClientException {
                if (this.isATaskToPerform) {
                    indexesListToRebuild.add(index);
                } else {
                    this.postponePostUpgrade(context);
                }
            }

            @Override
            public void postponePostUpgrade(UpgradeContext context) throws ClientException {
                if (!isRebuildAllIndexesIsPresent) {
                    context.notify(ToolMessages.INFO_UPGRADE_REBUILD_INDEX_DECLINED.get(index), 1);
                }
            }
        };
    }

    public static UpgradeTask postUpgradeRebuildIndexes() {
        return new AbstractUpgradeTask(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void postUpgrade(UpgradeContext context) throws ClientException {
                Message message = null;
                LinkedList<String> args = new LinkedList<String>();
                if (isRebuildAllIndexesIsPresent && isRebuildAllIndexesTaskAccepted) {
                    args.add("--rebuildAll");
                    message = ToolMessages.INFO_UPGRADE_REBUILD_ALL.get();
                } else {
                    if (indexesListToRebuild.isEmpty()) return;
                    if (isRebuildAllIndexesTaskAccepted) return;
                    message = ToolMessages.INFO_UPGRADE_REBUILD_INDEX_STARTS.get(Arrays.toString(indexesListToRebuild.toArray()));
                    for (String indexToRebuild : indexesListToRebuild) {
                        args.add("-i");
                        args.add(indexToRebuild);
                    }
                }
                ProgressNotificationCallback pnc = new ProgressNotificationCallback(0, message, 25);
                LOG.log(Level.INFO, message.toString());
                context.notifyProgress(pnc);
                args.addAll(Arrays.asList("-f", new File(UpgradeUtils.configDirectory, "config.ldif").getAbsolutePath()));
                List<String> backends = UpgradeUtils.getLocalBackendsFromConfig();
                if (backends.isEmpty()) {
                    Message msg = ToolMessages.INFO_UPGRADE_REBUILD_INDEX_NO_BACKEND_FOUND.get();
                    LOG.log(Level.INFO, msg.toString());
                    LOG.log(Level.INFO, ToolMessages.INFO_UPGRADE_REBUILD_INDEX_DECLINED.get(Arrays.toString(indexesListToRebuild.toArray())).toString());
                    context.notifyProgress(pnc.setProgress(100));
                    return;
                }
                for (String be : backends) {
                    args.add("-b");
                    args.add(be);
                }
                Object[] commandLineArgs = args.toArray(new String[args.size()]);
                LOG.log(Level.INFO, ToolMessages.INFO_UPGRADE_REBUILD_INDEX_ARGUMENTS.get(Arrays.toString(commandLineArgs)).toString());
                int result = new RebuildIndex().rebuildIndexesWithinMultipleBackends(true, UpgradeLog.getPrintStream(), (String[])commandLineArgs);
                if (result == 0) {
                    LOG.log(Level.INFO, ToolMessages.INFO_UPGRADE_REBUILD_INDEX_ENDS.get().toString());
                    context.notifyProgress(pnc.setProgress(100));
                    return;
                }
                Message msg = ToolMessages.ERR_UPGRADE_PERFORMING_POST_TASKS_FAIL.get();
                context.notifyProgress(pnc.setProgress(-100));
                throw new ClientException(1, msg);
            }
        };
    }

    public static UpgradeTask updateConfigUpgradeFolder() {
        return new AbstractUpgradeTask(){

            @Override
            public void perform(UpgradeContext context) throws ClientException {
                Message msg = ToolMessages.INFO_UPGRADE_TASK_REFRESH_UPGRADE_DIRECTORY.get();
                LOG.log(Level.INFO, msg.toString());
                ProgressNotificationCallback pnc = new ProgressNotificationCallback(0, msg, 20);
                context.notifyProgress(pnc);
                try {
                    UpgradeUtils.updateConfigUpgradeSchemaFile(UpgradeUtils.configSchemaDirectory, String.valueOf(context.getToVersion().getRevisionNumber()));
                    context.notifyProgress(pnc.setProgress(100));
                }
                catch (Exception ex) {
                    UpgradeTasks.manageTaskException(context, ToolMessages.ERR_UPGRADE_CONFIG_ERROR_UPGRADE_FOLDER.get(ex.getMessage()), pnc);
                }
            }
        };
    }

    public static UpgradeTask renameSnmpSecurityConfig(final Message summary) {
        return new AbstractUpgradeTask(){

            @Override
            public void perform(UpgradeContext context) throws ClientException {
                if (UpgradeUtils.configSnmpSecurityDirectory.exists()) {
                    ProgressNotificationCallback pnc = new ProgressNotificationCallback(0, summary, 0);
                    try {
                        File oldSnmpConfig = new File(UpgradeUtils.configSnmpSecurityDirectory, "opends-snmp.security");
                        if (oldSnmpConfig.exists()) {
                            context.notifyProgress(pnc.setProgress(20));
                            LOG.log(Level.INFO, summary.toString());
                            File snmpConfig = new File(UpgradeUtils.configSnmpSecurityDirectory, "opendj-snmp.security");
                            FileManager.rename(oldSnmpConfig, snmpConfig);
                            context.notifyProgress(pnc.setProgress(100));
                        }
                    }
                    catch (Exception ex) {
                        UpgradeTasks.manageTaskException(context, ToolMessages.ERR_UPGRADE_RENAME_SNMP_SECURITY_CONFIG_FILE.get(ex.getMessage()), pnc);
                    }
                }
            }
        };
    }

    private static UpgradeTask addConfigEntry0(final Message summary, final Message description, final boolean needsUserConfirmation, final String ... ldif) {
        return new AbstractUpgradeTask(){
            private boolean userConfirmation = true;

            @Override
            public void interact(UpgradeContext context) throws ClientException {
                int answer;
                if (needsUserConfirmation && (answer = context.confirmYN(ToolMessages.INFO_UPGRADE_TASK_NEEDS_USER_CONFIRM.get(description), 0)) == 1) {
                    this.userConfirmation = false;
                }
            }

            @Override
            public void perform(UpgradeContext context) throws ClientException {
                if (this.userConfirmation) {
                    UpgradeTasks.displayTaskLogInformation(summary.toString(), null, ldif);
                    ProgressNotificationCallback pnc = new ProgressNotificationCallback(0, summary, 20);
                    context.notifyProgress(pnc);
                    try {
                        File configFile = new File(UpgradeUtils.configDirectory, "config.ldif");
                        int changeCount = UpgradeUtils.updateConfigFile(configFile.getPath(), null, ChangeOperationType.ADD, ldif);
                        UpgradeTasks.displayChangeCount(configFile.getPath(), changeCount);
                        context.notifyProgress(pnc.setProgress(100));
                    }
                    catch (Exception e) {
                        UpgradeTasks.manageTaskException(context, Message.fromObject(e.getMessage(), new Object[0]), pnc);
                    }
                }
            }
        };
    }

    private static void displayChangeCount(String fileName, int changeCount) {
        if (changeCount != 0) {
            LOG.log(Level.INFO, ToolMessages.INFO_UPGRADE_CHANGE_DONE_IN_SPECIFIC_FILE.get(fileName, String.valueOf(changeCount)).toString());
        } else {
            LOG.log(Level.INFO, ToolMessages.INFO_UPGRADE_NO_CHANGE_DONE_IN_SPECIFIC_FILE.get(fileName).toString());
        }
    }

    private static void displayTaskLogInformation(String summary, String filter, String ... ldif) {
        LOG.log(Level.INFO, summary);
        if (filter != null) {
            LOG.log(Level.INFO, filter);
        }
        if (ldif != null) {
            LOG.log(Level.INFO, Arrays.asList(ldif).toString());
        }
    }

    private static void manageTaskException(UpgradeContext context, Message message, ProgressNotificationCallback pnc) throws ClientException {
        ++countErrors;
        context.notifyProgress(pnc.setProgress(-100));
        LOG.log(Level.SEVERE, message.toString());
        if (!context.isIgnoreErrorsMode()) {
            throw new ClientException(1, message);
        }
    }

    private static UpgradeTask modifyConfigEntry(final Message summary, final Message description, final boolean needsUserConfirmation, final String filter, final String ... ldif) {
        return new AbstractUpgradeTask(){
            private boolean userConfirmation = true;

            @Override
            public void interact(UpgradeContext context) throws ClientException {
                int answer;
                if (needsUserConfirmation && (answer = context.confirmYN(ToolMessages.INFO_UPGRADE_TASK_NEEDS_USER_CONFIRM.get(description), 0)) == 1) {
                    this.userConfirmation = false;
                }
            }

            @Override
            public void perform(UpgradeContext context) throws ClientException {
                if (this.userConfirmation) {
                    UpgradeTasks.displayTaskLogInformation(summary.toString(), filter, ldif);
                    ProgressNotificationCallback pnc = new ProgressNotificationCallback(0, summary, 20);
                    context.notifyProgress(pnc);
                    try {
                        File configFile = new File(UpgradeUtils.configDirectory, "config.ldif");
                        int changeCount = UpgradeUtils.updateConfigFile(configFile.getPath(), Filter.valueOf((String)filter), ChangeOperationType.MODIFY, ldif);
                        UpgradeTasks.displayChangeCount(configFile.getPath(), changeCount);
                        context.notifyProgress(pnc.setProgress(100));
                    }
                    catch (Exception e) {
                        UpgradeTasks.manageTaskException(context, Message.fromObject(e.getMessage(), new Object[0]), pnc);
                    }
                }
            }
        };
    }

    private UpgradeTasks() {
    }
}

