/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.api.ClientConnection;
import org.opends.server.controls.ControlDecoder;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.ldap.LDAPControl;
import org.opends.server.types.AdditionalLogItem;
import org.opends.server.types.CancelRequest;
import org.opends.server.types.CancelResult;
import org.opends.server.types.CanceledOperationException;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.Entry;
import org.opends.server.types.Operation;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.ResultCode;
import org.opends.server.types.StabilityLevel;
import org.opends.server.types.operation.PostResponseOperation;
import org.opends.server.types.operation.PreParseOperation;
import org.opends.server.util.Validator;

@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public abstract class AbstractOperation
implements Operation,
PreParseOperation,
PostResponseOperation {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    protected static final List<Control> NO_RESPONSE_CONTROLS = new ArrayList<Control>(0);
    protected final ClientConnection clientConnection;
    protected final int messageID;
    protected final long operationID;
    protected final boolean useNanoTime;
    protected CancelRequest cancelRequest;
    protected CancelResult cancelResult;
    private boolean isInternalOperation;
    private Boolean isInnerOperation;
    private boolean isSynchronizationOperation;
    private DN matchedDN;
    private Entry authorizationEntry;
    private Map<String, Object> attachments;
    private List<Control> requestControls;
    private List<String> referralURLs;
    private ResultCode resultCode;
    private List<AdditionalLogItem> additionalLogItems;
    private MessageBuilder errorMessage;
    private boolean dontSynchronizeFlag;
    private long processingStartTime;
    private long processingStopTime;
    private long processingStartNanoTime;
    private long processingStopNanoTime;
    private List<Runnable> postResponseCallbacks = null;

    protected AbstractOperation(ClientConnection clientConnection, long operationID, int messageID, List<Control> requestControls) {
        this.clientConnection = clientConnection;
        this.operationID = operationID;
        this.messageID = messageID;
        this.useNanoTime = DirectoryServer.getUseNanoTime();
        this.requestControls = requestControls == null ? new ArrayList<Control>(0) : requestControls;
        this.resultCode = ResultCode.UNDEFINED;
        this.additionalLogItems = null;
        this.errorMessage = new MessageBuilder();
        this.attachments = new HashMap<String, Object>();
        this.matchedDN = null;
        this.referralURLs = null;
        this.cancelResult = null;
        this.isInternalOperation = false;
        this.isSynchronizationOperation = false;
        this.authorizationEntry = clientConnection.getAuthenticationInfo().getAuthorizationEntry();
    }

    @Override
    public void disconnectClient(DisconnectReason disconnectReason, boolean sendNotification, Message message) {
        this.clientConnection.disconnect(disconnectReason, sendNotification, message);
    }

    @Override
    public final String[][] getCommonLogElements() {
        return new String[][]{{"connID", String.valueOf(this.getConnectionID())}, {"opID", String.valueOf(this.operationID)}, {"messageID", String.valueOf(this.messageID)}};
    }

    @Override
    public final ClientConnection getClientConnection() {
        return this.clientConnection;
    }

    @Override
    public final long getConnectionID() {
        return this.clientConnection.getConnectionID();
    }

    @Override
    public final long getOperationID() {
        return this.operationID;
    }

    @Override
    public final int getMessageID() {
        return this.messageID;
    }

    @Override
    public final List<Control> getRequestControls() {
        return this.requestControls;
    }

    @Override
    public final <T extends Control> T getRequestControl(ControlDecoder<T> d) throws DirectoryException {
        String oid = d.getOID();
        for (int i = 0; i < this.requestControls.size(); ++i) {
            Control c = this.requestControls.get(i);
            if (!c.getOID().equals(oid)) continue;
            if (c instanceof LDAPControl) {
                T decodedControl = d.decode(c.isCritical(), ((LDAPControl)c).getValue());
                this.requestControls.set(i, (Control)decodedControl);
                return decodedControl;
            }
            return (T)c;
        }
        return null;
    }

    @Override
    public final void addRequestControl(Control control) {
        this.requestControls.add(control);
    }

    @Override
    public final ResultCode getResultCode() {
        return this.resultCode;
    }

    @Override
    public final void setResultCode(ResultCode resultCode) {
        this.resultCode = resultCode;
    }

    @Override
    public final MessageBuilder getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public final void setErrorMessage(MessageBuilder errorMessage) {
        this.errorMessage = errorMessage == null ? new MessageBuilder() : errorMessage;
    }

    @Override
    public final void appendErrorMessage(Message message) {
        if (this.errorMessage == null) {
            this.errorMessage = new MessageBuilder(message);
        } else {
            if (this.errorMessage.length() > 0) {
                this.errorMessage.append("  ");
            }
            this.errorMessage.append(message);
        }
    }

    @Override
    public List<AdditionalLogItem> getAdditionalLogItems() {
        if (this.additionalLogItems != null) {
            return Collections.unmodifiableList(this.additionalLogItems);
        }
        return Collections.emptyList();
    }

    @Override
    public void addAdditionalLogItem(AdditionalLogItem item) {
        Validator.ensureNotNull(item);
        if (this.additionalLogItems == null) {
            this.additionalLogItems = new LinkedList<AdditionalLogItem>();
        }
        this.additionalLogItems.add(item);
    }

    @Override
    public final DN getMatchedDN() {
        return this.matchedDN;
    }

    @Override
    public final void setMatchedDN(DN matchedDN) {
        this.matchedDN = matchedDN;
    }

    @Override
    public final List<String> getReferralURLs() {
        return this.referralURLs;
    }

    @Override
    public final void setReferralURLs(List<String> referralURLs) {
        this.referralURLs = referralURLs;
    }

    @Override
    public final void setResponseData(DirectoryException directoryException) {
        this.resultCode = directoryException.getResultCode();
        this.matchedDN = directoryException.getMatchedDN();
        this.referralURLs = directoryException.getReferralURLs();
        this.appendErrorMessage(directoryException.getMessageObject());
    }

    @Override
    public final boolean isInternalOperation() {
        return this.isInternalOperation;
    }

    @Override
    public final void setInternalOperation(boolean isInternalOperation) {
        this.isInternalOperation = isInternalOperation;
    }

    @Override
    public boolean isInnerOperation() {
        if (this.isInnerOperation != null) {
            return this.isInnerOperation;
        }
        return this.isInternalOperation();
    }

    @Override
    public void setInnerOperation(boolean isInnerOperation) {
        this.isInnerOperation = isInnerOperation;
    }

    @Override
    public final boolean isSynchronizationOperation() {
        return this.isSynchronizationOperation;
    }

    @Override
    public final void setSynchronizationOperation(boolean isSynchronizationOperation) {
        this.isSynchronizationOperation = isSynchronizationOperation;
    }

    @Override
    public boolean dontSynchronize() {
        return this.dontSynchronizeFlag;
    }

    @Override
    public final void setDontSynchronize(boolean dontSynchronize) {
        this.dontSynchronizeFlag = dontSynchronize;
    }

    @Override
    public final Entry getAuthorizationEntry() {
        return this.authorizationEntry;
    }

    @Override
    public final void setAuthorizationEntry(Entry authorizationEntry) {
        this.authorizationEntry = authorizationEntry;
    }

    @Override
    public final DN getAuthorizationDN() {
        if (this.authorizationEntry != null) {
            return this.authorizationEntry.getDN();
        }
        return DN.nullDN();
    }

    @Override
    public final Map<String, Object> getAttachments() {
        return this.attachments;
    }

    @Override
    public final void setAttachments(Map<String, Object> attachments) {
        this.attachments = attachments;
    }

    @Override
    public final Object getAttachment(String name) {
        return this.attachments.get(name);
    }

    @Override
    public final Object removeAttachment(String name) {
        return this.attachments.remove(name);
    }

    @Override
    public final Object setAttachment(String name, Object value) {
        return this.attachments.put(name, value);
    }

    @Override
    public final void operationCompleted() {
        this.clientConnection.removeOperationInProgress(this.messageID);
    }

    @Override
    public CancelResult cancel(CancelRequest cancelRequest) {
        this.abort(cancelRequest);
        long stopWaitingTime = System.currentTimeMillis() + 5000L;
        while (this.cancelResult == null && System.currentTimeMillis() < stopWaitingTime) {
            try {
                Thread.sleep(50L);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        if (this.cancelResult == null) {
            this.cancelResult = new CancelResult(ResultCode.CANNOT_CANCEL, null);
        }
        return this.cancelResult;
    }

    @Override
    public synchronized void abort(CancelRequest cancelRequest) {
        if (this.cancelResult == null && this.cancelRequest == null) {
            this.cancelRequest = cancelRequest;
        }
    }

    @Override
    public final synchronized void checkIfCanceled(boolean signalTooLate) throws CanceledOperationException {
        if (this.cancelRequest != null) {
            throw new CanceledOperationException(this.cancelRequest);
        }
        if (signalTooLate && this.cancelResult != null) {
            this.cancelResult = new CancelResult(ResultCode.TOO_LATE, null);
        }
    }

    @Override
    public final CancelRequest getCancelRequest() {
        return this.cancelRequest;
    }

    @Override
    public final CancelResult getCancelResult() {
        return this.cancelResult;
    }

    @Override
    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    @Override
    public final long getProcessingStartTime() {
        return this.processingStartTime;
    }

    public final void setProcessingStartTime() {
        this.processingStartTime = System.currentTimeMillis();
        if (this.useNanoTime) {
            this.processingStartNanoTime = System.nanoTime();
        }
    }

    @Override
    public final long getProcessingStopTime() {
        return this.processingStopTime;
    }

    public final void setProcessingStopTime() {
        this.processingStopTime = System.currentTimeMillis();
        if (this.useNanoTime) {
            this.processingStopNanoTime = System.nanoTime();
        }
    }

    @Override
    public final long getProcessingTime() {
        return this.processingStopTime - this.processingStartTime;
    }

    @Override
    public final long getProcessingNanoTime() {
        if (this.useNanoTime) {
            return this.processingStopNanoTime - this.processingStartNanoTime;
        }
        return -1L;
    }

    @Override
    public final void registerPostResponseCallback(Runnable callback) {
        if (this.postResponseCallbacks == null) {
            this.postResponseCallbacks = new LinkedList<Runnable>();
        }
        this.postResponseCallbacks.add(callback);
    }

    public final int hashCode() {
        return this.clientConnection.hashCode() * (int)this.operationID;
    }

    public final boolean equals(Object obj) {
        Operation other;
        if (this == obj) {
            return true;
        }
        if (obj instanceof Operation && (other = (Operation)obj).getClientConnection().equals(this.clientConnection)) {
            return other.getOperationID() == this.operationID;
        }
        return false;
    }

    protected final void invokePostResponseCallbacks() {
        if (this.postResponseCallbacks != null) {
            for (Runnable callback : this.postResponseCallbacks) {
                try {
                    callback.run();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
    }
}

