/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.schema.NameFormSyntax;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ByteString;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.Schema;
import org.opends.server.types.SchemaFileElement;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.Validator;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public final class NameForm
implements SchemaFileElement {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final boolean isObsolete;
    private final Map<String, List<String>> extraProperties;
    private final Map<String, String> names;
    private final ObjectClass structuralClass;
    private final Set<AttributeType> optionalAttributes;
    private final Set<AttributeType> requiredAttributes;
    private final String definition;
    private final String description;
    private final String oid;

    public NameForm(String definition, Map<String, String> names, String oid, String description, boolean isObsolete, ObjectClass structuralClass, Set<AttributeType> requiredAttributes, Set<AttributeType> optionalAttributes, Map<String, List<String>> extraProperties) {
        Validator.ensureNotNull(definition, oid, structuralClass);
        this.oid = oid;
        this.description = description;
        this.isObsolete = isObsolete;
        this.structuralClass = structuralClass;
        int schemaFilePos = definition.indexOf("X-SCHEMA-FILE");
        if (schemaFilePos > 0) {
            String defStr;
            try {
                int firstQuotePos = definition.indexOf(39, schemaFilePos);
                int secondQuotePos = definition.indexOf(39, firstQuotePos + 1);
                defStr = definition.substring(0, schemaFilePos).trim() + " " + definition.substring(secondQuotePos + 1).trim();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                defStr = definition;
            }
            this.definition = defStr;
        } else {
            this.definition = definition;
        }
        this.names = names == null || names.isEmpty() ? new LinkedHashMap<String, String>(0) : new LinkedHashMap<String, String>(names);
        this.requiredAttributes = requiredAttributes == null || requiredAttributes.isEmpty() ? new LinkedHashSet<AttributeType>(0) : new LinkedHashSet<AttributeType>(requiredAttributes);
        this.optionalAttributes = optionalAttributes == null || optionalAttributes.isEmpty() ? new LinkedHashSet<AttributeType>(0) : new LinkedHashSet<AttributeType>(optionalAttributes);
        this.extraProperties = extraProperties == null || extraProperties.isEmpty() ? new LinkedHashMap<String, List<String>>(0) : new LinkedHashMap<String, List<String>>(extraProperties);
    }

    @Override
    public String getDefinition() {
        return this.definition;
    }

    @Override
    public NameForm recreateFromDefinition(Schema schema) throws DirectoryException {
        ByteString value = ByteString.valueOf(this.definition);
        NameForm nf = NameFormSyntax.decodeNameForm(value, schema, false);
        nf.setSchemaFile(this.getSchemaFile());
        return nf;
    }

    public Map<String, String> getNames() {
        return this.names;
    }

    public boolean hasName(String lowerName) {
        return this.names.containsKey(lowerName);
    }

    public String getOID() {
        return this.oid;
    }

    public String getNameOrOID() {
        if (this.names.isEmpty()) {
            return this.oid;
        }
        return this.names.values().iterator().next();
    }

    public boolean hasNameOrOID(String lowerValue) {
        if (this.names.containsKey(lowerValue)) {
            return true;
        }
        return lowerValue.equals(this.oid);
    }

    @Override
    public String getSchemaFile() {
        List<String> values = this.extraProperties.get("X-SCHEMA-FILE");
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    @Override
    public void setSchemaFile(String schemaFile) {
        this.setExtraProperty("X-SCHEMA-FILE", schemaFile);
    }

    public String getDescription() {
        return this.description;
    }

    public ObjectClass getStructuralClass() {
        return this.structuralClass;
    }

    public Set<AttributeType> getRequiredAttributes() {
        return this.requiredAttributes;
    }

    public boolean isRequired(AttributeType attributeType) {
        return this.requiredAttributes.contains(attributeType);
    }

    public Set<AttributeType> getOptionalAttributes() {
        return this.optionalAttributes;
    }

    public boolean isOptional(AttributeType attributeType) {
        return this.optionalAttributes.contains(attributeType);
    }

    public boolean isRequiredOrOptional(AttributeType attributeType) {
        return this.requiredAttributes.contains(attributeType) || this.optionalAttributes.contains(attributeType);
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    public Map<String, List<String>> getExtraProperties() {
        return this.extraProperties;
    }

    public List<String> getExtraProperty(String propertyName) {
        return this.extraProperties.get(propertyName);
    }

    public void setExtraProperty(String name, String value) {
        Validator.ensureNotNull(name);
        if (value == null) {
            this.extraProperties.remove(name);
        } else {
            LinkedList<String> values = new LinkedList<String>();
            values.add(value);
            this.extraProperties.put(name, values);
        }
    }

    public void setExtraProperty(String name, List<String> values) {
        Validator.ensureNotNull(name);
        if (values == null || values.isEmpty()) {
            this.extraProperties.remove(name);
        } else {
            LinkedList<String> valuesCopy = new LinkedList<String>(values);
            this.extraProperties.put(name, valuesCopy);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof NameForm)) {
            return false;
        }
        return this.oid.equals(((NameForm)o).oid);
    }

    public int hashCode() {
        int oidLength = this.oid.length();
        int hashCode = 0;
        for (int i = 0; i < oidLength; ++i) {
            hashCode += this.oid.charAt(i);
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer, true);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer, boolean includeFileElement) {
        String firstName;
        Iterator<Object> iterator;
        buffer.append("( ");
        buffer.append(this.oid);
        if (!this.names.isEmpty()) {
            iterator = this.names.values().iterator();
            firstName = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" NAME ( '");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append("' '");
                    buffer.append((String)iterator.next());
                }
                buffer.append("' )");
            } else {
                buffer.append(" NAME '");
                buffer.append(firstName);
                buffer.append("'");
            }
        }
        if (this.description != null && this.description.length() > 0) {
            buffer.append(" DESC '");
            buffer.append(this.description);
            buffer.append("'");
        }
        if (this.isObsolete) {
            buffer.append(" OBSOLETE");
        }
        buffer.append(" OC ");
        buffer.append(this.structuralClass.getNameOrOID());
        if (!this.requiredAttributes.isEmpty()) {
            iterator = this.requiredAttributes.iterator();
            firstName = ((AttributeType)iterator.next()).getNameOrOID();
            if (iterator.hasNext()) {
                buffer.append(" MUST ( ");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append(" $ ");
                    buffer.append(((AttributeType)iterator.next()).getNameOrOID());
                }
                buffer.append(" )");
            } else {
                buffer.append(" MUST ");
                buffer.append(firstName);
            }
        }
        if (!this.optionalAttributes.isEmpty()) {
            iterator = this.optionalAttributes.iterator();
            firstName = ((AttributeType)iterator.next()).getNameOrOID();
            if (iterator.hasNext()) {
                buffer.append(" MAY ( ");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append(" $ ");
                    buffer.append(((AttributeType)iterator.next()).getNameOrOID());
                }
                buffer.append(" )");
            } else {
                buffer.append(" MAY ");
                buffer.append(firstName);
            }
        }
        if (!this.extraProperties.isEmpty()) {
            for (String property : this.extraProperties.keySet()) {
                if (!includeFileElement && property.equals("X-SCHEMA-FILE")) continue;
                List<String> valueList = this.extraProperties.get(property);
                buffer.append(" ");
                buffer.append(property);
                if (valueList.size() == 1) {
                    buffer.append(" '");
                    buffer.append(valueList.get(0));
                    buffer.append("'");
                    continue;
                }
                buffer.append(" ( ");
                for (String value : valueList) {
                    buffer.append("'");
                    buffer.append(value);
                    buffer.append("' ");
                }
                buffer.append(")");
            }
        }
        buffer.append(" )");
    }
}

