/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.List;
import java.util.Map;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.api.ClientConnection;
import org.opends.server.controls.ControlDecoder;
import org.opends.server.types.AdditionalLogItem;
import org.opends.server.types.CancelRequest;
import org.opends.server.types.CancelResult;
import org.opends.server.types.CanceledOperationException;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.Entry;
import org.opends.server.types.OperationType;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.ResultCode;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public interface Operation
extends Runnable {
    public static final String LOCALBACKENDOPERATIONS = "LocalBackendOperations";

    public OperationType getOperationType();

    public void disconnectClient(DisconnectReason var1, boolean var2, Message var3);

    public String[][] getCommonLogElements();

    public String[][] getRequestLogElements();

    public String[][] getResponseLogElements();

    public ClientConnection getClientConnection();

    public long getConnectionID();

    public long getOperationID();

    public int getMessageID();

    public List<Control> getRequestControls();

    public <T extends Control> T getRequestControl(ControlDecoder<T> var1) throws DirectoryException;

    public void addRequestControl(Control var1);

    public List<Control> getResponseControls();

    public void addResponseControl(Control var1);

    public void removeResponseControl(Control var1);

    public ResultCode getResultCode();

    public void setResultCode(ResultCode var1);

    public MessageBuilder getErrorMessage();

    public void setErrorMessage(MessageBuilder var1);

    public void appendErrorMessage(Message var1);

    public List<AdditionalLogItem> getAdditionalLogItems();

    public void addAdditionalLogItem(AdditionalLogItem var1);

    public DN getMatchedDN();

    public void setMatchedDN(DN var1);

    public List<String> getReferralURLs();

    public void setReferralURLs(List<String> var1);

    public void setResponseData(DirectoryException var1);

    public boolean isInternalOperation();

    public void setInternalOperation(boolean var1);

    public boolean isInnerOperation();

    public void setInnerOperation(boolean var1);

    public boolean isSynchronizationOperation();

    public void setSynchronizationOperation(boolean var1);

    public void setDontSynchronize(boolean var1);

    public Entry getAuthorizationEntry();

    public void setAuthorizationEntry(Entry var1);

    public DN getAuthorizationDN();

    public Map<String, Object> getAttachments();

    public Object getAttachment(String var1);

    public Object removeAttachment(String var1);

    public Object setAttachment(String var1, Object var2);

    public long getProcessingStartTime();

    public long getProcessingStopTime();

    public long getProcessingTime();

    public long getProcessingNanoTime();

    public void operationCompleted();

    public CancelResult cancel(CancelRequest var1);

    public void abort(CancelRequest var1);

    public CancelRequest getCancelRequest();

    public CancelResult getCancelResult();

    public String toString();

    public void toString(StringBuilder var1);

    public boolean dontSynchronize();

    public void setAttachments(Map<String, Object> var1);

    public void checkIfCanceled(boolean var1) throws CanceledOperationException;

    public void registerPostResponseCallback(Runnable var1);

    @Override
    public void run();
}

