/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.SchemaMessages;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.Attributes;
import org.opends.server.types.CollectiveVirtualAttribute;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SubtreeSpecification;

public class SubEntry {
    public static final String ATTR_COLLECTIVE_CONFLICT_BEHAVIOR = "collectiveconflictbehavior";
    public static final String ATTR_INHERIT_COLLECTIVE_FROM_DN = "inheritfromdnattribute";
    public static final String ATTR_INHERIT_COLLECTIVE_FROM_RDN = "inheritfromrdnattribute";
    public static final String ATTR_INHERIT_COLLECTIVE_FROM_RDN_TYPE = "inheritfromrdntype";
    public static final String ATTR_INHERIT_COLLECTIVE_FROM_BASE = "inheritfrombaserdn";
    public static final String ATTR_INHERIT_COLLECTIVE_ATTR = "inheritattribute";
    private static final String ATTR_OPTION_COLLECTIVE = "collective";
    private Entry entry;
    private SubtreeSpecification subTreeSpec;
    private boolean isCollective = false;
    private boolean isInheritedCollective = false;
    private boolean isInheritedFromDNCollective = false;
    private boolean isInheritedFromRDNCollective = false;
    private AttributeType inheritFromDNType = null;
    private AttributeType inheritFromRDNAttrType = null;
    private AttributeType inheritFromRDNType = null;
    private AttributeValue inheritFromRDNAttrValue = null;
    private AttributeValue inheritFromDNAttrValue = null;
    private DN inheritFromBaseDN = null;
    private List<Attribute> collectiveAttributes;
    private CollectiveConflictBehavior conflictBehavior = CollectiveConflictBehavior.REAL_OVERRIDES_VIRTUAL;

    public SubEntry(Entry entry) throws DirectoryException {
        List<Attribute> attrList;
        this.entry = entry;
        this.subTreeSpec = null;
        String specString = null;
        boolean isValidSpec = true;
        AttributeType specAttrType = DirectoryServer.getAttributeType("subtreespecification", true);
        List<Attribute> specAttrList = entry.getAttribute(specAttrType);
        if (specAttrList != null) {
            for (Attribute attr : specAttrList) {
                for (AttributeValue value : attr) {
                    specString = ((Object)value).toString();
                    try {
                        this.subTreeSpec = SubtreeSpecification.valueOf(entry.getDN().getParent(), specString);
                        isValidSpec = true;
                    }
                    catch (DirectoryException de) {
                        isValidSpec = false;
                    }
                    if (this.subTreeSpec == null) continue;
                    break;
                }
                if (this.subTreeSpec == null) continue;
                break;
            }
        }
        if (!isValidSpec) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_SUBTREE_SPECIFICATION_INVALID.get(specString);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        if (this.subTreeSpec == null) {
            this.subTreeSpec = new SubtreeSpecification(entry.getDN().getParent(), null, -1, -1, null, null, null);
        }
        this.isCollective = entry.isCollectiveAttributeSubentry();
        this.isInheritedCollective = entry.isInheritedCollectiveAttributeSubentry();
        if (this.isInheritedCollective) {
            this.isInheritedFromDNCollective = entry.isInheritedFromDNCollectiveAttributeSubentry();
            this.isInheritedFromRDNCollective = entry.isInheritedFromRDNCollectiveAttributeSubentry();
        }
        this.collectiveAttributes = new ArrayList<Attribute>();
        if (this.isCollective) {
            List<Attribute> subAttrList = entry.getAttributes();
            for (Attribute subAttr : subAttrList) {
                AttributeType attrType = subAttr.getAttributeType();
                if (attrType.isCollective()) {
                    CollectiveVirtualAttribute collectiveAttr = new CollectiveVirtualAttribute(subAttr);
                    this.collectiveAttributes.add(collectiveAttr);
                    continue;
                }
                if (!subAttr.hasOption(ATTR_OPTION_COLLECTIVE)) continue;
                AttributeBuilder builder = new AttributeBuilder(subAttr.getAttributeType());
                builder.addAll(subAttr);
                LinkedHashSet<String> options = new LinkedHashSet<String>(subAttr.getOptions());
                options.remove(ATTR_OPTION_COLLECTIVE);
                builder.setOptions(options);
                Attribute attr = builder.toAttribute();
                CollectiveVirtualAttribute collectiveAttr = new CollectiveVirtualAttribute(attr);
                this.collectiveAttributes.add(collectiveAttr);
            }
        }
        if (this.isInheritedCollective) {
            AttributeValue value2;
            Iterator<AttributeValue> i$;
            if (this.isInheritedFromDNCollective && (attrList = entry.getAttribute(ATTR_INHERIT_COLLECTIVE_FROM_DN)) != null && !attrList.isEmpty()) {
                for (Attribute attr : attrList) {
                    i$ = attr.iterator();
                    if (!i$.hasNext()) continue;
                    value2 = i$.next();
                    this.inheritFromDNType = DirectoryServer.getAttributeType(((Object)value2).toString().toLowerCase(), true);
                    this.inheritFromDNAttrValue = value2;
                }
            }
            if (this.isInheritedFromRDNCollective) {
                attrList = entry.getAttribute(ATTR_INHERIT_COLLECTIVE_FROM_RDN);
                if (attrList != null && !attrList.isEmpty()) {
                    for (Attribute attr : attrList) {
                        i$ = attr.iterator();
                        if (!i$.hasNext()) continue;
                        value2 = i$.next();
                        this.inheritFromRDNAttrType = DirectoryServer.getAttributeType(((Object)value2).toString().toLowerCase(), true);
                        this.inheritFromRDNAttrValue = value2;
                    }
                }
                if ((attrList = entry.getAttribute(ATTR_INHERIT_COLLECTIVE_FROM_RDN_TYPE)) != null && !attrList.isEmpty()) {
                    for (Attribute attr : attrList) {
                        i$ = attr.iterator();
                        if (!i$.hasNext()) continue;
                        value2 = i$.next();
                        this.inheritFromRDNType = DirectoryServer.getAttributeType(((Object)value2).toString().toLowerCase(), true);
                    }
                }
                if ((attrList = entry.getAttribute(ATTR_INHERIT_COLLECTIVE_FROM_BASE)) != null && !attrList.isEmpty()) {
                    for (Attribute attr : attrList) {
                        i$ = attr.iterator();
                        if (!i$.hasNext()) continue;
                        value2 = i$.next();
                        this.inheritFromBaseDN = DN.decode(value2.getNormalizedValue());
                        this.inheritFromBaseDN = this.getDN().getParent().concat(this.inheritFromBaseDN);
                    }
                }
            }
            if ((attrList = entry.getAttribute(ATTR_INHERIT_COLLECTIVE_ATTR)) != null && !attrList.isEmpty()) {
                for (Attribute attr : attrList) {
                    for (AttributeValue value2 : attr) {
                        CollectiveVirtualAttribute collectiveAttr = new CollectiveVirtualAttribute(Attributes.empty(((Object)value2).toString()));
                        this.collectiveAttributes.add(collectiveAttr);
                    }
                }
            }
        }
        if ((this.isCollective || this.isInheritedCollective) && (attrList = entry.getAttribute(ATTR_COLLECTIVE_CONFLICT_BEHAVIOR)) != null && !attrList.isEmpty()) {
            for (Attribute attr : attrList) {
                block12: for (AttributeValue value2 : attr) {
                    for (CollectiveConflictBehavior behavior : CollectiveConflictBehavior.values()) {
                        if (!behavior.toString().equals(((Object)value2).toString())) continue;
                        this.conflictBehavior = behavior;
                        continue block12;
                    }
                }
            }
        }
    }

    public final DN getDN() {
        return this.entry.getDN();
    }

    public final Entry getEntry() {
        return this.entry;
    }

    public boolean isCollective() {
        return this.isCollective;
    }

    public boolean isInheritedCollective() {
        return this.isInheritedCollective;
    }

    public boolean isInheritedFromDNCollective() {
        return this.isInheritedFromDNCollective;
    }

    public boolean isInheritedFromRDNCollective() {
        return this.isInheritedFromRDNCollective;
    }

    public AttributeType getInheritFromDNType() {
        return this.inheritFromDNType;
    }

    public AttributeType getInheritFromRDNAttrType() {
        return this.inheritFromRDNAttrType;
    }

    public AttributeValue getInheritFromRDNAttrValue() {
        return this.inheritFromRDNAttrValue;
    }

    public AttributeType getInheritFromRDNType() {
        return this.inheritFromRDNType;
    }

    public AttributeValue getInheritFromDNAttrValue() {
        return this.inheritFromDNAttrValue;
    }

    public DN getInheritFromBaseDN() {
        return this.inheritFromBaseDN;
    }

    public SubtreeSpecification getSubTreeSpecification() {
        return this.subTreeSpec;
    }

    public List<Attribute> getCollectiveAttributes() {
        return this.collectiveAttributes;
    }

    public CollectiveConflictBehavior getConflictBehavior() {
        return this.conflictBehavior;
    }

    public static enum CollectiveConflictBehavior {
        MERGE_REAL_AND_VIRTUAL("merge-real-and-virtual"),
        REAL_OVERRIDES_VIRTUAL("real-overrides-virtual"),
        VIRTUAL_OVERRIDES_REAL("virtual-overrides-real");

        private final String name;

        private CollectiveConflictBehavior(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

