/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.List;
import org.opends.messages.Message;
import org.opends.server.types.DN;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.ResultCode;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public interface SynchronizationProviderResult {
    public boolean continueProcessing();

    public Message getErrorMessage();

    public ResultCode getResultCode();

    public DN getMatchedDN();

    public List<String> getReferralURLs();

    public static class StopProcessing
    implements SynchronizationProviderResult {
        private final DN matchedDN;
        private final List<String> referralURLs;
        private final ResultCode resultCode;
        private final Message errorMessage;

        public StopProcessing(ResultCode resultCode, Message errorMessage, DN matchedDN, List<String> referralURLs) {
            this.errorMessage = errorMessage;
            this.matchedDN = matchedDN;
            this.resultCode = resultCode;
            this.referralURLs = referralURLs;
        }

        public StopProcessing(ResultCode resultCode, Message errorMessage) {
            this.errorMessage = errorMessage;
            this.resultCode = resultCode;
            this.matchedDN = null;
            this.referralURLs = null;
        }

        @Override
        public ResultCode getResultCode() {
            return this.resultCode;
        }

        @Override
        public DN getMatchedDN() {
            return this.matchedDN;
        }

        @Override
        public List<String> getReferralURLs() {
            return this.referralURLs;
        }

        @Override
        public boolean continueProcessing() {
            return false;
        }

        @Override
        public Message getErrorMessage() {
            return this.errorMessage;
        }
    }

    public static class ContinueProcessing
    implements SynchronizationProviderResult {
        @Override
        public ResultCode getResultCode() {
            return null;
        }

        @Override
        public DN getMatchedDN() {
            return null;
        }

        @Override
        public List<String> getReferralURLs() {
            return null;
        }

        @Override
        public boolean continueProcessing() {
            return true;
        }

        @Override
        public Message getErrorMessage() {
            return null;
        }
    }
}

