/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util.table;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.opends.server.util.table.TablePrinter;
import org.opends.server.util.table.TableSerializer;

public final class TabSeparatedTablePrinter
extends TablePrinter {
    private boolean displayHeadings = false;
    private PrintWriter writer = null;

    public TabSeparatedTablePrinter(OutputStream stream) {
        this(new BufferedWriter(new OutputStreamWriter(stream)));
    }

    public TabSeparatedTablePrinter(Writer writer) {
        this.writer = new PrintWriter(writer);
    }

    public void setDisplayHeadings(boolean displayHeadings) {
        this.displayHeadings = displayHeadings;
    }

    @Override
    protected TableSerializer getSerializer() {
        return new Serializer();
    }

    private final class Serializer
    extends TableSerializer {
        private int column = 0;
        private int requiredSeparators = 0;

        private Serializer() {
        }

        @Override
        public void addCell(String s) {
            if (s.length() == 0) {
                ++this.requiredSeparators;
            } else {
                for (int i = 0; i < this.requiredSeparators; ++i) {
                    TabSeparatedTablePrinter.this.writer.print('\t');
                }
                this.requiredSeparators = 1;
            }
            TabSeparatedTablePrinter.this.writer.print(s.replaceAll("[\\t\\n\\r]", " "));
            ++this.column;
        }

        @Override
        public void addHeading(String s) {
            if (TabSeparatedTablePrinter.this.displayHeadings) {
                this.addCell(s);
            }
        }

        @Override
        public void endHeader() {
            if (TabSeparatedTablePrinter.this.displayHeadings) {
                TabSeparatedTablePrinter.this.writer.println();
            }
        }

        @Override
        public void endRow() {
            TabSeparatedTablePrinter.this.writer.println();
        }

        @Override
        public void endTable() {
            TabSeparatedTablePrinter.this.writer.flush();
        }

        @Override
        public void startHeader() {
            this.column = 0;
            this.requiredSeparators = 0;
        }

        @Override
        public void startRow() {
            this.column = 0;
            this.requiredSeparators = 0;
        }
    }
}

