/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.workflowelement.externalchangelog;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import org.opends.messages.Category;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.messages.ReplicationMessages;
import org.opends.messages.Severity;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.plugin.PluginResult;
import org.opends.server.controls.EntryChangelogNotificationControl;
import org.opends.server.controls.ExternalChangelogRequestControl;
import org.opends.server.controls.LDAPAssertionRequestControl;
import org.opends.server.controls.MatchedValuesControl;
import org.opends.server.controls.PersistentSearchControl;
import org.opends.server.controls.ProxiedAuthV1Control;
import org.opends.server.controls.ProxiedAuthV2Control;
import org.opends.server.controls.SubentriesControl;
import org.opends.server.core.AccessControlConfigManager;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PersistentSearch;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.core.SearchOperation;
import org.opends.server.core.SearchOperationWrapper;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.common.ExternalChangeLogSession;
import org.opends.server.replication.common.MultiDomainServerState;
import org.opends.server.replication.plugin.MultimasterReplication;
import org.opends.server.replication.protocol.AddMsg;
import org.opends.server.replication.protocol.DeleteMsg;
import org.opends.server.replication.protocol.ECLUpdateMsg;
import org.opends.server.replication.protocol.ModifyCommonMsg;
import org.opends.server.replication.protocol.ModifyDNMsg;
import org.opends.server.replication.protocol.StartECLSessionMsg;
import org.opends.server.replication.protocol.UpdateMsg;
import org.opends.server.replication.server.ReplicationServer;
import org.opends.server.types.AdditionalLogItem;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.Attributes;
import org.opends.server.types.ByteString;
import org.opends.server.types.CancelRequest;
import org.opends.server.types.CancelResult;
import org.opends.server.types.CanceledOperationException;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryConfig;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.FilterType;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.Privilege;
import org.opends.server.types.RDN;
import org.opends.server.types.RawAttribute;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;
import org.opends.server.types.operation.PostOperationSearchOperation;
import org.opends.server.types.operation.PreOperationSearchOperation;
import org.opends.server.types.operation.SearchEntrySearchOperation;
import org.opends.server.types.operation.SearchReferenceSearchOperation;
import org.opends.server.util.LDIFWriter;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;
import org.opends.server.workflowelement.externalchangelog.ECLWorkflowElement;

public class ECLSearchOperation
extends SearchOperationWrapper
implements PreOperationSearchOperation,
PostOperationSearchOperation,
SearchEntrySearchOperation,
SearchReferenceSearchOperation {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private StartECLSessionMsg startECLSessionMsg;
    private static final HashSet<String> CHANGELOG_SUPPORTED_CONTROLS = new HashSet(0);
    private static final HashMap<ObjectClass, String> CHANGELOG_ROOT_OBJECT_CLASSES;
    private static final HashMap<ObjectClass, String> CHANGELOG_ENTRY_OBJECT_CLASSES;
    private static final AttributeType CREATORS_NAME_TYPE;
    private static final AttributeType MODIFIERS_NAME_TYPE;
    private static final DN CHANGELOG_ROOT_DN;
    private ReplicationServer replicationServer;
    private ClientConnection clientConnection;
    private DN baseDN;
    private PersistentSearch persistentSearch;
    private SearchFilter filter;
    private ExternalChangeLogSession eclSession;
    private Boolean returnECLControl = false;

    ECLSearchOperation(SearchOperation search) {
        super(search);
        ECLWorkflowElement.attachLocalOperation(search, this);
    }

    void processECLSearch(ECLWorkflowElement wfe) throws CanceledOperationException {
        PluginResult.PostOperation postOpResult;
        PluginConfigManager pluginConfigManager;
        boolean executePostOpPlugins;
        block25: {
            executePostOpPlugins = false;
            pluginConfigManager = DirectoryServer.getPluginConfigManager();
            this.checkIfCanceled(false);
            this.replicationServer = wfe.getReplicationServer();
            this.clientConnection = this.getClientConnection();
            this.startECLSessionMsg = new StartECLSessionMsg();
            this.startECLSessionMsg.setECLRequestType((short)1);
            this.startECLSessionMsg.setOperationId(this.toString());
            ArrayList<String> excludedDomains = MultimasterReplication.getECLDisabledDomains();
            if (!excludedDomains.contains("cn=changelog")) {
                excludedDomains.add("cn=changelog");
            }
            this.startECLSessionMsg.setExcludedDNs(excludedDomains);
            this.baseDN = this.getBaseDN();
            this.filter = this.getFilter();
            if (this.baseDN != null && this.filter != null) {
                if (this.replicationServer == null) {
                    this.setResultCode(ResultCode.OPERATIONS_ERROR);
                    this.appendErrorMessage(CoreMessages.ERR_SEARCH_BASE_DOESNT_EXIST.get(String.valueOf(this.baseDN)));
                } else {
                    try {
                        this.handleRequestControls();
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        this.setResponseData(de);
                        break block25;
                    }
                    try {
                        ECLSearchOperation.evaluateSearchParameters(this.startECLSessionMsg, this.baseDN, this.filter);
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        this.setResponseData(de);
                        break block25;
                    }
                    this.checkIfCanceled(false);
                    executePostOpPlugins = true;
                    PluginResult.PreOperation preOpResult = pluginConfigManager.invokePreOperationSearchPlugins(this);
                    if (!preOpResult.continueProcessing()) {
                        this.setResultCode(preOpResult.getResultCode());
                        this.appendErrorMessage(preOpResult.getErrorMessage());
                        this.setMatchedDN(preOpResult.getMatchedDN());
                        this.setReferralURLs(preOpResult.getReferralURLs());
                    } else {
                        this.checkIfCanceled(false);
                        this.setResultCode(ResultCode.SUCCESS);
                        if (this.persistentSearch != null) {
                            wfe.registerPersistentSearch(this.persistentSearch);
                            this.persistentSearch.enable();
                        }
                        try {
                            this.processSearch();
                        }
                        catch (DirectoryException de) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, de);
                            }
                            this.setResponseData(de);
                            if (this.persistentSearch != null) {
                                this.persistentSearch.cancel();
                                this.setSendResponse(true);
                            }
                        }
                        catch (CanceledOperationException coe) {
                            if (this.persistentSearch != null) {
                                this.persistentSearch.cancel();
                                this.setSendResponse(true);
                            }
                            if (this.eclSession != null) {
                                try {
                                    this.eclSession.close();
                                }
                                catch (Exception ignored) {
                                    // empty catch block
                                }
                            }
                            throw coe;
                        }
                        catch (Exception e) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                            this.setResultCode(DirectoryServer.getServerErrorResultCode());
                            this.appendErrorMessage(CoreMessages.ERR_SEARCH_BACKEND_EXCEPTION.get(StaticUtils.getExceptionMessage(e)));
                            if (this.persistentSearch == null) break block25;
                            this.persistentSearch.cancel();
                            this.setSendResponse(true);
                        }
                    }
                }
            }
        }
        this.checkIfCanceled(false);
        if (executePostOpPlugins && !(postOpResult = pluginConfigManager.invokePostOperationSearchPlugins(this)).continueProcessing()) {
            this.setResultCode(postOpResult.getResultCode());
            this.appendErrorMessage(postOpResult.getErrorMessage());
            this.setMatchedDN(postOpResult.getMatchedDN());
            this.setReferralURLs(postOpResult.getReferralURLs());
        }
    }

    private void handleRequestControls() throws DirectoryException {
        List<Control> requestControls = this.getRequestControls();
        if (requestControls != null && !requestControls.isEmpty()) {
            Iterator<Control> iter = requestControls.iterator();
            while (iter.hasNext()) {
                Entry authorizationEntry;
                Control proxyControl;
                Control c = iter.next();
                String oid = c.getOID();
                if (!AccessControlConfigManager.getInstance().getAccessControlHandler().isAllowed(this.baseDN, this, c)) {
                    if (c.isCritical()) {
                        throw new DirectoryException(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION, CoreMessages.ERR_CONTROL_INSUFFICIENT_ACCESS_RIGHTS.get(oid));
                    }
                    iter.remove();
                    continue;
                }
                if (oid.equals("1.3.6.1.4.1.26027.1.5.4")) {
                    ExternalChangelogRequestControl eclControl = this.getRequestControl(ExternalChangelogRequestControl.DECODER);
                    MultiDomainServerState cookie = eclControl.getCookie();
                    this.returnECLControl = true;
                    if (cookie == null) continue;
                    this.startECLSessionMsg.setECLRequestType((short)0);
                    this.startECLSessionMsg.setCrossDomainServerState(cookie.toString());
                    continue;
                }
                if (oid.equals("1.3.6.1.1.12")) {
                    LDAPAssertionRequestControl assertControl = this.getRequestControl(LDAPAssertionRequestControl.DECODER);
                    try {
                        Entry entry;
                        SearchFilter assertionFilter = assertControl.getSearchFilter();
                        try {
                            entry = DirectoryServer.getEntry(this.baseDN);
                        }
                        catch (DirectoryException de) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, de);
                            }
                            throw new DirectoryException(de.getResultCode(), CoreMessages.ERR_SEARCH_CANNOT_GET_ENTRY_FOR_ASSERTION.get(de.getMessageObject()));
                        }
                        if (entry == null) {
                            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, CoreMessages.ERR_SEARCH_NO_SUCH_ENTRY_FOR_ASSERTION.get());
                        }
                        if (assertionFilter.matchesEntry(entry)) continue;
                        throw new DirectoryException(ResultCode.ASSERTION_FAILED, CoreMessages.ERR_SEARCH_ASSERTION_FAILED.get());
                    }
                    catch (DirectoryException de) {
                        if (de.getResultCode() == ResultCode.ASSERTION_FAILED) {
                            throw de;
                        }
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        throw new DirectoryException(ResultCode.PROTOCOL_ERROR, CoreMessages.ERR_SEARCH_CANNOT_PROCESS_ASSERTION_FILTER.get(de.getMessageObject()), de);
                    }
                }
                if (oid.equals("2.16.840.1.113730.3.4.12")) {
                    this.addAdditionalLogItem(AdditionalLogItem.keyOnly(this.getClass(), "obsoleteProxiedAuthzV1Control"));
                    if (!this.clientConnection.hasPrivilege(Privilege.PROXIED_AUTH, this)) {
                        throw new DirectoryException(ResultCode.AUTHORIZATION_DENIED, CoreMessages.ERR_PROXYAUTH_INSUFFICIENT_PRIVILEGES.get());
                    }
                    proxyControl = this.getRequestControl(ProxiedAuthV1Control.DECODER);
                    authorizationEntry = ((ProxiedAuthV1Control)proxyControl).getAuthorizationEntry();
                    this.setAuthorizationEntry(authorizationEntry);
                    if (authorizationEntry == null) {
                        this.setProxiedAuthorizationDN(DN.nullDN());
                        continue;
                    }
                    this.setProxiedAuthorizationDN(authorizationEntry.getDN());
                    continue;
                }
                if (oid.equals("2.16.840.1.113730.3.4.18")) {
                    if (!this.clientConnection.hasPrivilege(Privilege.PROXIED_AUTH, this)) {
                        throw new DirectoryException(ResultCode.AUTHORIZATION_DENIED, CoreMessages.ERR_PROXYAUTH_INSUFFICIENT_PRIVILEGES.get());
                    }
                    proxyControl = this.getRequestControl(ProxiedAuthV2Control.DECODER);
                    authorizationEntry = ((ProxiedAuthV2Control)proxyControl).getAuthorizationEntry();
                    this.setAuthorizationEntry(authorizationEntry);
                    if (authorizationEntry == null) {
                        this.setProxiedAuthorizationDN(DN.nullDN());
                        continue;
                    }
                    this.setProxiedAuthorizationDN(authorizationEntry.getDN());
                    continue;
                }
                if (oid.equals("2.16.840.1.113730.3.4.3")) {
                    PersistentSearchControl psearchControl = this.getRequestControl(PersistentSearchControl.DECODER);
                    this.persistentSearch = new PersistentSearch(this, psearchControl.getChangeTypes(), psearchControl.getReturnECs());
                    if (psearchControl.getChangesOnly()) {
                        this.startECLSessionMsg.setPersistent((short)2);
                        continue;
                    }
                    this.startECLSessionMsg.setPersistent((short)0);
                    continue;
                }
                if (oid.equals("1.3.6.1.4.1.4203.1.10.1")) {
                    SubentriesControl subentriesControl = this.getRequestControl(SubentriesControl.DECODER);
                    this.setReturnSubentriesOnly(subentriesControl.getVisibility());
                    continue;
                }
                if (oid.equals("1.3.6.1.4.1.7628.5.101.1")) {
                    this.addAdditionalLogItem(AdditionalLogItem.keyOnly(this.getClass(), "obsoleteSubentryControl"));
                    this.setReturnSubentriesOnly(true);
                    continue;
                }
                if (oid.equals("1.2.826.0.1.3344810.2.3")) {
                    MatchedValuesControl matchedValuesControl = this.getRequestControl(MatchedValuesControl.DECODER);
                    this.setMatchedValuesControl(matchedValuesControl);
                    continue;
                }
                if (oid.equals("1.3.6.1.4.1.42.2.27.9.5.8")) {
                    this.setIncludeUsableControl(true);
                    continue;
                }
                if (oid.equals("2.16.840.1.113730.3.4.17")) {
                    this.setRealAttributesOnly(true);
                    continue;
                }
                if (oid.equals("2.16.840.1.113730.3.4.19")) {
                    this.setVirtualAttributesOnly(true);
                    continue;
                }
                if (oid.equals("1.3.6.1.4.1.42.2.27.9.5.2") && DirectoryServer.isSupportedControl("1.3.6.1.4.1.42.2.27.9.5.2") || !c.isCritical() || this.replicationServer != null && this.supportsControl(oid)) continue;
                throw new DirectoryException(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION, CoreMessages.ERR_SEARCH_UNSUPPORTED_CRITICAL_CONTROL.get(oid));
            }
        }
    }

    private void processSearch() throws DirectoryException, CanceledOperationException {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo(" processSearch toString=[" + this.toString() + "] opid=[" + this.startECLSessionMsg.getOperationId() + "]");
        }
        this.eclSession = this.replicationServer.createECLSession(this.startECLSessionMsg);
        boolean abortECLSession = false;
        try {
            Entry entry;
            ECLUpdateMsg update = this.eclSession.getNextUpdate();
            if (CHANGELOG_ROOT_DN.matchesBaseAndScope(this.baseDN, this.getScope()) && this.filter.matchesEntry(entry = this.createRootEntry(update != null)) && !this.returnEntry(entry, null)) {
                abortECLSession = true;
                return;
            }
            if (this.baseDN.equals(CHANGELOG_ROOT_DN) && this.getScope().equals((Object)SearchScope.BASE_OBJECT)) {
                return;
            }
            int lookthroughCount = 0;
            int lookthroughLimit = this.getClientConnection().getLookthroughLimit();
            while (update != null) {
                if (lookthroughLimit > 0 && lookthroughCount > lookthroughLimit) {
                    this.setResultCode(ResultCode.ADMIN_LIMIT_EXCEEDED);
                    this.appendErrorMessage(ReplicationMessages.NOTE_ECL_LOOKTHROUGH_LIMIT_EXCEEDED.get(lookthroughLimit));
                    return;
                }
                this.checkIfCanceled(false);
                if (!this.buildAndReturnEntry(update)) {
                    abortECLSession = true;
                    return;
                }
                ++lookthroughCount;
                update = this.eclSession.getNextUpdate();
            }
        }
        catch (CanceledOperationException e) {
            abortECLSession = true;
            throw e;
        }
        catch (DirectoryException e) {
            abortECLSession = true;
            throw e;
        }
        finally {
            if (this.persistentSearch == null || abortECLSession) {
                this.eclSession.close();
            }
        }
    }

    private boolean supportsControl(String oid) {
        return CHANGELOG_SUPPORTED_CONTROLS.contains(oid);
    }

    private boolean buildAndReturnEntry(ECLUpdateMsg eclmsg) throws DirectoryException {
        Entry entry = ECLSearchOperation.createEntryFromMsg(eclmsg);
        if (this.matchScopeAndFilter(entry)) {
            ArrayList<EntryChangelogNotificationControl> controls = null;
            if (this.returnECLControl.booleanValue()) {
                controls = new ArrayList<EntryChangelogNotificationControl>(1);
                EntryChangelogNotificationControl clrc = new EntryChangelogNotificationControl(true, eclmsg.getCookie().toString());
                controls.add(clrc);
            }
            return this.returnEntry(entry, controls);
        }
        if (this.getTimeLimit() > 0 && TimeThread.getTime() >= this.getTimeLimitExpiration()) {
            this.setResultCode(ResultCode.TIME_LIMIT_EXCEEDED);
            this.appendErrorMessage(CoreMessages.ERR_SEARCH_TIME_LIMIT_EXCEEDED.get(this.getTimeLimit()));
            return false;
        }
        return true;
    }

    private boolean matchScopeAndFilter(Entry entry) throws DirectoryException {
        if (entry.matchesBaseAndScope(this.getBaseDN(), this.getScope())) {
            return this.getFilter().matchesEntry(entry);
        }
        return false;
    }

    public static Entry createEntryFromMsg(ECLUpdateMsg eclmsg) throws DirectoryException {
        Entry clEntry = null;
        UpdateMsg msg = eclmsg.getUpdateMsg();
        if (msg instanceof AddMsg) {
            AddMsg addMsg = (AddMsg)msg;
            String changeInitiatorsName = null;
            String ldifChanges = null;
            try {
                StringBuilder builder = new StringBuilder(256);
                for (Attribute a : addMsg.getAttributes()) {
                    if (a.getAttributeType().equals(CREATORS_NAME_TYPE) && !a.isEmpty()) {
                        changeInitiatorsName = ((Object)a.iterator().next()).toString();
                    }
                    String attrName = a.getNameWithOptions();
                    for (AttributeValue v : a) {
                        builder.append(attrName);
                        LDIFWriter.appendLDIFSeparatorAndValue(builder, v.getValue());
                        builder.append('\n');
                    }
                }
                ldifChanges = builder.toString();
            }
            catch (Exception e) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                ErrorLogger.logError(Message.raw(Category.SYNC, Severity.MILD_ERROR, "An exception was encountered while try to encode a replication add message for entry \"" + addMsg.getDn() + "\" into an External Change Log entry: " + e.getMessage(), new Object[0]));
            }
            ArrayList<RawAttribute> eclAttributes = addMsg.getEclIncludes();
            clEntry = ECLSearchOperation.createChangelogEntry(eclmsg.getServiceId(), eclmsg.getCookie().toString(), DN.decode(addMsg.getDn()), addMsg.getChangeNumber(), ldifChanges, addMsg.getEntryUUID(), eclAttributes, eclmsg.getDraftChangeNumber(), "add", changeInitiatorsName);
        } else if (msg instanceof ModifyCommonMsg) {
            ModifyCommonMsg modifyMsg = (ModifyCommonMsg)msg;
            String changeInitiatorsName = null;
            String ldifChanges = null;
            try {
                StringBuilder builder = new StringBuilder(128);
                for (Modification m : modifyMsg.getMods()) {
                    Attribute a = m.getAttribute();
                    if (m.getModificationType() == ModificationType.REPLACE && a.getAttributeType().equals(MODIFIERS_NAME_TYPE) && !a.isEmpty()) {
                        changeInitiatorsName = ((Object)a.iterator().next()).toString();
                    }
                    String attrName = a.getNameWithOptions();
                    builder.append(m.getModificationType().getLDIFName());
                    builder.append(": ");
                    builder.append(attrName);
                    builder.append('\n');
                    for (AttributeValue v : a) {
                        builder.append(attrName);
                        LDIFWriter.appendLDIFSeparatorAndValue(builder, v.getValue());
                        builder.append('\n');
                    }
                    builder.append("-\n");
                }
                ldifChanges = builder.toString();
            }
            catch (Exception e) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                ErrorLogger.logError(Message.raw(Category.SYNC, Severity.MILD_ERROR, "An exception was encountered while try to encode a replication modify message for entry \"" + modifyMsg.getDn() + "\" into an External Change Log entry: " + e.getMessage(), new Object[0]));
            }
            String changeType = modifyMsg instanceof ModifyDNMsg ? "modrdn" : "modify";
            clEntry = ECLSearchOperation.createChangelogEntry(eclmsg.getServiceId(), eclmsg.getCookie().toString(), DN.decode(modifyMsg.getDn()), modifyMsg.getChangeNumber(), ldifChanges, modifyMsg.getEntryUUID(), modifyMsg.getEclIncludes(), eclmsg.getDraftChangeNumber(), changeType, changeInitiatorsName);
            if (modifyMsg instanceof ModifyDNMsg) {
                ModifyDNMsg modDNMsg = (ModifyDNMsg)modifyMsg;
                Attribute a = Attributes.create("newrdn", modDNMsg.getNewRDN());
                clEntry.addAttribute(a, null);
                if (modDNMsg.getNewSuperior() != null) {
                    Attribute b = Attributes.create("newsuperior", modDNMsg.getNewSuperior());
                    clEntry.addAttribute(b, null);
                }
                Attribute c = Attributes.create("deleteoldrdn", String.valueOf(modDNMsg.deleteOldRdn()));
                clEntry.addAttribute(c, null);
            }
        } else if (msg instanceof DeleteMsg) {
            DeleteMsg delMsg = (DeleteMsg)msg;
            clEntry = ECLSearchOperation.createChangelogEntry(eclmsg.getServiceId(), eclmsg.getCookie().toString(), DN.decode(delMsg.getDn()), delMsg.getChangeNumber(), null, delMsg.getEntryUUID(), delMsg.getEclIncludes(), eclmsg.getDraftChangeNumber(), "delete", delMsg.getInitiatorsName());
        }
        return clEntry;
    }

    private Entry createRootEntry(boolean hasSubordinates) {
        LinkedHashMap<AttributeType, List<Attribute>> userAttrs = new LinkedHashMap<AttributeType, List<Attribute>>();
        LinkedHashMap<AttributeType, List<Attribute>> operationalAttrs = new LinkedHashMap<AttributeType, List<Attribute>>();
        AttributeType aType = DirectoryServer.getAttributeType("cn");
        if (aType == null) {
            aType = DirectoryServer.getDefaultAttributeType("cn");
        }
        Attribute a = Attributes.create("cn", "changelog");
        List<Attribute> attrList = Collections.singletonList(a);
        userAttrs.put(aType, attrList);
        aType = DirectoryServer.getAttributeType("subschemasubentry");
        if (aType == null) {
            aType = DirectoryServer.getDefaultAttributeType("subschemaSubentry");
        }
        a = Attributes.create("subschemaSubentry", "cn=schema");
        attrList = Collections.singletonList(a);
        if (aType.isOperational()) {
            operationalAttrs.put(aType, attrList);
        } else {
            userAttrs.put(aType, attrList);
        }
        aType = DirectoryServer.getAttributeType("hassubordinates");
        if (aType == null) {
            aType = DirectoryServer.getDefaultAttributeType("hasSubordinates");
        }
        a = Attributes.create("hasSubordinates", Boolean.toString(hasSubordinates));
        attrList = Collections.singletonList(a);
        if (aType.isOperational()) {
            operationalAttrs.put(aType, attrList);
        } else {
            userAttrs.put(aType, attrList);
        }
        aType = DirectoryServer.getAttributeType("entrydn");
        if (aType == null) {
            aType = DirectoryServer.getDefaultAttributeType("entryDN");
        }
        a = Attributes.create("entryDN", CHANGELOG_ROOT_DN.toNormalizedString());
        attrList = Collections.singletonList(a);
        if (aType.isOperational()) {
            operationalAttrs.put(aType, attrList);
        } else {
            userAttrs.put(aType, attrList);
        }
        Entry e = new Entry(CHANGELOG_ROOT_DN, CHANGELOG_ROOT_OBJECT_CLASSES, userAttrs, operationalAttrs);
        return e;
    }

    private static Entry createChangelogEntry(String serviceID, String cookie, DN targetDN, ChangeNumber changeNumber, String clearLDIFchanges, String targetUUID, List<RawAttribute> includedAttributes, int draftChangenumber, String changetype, String changeInitiatorsName) throws DirectoryException {
        String dnString = draftChangenumber == 0 ? "replicationCSN=" + changeNumber + "," + serviceID + "," + "cn=changelog" : "changeNumber=" + draftChangenumber + "," + "cn=changelog";
        LinkedHashMap<AttributeType, List<Attribute>> uAttrs = new LinkedHashMap<AttributeType, List<Attribute>>();
        LinkedHashMap<AttributeType, List<Attribute>> operationalAttrs = new LinkedHashMap<AttributeType, List<Attribute>>();
        AttributeType aType = DirectoryServer.getAttributeType("subschemasubentry");
        if (aType == null) {
            aType = DirectoryServer.getDefaultAttributeType("subschemasubentry");
        }
        Attribute a = Attributes.create(aType, "cn=schema");
        List<Attribute> attrList = Collections.singletonList(a);
        if (aType.isOperational()) {
            operationalAttrs.put(aType, attrList);
        } else {
            uAttrs.put(aType, attrList);
        }
        aType = DirectoryServer.getAttributeType("numsubordinates");
        if (aType == null) {
            aType = DirectoryServer.getDefaultAttributeType("numSubordinates");
        }
        a = Attributes.create(aType, "0");
        attrList = Collections.singletonList(a);
        if (aType.isOperational()) {
            operationalAttrs.put(aType, attrList);
        } else {
            uAttrs.put(aType, attrList);
        }
        aType = DirectoryServer.getAttributeType("hassubordinates");
        if (aType == null) {
            aType = DirectoryServer.getDefaultAttributeType("hasSubordinates");
        }
        a = Attributes.create(aType, "false");
        attrList = Collections.singletonList(a);
        if (aType.isOperational()) {
            operationalAttrs.put(aType, attrList);
        } else {
            uAttrs.put(aType, attrList);
        }
        aType = DirectoryServer.getAttributeType("entrydn");
        if (aType == null) {
            aType = DirectoryServer.getDefaultAttributeType("entryDN");
        }
        a = Attributes.create(aType, dnString);
        attrList = Collections.singletonList(a);
        if (aType.isOperational()) {
            operationalAttrs.put(aType, attrList);
        } else {
            uAttrs.put(aType, attrList);
        }
        aType = DirectoryServer.getAttributeType("changenumber");
        if (aType == null) {
            aType = DirectoryServer.getDefaultAttributeType("changeNumber");
        }
        a = Attributes.create(aType, String.valueOf(draftChangenumber));
        attrList = new ArrayList<Attribute>(1);
        attrList.add(a);
        if (aType.isOperational()) {
            operationalAttrs.put(aType, attrList);
        } else {
            uAttrs.put(aType, attrList);
        }
        aType = DirectoryServer.getAttributeType("changetime");
        if (aType == null) {
            aType = DirectoryServer.getDefaultAttributeType("changeTime");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        a = Attributes.create(aType, dateFormat.format(new Date(changeNumber.getTime())));
        attrList = new ArrayList<Attribute>(1);
        attrList.add(a);
        if (aType.isOperational()) {
            operationalAttrs.put(aType, attrList);
        } else {
            uAttrs.put(aType, attrList);
        }
        aType = DirectoryServer.getAttributeType("changetype");
        if (aType == null) {
            aType = DirectoryServer.getDefaultAttributeType("changeType");
        }
        a = Attributes.create(aType, changetype);
        attrList = new ArrayList<Attribute>(1);
        attrList.add(a);
        if (aType.isOperational()) {
            operationalAttrs.put(aType, attrList);
        } else {
            uAttrs.put(aType, attrList);
        }
        aType = DirectoryServer.getAttributeType("targetdn");
        if (aType == null) {
            aType = DirectoryServer.getDefaultAttributeType("targetDN");
        }
        a = Attributes.create(aType, targetDN.toNormalizedString());
        attrList = new ArrayList<Attribute>(1);
        attrList.add(a);
        if (aType.isOperational()) {
            operationalAttrs.put(aType, attrList);
        } else {
            uAttrs.put(aType, attrList);
        }
        aType = DirectoryServer.getAttributeType("replicationcsn");
        if (aType == null) {
            aType = DirectoryServer.getDefaultAttributeType("replicationCSN");
        }
        a = Attributes.create(aType, changeNumber.toString());
        attrList = new ArrayList<Attribute>(1);
        attrList.add(a);
        if (aType.isOperational()) {
            operationalAttrs.put(aType, attrList);
        } else {
            uAttrs.put(aType, attrList);
        }
        aType = DirectoryServer.getAttributeType("replicaidentifier");
        if (aType == null) {
            aType = DirectoryServer.getDefaultAttributeType("replicaIdentifier");
        }
        a = Attributes.create(aType, Integer.toString(changeNumber.getServerId()));
        attrList = new ArrayList<Attribute>(1);
        attrList.add(a);
        if (aType.isOperational()) {
            operationalAttrs.put(aType, attrList);
        } else {
            uAttrs.put(aType, attrList);
        }
        if (clearLDIFchanges != null) {
            aType = DirectoryServer.getAttributeType("changes");
            if (aType == null) {
                aType = DirectoryServer.getDefaultAttributeType("changes");
            }
            a = Attributes.create(aType, clearLDIFchanges);
            attrList = new ArrayList<Attribute>(1);
            attrList.add(a);
            if (aType.isOperational()) {
                operationalAttrs.put(aType, attrList);
            } else {
                uAttrs.put(aType, attrList);
            }
        }
        if (changeInitiatorsName != null) {
            aType = DirectoryServer.getAttributeType("changeinitiatorsname");
            if (aType == null) {
                aType = DirectoryServer.getDefaultAttributeType("changeInitiatorsName");
            }
            a = Attributes.create(aType, changeInitiatorsName);
            attrList = new ArrayList<Attribute>(1);
            attrList.add(a);
            if (aType.isOperational()) {
                operationalAttrs.put(aType, attrList);
            } else {
                uAttrs.put(aType, attrList);
            }
        }
        if (targetUUID != null) {
            aType = DirectoryServer.getAttributeType("targetentryuuid");
            if (aType == null) {
                aType = DirectoryServer.getDefaultAttributeType("targetEntryUUID");
            }
            a = Attributes.create(aType, targetUUID);
            attrList = new ArrayList<Attribute>(1);
            attrList.add(a);
            if (aType.isOperational()) {
                operationalAttrs.put(aType, attrList);
            } else {
                uAttrs.put(aType, attrList);
            }
        }
        if ((aType = DirectoryServer.getAttributeType("changelogcookie")) == null) {
            aType = DirectoryServer.getDefaultAttributeType("changeLogCookie");
        }
        a = Attributes.create(aType, cookie);
        attrList = new ArrayList<Attribute>(1);
        attrList.add(a);
        if (aType.isOperational()) {
            operationalAttrs.put(aType, attrList);
        } else {
            uAttrs.put(aType, attrList);
        }
        if (includedAttributes != null && !includedAttributes.isEmpty()) {
            StringBuilder builder = new StringBuilder(256);
            for (RawAttribute includedAttribute : includedAttributes) {
                String name = includedAttribute.getAttributeType();
                for (ByteString value : includedAttribute.getValues()) {
                    builder.append(name);
                    LDIFWriter.appendLDIFSeparatorAndValue(builder, value);
                    builder.append('\n');
                }
            }
            String includedAttributesLDIF = builder.toString();
            aType = DirectoryServer.getAttributeType("includedattributes");
            if (aType == null) {
                aType = DirectoryServer.getDefaultAttributeType("includedAttributes");
            }
            a = Attributes.create(aType, includedAttributesLDIF);
            attrList = new ArrayList<Attribute>(1);
            attrList.add(a);
            if (aType.isOperational()) {
                operationalAttrs.put(aType, attrList);
            } else {
                uAttrs.put(aType, attrList);
            }
        }
        Entry cle = new Entry(DN.decode(dnString), CHANGELOG_ENTRY_OBJECT_CLASSES, uAttrs, operationalAttrs);
        return cle;
    }

    @Override
    public CancelResult cancel(CancelRequest cancelRequest) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo(this + " cancel() " + this.eclSession);
        }
        if (this.eclSession != null) {
            try {
                this.eclSession.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.cancel(cancelRequest);
    }

    @Override
    public void abort(CancelRequest cancelRequest) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo(this + " abort() " + this.eclSession);
        }
        if (this.eclSession != null) {
            try {
                this.eclSession.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void evaluateSearchParameters(StartECLSessionMsg startCLmsg, DN baseDN, SearchFilter sf) throws DirectoryException {
        switch (baseDN.getNumComponents()) {
            case 1: {
                break;
            }
            case 2: {
                AttributeValue av;
                RDN rdn = baseDN.getRDN();
                AttributeType at = DirectoryServer.getAttributeType("changenumber");
                if (at == null) {
                    at = DirectoryServer.getDefaultAttributeType("changeNumber");
                }
                if ((av = rdn.getAttributeValue(at)) == null) break;
                sf = SearchFilter.createEqualityFilter(at, av);
                break;
            }
            default: {
                AttributeValue av;
                RDN rdn = baseDN.getRDN();
                AttributeType at = DirectoryServer.getAttributeType("replicationcsn");
                if (at == null) {
                    at = DirectoryServer.getDefaultAttributeType("replicationCSN");
                }
                if ((av = rdn.getAttributeValue(at)) == null) break;
                sf = SearchFilter.createEqualityFilter(at, av);
            }
        }
        StartECLSessionMsg msg = ECLSearchOperation.evaluateSearchParameters2(sf);
        startCLmsg.setFirstDraftChangeNumber(msg.getFirstDraftChangeNumber());
        startCLmsg.setLastDraftChangeNumber(msg.getLastDraftChangeNumber());
        startCLmsg.setChangeNumber(msg.getChangeNumber());
    }

    private static StartECLSessionMsg evaluateSearchParameters2(SearchFilter sf) throws DirectoryException {
        StartECLSessionMsg startCLmsg = new StartECLSessionMsg();
        startCLmsg.setFirstDraftChangeNumber(-1);
        startCLmsg.setLastDraftChangeNumber(-1);
        startCLmsg.setChangeNumber(new ChangeNumber(0L, 0, 0));
        if (sf == null) {
            return startCLmsg;
        }
        if (sf.getFilterType() == FilterType.GREATER_OR_EQUAL && sf.getAttributeType() != null && sf.getAttributeType().getPrimaryName().equalsIgnoreCase("changeNumber")) {
            int sn = Integer.decode(sf.getAssertionValue().getNormalizedValue().toString());
            startCLmsg.setFirstDraftChangeNumber(sn);
            return startCLmsg;
        }
        if (sf.getFilterType() == FilterType.LESS_OR_EQUAL && sf.getAttributeType() != null && sf.getAttributeType().getPrimaryName().equalsIgnoreCase("changeNumber")) {
            int sn = Integer.decode(sf.getAssertionValue().getNormalizedValue().toString());
            startCLmsg.setLastDraftChangeNumber(sn);
            return startCLmsg;
        }
        if (sf.getFilterType() == FilterType.EQUALITY && sf.getAttributeType() != null && sf.getAttributeType().getPrimaryName().equalsIgnoreCase("replicationcsn")) {
            ChangeNumber cn = new ChangeNumber(((Object)sf.getAssertionValue()).toString());
            startCLmsg.setChangeNumber(cn);
            return startCLmsg;
        }
        if (sf.getFilterType() == FilterType.EQUALITY && sf.getAttributeType() != null && sf.getAttributeType().getPrimaryName().equalsIgnoreCase("changenumber")) {
            int sn = Integer.decode(sf.getAssertionValue().getNormalizedValue().toString());
            startCLmsg.setFirstDraftChangeNumber(sn);
            startCLmsg.setLastDraftChangeNumber(sn);
            return startCLmsg;
        }
        if (sf.getFilterType() == FilterType.AND) {
            Set<SearchFilter> comps = sf.getFilterComponents();
            SearchFilter[] sfs = comps.toArray(new SearchFilter[0]);
            int l1 = -1;
            int f1 = -1;
            int l2 = -1;
            int f2 = -1;
            if (sfs.length > 0) {
                StartECLSessionMsg m1 = ECLSearchOperation.evaluateSearchParameters2(sfs[0]);
                l1 = m1.getLastDraftChangeNumber();
                f1 = m1.getFirstDraftChangeNumber();
            }
            if (sfs.length > 1) {
                StartECLSessionMsg m2 = ECLSearchOperation.evaluateSearchParameters2(sfs[1]);
                l2 = m2.getLastDraftChangeNumber();
                f2 = m2.getFirstDraftChangeNumber();
            }
            if (l1 == -1) {
                startCLmsg.setLastDraftChangeNumber(l2);
            } else if (l2 == -1) {
                startCLmsg.setLastDraftChangeNumber(l1);
            } else {
                startCLmsg.setLastDraftChangeNumber(Math.min(l1, l2));
            }
            startCLmsg.setFirstDraftChangeNumber(Math.max(f1, f2));
            return startCLmsg;
        }
        return startCLmsg;
    }

    static {
        CHANGELOG_SUPPORTED_CONTROLS.add("1.2.840.113556.1.4.473");
        CHANGELOG_SUPPORTED_CONTROLS.add("2.16.840.1.113730.3.4.9");
        CHANGELOG_ROOT_OBJECT_CLASSES = new LinkedHashMap<ObjectClass, String>(2);
        ObjectClass topOC = DirectoryServer.getObjectClass("top", true);
        CHANGELOG_ROOT_OBJECT_CLASSES.put(topOC, "top");
        ObjectClass containerOC = DirectoryServer.getObjectClass("container", true);
        CHANGELOG_ROOT_OBJECT_CLASSES.put(containerOC, "container");
        CHANGELOG_ENTRY_OBJECT_CLASSES = new LinkedHashMap<ObjectClass, String>(2);
        topOC = DirectoryServer.getObjectClass("top", true);
        CHANGELOG_ENTRY_OBJECT_CLASSES.put(topOC, "top");
        ObjectClass eclEntryOC = DirectoryServer.getObjectClass("changeLogEntry", true);
        CHANGELOG_ENTRY_OBJECT_CLASSES.put(eclEntryOC, "changeLogEntry");
        CREATORS_NAME_TYPE = DirectoryConfig.getAttributeType("creatorsname", true);
        MODIFIERS_NAME_TYPE = DirectoryConfig.getAttributeType("modifiersname", true);
        try {
            CHANGELOG_ROOT_DN = DN.decode("cn=changelog");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

