/*
 * Decompiled with CFR 0.152.
 */
package org.lsc;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.ArrayUtils;
import org.lsc.AbstractSynchronize;
import org.lsc.InfoCounter;
import org.lsc.LscDatasets;
import org.lsc.SynchronizeTask;
import org.lsc.Task;
import org.lsc.beans.IBean;
import org.lsc.configuration.LscConfiguration;
import org.lsc.configuration.TaskType;
import org.lsc.exception.LscConfigurationException;
import org.lsc.jmx.LscServerImpl;
import org.lsc.service.IAsynchronousService;
import org.lsc.utils.LSCStructuralLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSynchronize
extends AbstractSynchronize {
    public static final String ALL_TASKS_KEYWORD = "all";
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleSynchronize.class);
    public static final List<String> EMPTY_LIST = new ArrayList<String>();
    Map<String, Task> cache;

    public SimpleSynchronize() {
        this.setThreads(5);
        this.cache = new TreeMap<String, Task>();
    }

    public void init() throws LscConfigurationException {
        Collection<TaskType> tasks = LscConfiguration.getTasks();
        for (TaskType t : tasks) {
            this.cache.put(t.getName(), new Task(t));
        }
    }

    private void close() {
        for (Task task : this.cache.values()) {
            if (task.getSourceService() instanceof Closeable) {
                try {
                    ((Closeable)((Object)task.getSourceService())).close();
                }
                catch (IOException e) {
                    LOGGER.error("Error while closing service.");
                }
            }
            if (!(task.getDestinationService() instanceof Closeable)) continue;
            try {
                ((Closeable)((Object)task.getDestinationService())).close();
            }
            catch (IOException e) {
                LOGGER.error("Error while closing service.");
            }
        }
    }

    public final boolean launch(List<String> asyncTasks, List<String> syncTasks, List<String> cleanTasks) throws Exception {
        Boolean foundATask = false;
        boolean canClose = true;
        boolean launchResult = true;
        boolean isASyncTaskAll = asyncTasks.contains(ALL_TASKS_KEYWORD);
        boolean isSyncTaskAll = syncTasks.contains(ALL_TASKS_KEYWORD);
        boolean isCleanTaskAll = cleanTasks.contains(ALL_TASKS_KEYWORD);
        if (this.getTasksName() == null) {
            return false;
        }
        if (this.getTasks().length == 0) {
            this.init();
        }
        if (!asyncTasks.isEmpty()) {
            LscServerImpl.startJmx(this);
        }
        for (Task task : this.cache.values()) {
            if (isSyncTaskAll || syncTasks.contains(task.getName())) {
                foundATask = true;
                if (!this.launchTask(task, Task.Mode.sync)) {
                    launchResult = false;
                } else if (task.getSyncHook() != null && task.getSyncHook() != "") {
                    this.runPostHook(task.getName(), task.getSyncHook(), task.getTaskType());
                }
            }
            if (isCleanTaskAll || cleanTasks.contains(task.getName())) {
                foundATask = true;
                if (!this.launchTask(task, Task.Mode.clean)) {
                    launchResult = false;
                } else if (task.getCleanHook() != null && task.getCleanHook() != "") {
                    this.runPostHook(task.getName(), task.getCleanHook(), task.getTaskType());
                }
            }
            if (!isASyncTaskAll && !asyncTasks.contains(task.getName())) continue;
            foundATask = true;
            canClose = false;
            if (this.launchTask(task, Task.Mode.async)) continue;
            launchResult = false;
        }
        if (canClose) {
            this.close();
        }
        if (!foundATask.booleanValue()) {
            LOGGER.error("No specified tasks could be launched! Check spelling and that they exist in the configuration file.");
            return false;
        }
        return launchResult;
    }

    private boolean launchTask(Task task, Task.Mode taskMode) throws Exception {
        boolean status = true;
        this.addScriptingContext(task);
        try {
            LSCStructuralLogger.DESTINATION.info("Starting {} for {}", (Object)taskMode.name(), (Object)task.getName());
            switch (taskMode) {
                case clean: {
                    status = this.clean2Ldap(task);
                    break;
                }
                case sync: {
                    status = this.synchronize2Ldap(task);
                    break;
                }
                case async: {
                    if (task.getSourceService() instanceof IAsynchronousService || task.getDestinationService() instanceof IAsynchronousService) {
                        this.startAsynchronousSynchronize2Ldap(task);
                        break;
                    }
                    LOGGER.error("Requested asynchronous source service does not implement IAsynchronousService ! (" + task.getSourceService().getClass().getName() + ")");
                    break;
                }
                default: {
                    LOGGER.error("Unknown task mode type {}", (Object)taskMode.toString());
                    throw new InvalidParameterException("Unknown task mode type " + taskMode.toString());
                }
            }
        }
        catch (Exception e) {
            Object[] exceptionsCaught = new Class[]{InstantiationException.class, IllegalAccessException.class, ClassNotFoundException.class, SecurityException.class, NoSuchMethodException.class, IllegalArgumentException.class, InvocationTargetException.class};
            if (ArrayUtils.contains((Object[])exceptionsCaught, e.getClass())) {
                String errorDetail = e instanceof InvocationTargetException && e.getCause() != null ? e.getCause().toString() : e.toString();
                LOGGER.error("Error while launching task \"{}\". Please check your configuration! ({})", (Object)task.getName(), (Object)errorDetail);
                LOGGER.debug(e.toString(), (Throwable)e);
                return false;
            }
            throw e;
        }
        return status;
    }

    private void addScriptingContext(Task task) {
        task.addScriptingVar("nocreate", this.nocreate);
        task.addScriptingVar("noupdate", this.noupdate);
        task.addScriptingVar("nodelete", this.nodelete);
        task.addScriptingVar("nomodrdn", this.nomodrdn);
    }

    private void runPostHook(String taskName, String servicePostHook, TaskType taskType) {
        if (servicePostHook != null && servicePostHook.length() > 0) {
            LOGGER.debug("Service Post Hook found: " + servicePostHook);
            String hookClass = servicePostHook.substring(0, servicePostHook.lastIndexOf(46));
            String hookMethod = servicePostHook.substring(servicePostHook.lastIndexOf(46) + 1);
            LOGGER.debug("Hook Class: " + hookClass);
            LOGGER.debug("Hook Method: " + hookMethod);
            if (hookClass.length() > 0 && hookMethod.length() > 0) {
                try {
                    Class<?> clazz = Class.forName(hookClass);
                    try {
                        Method hook = clazz.getMethod(hookMethod, TaskType.class);
                        hook.invoke(null, taskType);
                    }
                    catch (NoSuchMethodException e) {
                        Method hook = clazz.getMethod(hookMethod, new Class[0]);
                        hook.invoke(null, new Object[0]);
                    }
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error("Invalid Hook Class specified " + hookClass + " for task " + taskName);
                    LOGGER.debug(e.toString(), (Throwable)e);
                }
                catch (NoSuchMethodException e) {
                    LOGGER.error("Invalid hook method " + hookMethod + " specified for task " + taskName);
                    LOGGER.debug(e.toString(), (Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error("Invalid argument exception for hook method " + hookClass + "." + hookMethod);
                    LOGGER.debug(e.toString(), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    LOGGER.error("Illegal access exception for hook method " + hookClass + "." + hookMethod);
                    LOGGER.debug(e.toString(), (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    LOGGER.error("Invocation target exception for hook method " + hookClass + "." + hookMethod);
                    LOGGER.debug(e.toString(), (Throwable)e);
                }
            }
        }
    }

    public Set<Map.Entry<String, Task>> getTasksName() {
        return this.cache.entrySet();
    }

    @Override
    public boolean isAsynchronousTask(String taskName) {
        return this.cache.get(taskName).getSourceService() instanceof IAsynchronousService;
    }

    @Override
    public Task getTask(String taskName) {
        return this.cache.get(taskName);
    }

    @Override
    public Task[] getTasks() {
        return this.cache.values().toArray(new Task[this.cache.values().size()]);
    }

    public final boolean launchById(String taskName, Map<String, LscDatasets> entries) {
        Task task = this.cache.get(taskName);
        InfoCounter counter = new InfoCounter();
        for (Map.Entry<String, LscDatasets> entry : entries.entrySet()) {
            new SynchronizeTask(task, counter, this, entry, true).run();
        }
        return counter.getCountError() == 0;
    }

    public final boolean launch(String taskName, IBean bean) {
        Task task = this.cache.get(taskName);
        InfoCounter counter = new InfoCounter();
        return new SynchronizeTask(task, counter, this, null, true).run(bean);
    }
}

