/*
 * Decompiled with CFR 0.152.
 */
package org.lsc;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.lsc.AbstractSynchronize;
import org.lsc.InfoCounter;
import org.lsc.LscDatasets;
import org.lsc.LscModificationType;
import org.lsc.LscModifications;
import org.lsc.Task;
import org.lsc.beans.BeanComparator;
import org.lsc.beans.IBean;
import org.lsc.exception.LscServiceCommunicationException;
import org.lsc.utils.ScriptingEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SynchronizeTask
implements Runnable {
    static final Logger LOGGER = LoggerFactory.getLogger(SynchronizeTask.class);
    private String syncName;
    private InfoCounter counter;
    private AbstractSynchronize abstractSynchronize;
    private Map.Entry<String, LscDatasets> id;
    private Task task;
    private boolean fromSource;

    public SynchronizeTask(Task task, InfoCounter counter, AbstractSynchronize abstractSynchronize, Map.Entry<String, LscDatasets> id, boolean fromSource) {
        this.syncName = task.getName();
        this.counter = counter;
        this.task = task;
        this.abstractSynchronize = abstractSynchronize;
        this.id = id;
        this.fromSource = fromSource;
    }

    @Override
    public void run() {
        this.counter.incrementCountAll();
        try {
            this.run((this.fromSource ? this.task.getSourceService() : this.task.getDestinationService()).getBean(this.id.getKey(), this.id.getValue(), this.fromSource));
        }
        catch (RuntimeException e) {
            this.counter.incrementCountError();
            this.abstractSynchronize.logActionError(null, this.id.getValue(), e);
            if (e.getCause() instanceof LscServiceCommunicationException) {
                AbstractSynchronize.LOGGER.error("Connection lost! Aborting.");
            }
        }
        catch (Exception e) {
            this.counter.incrementCountError();
            this.abstractSynchronize.logActionError(null, this.id.getValue(), e);
        }
    }

    public boolean run(IBean entry) {
        LscModifications lm = null;
        IBean dstBean = null;
        HashMap<String, Object> conditionObjects = null;
        try {
            if (entry == null) {
                this.counter.incrementCountError();
                AbstractSynchronize.LOGGER.error("Synchronization aborted because no source object has been found !");
                return false;
            }
            if (this.id != null) {
                dstBean = this.task.getDestinationService().getBean(this.id.getKey(), this.id.getValue(), true);
            } else {
                LscDatasets entryDatasets = new LscDatasets();
                for (String datasetName : entry.datasets().getAttributesNames()) {
                    entryDatasets.getDatasets().put(datasetName, entry.getDatasetById(datasetName));
                }
                dstBean = this.task.getDestinationService().getBean(entry.getMainIdentifier(), entryDatasets, true);
            }
            LscModificationType modificationType = BeanComparator.calculateModificationType(this.task, entry, dstBean);
            Boolean applyCondition = null;
            String conditionString = this.task.getSyncOptions().getCondition(modificationType);
            if (conditionString.matches("true")) {
                applyCondition = true;
            } else if (conditionString.matches("false")) {
                applyCondition = false;
            } else {
                conditionObjects = new HashMap<String, Object>();
                conditionObjects.put("dstBean", dstBean);
                conditionObjects.put("srcBean", entry);
                conditionObjects.putAll(this.task.getScriptingVars());
                applyCondition = ScriptingEvaluator.evalToBoolean(this.task, conditionString, conditionObjects);
            }
            if (applyCondition.booleanValue()) {
                lm = BeanComparator.calculateModifications(this.task, entry, dstBean);
                if (lm == null) {
                    return true;
                }
                this.counter.incrementCountModifiable();
                if (modificationType == LscModificationType.CREATE_OBJECT && this.abstractSynchronize.nocreate || modificationType == LscModificationType.UPDATE_OBJECT && this.abstractSynchronize.noupdate || modificationType == LscModificationType.CHANGE_ID && (this.abstractSynchronize.nomodrdn || this.abstractSynchronize.noupdate)) {
                    this.abstractSynchronize.logShouldAction(lm, this.syncName);
                    return true;
                }
            } else {
                return true;
            }
            if (this.task.getDestinationService().apply(lm)) {
                this.counter.incrementCountCompleted();
                this.abstractSynchronize.logAction(lm, this.id, this.syncName);
                return true;
            }
            this.counter.incrementCountError();
            this.abstractSynchronize.logActionError(lm, this.id != null ? (Serializable)this.id.getValue() : entry.getMainIdentifier(), new Exception("Technical problem while applying modifications to the destination"));
            return false;
        }
        catch (RuntimeException e) {
            this.counter.incrementCountError();
            this.abstractSynchronize.logActionError(lm, this.id != null ? (Serializable)this.id.getValue() : (entry != null ? entry.getMainIdentifier() : e.toString()), e);
            if (e.getCause() instanceof LscServiceCommunicationException) {
                AbstractSynchronize.LOGGER.error("Connection lost! Aborting.");
            }
            return false;
        }
        catch (Exception e) {
            this.counter.incrementCountError();
            this.abstractSynchronize.logActionError(lm, this.id != null ? (Serializable)this.id.getValue() : entry.getMainIdentifier(), e);
            return false;
        }
    }

    public String getSyncName() {
        return this.syncName;
    }

    public InfoCounter getCounter() {
        return this.counter;
    }

    public AbstractSynchronize getAbstractSynchronize() {
        return this.abstractSynchronize;
    }

    public Map.Entry<String, LscDatasets> getId() {
        return this.id;
    }
}

