/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.beans.syncoptions;

import java.util.HashMap;
import java.util.Map;
import org.lsc.beans.syncoptions.ISyncOptions;
import org.lsc.configuration.LscConfiguration;
import org.lsc.configuration.TaskType;
import org.lsc.exception.LscConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SyncOptionsFactory {
    private static SyncOptionsFactory INSTANCE = new SyncOptionsFactory();
    private Map<String, ISyncOptions> cache = new HashMap<String, ISyncOptions>();
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncOptionsFactory.class);

    private SyncOptionsFactory() {
    }

    private void convertFromTask(TaskType task) throws LscConfigurationException {
        try {
            ISyncOptions iso = (ISyncOptions)LscConfiguration.getSyncOptionsImplementation(LscConfiguration.getSyncOptions(task)).newInstance();
            iso.initialize(task);
            this.cache.put(task.getName(), iso);
        }
        catch (InstantiationException e) {
            LOGGER.error("Internal error while instanciating '{}' name. Choose another implementation or fix it !", (Object)LscConfiguration.getSyncOptionsImplementation(LscConfiguration.getSyncOptions(task)).getClass().getName());
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Internal error while instanciating '{}' name. Choose another implementation or fix it !", (Object)LscConfiguration.getSyncOptionsImplementation(LscConfiguration.getSyncOptions(task)).getClass().getName());
        }
    }

    public static ISyncOptions convert(TaskType task) throws LscConfigurationException {
        return INSTANCE.get(task);
    }

    private ISyncOptions get(TaskType task) throws LscConfigurationException {
        if (!this.cache.containsKey(task.getName())) {
            this.convertFromTask(task);
        }
        return this.cache.get(task.getName());
    }
}

