/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.configuration;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.io.FileUtils;
import org.lsc.configuration.Lsc;
import org.lsc.exception.LscConfigurationException;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class JaxbXmlConfigurationHelper {
    public static final String LSC_CONF_XML = "lsc.xml";
    public static final String LSC_NAMESPACE = "http://lsc-project.org/XSD/lsc-core-2.0.xsd";
    private JAXBContext jaxbc;
    private static final Logger LOGGER = LoggerFactory.getLogger(JaxbXmlConfigurationHelper.class);

    public JaxbXmlConfigurationHelper() throws LscConfigurationException {
        String packagesName = Lsc.class.getPackage().getName();
        String pluginsPackagePath = System.getProperty("LSC.PLUGINS.PACKAGEPATH");
        if (pluginsPackagePath != null) {
            packagesName = packagesName + ":" + pluginsPackagePath;
        }
        try {
            this.jaxbc = JAXBContext.newInstance((String)packagesName);
        }
        catch (JAXBException e) {
            throw new LscConfigurationException(e);
        }
    }

    public Lsc getConfiguration(String filename) throws LscConfigurationException {
        LOGGER.debug("Loading XML configuration from: " + filename);
        try {
            Unmarshaller unmarshaller = this.jaxbc.createUnmarshaller();
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema lscSchema = null;
            try {
                int i = 0;
                HashSet urls = new HashSet();
                urls.addAll(ClasspathHelper.forPackage((String)"org.lsc", (ClassLoader[])new ClassLoader[0]));
                if (System.getProperty("LSC.PLUGINS.PACKAGEPATH") != null) {
                    String[] pathElements;
                    for (String pathElement : pathElements = System.getProperty("LSC.PLUGINS.PACKAGEPATH").split(System.getProperty("path.separator"))) {
                        urls.addAll(ClasspathHelper.forPackage((String)pathElement, (ClassLoader[])new ClassLoader[0]));
                    }
                }
                Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().addUrls(urls).setScanners(new Scanner[]{new ResourcesScanner(), new SubTypesScanner()}));
                Set xsdFiles = reflections.getResources(Pattern.compile(".*\\.xsd"));
                Source[] schemasSource = new Source[xsdFiles.size()];
                ArrayList xsdFilesList = new ArrayList(xsdFiles);
                Collections.reverse(xsdFilesList);
                for (String schemaFile : xsdFilesList) {
                    LOGGER.debug("Importing XML schema file: " + schemaFile);
                    InputStream schemaStream = this.getClass().getClassLoader().getResourceAsStream(schemaFile);
                    schemasSource[i++] = new StreamSource(schemaStream);
                }
                lscSchema = schemaFactory.newSchema(schemasSource);
                unmarshaller.setSchema(lscSchema);
            }
            catch (VerifyError e) {
                throw new LscConfigurationException(e.toString(), e);
            }
            catch (SAXException e) {
                throw new LscConfigurationException((Throwable)e);
            }
            return (Lsc)unmarshaller.unmarshal(new File(filename));
        }
        catch (JAXBException e) {
            throw new LscConfigurationException(e);
        }
    }

    public void saveConfiguration(String filename, Lsc lscConf) throws IOException {
        File existing = new File(filename);
        if (existing.exists()) {
            File backup = new File(existing + ".bak");
            if (backup.exists()) {
                backup.delete();
            }
            FileUtils.copyFile((File)existing, (File)backup);
        }
        try {
            Marshaller marshaller = this.jaxbc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)lscConf, new File(filename));
        }
        catch (JAXBException e) {
            LOGGER.error("Cannot save configuration file: " + e.toString(), (Throwable)e);
        }
    }
}

