/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.lsc.Configuration;
import org.lsc.beans.syncoptions.ForceSyncOptions;
import org.lsc.beans.syncoptions.PropertiesBasedSyncOptions;
import org.lsc.configuration.AsyncLdapSourceServiceType;
import org.lsc.configuration.AuditType;
import org.lsc.configuration.ConnectionType;
import org.lsc.configuration.DatabaseDestinationServiceType;
import org.lsc.configuration.DatabaseSourceServiceType;
import org.lsc.configuration.DatasetType;
import org.lsc.configuration.EncryptionType;
import org.lsc.configuration.ForceSyncOptionsType;
import org.lsc.configuration.GoogleAppsServiceType;
import org.lsc.configuration.LdapDestinationServiceType;
import org.lsc.configuration.LdapSourceServiceType;
import org.lsc.configuration.Lsc;
import org.lsc.configuration.MultiDestinationServiceType;
import org.lsc.configuration.PluginDestinationServiceType;
import org.lsc.configuration.PluginSourceServiceType;
import org.lsc.configuration.PluginSyncOptionsType;
import org.lsc.configuration.PolicyType;
import org.lsc.configuration.PropertiesBasedSyncOptionsType;
import org.lsc.configuration.SecurityType;
import org.lsc.configuration.ServiceType;
import org.lsc.configuration.SyncOptionsType;
import org.lsc.configuration.TaskType;
import org.lsc.configuration.XaFileDestinationServiceType;
import org.lsc.exception.LscConfigurationException;
import org.lsc.exception.LscException;
import org.lsc.jndi.PullableJndiSrcService;
import org.lsc.jndi.SimpleJndiDstService;
import org.lsc.service.GoogleAppsService;
import org.lsc.service.MultipleDstService;
import org.lsc.service.SimpleJdbcDstService;
import org.lsc.service.SimpleJdbcSrcService;
import org.lsc.service.SyncReplSourceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LscConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(LscConfiguration.class);
    private ArrayList<ConnectionType> connections = new ArrayList();
    private ArrayList<AuditType> audits = new ArrayList();
    private ArrayList<TaskType> tasks = new ArrayList();
    private boolean underInitialization = true;
    private boolean modified = false;
    private static LscConfiguration instance = null;
    private static LscConfiguration original;
    private Lsc lscObject;
    private int revision = 0;
    private SecurityType security;

    public static void loadFromInstance(Lsc lscInstance) {
        if (instance == null) {
            instance = new LscConfiguration();
        } else {
            original = instance;
        }
        LscConfiguration.instance.lscObject = new Lsc();
        LscConfiguration.instance.lscObject.setAudits(lscInstance.getAudits());
        LscConfiguration.instance.lscObject.setConnections(lscInstance.getConnections());
        LscConfiguration.instance.lscObject.setId(lscInstance.getId());
        LscConfiguration.instance.lscObject.setRevision(lscInstance.getRevision());
        LscConfiguration.instance.lscObject.setSecurity(lscInstance.getSecurity());
        LscConfiguration.instance.lscObject.setTasks(lscInstance.getTasks());
        LscConfiguration.finalizeInitialization();
    }

    public static LscConfiguration getInstance() {
        if (instance == null) {
            Configuration.setUp();
        }
        return instance;
    }

    private LscConfiguration() {
    }

    public static Collection<AuditType> getAudits() {
        return Collections.unmodifiableCollection(LscConfiguration.getInstance().getLsc().getAudits().getCsvAuditOrLdifAuditOrPluginAudit());
    }

    public static AuditType getAudit(String name) {
        if (LscConfiguration.getInstance().getLsc().getAudits() != null) {
            for (AuditType audit : LscConfiguration.getInstance().getLsc().getAudits().getCsvAuditOrLdifAuditOrPluginAudit()) {
                if (!audit.getName().equalsIgnoreCase(name)) continue;
                return audit;
            }
        }
        return null;
    }

    public static Collection<ConnectionType> getConnections() {
        ArrayList<ConnectionType> connectionsList = new ArrayList<ConnectionType>();
        if (LscConfiguration.getInstance().getLsc().getConnections() != null) {
            connectionsList.addAll(LscConfiguration.getInstance().getLsc().getConnections().getLdapConnectionOrDatabaseConnectionOrGoogleAppsConnection());
        }
        return Collections.unmodifiableCollection(connectionsList);
    }

    public static ConnectionType getConnection(String name) {
        for (ConnectionType connection : LscConfiguration.getConnections()) {
            if (!connection.getName().equalsIgnoreCase(name)) continue;
            return connection;
        }
        return null;
    }

    public static TaskType getTask(String name) {
        for (TaskType task : LscConfiguration.getInstance().getLsc().getTasks().getTask()) {
            if (!task.getName().equalsIgnoreCase(name)) continue;
            return task;
        }
        return null;
    }

    public static Collection<TaskType> getTasks() {
        return Collections.unmodifiableCollection(LscConfiguration.getInstance().getLsc().getTasks().getTask());
    }

    public static void addTask(TaskType task) {
        LscConfiguration.logModification(task);
        LscConfiguration.getInstance().getLsc().getTasks().getTask().add(task);
    }

    public static void removeTask(TaskType task) {
        LscConfiguration.logModification(task);
        LscConfiguration.getInstance().getLsc().getTasks().getTask().remove(task);
    }

    public static void addConnection(ConnectionType connection) {
        LscConfiguration.logModification(connection);
        LscConfiguration.getInstance().getLsc().getConnections().getLdapConnectionOrDatabaseConnectionOrGoogleAppsConnection().add(connection);
    }

    public static void removeConnection(ConnectionType connection) {
        LscConfiguration.logModification(connection);
        LscConfiguration.getInstance().getLsc().getConnections().getLdapConnectionOrDatabaseConnectionOrGoogleAppsConnection().remove(connection);
    }

    public static void addAudit(AuditType audit) {
        LscConfiguration.logModification(audit);
        LscConfiguration.getInstance().getLsc().getAudits().getCsvAuditOrLdifAuditOrPluginAudit().add(audit);
    }

    public static void removeAudit(AuditType audit) {
        LscConfiguration.logModification(audit);
        LscConfiguration.getInstance().getLsc().getAudits().getCsvAuditOrLdifAuditOrPluginAudit().remove(audit);
    }

    public static void finalizeInitialization() {
        original = instance.clone();
        LscConfiguration.getInstance().underInitialization = false;
    }

    public LscConfiguration clone() {
        LscConfiguration clone = new LscConfiguration();
        clone.revision = this.revision;
        if (this.audits != null) {
            clone.audits = (ArrayList)this.audits.clone();
        }
        if (this.connections != null) {
            clone.connections = (ArrayList)this.connections.clone();
        }
        if (this.tasks != null) {
            clone.tasks = (ArrayList)this.tasks.clone();
        }
        if (this.security != null) {
            clone.security = new SecurityType();
            clone.security.setId(this.security.getId());
            clone.security.setEncryption(new EncryptionType());
            clone.security.getEncryption().setAlgorithm(this.security.getEncryption().getAlgorithm());
            clone.security.getEncryption().setId(this.security.getEncryption().getId());
            clone.security.getEncryption().setKeyfile(this.security.getEncryption().getKeyfile());
            clone.security.getEncryption().setStrength(this.security.getEncryption().getStrength());
        }
        return clone;
    }

    public static void saving() {
        LscConfiguration.getInstance().getLsc().setRevision(LscConfiguration.getInstance().getLsc().getRevision() + 1);
    }

    public static void saved() {
        LscConfiguration.finalizeInitialization();
        LscConfiguration.getInstance().modified = false;
    }

    public static void logModification(Object o) {
        if (!LscConfiguration.getInstance().underInitialization) {
            LscConfiguration.getInstance().modified = true;
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    public static void revertToInitialState() {
        LscConfiguration.instance.audits = LscConfiguration.original.audits;
        LscConfiguration.instance.connections = LscConfiguration.original.connections;
        LscConfiguration.instance.tasks = LscConfiguration.original.tasks;
        LscConfiguration.instance.security = LscConfiguration.original.security;
        LscConfiguration.instance.audits = LscConfiguration.original.audits;
        LscConfiguration.instance.revision = LscConfiguration.original.revision;
        LscConfiguration.instance.modified = false;
    }

    public static boolean isInitialized() {
        return instance != null && !LscConfiguration.instance.underInitialization && LscConfiguration.instance.lscObject != null;
    }

    public void setConnections(List<ConnectionType> conns) {
        LscConfiguration.getInstance().getLsc().getConnections().getLdapConnectionOrDatabaseConnectionOrGoogleAppsConnection().clear();
        for (ConnectionType conn : conns) {
            LscConfiguration.logModification(conn);
            LscConfiguration.getInstance().getLsc().getConnections().getLdapConnectionOrDatabaseConnectionOrGoogleAppsConnection().add(conn);
        }
    }

    public int getRevision() {
        return this.getLsc().getRevision() != null ? this.getLsc().getRevision() : -1;
    }

    public static SecurityType getSecurity() {
        return LscConfiguration.getInstance().getLsc().getSecurity();
    }

    public void setSecurity(SecurityType sec) {
        this.getLsc().setSecurity(sec);
    }

    public void validate() throws LscException {
        for (TaskType task : LscConfiguration.getTasks()) {
            LscConfiguration.validate(task);
        }
        if (this.security != null) {
            LscConfiguration.validate(this.security);
        }
    }

    private static void validate(SecurityType security2) {
    }

    private static void validate(TaskType task) {
    }

    public Lsc getLsc() {
        return this.lscObject;
    }

    public static SyncOptionsType getSyncOptions(TaskType task) {
        if (task.getPropertiesBasedSyncOptions() != null) {
            return task.getPropertiesBasedSyncOptions();
        }
        if (task.getForceSyncOptions() != null) {
            return task.getForceSyncOptions();
        }
        if (task.getPluginSyncOptions() != null) {
            return task.getPluginSyncOptions();
        }
        return null;
    }

    public static DatasetType getDataset(PropertiesBasedSyncOptionsType conf, String attributeName) {
        if (conf != null && conf.getDataset() != null) {
            for (DatasetType dataset : conf.getDataset()) {
                if (!dataset.getName().equalsIgnoreCase(attributeName)) continue;
                return dataset;
            }
        }
        DatasetType attr = new DatasetType();
        attr.setName(attributeName);
        attr.setPolicy(conf.getDefaultPolicy());
        return attr;
    }

    public static ServiceType getDestinationService(TaskType t) {
        if (t.getLdapDestinationService() != null) {
            return t.getLdapDestinationService();
        }
        if (t.getDatabaseDestinationService() != null) {
            return t.getDatabaseDestinationService();
        }
        if (t.getGoogleAppsDestinationService() != null) {
            return t.getGoogleAppsDestinationService();
        }
        if (t.getMultiDestinationService() != null) {
            return t.getMultiDestinationService();
        }
        if (t.getPluginDestinationService() != null) {
            return t.getPluginDestinationService();
        }
        return null;
    }

    public static ServiceType getSourceService(TaskType t) {
        if (t.getAsyncLdapSourceService() != null) {
            return t.getAsyncLdapSourceService();
        }
        if (t.getLdapSourceService() != null) {
            return t.getLdapSourceService();
        }
        if (t.getGoogleAppsSourceService() != null) {
            return t.getGoogleAppsSourceService();
        }
        if (t.getDatabaseSourceService() != null) {
            return t.getDatabaseSourceService();
        }
        if (t.getPluginSourceService() != null) {
            return t.getPluginSourceService();
        }
        return null;
    }

    public static void setSourceService(TaskType t, ServiceType s) throws LscConfigurationException {
        if (s instanceof DatabaseSourceServiceType) {
            t.setDatabaseSourceService((DatabaseSourceServiceType)s);
        } else if (s instanceof LdapSourceServiceType) {
            t.setLdapSourceService((LdapSourceServiceType)s);
        } else if (s instanceof GoogleAppsServiceType) {
            t.setGoogleAppsSourceService((GoogleAppsServiceType)s);
        } else if (s instanceof PluginSourceServiceType) {
            t.setPluginSourceService((PluginSourceServiceType)s);
        } else {
            throw new LscConfigurationException("Unable to map source service type to a known type: " + s.getClass().getName());
        }
    }

    public static void setDestinationService(TaskType t, ServiceType s) throws LscConfigurationException {
        if (s instanceof DatabaseDestinationServiceType) {
            t.setDatabaseDestinationService((DatabaseDestinationServiceType)s);
        } else if (s instanceof XaFileDestinationServiceType) {
            t.setXaFileDestinationService((XaFileDestinationServiceType)s);
        } else if (s instanceof MultiDestinationServiceType) {
            t.setMultiDestinationService((MultiDestinationServiceType)s);
        } else if (s instanceof LdapDestinationServiceType) {
            t.setLdapDestinationService((LdapDestinationServiceType)s);
        } else if (s instanceof GoogleAppsServiceType) {
            t.setGoogleAppsDestinationService((GoogleAppsServiceType)s);
        } else if (s instanceof PluginDestinationServiceType) {
            t.setPluginDestinationService((PluginDestinationServiceType)s);
        } else {
            throw new LscConfigurationException("Unable to map destination service type to a known type: " + s.getClass().getName());
        }
    }

    public static Class<?> getServiceImplementation(ServiceType service) {
        if (service instanceof LdapDestinationServiceType) {
            return SimpleJndiDstService.class;
        }
        if (service instanceof AsyncLdapSourceServiceType) {
            return SyncReplSourceService.class;
        }
        if (service instanceof LdapSourceServiceType) {
            return PullableJndiSrcService.class;
        }
        if (service instanceof DatabaseDestinationServiceType) {
            return SimpleJdbcDstService.class;
        }
        if (service instanceof DatabaseSourceServiceType) {
            return SimpleJdbcSrcService.class;
        }
        if (service instanceof MultiDestinationServiceType) {
            return MultipleDstService.class;
        }
        if (service instanceof GoogleAppsServiceType) {
            return GoogleAppsService.class;
        }
        if (service instanceof PluginDestinationServiceType) {
            try {
                return Class.forName(((PluginDestinationServiceType)service).getImplementationClass());
            }
            catch (ClassNotFoundException e) {
                throw new UnsupportedOperationException("Unknown plugin implementation: " + ((PluginDestinationServiceType)service).getImplementationClass());
            }
        }
        if (service instanceof PluginSourceServiceType) {
            try {
                return Class.forName(((PluginSourceServiceType)service).getImplementationClass());
            }
            catch (ClassNotFoundException e) {
                throw new UnsupportedOperationException("Unknown plugin implementation: " + ((PluginSourceServiceType)service).getImplementationClass());
            }
        }
        throw new UnsupportedOperationException("Unknown service type: " + service.getClass().getName());
    }

    public static Class<?> getSyncOptionsImplementation(SyncOptionsType syncOptions) {
        if (syncOptions instanceof PropertiesBasedSyncOptionsType) {
            return PropertiesBasedSyncOptions.class;
        }
        if (syncOptions instanceof ForceSyncOptionsType) {
            return ForceSyncOptions.class;
        }
        if (syncOptions instanceof PluginSyncOptionsType) {
            try {
                return Class.forName(((PluginSyncOptionsType)syncOptions).getImplementationClass());
            }
            catch (ClassNotFoundException e) {
                throw new UnsupportedOperationException("Unknown plugin implementation: " + ((PluginSyncOptionsType)syncOptions).getImplementationClass());
            }
        }
        throw new UnsupportedOperationException("Unknown syncoptions type: " + syncOptions.getClass().getName());
    }

    public static void loadSyncOptions(TaskType newTask, String taskName, Properties props) throws LscConfigurationException {
        SyncOptionsType sot = LscConfiguration.getSyncOptions(newTask);
        if (sot instanceof ForceSyncOptionsType) {
            return;
        }
        if (!(sot instanceof PropertiesBasedSyncOptionsType)) {
            throw new LscConfigurationException("Conversion from old properties configuration file format is not supported for this type of SyncOptions: " + sot.getClass().getName());
        }
        PropertiesBasedSyncOptionsType pbsot = (PropertiesBasedSyncOptionsType)sot;
        Enumeration<Object> en = props.keys();
        HashMap<String, String> defaultValueStrings = new HashMap<String, String>();
        HashMap<String, String> createValueStrings = new HashMap<String, String>();
        HashMap<String, String> forceValueStrings = new HashMap<String, String>();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (key.equals("")) continue;
            String value = props.getProperty(key);
            StringTokenizer stok = new StringTokenizer(key, ".");
            if (stok.countTokens() != 2) {
                LOGGER.error("Unable to use invalid name : lsc.{}.{} ! Bypassing ...", (Object)taskName, (Object)key);
                continue;
            }
            String datasetName = stok.nextToken();
            String typeName = stok.nextToken();
            DatasetType dataset = LscConfiguration.getDataset(pbsot, datasetName);
            if (typeName.equalsIgnoreCase("action")) {
                PolicyType policy = LscConfiguration.parseSyncType(value);
                LOGGER.debug("Adding '{}' sync type for dataset name {}.", (Object)value, (Object)datasetName);
                if (datasetName.equalsIgnoreCase("default")) {
                    pbsot.setDefaultPolicy(policy);
                    continue;
                }
                dataset.setPolicy(policy);
                continue;
            }
            if (typeName.equalsIgnoreCase("default_value")) {
                defaultValueStrings.put(datasetName.toLowerCase(), value);
                continue;
            }
            if (typeName.equalsIgnoreCase("create_value")) {
                createValueStrings.put(datasetName.toLowerCase(), value);
                continue;
            }
            if (typeName.equalsIgnoreCase("force_value")) {
                forceValueStrings.put(datasetName.toLowerCase(), value);
                continue;
            }
            if (typeName.equalsIgnoreCase("delimiter")) {
                if (value.length() > 1) {
                    LOGGER.error("Invalid delimiter for {} dataset. Delimiters must be 1 character maximum. Ignoring.", (Object)datasetName);
                    continue;
                }
                if (datasetName.equalsIgnoreCase("default")) {
                    pbsot.setDefaultDelimiter(value);
                    continue;
                }
                dataset.setDelimiter(value);
                continue;
            }
            LOGGER.error("Unable to identify dataset option \"{}\" in this name : lsc.{}.{} ! Bypassing.", new Object[]{typeName, taskName, key});
        }
    }

    private static PolicyType parseSyncType(String value) throws LscConfigurationException {
        if (value.equalsIgnoreCase("K")) {
            return PolicyType.KEEP;
        }
        if (value.equalsIgnoreCase("F")) {
            return PolicyType.FORCE;
        }
        if (value.equalsIgnoreCase("M")) {
            return PolicyType.MERGE;
        }
        throw new LscConfigurationException("Unknown synchronization policy in old properties format: " + value);
    }

    public static void reset() {
        instance = null;
        original = null;
    }

    public static void setSyncOptions(TaskType task, SyncOptionsType syncOptions) throws LscConfigurationException {
        if (syncOptions instanceof ForceSyncOptionsType) {
            task.setForceSyncOptions((ForceSyncOptionsType)syncOptions);
        } else if (syncOptions instanceof PropertiesBasedSyncOptionsType) {
            task.setPropertiesBasedSyncOptions((PropertiesBasedSyncOptionsType)syncOptions);
        } else if (syncOptions instanceof PluginSyncOptionsType) {
            task.setPluginSyncOptions((PluginSyncOptionsType)syncOptions);
        } else {
            throw new LscConfigurationException("Unknown or null syncoptions type: " + syncOptions.getClass().getName());
        }
    }
}

