/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.connectors.xmlrpc;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.lsc.connectors.xmlrpc.AbstractLscXmlRpcObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLscXmlRpcClient
extends AbstractLscXmlRpcObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractLscXmlRpcClient.class);
    private URL url;
    private String username;
    private String password;
    protected XmlRpcClient client;
    protected Options options = new Options();
    protected CommandLine cmdLine;

    public AbstractLscXmlRpcClient() {
        this.options.addOption("h", "hosturl", true, "Specify the XML RPC server URL");
        this.options.addOption("u", "username", true, "Specify the username");
        this.options.addOption("p", "password", true, "Specify the password");
        this.client = new XmlRpcClient();
    }

    public abstract void run() throws XmlRpcException;

    public boolean bind() {
        XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
        config.setServerURL(this.url);
        if (this.username != null && this.password != null) {
            config.setBasicUserName(this.username);
            config.setBasicPassword(this.password);
        }
        config.setEnabledForExtensions(false);
        config.setGzipCompressing(false);
        this.client.setConfig((XmlRpcClientConfig)config);
        return true;
    }

    protected int parseOptions(String[] args) throws MalformedURLException {
        GnuParser parser = new GnuParser();
        try {
            this.cmdLine = parser.parse(this.options, args);
            if (this.cmdLine.hasOption("h")) {
                this.url = new URL(this.cmdLine.getOptionValue("h"));
            }
            if (this.cmdLine.hasOption("u")) {
                this.username = this.cmdLine.getOptionValue("u");
            }
            if (this.cmdLine.hasOption("p")) {
                this.password = this.cmdLine.getOptionValue("p");
            }
            if (this.url == null) {
                AbstractLscXmlRpcClient.printHelp(this.options);
                return -1;
            }
        }
        catch (ParseException e) {
            LOGGER.error("Unable to parse the options ({})", (Object)e.toString());
            LOGGER.debug(e.toString(), (Throwable)e);
            return 1;
        }
        return 0;
    }

    protected static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("lsc", options);
    }
}

