/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.jmx;

import java.beans.ConstructorProperties;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.lsc.AbstractSynchronize;
import org.lsc.Configuration;
import org.lsc.LscDatasets;
import org.lsc.SimpleSynchronize;
import org.lsc.Task;
import org.lsc.beans.SimpleBean;
import org.lsc.jmx.LscServer;
import org.lsc.utils.PidUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LscServerImpl
implements LscServer,
Runnable {
    static final Logger LOGGER = LoggerFactory.getLogger(AbstractSynchronize.class);
    private SimpleSynchronize synchronize;
    private static boolean jmxStarted = false;

    @ConstructorProperties(value={"synchronize"})
    public LscServerImpl(SimpleSynchronize synchronize) {
        this.synchronize = synchronize;
    }

    public SimpleSynchronize getSynchronize() {
        return this.synchronize;
    }

    @Override
    public String[] getAsyncTasksName() {
        ArrayList<String> asynchronousTasksName = new ArrayList<String>();
        for (Task task : this.synchronize.getTasks()) {
            if (!this.synchronize.isAsynchronousTask(task.getName())) continue;
            asynchronousTasksName.add(task.getName());
        }
        return asynchronousTasksName.toArray(new String[asynchronousTasksName.size()]);
    }

    @Override
    public String[] getSyncTasksName() {
        ArrayList<String> synchronousTasksName = new ArrayList<String>();
        for (Task task : this.synchronize.getTasks()) {
            if (this.synchronize.isAsynchronousTask(task.getName())) continue;
            synchronousTasksName.add(task.getName());
        }
        return synchronousTasksName.toArray(new String[synchronousTasksName.size()]);
    }

    @Override
    public boolean isAsyncTaskRunning(String taskName) {
        boolean status = this.synchronize.isAsynchronousTaskRunning(taskName);
        LOGGER.info("Task " + taskName + " confirmed " + (status ? "running" : "stopped") + " to JMX client !");
        return status;
    }

    public static void startJmx(SimpleSynchronize sync) {
        try {
            if (!jmxStarted) {
                MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
                ObjectName name = new ObjectName("org.lsc.jmx:type=LscServer");
                LscServerImpl mbean = new LscServerImpl(sync);
                mbs.registerMBean(mbean, name);
                jmxStarted = true;
            }
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
        }
        catch (NotCompliantMBeanException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean launchSyncTaskById(String taskName, String id, Map<String, String> attributes) {
        HashMap<String, LscDatasets> entries = new HashMap<String, LscDatasets>();
        entries.put(id, new LscDatasets(attributes));
        return this.synchronize.launchById(taskName, entries);
    }

    @Override
    public void launchCleanTask(String taskName) throws Exception {
        ArrayList<String> cleanList = new ArrayList<String>();
        cleanList.add(taskName);
        this.synchronize.launch(SimpleSynchronize.EMPTY_LIST, SimpleSynchronize.EMPTY_LIST, cleanList);
    }

    @Override
    public void shutdownAsyncTask(String taskName) {
        this.synchronize.shutdownAsynchronousSynchronize2Ldap(taskName, true);
    }

    @Override
    public void startAsyncTask(String taskName) {
        this.synchronize.startAsynchronousSynchronize2Ldap(this.synchronize.getTask(taskName));
    }

    @Override
    public boolean ping() {
        return true;
    }

    @Override
    public String getPid() {
        try {
            return PidUtil.getPID();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public String status() {
        return "Running";
    }

    @Override
    public void stop() {
        for (Task task : this.synchronize.getTasks()) {
            String taskName = task.getName();
            if (!this.synchronize.isAsynchronousTask(taskName) || !this.synchronize.isAsynchronousTaskRunning(taskName)) continue;
            this.synchronize.shutdownAsynchronousSynchronize2Ldap(taskName, false);
        }
        new Thread(this).start();
    }

    @Override
    public void run() {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.exit(0);
    }

    @Override
    public String getConfigurationDirectory() {
        return Configuration.getConfigurationDirectory();
    }

    @Override
    public boolean launchSyncTask(String taskName, SimpleBean bean) {
        return this.synchronize.launch(taskName, bean);
    }

    @Override
    public String getTaskStatus(String taskName) {
        return this.synchronize.getTaskFullStatus(taskName);
    }
}

