/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.opendj;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.lsc.Configuration;
import org.opends.messages.Message;
import org.opends.server.api.Backend;
import org.opends.server.backends.MemoryBackend;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryEnvironmentConfig;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.ResultCode;
import org.opends.server.util.LDIFException;
import org.opends.server.util.LDIFReader;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

public final class EmbeddedOpenDJ {
    private static Log logger = LogFactory.getLog(EmbeddedOpenDJ.class);
    public static final String PROPERTY_WORKING_DIR = "org.opends.server.workingDir";
    public static final String DEFAULT_WORKING_DIR_NAME = "opendj-test";
    public static boolean SERVER_STARTED = false;
    private static final String CONFIG_DIR = "config";
    private static MemoryBackend memoryBackend = null;

    private EmbeddedOpenDJ() {
    }

    public static void startServer() throws IOException, InitializationException, URISyntaxException {
        if (SERVER_STARTED) {
            return;
        }
        String configClass = "org.opends.server.extensions.ConfigFileHandler";
        String conf = EmbeddedOpenDJ.getPathToConfigFile(CONFIG_DIR);
        if (conf == null || "".equals(conf)) {
            throw new RuntimeException("The config directory template " + conf + "(from " + CONFIG_DIR + ") has not been found");
        }
        String workingDirectory = System.getProperty(PROPERTY_WORKING_DIR);
        if (null == workingDirectory) {
            String tempDir = System.getProperty("java.io.tmpdir");
            if (!tempDir.endsWith("/") && !tempDir.endsWith("\\")) {
                tempDir = tempDir + System.getProperty("file.separator");
            }
            workingDirectory = tempDir + DEFAULT_WORKING_DIR_NAME;
        }
        EmbeddedOpenDJ.initOpenDJDirectory(conf, workingDirectory);
        DirectoryServer directoryServer = DirectoryServer.getInstance();
        directoryServer.bootstrapServer();
        try {
            directoryServer.initializeConfiguration(configClass, new File(new File(workingDirectory, CONFIG_DIR), "config.ldif").getAbsolutePath());
            DirectoryEnvironmentConfig dec = new DirectoryEnvironmentConfig();
            dec.setLockDirectory(new File(workingDirectory, "locks"));
            dec.setSchemaDirectory(new File(new File(workingDirectory, CONFIG_DIR), "schema"));
            directoryServer.setEnvironmentConfig(dec);
        }
        catch (Exception e) {
            throw new RuntimeException("Error when intializing the server: " + e, e);
        }
        try {
            directoryServer.startServer();
        }
        catch (Exception e) {
            throw new RuntimeException("Error when starting the server: " + e, e);
        }
        SERVER_STARTED = true;
        if (logger.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer("");
            for (Backend b : DirectoryServer.getBackends().values()) {
                sb.append("[ ").append(b.getBackendID()).append(" => ");
                DN[] dns = b.getBaseDNs();
                for (int i = 0; i < dns.length; ++i) {
                    sb.append("(").append(dns[i].toNormalizedString()).append(")");
                }
                sb.append(" ]");
            }
            logger.debug((Object)sb.toString());
        }
        SERVER_STARTED = true;
    }

    public static void shutdownServer(String reason) {
        if (SERVER_STARTED) {
            DirectoryServer.shutDown((String)"org.lsc.opends.EmbeddedOpenDS", (Message)Message.fromObject(null, (Object[])new Object[]{reason}));
            SERVER_STARTED = false;
        }
    }

    public static void main(String[] args) {
        try {
            EmbeddedOpenDJ.startServer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Server started");
        try {
            EmbeddedOpenDJ.shutdownServer("Stop required");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Server stoped");
    }

    private static void initOpenDJDirectory(String copyFromConfigDirectory, String targetRootDirectory) throws IOException {
        String[] subDirectories;
        File workingDirectory = new File(targetRootDirectory);
        if (workingDirectory.exists()) {
            FileUtils.deleteDirectory((File)workingDirectory);
        }
        if (workingDirectory.exists()) {
            throw new IOException("Failed to delete: " + workingDirectory);
        }
        if (!workingDirectory.mkdirs()) {
            throw new IOException("Failed to create:" + workingDirectory);
        }
        FileUtils.copyDirectory((File)new File(copyFromConfigDirectory), (File)new File(targetRootDirectory, CONFIG_DIR));
        for (String s : subDirectories = new String[]{"changelogDb", "classes", "db", "ldif", "locks", "logs"}) {
            new File(workingDirectory, s).mkdir();
        }
    }

    public static List<Entry> entriesFromLdifString(String ldif) throws IOException, LDIFException {
        Entry entry;
        LDIFImportConfig ldifImportConfig = new LDIFImportConfig((Reader)new StringReader(ldif));
        LDIFReader reader = new LDIFReader(ldifImportConfig);
        ArrayList<Entry> entries = new ArrayList<Entry>();
        while ((entry = reader.readEntry()) != null) {
            entries.add(entry);
        }
        return entries;
    }

    public static Entry entryFromLdifString(String ldif) throws Exception {
        return EmbeddedOpenDJ.entriesFromLdifString(ldif).get(0);
    }

    public static String makeLdif(String ... lines) {
        StringBuilder buffer = new StringBuilder();
        for (String line : lines) {
            buffer.append(line).append(ServerConstants.EOL);
        }
        buffer.append(ServerConstants.EOL);
        return buffer.toString();
    }

    public static Entry makeEntry(String ... lines) throws Exception {
        return EmbeddedOpenDJ.entryFromLdifString(EmbeddedOpenDJ.makeLdif(lines));
    }

    public static List<Entry> makeEntries(String ... lines) throws LDIFException, IOException {
        return EmbeddedOpenDJ.entriesFromLdifString(EmbeddedOpenDJ.makeLdif(lines));
    }

    public static ResultCode addEntry(Entry entry) {
        InternalClientConnection conn = InternalClientConnection.getRootConnection();
        AddOperation addOperation = conn.processAdd(entry.getDN(), entry.getObjectClasses(), entry.getUserAttributes(), entry.getOperationalAttributes());
        return addOperation.getResultCode();
    }

    public static void addEntries(List<Entry> entries) {
        for (Entry entry : entries) {
            EmbeddedOpenDJ.addEntry(entry);
        }
    }

    public static void addEntries(String ... lines) throws LDIFException, IOException {
        for (Entry entry : EmbeddedOpenDJ.makeEntries(lines)) {
            EmbeddedOpenDJ.addEntry(entry);
        }
    }

    public static void initializeTestBackend(boolean createBaseEntry, String dn) throws Exception {
        DN baseDN = DN.decode((String)dn);
        if (memoryBackend == null) {
            memoryBackend = new MemoryBackend();
            memoryBackend.setBackendID("test");
            memoryBackend.setBaseDNs(new DN[]{baseDN});
            memoryBackend.initializeBackend();
            DirectoryServer.registerBackend((Backend)memoryBackend);
        }
        memoryBackend.clearMemoryBackend();
        if (createBaseEntry) {
            Entry e = StaticUtils.createEntry((DN)baseDN);
            memoryBackend.addEntry(e, null);
        }
    }

    public static void importLdif(String ldif) throws IOException, LDIFException {
        BufferedReader br = new BufferedReader(new FileReader(ldif));
        StringBuffer sb = new StringBuffer("");
        String line = null;
        while (null != (line = br.readLine())) {
            sb.append(line).append("\n");
        }
        EmbeddedOpenDJ.addEntries(sb.toString());
        br.close();
    }

    public static String getPathToConfigFile(String fileName) {
        String res = null;
        try {
            URL configUrl = EmbeddedOpenDJ.class.getResource(fileName);
            if (configUrl != null) {
                res = configUrl.toURI().getPath();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (res == null || "".equals(res)) {
            res = new File(Configuration.getConfigurationDirectory() + fileName).getAbsolutePath();
        }
        return res;
    }
}

