/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.opendj;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.lsc.Configuration;
import org.lsc.exception.LscException;
import org.lsc.opendj.EmbeddedOpenDJ;
import org.opends.server.api.Backend;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.DN;
import org.opends.server.util.StaticUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapServer.class);
    private static Options options;

    public static final void start() throws Exception {
        EmbeddedOpenDJ.startServer();
        EmbeddedOpenDJ.initializeTestBackend(false, Configuration.DN_REAL_ROOT);
        Backend backend = DirectoryServer.getBackend((DN)DN.decode((String)Configuration.DN_REAL_ROOT));
        backend.addEntry(StaticUtils.createEntry((DN)DN.decode((String)Configuration.DN_REAL_ROOT)), null);
        String ldifPath = EmbeddedOpenDJ.getPathToConfigFile("test.ldif");
        if (ldifPath == null || "".equals(ldifPath)) {
            LOGGER.error("Unable to load LDIF sample content !");
        } else {
            EmbeddedOpenDJ.importLdif(ldifPath);
            LOGGER.info("LDIF sample content loaded successfully");
        }
    }

    public static final void stop() {
        EmbeddedOpenDJ.shutdownServer("Normal stop process");
    }

    public static void main(String[] args) {
        LdapServer.parseOptionsForConfiguration(args);
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)context);
        context.reset();
        String logBackXMLPropertiesFile = Configuration.getConfigurationDirectory() + "logback-opends.xml";
        try {
            configurator.doConfigure(logBackXMLPropertiesFile);
        }
        catch (JoranException je) {
            System.err.println("Can not find LogBack configuration file for OpenDS");
            System.exit(1);
        }
        int retCode = 1;
        try {
            retCode = LdapServer.usage(args);
        }
        catch (Exception e) {
            LOGGER.error(e.toString());
            LOGGER.debug(e.toString(), (Throwable)e);
        }
        if (retCode != 0) {
            System.exit(retCode);
        }
    }

    private static CommandLine getOptionsCmdLine(String[] args) throws ParseException {
        options = new Options();
        options.addOption("a", "start", false, "Start the embedded directory");
        options.addOption("o", "stop", false, "Stop the embedded directory");
        options.addOption("f", "config", true, "Specify configuration directory");
        options.addOption("h", "help", false, "Get this text");
        GnuParser parser = new GnuParser();
        return parser.parse(options, args);
    }

    private static void parseOptionsForConfiguration(String[] args) {
        try {
            CommandLine cmdLine = LdapServer.getOptionsCmdLine(args);
            if (cmdLine.getOptions().length > 0 && !cmdLine.hasOption("h")) {
                if (cmdLine.hasOption("f")) {
                    Configuration.setUp(new File(cmdLine.getOptionValue("f")).getAbsolutePath(), false);
                }
            } else {
                LdapServer.printHelp(options);
            }
        }
        catch (ParseException e) {
            if (LOGGER.isErrorEnabled()) {
                StringBuilder sbf = new StringBuilder();
                for (String arg : args) {
                    sbf.append(arg).append(" ");
                }
                LOGGER.error("Unable to parse options : {}({})", (Object)sbf.toString(), (Object)e);
            }
            LOGGER.debug(e.toString(), (Throwable)e);
        }
        catch (LscException e) {
            LOGGER.warn("Error while loading configuration: " + e.toString());
        }
    }

    private static int usage(String[] args) throws Exception {
        block8: {
            try {
                CommandLine cmdLine = LdapServer.getOptionsCmdLine(args);
                if (cmdLine.getOptions().length > 0 && !cmdLine.hasOption("h")) {
                    if (cmdLine.hasOption("a")) {
                        LdapServer.start();
                    } else if (cmdLine.hasOption("o")) {
                        LdapServer.stop();
                    }
                    break block8;
                }
                LdapServer.printHelp(options);
                return 1;
            }
            catch (ParseException e) {
                if (LOGGER.isErrorEnabled()) {
                    StringBuilder sbf = new StringBuilder();
                    for (String arg : args) {
                        sbf.append(arg).append(" ");
                    }
                    LOGGER.error("Unable to parse options : {}({})", (Object)sbf.toString(), (Object)e);
                }
                LOGGER.debug(e.toString(), (Throwable)e);
                return 1;
            }
        }
        return 0;
    }

    private static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("lsc", options);
    }
}

