/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.service;

import com.ibatis.sqlmap.client.SqlMapClient;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.CommunicationException;
import javax.naming.NamingException;
import javax.naming.directory.BasicAttribute;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.lang.StringUtils;
import org.lsc.LscDatasetModification;
import org.lsc.LscDatasets;
import org.lsc.beans.IBean;
import org.lsc.configuration.DatabaseConnectionType;
import org.lsc.exception.LscServiceConfigurationException;
import org.lsc.exception.LscServiceException;
import org.lsc.persistence.DaoConfig;
import org.lsc.service.IService;
import org.lsc.utils.SetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJdbcService
implements IService {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractJdbcService.class);
    protected SqlMapClient sqlMapper;
    private Class<IBean> beanClass;

    public abstract String getRequestNameForList();

    public abstract String getRequestNameForObject();

    public abstract String getRequestNameForNextId();

    public abstract String getRequestNameForClean();

    public AbstractJdbcService(SqlMapClient sqlmap, String beanClassname) throws LscServiceConfigurationException {
        this.sqlMapper = sqlmap;
        try {
            this.beanClass = Class.forName(beanClassname);
        }
        catch (ClassNotFoundException e) {
            throw new LscServiceConfigurationException(e);
        }
    }

    public AbstractJdbcService(DatabaseConnectionType destinationConnection, String beanClassname) throws LscServiceConfigurationException {
        this.sqlMapper = DaoConfig.getSqlMapClient(destinationConnection);
        try {
            this.beanClass = Class.forName(beanClassname);
        }
        catch (ClassNotFoundException e) {
            throw new LscServiceConfigurationException(e);
        }
    }

    public IBean getBean(String pivotName, LscDatasets pivotAttributes) throws LscServiceException {
        Map<String, Object> attributeMap = pivotAttributes.getDatasets();
        try {
            return (IBean)this.sqlMapper.queryForObject(this.getRequestNameForObject(), attributeMap);
        }
        catch (SQLException e) {
            LOGGER.warn("Error while looking for a specific entry with id={} ({})", (Object)pivotName, (Object)e);
            LOGGER.debug(e.toString(), (Throwable)e);
            throw new LscServiceException(new CommunicationException(e.getMessage()));
        }
    }

    @Override
    public Map<String, LscDatasets> getListPivots() {
        ListOrderedMap ret = new ListOrderedMap();
        try {
            List ids = this.sqlMapper.queryForList(this.getRequestNameForList());
            Iterator idsIter = ids.iterator();
            int count = 1;
            while (idsIter.hasNext()) {
                Map idMap = (Map)idsIter.next();
                ret.put(this.getMapKey(idMap, count), new LscDatasets(idMap));
                ++count;
            }
        }
        catch (SQLException e) {
            LOGGER.warn("Error while looking for the entries list: {}", (Object)e.toString());
            LOGGER.debug(e.toString(), (Throwable)e);
        }
        return ret;
    }

    protected String getMapKey(Map<String, Object> idMap, int count) {
        String key = idMap.values().size() == 1 ? idMap.values().iterator().next().toString() : StringUtils.join(idMap.values().iterator(), (String)", ") + " (" + count + ")";
        return key;
    }

    @Override
    public IBean getBean(String id, LscDatasets attributes, boolean fromSource) throws LscServiceException {
        IBean srcBean = null;
        try {
            srcBean = this.beanClass.newInstance();
            List records = this.sqlMapper.queryForList(fromSource ? this.getRequestNameForObject() : this.getRequestNameForClean(), AbstractJdbcService.getAttributesMap(attributes));
            if (records.size() > 1) {
                throw new LscServiceException("Only a single record can be returned from a getObject request ! For id=" + id + ", there are " + records.size() + " records !");
            }
            if (records.size() == 0) {
                return null;
            }
            Map record = (Map)records.get(0);
            for (Map.Entry entry : record.entrySet()) {
                if (entry.getValue() != null) {
                    srcBean.setDataset((String)entry.getKey(), SetUtils.attributeToSet(new BasicAttribute((String)entry.getKey(), entry.getValue())));
                    continue;
                }
                srcBean.setDataset((String)entry.getKey(), SetUtils.attributeToSet(new BasicAttribute((String)entry.getKey())));
            }
            srcBean.setMainIdentifier(id);
            return srcBean;
        }
        catch (InstantiationException e) {
            LOGGER.error("Unable to get static method getInstance on {} ! This is probably a programmer's error ({})", (Object)this.beanClass.getName(), (Object)e.toString());
            LOGGER.debug(e.toString(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Unable to get static method getInstance on {} ! This is probably a programmer's error ({})", (Object)this.beanClass.getName(), (Object)e.toString());
            LOGGER.debug(e.toString(), (Throwable)e);
        }
        catch (SQLException e) {
            LOGGER.warn("Error while looking for a specific entry with id={} ({})", (Object)id, (Object)e);
            LOGGER.debug(e.toString(), (Throwable)e);
            throw new LscServiceException(new CommunicationException(e.getMessage()));
        }
        catch (NamingException e) {
            LOGGER.error("Unable to get handle cast: " + e.toString());
            LOGGER.debug(e.toString(), (Throwable)e);
        }
        return null;
    }

    public static Map<String, Object> fillAttributesMap(Map<String, Object> datasets, IBean destinationBean) {
        for (String attributeName : destinationBean.datasets().getAttributesNames()) {
            if (datasets.containsKey(attributeName) || destinationBean.getDatasetById(attributeName) == null || destinationBean.getDatasetById(attributeName).size() <= 0) continue;
            datasets.put(attributeName, destinationBean.getDatasetById(attributeName).iterator().next().toString());
        }
        return datasets;
    }

    public static Map<String, Object> getAttributesMap(List<LscDatasetModification> lscAttributeModifications) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (LscDatasetModification lam : lscAttributeModifications) {
            if (lam.getValues().size() <= 0) continue;
            values.put(lam.getAttributeName(), lam.getValues().get(0));
        }
        return values;
    }

    public static Map<String, String> getAttributesMap(LscDatasets lscAttributes) {
        HashMap<String, String> values = new HashMap<String, String>(lscAttributes.getDatasets().size());
        for (Map.Entry<String, Object> entry : lscAttributes.getDatasets().entrySet()) {
            if (entry.getValue() == null) continue;
            values.put(entry.getKey(), AbstractJdbcService.getValue(entry.getValue()));
        }
        return values;
    }

    public static String getValue(Object value) {
        if (value instanceof List) {
            return ((List)value).iterator().next().toString();
        }
        if (value instanceof Set) {
            return ((Set)value).iterator().next().toString();
        }
        return value.toString();
    }
}

