/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;

public class PidUtil {
    public static String getPID() throws IOException {
        String pid = System.getProperty("pid");
        if (pid == null) {
            String[] cmd;
            File tempFile = null;
            if (System.getProperty("os.name").toLowerCase().indexOf("windows") == -1) {
                cmd = new String[]{"/bin/sh", "-c", "echo $$ $PPID"};
            } else {
                tempFile = File.createTempFile("getpids", "exe");
                PidUtil.pump(PidUtil.class.getResourceAsStream("getpids.exe"), new FileOutputStream(tempFile), true, true);
                cmd = new String[]{tempFile.getAbsolutePath()};
            }
            if (cmd != null) {
                Process p = Runtime.getRuntime().exec(cmd);
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                PidUtil.pump(p.getInputStream(), bout, false, true);
                if (tempFile != null) {
                    tempFile.delete();
                }
                StringTokenizer stok = new StringTokenizer(bout.toString());
                stok.nextToken();
                pid = stok.nextToken();
                if (pid != null) {
                    System.setProperty("pid", pid);
                }
            }
        }
        return pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pump(InputStream in, OutputStream out, boolean closeIn, boolean closeOut) throws IOException {
        byte[] bytes = new byte[1024];
        try {
            int read;
            while ((read = in.read(bytes)) != -1) {
                out.write(bytes, 0, read);
            }
        }
        finally {
            if (closeIn) {
                in.close();
            }
            if (closeOut) {
                out.close();
            }
        }
    }

    public static void main(String[] args) throws IOException {
        System.out.println(PidUtil.getPID());
    }
}

