/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.utils;

import java.awt.event.ActionEvent;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.debug.DebuggableScript;
import org.mozilla.javascript.tools.debugger.Dim;
import org.mozilla.javascript.tools.debugger.SourceProvider;
import org.mozilla.javascript.tools.debugger.SwingGui;
import org.mozilla.javascript.tools.shell.Global;

public class RhinoDebugger
implements Runnable {
    private Dim dim = new Dim();
    private SwingGui debugGui;
    private Context cx;
    private Scriptable scope;
    private Script script;
    private static Global global;

    public RhinoDebugger(String source, ContextFactory factory) {
        this.dim.setSourceProvider((SourceProvider)new LscSourceProvider(source));
        this.dim.attachTo(factory);
        this.debugGui = new LscRhinoGui(this.dim, "Debugging LSC javascript", this);
        this.debugGui.setExitAction((Runnable)this);
        this.debugGui.pack();
        this.debugGui.setSize(600, 460);
    }

    public void initContext(Context cx, Scriptable scope, Script script) {
        this.cx = cx;
        this.scope = scope;
        this.script = script;
        if (global == null || !global.isInitialized()) {
            global = new Global(cx);
            global.setIn(System.in);
            global.setOut(System.out);
            global.setErr(System.err);
        }
    }

    public Object exec() {
        this.debugGui.setVisible(true);
        this.dim.setBreak();
        this.dim.setBreakOnEnter(true);
        this.dim.setBreakOnExceptions(true);
        return this.script.exec(this.cx, this.scope);
    }

    public void execInclude(Script include) {
        include.exec(this.cx, this.scope);
    }

    @Override
    public void run() {
        this.debugGui.dispose();
    }

    public boolean isVisible() {
        return this.debugGui != null && this.debugGui.isVisible();
    }

    private static class LscSourceProvider
    implements SourceProvider {
        private String source;

        public LscSourceProvider(String source) {
            this.source = source;
        }

        public String getSource(DebuggableScript script) {
            return this.source;
        }
    }

    private static class LscRhinoGui
    extends SwingGui {
        private static final long serialVersionUID = -6368924684609097200L;
        private RhinoDebugger debugger;

        public LscRhinoGui(Dim dim, String title, RhinoDebugger debugger) {
            super(dim, title);
            this.debugger = debugger;
        }

        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals("Exit")) {
                this.debugger.run();
            } else {
                super.actionPerformed(e);
            }
        }
    }
}

