/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.utils.directory;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.NamingException;
import javax.naming.SizeLimitExceededException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.directory.api.ldap.model.exception.LdapURLEncodingException;
import org.apache.directory.api.ldap.model.url.LdapUrl;
import org.lsc.jndi.JndiServices;

public class LDAP {
    private LDAP() {
    }

    public static boolean canBind(String url, String dnToCheck, String passwordToCheck) throws NamingException {
        return LDAP.canBind(url, null, null, dnToCheck, passwordToCheck);
    }

    public static boolean canBind(String url, String bindDn, String bindPassword, String dnToCheck, String passwordToCheck) throws NamingException {
        JndiServices bindJndiServices = LDAP.getJndiServices(url, bindDn, bindPassword);
        LdapContext bindContext = bindJndiServices.getContext();
        try {
            bindContext.addToEnvironment("java.naming.security.authentication", "simple");
            bindContext.addToEnvironment("java.naming.security.principal", dnToCheck);
            bindContext.addToEnvironment("java.naming.security.credentials", passwordToCheck);
            bindContext.reconnect(bindContext.getConnectControls());
        }
        catch (AuthenticationException e) {
            boolean bl = false;
            return bl;
        }
        catch (NamingException e) {
            throw e;
        }
        finally {
            Properties authProps = LDAP.getJndiAuthenticationProperties(bindDn, bindPassword);
            for (Map.Entry<Object, Object> propertyEntry : authProps.entrySet()) {
                bindContext.addToEnvironment(propertyEntry.getKey().toString(), propertyEntry.getValue());
            }
            bindContext.reconnect(bindContext.getConnectControls());
        }
        return true;
    }

    public static boolean canBindSearchRebind(String url, String passwordToCheck) throws NamingException, LdapURLEncodingException {
        return LDAP.canBindSearchRebind(url, null, null, passwordToCheck);
    }

    public static boolean canBindSearchRebind(String url, String bindDn, String bindPassword, String passwordToCheck) throws NamingException, LdapURLEncodingException {
        SearchResult matchingDns;
        LdapUrl urlInstance = new LdapUrl(url);
        JndiServices bindJndiServices = LDAP.getJndiServices(url, bindDn, bindPassword);
        String baseDn = urlInstance.getDn().toString();
        String contextDn = bindJndiServices.getContextDn();
        if (contextDn != null && baseDn.endsWith(contextDn)) {
            baseDn = baseDn.substring(0, baseDn.length() - contextDn.length());
        }
        try {
            matchingDns = bindJndiServices.getEntry(baseDn, urlInstance.getFilter().toString(), new SearchControls(), urlInstance.getScope().getScope());
        }
        catch (SizeLimitExceededException e) {
            return false;
        }
        if (matchingDns == null) {
            return false;
        }
        String dnToCheck = matchingDns.getNameInNamespace();
        return LDAP.canBind(url, bindDn, bindPassword, dnToCheck, passwordToCheck);
    }

    private static JndiServices getJndiServices(String url, String bindDn, String bindPassword) throws NamingException {
        try {
            Properties props = new Properties();
            props.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            props.put("java.naming.referral", "ignore");
            String bindUrl = url.contains("?") ? url.substring(0, url.indexOf(63)) : url;
            props.put("java.naming.provider.url", bindUrl);
            props.putAll((Map<?, ?>)LDAP.getJndiAuthenticationProperties(bindDn, bindPassword));
            return JndiServices.getInstance(props);
        }
        catch (NamingException e) {
            throw e;
        }
        catch (IOException e) {
            throw new CommunicationException(e.toString());
        }
    }

    private static Properties getJndiAuthenticationProperties(String bindDn, String bindPassword) {
        Properties props = new Properties();
        if (bindDn == null) {
            props.put("java.naming.security.authentication", "none");
        } else {
            props.put("java.naming.security.authentication", "simple");
            props.put("java.naming.security.principal", bindDn);
            props.put("java.naming.security.credentials", bindPassword);
        }
        return props;
    }
}

