/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.utils.output;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.LayoutBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.lsc.LscModificationType;
import org.lsc.LscModifications;

public class CsvLayout
extends LayoutBase<ILoggingEvent> {
    protected static final String DEFAULT_SEPARATOR = ";";
    protected static final String OPTIONS_SEPARATOR = ",";
    private String logOperations;
    private String attrs;
    private String separator = ";";
    private String taskNames;
    protected List<String> attributes;
    protected Set<String> taskNamesList;
    protected Set<LscModificationType> operations = new HashSet<LscModificationType>();
    private Boolean outputHeader = false;
    private static final String DN_STRING = "dn";

    public CsvLayout() {
        this.taskNamesList = new HashSet<String>();
    }

    public String doLayout(ILoggingEvent event) {
        LscModifications lm;
        Object[] messages = event.getArgumentArray();
        String result = "";
        if (messages != null && messages.length != 0 && messages[0] != null && LscModifications.class.isAssignableFrom(messages[0].getClass()) && this.operations.contains((Object)(lm = (LscModifications)messages[0]).getOperation()) && (this.taskNamesList.size() == 0 || this.taskNamesList.contains(lm.getTaskName().toLowerCase()))) {
            StringBuilder sb = new StringBuilder(1024);
            Map<String, List<Object>> modifications = lm.getModificationsItemsByHash();
            List<Object> values = null;
            for (String attributeName : this.attributes) {
                if (modifications.containsKey(attributeName)) {
                    values = modifications.get(attributeName);
                    if (values.size() > 0) {
                        sb.append(values.get(0));
                    }
                } else if (attributeName.equalsIgnoreCase(DN_STRING)) {
                    sb.append(lm.getMainIdentifier());
                }
                sb.append(this.separator);
            }
            sb.deleteCharAt(sb.length() - 1).append("\n");
            result = sb.toString();
        }
        return result;
    }

    public String getHeader() {
        String result = "";
        if (this.outputHeader.booleanValue()) {
            result = this.attrs + "\n";
        }
        return result;
    }

    public void start() {
        Object st;
        if (this.logOperations != null) {
            st = new StringTokenizer(this.logOperations, OPTIONS_SEPARATOR);
            String token = null;
            while (((StringTokenizer)st).hasMoreTokens()) {
                token = ((StringTokenizer)st).nextToken().toLowerCase();
                LscModificationType op = LscModificationType.getFromDescription(token);
                if (op == null) continue;
                this.operations.add(op);
            }
        } else if (this.operations.isEmpty()) {
            for (LscModificationType type : LscModificationType.values()) {
                this.operations.add(type);
            }
        }
        this.attributes = new ArrayList<String>();
        if (this.attrs != null) {
            for (String st2 : this.attrs.split(this.separator)) {
                this.attributes.add(st2.toLowerCase());
            }
        } else {
            this.addWarn("There is no attributes to write in the CSV file.\nSet the attrs property in the logback configuration file");
        }
        if (this.taskNames != null) {
            st = new StringTokenizer(this.taskNames, OPTIONS_SEPARATOR);
            String token = null;
            while (((StringTokenizer)st).hasMoreTokens()) {
                token = ((StringTokenizer)st).nextToken().toLowerCase();
                this.taskNamesList.add(token);
            }
        }
        super.start();
    }

    public void setLogOperations(LscModificationType[] logOperations) {
        this.operations.addAll(Arrays.asList(logOperations));
    }

    public void setLogOperations(String logOperations) {
        this.logOperations = logOperations;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void setTaskNames(String taskNames) {
        this.taskNames = taskNames;
    }

    public void setTaskNames(String[] taskNames) {
        if (taskNames != null) {
            this.taskNamesList.addAll(Arrays.asList(taskNames));
        }
    }

    public void setOutputHeader(Boolean outputHeader) {
        this.outputHeader = outputHeader;
    }

    Set<LscModificationType> getLogOperations() {
        return this.operations;
    }
}

