/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm;

import bitronix.tm.BitronixTransaction;
import bitronix.tm.BitronixTransactionManager;
import bitronix.tm.BitronixTransactionSynchronizationRegistryObjectFactory;
import bitronix.tm.TransactionManagerServices;
import bitronix.tm.internal.BitronixRuntimeException;
import java.util.HashMap;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionSynchronizationRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitronixTransactionSynchronizationRegistry
implements TransactionSynchronizationRegistry,
Referenceable {
    private static final Logger log = LoggerFactory.getLogger(BitronixTransactionSynchronizationRegistry.class);
    private static BitronixTransactionManager transactionManager;
    private static final ThreadLocal resourcesTl;

    public BitronixTransactionSynchronizationRegistry() {
        transactionManager = TransactionManagerServices.getTransactionManager();
    }

    public Object getResource(Object key) {
        try {
            if (key == null) {
                throw new NullPointerException("key cannot be null");
            }
            if (this.currentTransaction() == null || this.currentTransaction().getStatus() == 6) {
                throw new IllegalStateException("no transaction started on current thread");
            }
            return this.getResources().get(key);
        }
        catch (SystemException ex) {
            throw new BitronixRuntimeException("cannot get current transaction status", ex);
        }
    }

    public boolean getRollbackOnly() {
        try {
            if (this.currentTransaction() == null || this.currentTransaction().getStatus() == 6) {
                throw new IllegalStateException("no transaction started on current thread");
            }
            return this.currentTransaction().getStatus() == 1;
        }
        catch (SystemException e) {
            throw new BitronixRuntimeException("cannot get current transaction status");
        }
    }

    public Object getTransactionKey() {
        try {
            if (this.currentTransaction() == null || this.currentTransaction().getStatus() == 6) {
                return null;
            }
            return this.currentTransaction().getGtrid();
        }
        catch (SystemException ex) {
            throw new BitronixRuntimeException("cannot get current transaction status", ex);
        }
    }

    public int getTransactionStatus() {
        try {
            if (this.currentTransaction() == null) {
                return 6;
            }
            return this.currentTransaction().getStatus();
        }
        catch (SystemException ex) {
            throw new BitronixRuntimeException("cannot get current transaction status", ex);
        }
    }

    public void putResource(Object key, Object value) {
        try {
            if (key == null) {
                throw new NullPointerException("key cannot be null");
            }
            if (this.currentTransaction() == null || this.currentTransaction().getStatus() == 6) {
                throw new IllegalStateException("no transaction started on current thread");
            }
            this.getResources().put(key, value);
            if (this.getResources().size() == 1) {
                if (log.isDebugEnabled()) {
                    log.debug("first resource put in synchronization registry, registering a ClearRegistryResourcesSynchronization");
                }
                ClearRegistryResourcesSynchronization synchronization = new ClearRegistryResourcesSynchronization();
                this.currentTransaction().getSynchronizationScheduler().add(synchronization, Integer.MAX_VALUE);
            }
        }
        catch (SystemException ex) {
            throw new BitronixRuntimeException("cannot get current transaction status", ex);
        }
    }

    public void registerInterposedSynchronization(Synchronization synchronization) {
        try {
            if (this.currentTransaction() == null || this.currentTransaction().getStatus() == 6) {
                throw new IllegalStateException("no transaction started on current thread");
            }
            if (this.currentTransaction().getStatus() == 7 || this.currentTransaction().getStatus() == 2 || this.currentTransaction().getStatus() == 8 || this.currentTransaction().getStatus() == 3 || this.currentTransaction().getStatus() == 9 || this.currentTransaction().getStatus() == 4) {
                throw new IllegalStateException("transaction is done, cannot register an interposed synchronization");
            }
            this.currentTransaction().getSynchronizationScheduler().add(synchronization, -1);
        }
        catch (SystemException ex) {
            throw new BitronixRuntimeException("cannot get current transaction status", ex);
        }
    }

    public void setRollbackOnly() {
        try {
            if (this.currentTransaction() == null || this.currentTransaction().getStatus() == 6) {
                throw new IllegalStateException("no transaction started on current thread");
            }
            this.currentTransaction().setStatus(1);
        }
        catch (SystemException ex) {
            throw new BitronixRuntimeException("cannot get or set current transaction status", ex);
        }
    }

    private Map getResources() {
        return (Map)resourcesTl.get();
    }

    private BitronixTransaction currentTransaction() {
        return transactionManager.getCurrentTransaction();
    }

    public Reference getReference() throws NamingException {
        return new Reference(BitronixTransactionManager.class.getName(), new StringRefAddr("TransactionSynchronizationRegistry", "BitronixTransactionSynchronizationRegistry"), BitronixTransactionSynchronizationRegistryObjectFactory.class.getName(), null);
    }

    static {
        resourcesTl = new ThreadLocal(){

            protected Object initialValue() {
                return new HashMap();
            }
        };
    }

    private class ClearRegistryResourcesSynchronization
    implements Synchronization {
        private ClearRegistryResourcesSynchronization() {
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            if (log.isDebugEnabled()) {
                log.debug("clearing resources");
            }
            BitronixTransactionSynchronizationRegistry.this.getResources().clear();
        }
    }
}

