/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.journal;

import bitronix.tm.journal.TransactionLogAppender;
import bitronix.tm.utils.CollectionUtils;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskForceWaitQueue {
    private static final Logger log = LoggerFactory.getLogger(DiskForceWaitQueue.class);
    private List objects = new LinkedList();

    public synchronized void enqueue(TransactionLogAppender tla) {
        this.objects.add(tla);
        if (log.isDebugEnabled()) {
            log.debug("enqueued " + tla + ", " + this.objects.size() + " TransactionLogAppender waiting for a disk force");
        }
        this.notifyAll();
    }

    public synchronized TransactionLogAppender head() {
        if (log.isDebugEnabled()) {
            log.debug("returning head TransactionLogAppender");
        }
        return (TransactionLogAppender)this.objects.get(0);
    }

    public synchronized void clear() {
        if (log.isDebugEnabled()) {
            log.debug("clearing list of waiting TransactionLogAppender");
        }
        this.objects.clear();
        this.notifyAll();
    }

    public synchronized boolean isEmpty() {
        return this.objects.isEmpty();
    }

    public synchronized void waitUntilNotEmpty() throws InterruptedException {
        while (this.objects.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug("waiting for some TransactionLogAppender to get enqueued");
            }
            this.wait();
        }
    }

    public synchronized int size() {
        return this.objects.size();
    }

    public synchronized void waitUntilNotContains(TransactionLogAppender tla) throws InterruptedException {
        while (CollectionUtils.containsByIdentity(this.objects, tla)) {
            if (log.isDebugEnabled()) {
                log.debug("waiting for " + tla + " to get dequeued");
            }
            this.wait();
        }
    }
}

