/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.recovery;

import bitronix.tm.BitronixXid;
import bitronix.tm.TransactionManagerServices;
import bitronix.tm.internal.XAResourceHolderState;
import bitronix.tm.journal.TransactionLogRecord;
import bitronix.tm.recovery.DanglingTransaction;
import bitronix.tm.recovery.RecovererMBean;
import bitronix.tm.recovery.RecoveryException;
import bitronix.tm.recovery.RecoveryHelper;
import bitronix.tm.resource.ResourceRegistrar;
import bitronix.tm.resource.common.XAResourceProducer;
import bitronix.tm.utils.Decoder;
import bitronix.tm.utils.ManagementRegistrar;
import bitronix.tm.utils.Service;
import bitronix.tm.utils.Uid;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Recoverer
implements Runnable,
Service,
RecovererMBean {
    private static final Logger log = LoggerFactory.getLogger(Recoverer.class);
    private Map registeredResources = new HashMap();
    private Map recoveredXidSets = new HashMap();
    private Exception completionException;
    private int committedCount;
    private int rolledbackCount;
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private int executionsCount = 0;

    public Recoverer() {
        ManagementRegistrar.register("bitronix.tm:type=Recoverer", this);
    }

    public void shutdown() {
        ManagementRegistrar.unregister("bitronix.tm:type=Recoverer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (!this.isRunning.compareAndSet(false, true)) {
            log.info("recoverer is already running, abandoning this recovery request");
            return;
        }
        try {
            this.committedCount = 0;
            this.rolledbackCount = 0;
            long oldestTransactionTimestamp = Long.MAX_VALUE;
            Class<ResourceRegistrar> clazz = ResourceRegistrar.class;
            synchronized (ResourceRegistrar.class) {
                for (String name : ResourceRegistrar.getResourcesUniqueNames()) {
                    this.registeredResources.put(name, ResourceRegistrar.get(name));
                }
                if (TransactionManagerServices.isTransactionManagerRunning()) {
                    oldestTransactionTimestamp = TransactionManagerServices.getTransactionManager().getOldestInFlightTransactionTimestamp();
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                Map danglingRecords = TransactionManagerServices.getJournal().collectDanglingRecords();
                this.recoverAllResources();
                Set committedGtrids = this.commitDanglingTransactions(oldestTransactionTimestamp, danglingRecords);
                this.committedCount = committedGtrids.size();
                this.rolledbackCount = this.rollbackAbortedTransactions(oldestTransactionTimestamp, committedGtrids);
                if (this.executionsCount == 0 || this.committedCount > 0 || this.rolledbackCount > 0) {
                    log.info("recovery committed " + this.committedCount + " dangling transaction(s) and rolled back " + this.rolledbackCount + " aborted transaction(s) on " + this.registeredResources.size() + " resource(s) [" + this.getRegisteredResourcesUniqueNames() + "]" + (TransactionManagerServices.getConfiguration().isCurrentNodeOnlyRecovery() ? " (restricted to serverId '" + TransactionManagerServices.getConfiguration().getServerId() + "')" : ""));
                } else if (log.isDebugEnabled()) {
                    log.debug("recovery committed " + this.committedCount + " dangling transaction(s) and rolled back " + this.rolledbackCount + " aborted transaction(s) on " + this.registeredResources.size() + " resource(s) [" + this.getRegisteredResourcesUniqueNames() + "]" + (TransactionManagerServices.getConfiguration().isCurrentNodeOnlyRecovery() ? " (restricted to serverId '" + TransactionManagerServices.getConfiguration().getServerId() + "')" : ""));
                }
                this.completionException = null;
            }
        }
        catch (Exception ex) {
            this.completionException = ex;
            log.warn("recovery failed, registered resource(s): " + this.getRegisteredResourcesUniqueNames(), (Throwable)ex);
        }
        finally {
            this.recoveredXidSets.clear();
            this.registeredResources.clear();
            ++this.executionsCount;
            this.isRunning.set(false);
        }
        {
            return;
        }
    }

    public Exception getCompletionException() {
        return this.completionException;
    }

    public int getCommittedCount() {
        return this.committedCount;
    }

    public int getRolledbackCount() {
        return this.rolledbackCount;
    }

    public int getExecutionsCount() {
        return this.executionsCount;
    }

    public boolean isRunning() {
        return this.isRunning.get();
    }

    private void recoverAllResources() {
        for (Map.Entry entry : new HashMap(this.registeredResources).entrySet()) {
            String uniqueName = (String)entry.getKey();
            XAResourceProducer producer = (XAResourceProducer)entry.getValue();
            try {
                if (log.isDebugEnabled()) {
                    log.debug("performing recovery on " + uniqueName);
                }
                Set xids = this.recover(producer);
                if (log.isDebugEnabled()) {
                    log.debug("recovered " + xids.size() + " XID(s) from resource " + uniqueName);
                }
                this.recoveredXidSets.put(uniqueName, xids);
                producer.setFailed(false);
            }
            catch (XAException ex) {
                producer.setFailed(true);
                this.registeredResources.remove(uniqueName);
                log.warn("error running recovery on resource '" + uniqueName + "', resource marked as failed (background recoverer will retry recovery) (error=" + Decoder.decodeXAExceptionErrorCode(ex) + ")", (Throwable)ex);
            }
            catch (Exception ex) {
                producer.setFailed(true);
                this.registeredResources.remove(uniqueName);
                log.warn("error running recovery on resource '" + uniqueName + "', resource marked as failed (background recoverer will retry recovery)", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set recover(XAResourceProducer producer) throws XAException, RecoveryException {
        if (producer == null) {
            throw new IllegalArgumentException("recoverable resource cannot be null");
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug("running recovery on " + producer);
            }
            XAResourceHolderState xaResourceHolderState = producer.startRecovery();
            Set set = RecoveryHelper.recover(xaResourceHolderState);
            return set;
        }
        finally {
            producer.endRecovery();
        }
    }

    private Set commitDanglingTransactions(long oldestTransactionTimestamp, Map danglingRecords) throws IOException, RecoveryException {
        HashSet<Uid> committedGtrids = new HashSet<Uid>();
        if (log.isDebugEnabled()) {
            log.debug("found " + danglingRecords.size() + " dangling record(s) in journal");
        }
        for (Map.Entry entry : danglingRecords.entrySet()) {
            Uid gtrid = (Uid)entry.getKey();
            TransactionLogRecord tlog = (TransactionLogRecord)entry.getValue();
            Set uniqueNames = tlog.getUniqueNames();
            Set danglingTransactions = this.getDanglingTransactionsInRecoveredXids(uniqueNames, tlog.getGtrid());
            long txTimestamp = gtrid.extractTimestamp();
            if (log.isDebugEnabled()) {
                log.debug("recovered XID timestamp: " + txTimestamp + " - oldest in-flight TX timestamp: " + oldestTransactionTimestamp);
            }
            if (txTimestamp < oldestTransactionTimestamp) {
                if (log.isDebugEnabled()) {
                    log.debug("committing dangling transaction with GTRID " + gtrid);
                }
                this.commit(danglingTransactions);
                if (log.isDebugEnabled()) {
                    log.debug("committed dangling transaction with GTRID " + gtrid);
                }
                committedGtrids.add(gtrid);
                Set participatingUniqueNames = this.filterParticipatingUniqueNamesInRecoveredXids(uniqueNames);
                if (participatingUniqueNames.size() > 0) {
                    if (log.isDebugEnabled()) {
                        log.debug("updating journal's transaction with GTRID " + gtrid + " status to COMMITTED for names [" + Recoverer.buildUniqueNamesString(participatingUniqueNames) + "]");
                    }
                    TransactionManagerServices.getJournal().log(3, tlog.getGtrid(), participatingUniqueNames);
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug("not updating journal's transaction with GTRID " + gtrid + " status to COMMITTED as no resource could be found (incremental recovery will need to clean this)");
                }
                committedGtrids.remove(gtrid);
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("skipping in-flight transaction with GTRID " + gtrid);
        }
        if (log.isDebugEnabled()) {
            log.debug("committed " + committedGtrids.size() + " dangling transaction(s)");
        }
        return committedGtrids;
    }

    private Set getDanglingTransactionsInRecoveredXids(Set uniqueNames, Uid gtrid) {
        HashSet<DanglingTransaction> danglingTransactions = new HashSet<DanglingTransaction>();
        for (String uniqueName : uniqueNames) {
            Set recoveredXids;
            if (log.isDebugEnabled()) {
                log.debug("finding dangling transaction(s) in recovered XID(s) of resource " + uniqueName);
            }
            if ((recoveredXids = (Set)this.recoveredXidSets.get(uniqueName)) == null) {
                if (!log.isDebugEnabled()) continue;
                log.debug("resource " + uniqueName + " did not recover, skipping commit");
                continue;
            }
            for (BitronixXid recoveredXid : recoveredXids) {
                if (!gtrid.equals(recoveredXid.getGlobalTransactionIdUid())) continue;
                if (log.isDebugEnabled()) {
                    log.debug("found a recovered XID matching dangling log's GTRID " + gtrid + " in resource " + uniqueName);
                }
                danglingTransactions.add(new DanglingTransaction(uniqueName, recoveredXid));
            }
        }
        return danglingTransactions;
    }

    private Set filterParticipatingUniqueNamesInRecoveredXids(Set uniqueNames) {
        HashSet<String> recoveredUniqueNames = new HashSet<String>();
        for (String uniqueName : uniqueNames) {
            Set recoveredXids;
            if (log.isDebugEnabled()) {
                log.debug("finding dangling transaction(s) in recovered XID(s) of resource " + uniqueName);
            }
            if ((recoveredXids = (Set)this.recoveredXidSets.get(uniqueName)) == null) {
                if (!log.isDebugEnabled()) continue;
                log.debug("cannot find resource '" + uniqueName + "' present in the journal, leaving it for incremental recovery");
                continue;
            }
            recoveredUniqueNames.add(uniqueName);
        }
        return recoveredUniqueNames;
    }

    private void commit(Set danglingTransactions) throws RecoveryException {
        if (log.isDebugEnabled()) {
            log.debug(danglingTransactions.size() + " branch(es) to commit");
        }
        for (DanglingTransaction danglingTransaction : danglingTransactions) {
            Xid xid = danglingTransaction.getXid();
            String uniqueName = danglingTransaction.getUniqueName();
            if (log.isDebugEnabled()) {
                log.debug("committing branch with XID " + xid + " on " + uniqueName);
            }
            this.commit(uniqueName, xid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean commit(String uniqueName, Xid xid) throws RecoveryException {
        XAResourceProducer producer = (XAResourceProducer)this.registeredResources.get(uniqueName);
        try {
            XAResourceHolderState xaResourceHolderState = producer.startRecovery();
            boolean bl = RecoveryHelper.commit(xaResourceHolderState, xid);
            return bl;
        }
        finally {
            producer.endRecovery();
        }
    }

    private int rollbackAbortedTransactions(long oldestTransactionTimestamp, Set committedGtrids) throws RecoveryException {
        if (log.isDebugEnabled()) {
            log.debug("rolling back aborted branch(es)");
        }
        int rollbackCount = 0;
        for (Map.Entry entry : this.recoveredXidSets.entrySet()) {
            String uniqueName = (String)entry.getKey();
            Set recoveredXids = (Set)entry.getValue();
            if (log.isDebugEnabled()) {
                log.debug("checking " + recoveredXids.size() + " branch(es) on " + uniqueName + " for rollback");
            }
            int count = this.rollbackAbortedBranchesOfResource(oldestTransactionTimestamp, uniqueName, recoveredXids, committedGtrids);
            if (log.isDebugEnabled()) {
                log.debug("checked " + recoveredXids.size() + " branch(es) on " + uniqueName + " for rollback");
            }
            rollbackCount += count;
        }
        if (log.isDebugEnabled()) {
            log.debug("rolled back " + rollbackCount + " aborted branch(es)");
        }
        return rollbackCount;
    }

    private int rollbackAbortedBranchesOfResource(long oldestTransactionTimestamp, String uniqueName, Set recoveredXids, Set committedGtrids) throws RecoveryException {
        int abortedCount = 0;
        for (BitronixXid recoveredXid : recoveredXids) {
            boolean success;
            if (committedGtrids.contains(recoveredXid.getGlobalTransactionIdUid())) {
                if (!log.isDebugEnabled()) continue;
                log.debug("XID has been committed, skipping rollback: " + recoveredXid + " on " + uniqueName);
                continue;
            }
            long txTimestamp = recoveredXid.getGlobalTransactionIdUid().extractTimestamp();
            if (log.isDebugEnabled()) {
                log.debug("recovered XID timestamp: " + txTimestamp + " - oldest in-flight TX timestamp: " + oldestTransactionTimestamp);
            }
            if (txTimestamp >= oldestTransactionTimestamp) {
                if (!log.isDebugEnabled()) continue;
                log.debug("skipping XID of in-flight transaction: " + recoveredXid);
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug("rolling back in-doubt branch with XID " + recoveredXid + " on " + uniqueName);
            }
            if (!(success = this.rollback(uniqueName, recoveredXid))) continue;
            ++abortedCount;
        }
        return abortedCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rollback(String uniqueName, Xid xid) throws RecoveryException {
        XAResourceProducer producer = (XAResourceProducer)this.registeredResources.get(uniqueName);
        if (producer == null) {
            if (log.isDebugEnabled()) {
                log.debug("resource " + uniqueName + " has not recovered, skipping rollback");
            }
            return false;
        }
        try {
            XAResourceHolderState xaResourceHolderState = producer.startRecovery();
            boolean bl = RecoveryHelper.rollback(xaResourceHolderState, xid);
            return bl;
        }
        finally {
            producer.endRecovery();
        }
    }

    private String getRegisteredResourcesUniqueNames() {
        return Recoverer.buildUniqueNamesString(this.registeredResources.keySet());
    }

    private static String buildUniqueNamesString(Set uniqueNames) {
        StringBuffer resourcesUniqueNames = new StringBuffer();
        Iterator it = uniqueNames.iterator();
        while (it.hasNext()) {
            String uniqueName = (String)it.next();
            resourcesUniqueNames.append(uniqueName);
            if (!it.hasNext()) continue;
            resourcesUniqueNames.append(", ");
        }
        return resourcesUniqueNames.toString();
    }

    private static class AtomicBoolean {
        private boolean value;

        public AtomicBoolean(boolean value) {
            this.value = value;
        }

        public synchronized boolean get() {
            return this.value;
        }

        public synchronized void set(boolean value) {
            this.value = value;
        }

        public synchronized boolean compareAndSet(boolean expect, boolean update) {
            if (this.value == expect) {
                this.value = update;
                return true;
            }
            return false;
        }
    }
}

