/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.jdbc;

import bitronix.tm.internal.BitronixRollbackSystemException;
import bitronix.tm.internal.BitronixSystemException;
import bitronix.tm.resource.common.AbstractXAResourceHolder;
import bitronix.tm.resource.common.RecoveryXAResourceHolder;
import bitronix.tm.resource.common.ResourceBean;
import bitronix.tm.resource.common.StateChangeListener;
import bitronix.tm.resource.common.TransactionContextHelper;
import bitronix.tm.resource.common.XAStatefulHolder;
import bitronix.tm.resource.jdbc.JdbcConnectionHandle;
import bitronix.tm.resource.jdbc.JdbcPooledConnectionMBean;
import bitronix.tm.resource.jdbc.JdbcPreparedStatementHandle;
import bitronix.tm.resource.jdbc.LruEvictionListener;
import bitronix.tm.resource.jdbc.LruStatementCache;
import bitronix.tm.resource.jdbc.PoolingDataSource;
import bitronix.tm.resource.jdbc.lrc.LrcXADataSource;
import bitronix.tm.utils.Decoder;
import bitronix.tm.utils.ManagementRegistrar;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.sql.XAConnection;
import javax.transaction.SystemException;
import javax.transaction.xa.XAResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcPooledConnection
extends AbstractXAResourceHolder
implements StateChangeListener,
JdbcPooledConnectionMBean {
    private static final Logger log = LoggerFactory.getLogger(JdbcPooledConnection.class);
    private static final int DETECTION_TIMEOUT = 5;
    private XAConnection xaConnection;
    private Connection connection;
    private XAResource xaResource;
    private PoolingDataSource poolingDataSource;
    private LruStatementCache statementsCache;
    private List uncachedStatements;
    private int usageCount;
    private String jmxName;
    private Date acquisitionDate;
    private Date lastReleaseDate;
    private int jdbcVersionDetected;
    private Method isValidMethod;

    public JdbcPooledConnection(PoolingDataSource poolingDataSource, XAConnection xaConnection) throws SQLException {
        this.poolingDataSource = poolingDataSource;
        this.xaConnection = xaConnection;
        this.xaResource = xaConnection.getXAResource();
        this.statementsCache = new LruStatementCache(poolingDataSource.getPreparedStatementCacheSize());
        this.uncachedStatements = Collections.synchronizedList(new ArrayList());
        this.statementsCache.addEvictionListener(new LruEvictionListener(){

            public void onEviction(Object value) {
                PreparedStatement stmt = (PreparedStatement)value;
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    log.warn("error closing evicted statement", (Throwable)ex);
                }
            }
        });
        this.connection = xaConnection.getConnection();
        this.detectJdbcVersion(this.connection);
        this.addStateChangeEventListener(this);
        if (poolingDataSource.getClassName().equals(LrcXADataSource.class.getName())) {
            if (log.isDebugEnabled()) {
                log.debug("emulating XA for resource " + poolingDataSource.getUniqueName() + " - changing twoPcOrderingPosition to ALWAYS_LAST_POSITION");
            }
            poolingDataSource.setTwoPcOrderingPosition(Integer.MAX_VALUE);
            if (log.isDebugEnabled()) {
                log.debug("emulating XA for resource " + poolingDataSource.getUniqueName() + " - changing deferConnectionRelease to true");
            }
            poolingDataSource.setDeferConnectionRelease(true);
            if (log.isDebugEnabled()) {
                log.debug("emulating XA for resource " + poolingDataSource.getUniqueName() + " - changing useTmJoin to true");
            }
            poolingDataSource.setUseTmJoin(true);
        }
        this.jmxName = "bitronix.tm:type=JDBC,UniqueName=" + ManagementRegistrar.makeValidName(poolingDataSource.getUniqueName()) + ",Id=" + poolingDataSource.incCreatedResourcesCounter();
        ManagementRegistrar.register(this.jmxName, this);
    }

    private synchronized void detectJdbcVersion(Connection connection) {
        if (this.jdbcVersionDetected > 0) {
            return;
        }
        try {
            this.isValidMethod = connection.getClass().getMethod("isValid", Integer.TYPE);
            this.isValidMethod.invoke((Object)connection, new Integer(5));
            this.jdbcVersionDetected = 4;
            if (!this.poolingDataSource.isEnableJdbc4ConnectionTest() && log.isDebugEnabled()) {
                log.debug("dataSource is JDBC4 or newer and supports isValid(), but enableJdbc4ConnectionTest is not set or is false");
            }
        }
        catch (Exception ex) {
            this.jdbcVersionDetected = 3;
        }
        catch (AbstractMethodError er) {
            this.jdbcVersionDetected = 3;
        }
        if (log.isDebugEnabled()) {
            log.debug("detected JDBC connection class '" + connection.getClass() + "' is version " + this.jdbcVersionDetected + " type");
        }
    }

    private void applyIsolationLevel() throws SQLException {
        String isolationLevel = this.getPoolingDataSource().getIsolationLevel();
        if (isolationLevel != null) {
            int level = JdbcPooledConnection.translateIsolationLevel(isolationLevel);
            if (level < 0) {
                log.warn("invalid transaction isolation level '" + isolationLevel + "' configured, keeping the default isolation level.");
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("setting connection's isolation level to " + isolationLevel);
                }
                this.connection.setTransactionIsolation(level);
            }
        }
    }

    private static int translateIsolationLevel(String isolationLevelGuarantee) {
        if ("READ_COMMITTED".equals(isolationLevelGuarantee)) {
            return 2;
        }
        if ("READ_UNCOMMITTED".equals(isolationLevelGuarantee)) {
            return 1;
        }
        if ("REPEATABLE_READ".equals(isolationLevelGuarantee)) {
            return 4;
        }
        if ("SERIALIZABLE".equals(isolationLevelGuarantee)) {
            return 8;
        }
        return -1;
    }

    public void close() throws SQLException {
        if (this.usageCount > 0 && log.isDebugEnabled()) {
            log.debug("close connection with usage count > 0, " + this);
        }
        this.setState(0);
        this.statementsCache.clear();
        ManagementRegistrar.unregister(this.jmxName);
        this.connection.close();
        this.xaConnection.close();
    }

    public RecoveryXAResourceHolder createRecoveryXAResourceHolder() {
        return new RecoveryXAResourceHolder(this);
    }

    private void testConnection(Connection connection) throws SQLException {
        String query;
        if (this.poolingDataSource.isEnableJdbc4ConnectionTest() && this.jdbcVersionDetected >= 4) {
            Boolean isValid = null;
            try {
                if (log.isDebugEnabled()) {
                    log.debug("testing with JDBC4 isValid() method, connection of " + this);
                }
                isValid = (Boolean)this.isValidMethod.invoke((Object)connection, new Integer(this.poolingDataSource.getAcquisitionTimeout()));
            }
            catch (Exception e) {
                log.warn("dysfunctional JDBC4 Connection.isValid() method, or negative acquisition timeout, in call to test connection of " + this + ".  Falling back to test query.");
                this.jdbcVersionDetected = 3;
            }
            if (isValid != null) {
                if (isValid.booleanValue()) {
                    if (log.isDebugEnabled()) {
                        log.debug("isValid successfully tested connection of " + this);
                    }
                    return;
                }
                throw new SQLException("connection is no longer valid");
            }
        }
        if ((query = this.poolingDataSource.getTestQuery()) == null) {
            if (log.isDebugEnabled()) {
                log.debug("no query to test connection of " + this + ", skipping test");
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("testing with query '" + query + "' connection of " + this);
        }
        PreparedStatement stmt = connection.prepareStatement(query);
        ResultSet rs = stmt.executeQuery();
        rs.close();
        stmt.close();
        if (log.isDebugEnabled()) {
            log.debug("testQuery successfully tested connection of " + this);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void release() throws SQLException {
        block11: {
            if (log.isDebugEnabled()) {
                log.debug("releasing to pool " + this);
            }
            --this.usageCount;
            try {
                try {
                    TransactionContextHelper.delistFromCurrentTransaction(this);
                }
                catch (BitronixRollbackSystemException ex) {
                    throw (SQLException)new SQLException("unilateral rollback of " + this).initCause((Throwable)((Object)ex));
                }
                catch (SystemException ex) {
                    throw (SQLException)new SQLException("error delisting " + this).initCause(ex);
                }
                Object var3_1 = null;
                if (this.usageCount != 0) break block11;
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                if (this.usageCount != 0) {
                    if (!log.isDebugEnabled()) throw throwable;
                    log.debug("not releasing " + this + " to pool yet, connection is still shared");
                    throw throwable;
                }
                try {
                    TransactionContextHelper.requeue(this, this.poolingDataSource);
                }
                catch (BitronixSystemException ex) {
                    ++this.usageCount;
                    throw (SQLException)new SQLException("error requeuing " + this).initCause((Throwable)((Object)ex));
                }
                if (!log.isDebugEnabled()) throw throwable;
                log.debug("released to pool " + this);
                throw throwable;
            }
            try {}
            catch (BitronixSystemException ex) {
                ++this.usageCount;
                throw (SQLException)new SQLException("error requeuing " + this).initCause((Throwable)((Object)ex));
            }
            TransactionContextHelper.requeue(this, this.poolingDataSource);
            if (!log.isDebugEnabled()) return;
            log.debug("released to pool " + this);
            return;
        }
        if (!log.isDebugEnabled()) return;
        log.debug("not releasing " + this + " to pool yet, connection is still shared");
    }

    public XAResource getXAResource() {
        return this.xaResource;
    }

    public ResourceBean getResourceBean() {
        return this.getPoolingDataSource();
    }

    public PoolingDataSource getPoolingDataSource() {
        return this.poolingDataSource;
    }

    public List getXAResourceHolders() {
        ArrayList<JdbcPooledConnection> xaResourceHolders = new ArrayList<JdbcPooledConnection>();
        xaResourceHolders.add(this);
        return xaResourceHolders;
    }

    public Object getConnectionHandle() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("getting connection handle from " + this);
        }
        int oldState = this.getState();
        ++this.usageCount;
        if (this.usageCount == 1 || oldState == 3) {
            this.setState(2);
        }
        if (oldState == 1) {
            if (log.isDebugEnabled()) {
                log.debug("connection " + this.xaConnection + " was in state IN_POOL, testing it");
            }
            this.testConnection(this.connection);
            this.applyIsolationLevel();
            this.applyCursorHoldabilty();
            if (TransactionContextHelper.currentTransaction() == null) {
                this.applyLocalAutoCommit();
            }
        } else if (log.isDebugEnabled()) {
            log.debug("connection " + this.xaConnection + " was in state " + Decoder.decodeXAStatefulHolderState(oldState) + ", no need to test it");
        }
        if (log.isDebugEnabled()) {
            log.debug("got connection handle from " + this);
        }
        return new JdbcConnectionHandle(this, this.connection);
    }

    public void stateChanged(XAStatefulHolder source, int oldState, int newState) {
        if (newState == 1) {
            if (log.isDebugEnabled()) {
                log.debug("requeued JDBC connection of " + this.poolingDataSource);
            }
            this.lastReleaseDate = new Date();
        }
        if (oldState == 1 && newState == 2) {
            this.acquisitionDate = new Date();
        }
        if (oldState == 3 && newState == 2) {
            TransactionContextHelper.recycle(this);
        }
    }

    public void stateChanging(XAStatefulHolder source, int currentState, int futureState) {
        block9: {
            if (futureState == 1 && this.usageCount > 0) {
                log.warn("usage count too high (" + this.usageCount + ") on connection returned to pool " + source);
            }
            if (futureState == 1 || futureState == 3) {
                if (log.isDebugEnabled()) {
                    log.debug("closing " + this.uncachedStatements.size() + " dangling uncached statement(s)");
                }
                for (int i = 0; i < this.uncachedStatements.size(); ++i) {
                    Statement statement = (Statement)this.uncachedStatements.get(i);
                    try {
                        statement.close();
                        continue;
                    }
                    catch (SQLException ex) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug("error trying to close uncached statement " + statement, (Throwable)ex);
                    }
                }
                this.uncachedStatements.clear();
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("clearing warnings of " + this.connection);
                    }
                    this.connection.clearWarnings();
                }
                catch (SQLException ex) {
                    if (!log.isDebugEnabled()) break block9;
                    log.debug("error cleaning warnings of " + this.connection, (Throwable)ex);
                }
            }
        }
    }

    protected JdbcPreparedStatementHandle getCachedStatement(JdbcPreparedStatementHandle stmt) {
        return this.statementsCache.get(stmt);
    }

    protected JdbcPreparedStatementHandle putCachedStatement(JdbcPreparedStatementHandle stmt) {
        return this.statementsCache.put(stmt);
    }

    protected Statement registerUncachedStatement(Statement stmt) {
        this.uncachedStatements.add(stmt);
        return stmt;
    }

    protected void unregisterUncachedStatement(Statement stmt) {
        this.uncachedStatements.remove(stmt);
    }

    public String toString() {
        return "a JdbcPooledConnection from datasource " + this.poolingDataSource.getUniqueName() + " in state " + Decoder.decodeXAStatefulHolderState(this.getState()) + " with usage count " + this.usageCount + " wrapping " + this.xaConnection;
    }

    private void applyCursorHoldabilty() throws SQLException {
        String cursorHoldability = this.getPoolingDataSource().getCursorHoldability();
        if (cursorHoldability != null) {
            int holdability = JdbcPooledConnection.translateCursorHoldability(cursorHoldability);
            if (holdability < 0) {
                log.warn("invalid cursor holdability '" + cursorHoldability + "' configured, keeping the default cursor holdability.");
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("setting connection's cursor holdability to " + cursorHoldability);
                }
                this.connection.setHoldability(holdability);
            }
        }
    }

    private static int translateCursorHoldability(String cursorHoldability) {
        if ("CLOSE_CURSORS_AT_COMMIT".equals(cursorHoldability)) {
            return 2;
        }
        if ("HOLD_CURSORS_OVER_COMMIT".equals(cursorHoldability)) {
            return 1;
        }
        return -1;
    }

    private void applyLocalAutoCommit() throws SQLException {
        String localAutoCommit = this.getPoolingDataSource().getLocalAutoCommit();
        if (localAutoCommit != null) {
            if (localAutoCommit.equalsIgnoreCase("true")) {
                if (log.isDebugEnabled()) {
                    log.debug("setting connection's auto commit to true");
                }
                this.connection.setAutoCommit(true);
            } else if (localAutoCommit.equalsIgnoreCase("false")) {
                if (log.isDebugEnabled()) {
                    log.debug("setting connection's auto commit to false");
                }
                this.connection.setAutoCommit(false);
            } else {
                log.warn("invalid auto commit '" + localAutoCommit + "' configured, keeping default auto commit");
            }
        }
    }

    public String getStateDescription() {
        return Decoder.decodeXAStatefulHolderState(this.getState());
    }

    public Date getAcquisitionDate() {
        return this.acquisitionDate;
    }

    public Date getLastReleaseDate() {
        return this.lastReleaseDate;
    }

    public Collection getTransactionGtridsCurrentlyHoldingThis() {
        return this.getXAResourceHolderStateGtrids();
    }
}

