/*
 * Decompiled with CFR 0.152.
 */
package org.opends.admin.ads.util;

import java.util.LinkedHashSet;
import javax.naming.ldap.InitialLdapContext;
import org.opends.admin.ads.util.ConnectionUtils;

public class PreferredConnection {
    private String ldapUrl;
    private Type type;

    public PreferredConnection(String ldapUrl, Type type) {
        this.ldapUrl = ldapUrl;
        this.type = type;
    }

    public String getLDAPURL() {
        return this.ldapUrl;
    }

    public Type getType() {
        return this.type;
    }

    public int hashCode() {
        return ((Object)((Object)this.type) + this.ldapUrl.toLowerCase()).hashCode();
    }

    public boolean equals(Object o) {
        boolean equals = false;
        if (this != o) {
            if (o != null && o instanceof PreferredConnection) {
                PreferredConnection p = (PreferredConnection)o;
                equals = this.type == p.getType() && this.ldapUrl.equalsIgnoreCase(p.getLDAPURL());
            }
        } else {
            equals = true;
        }
        return equals;
    }

    public static PreferredConnection getPreferredConnection(InitialLdapContext ctx) {
        String ldapUrl = ConnectionUtils.getLdapUrl(ctx);
        Type type = ConnectionUtils.isStartTLS(ctx) ? Type.START_TLS : (ConnectionUtils.isSSL(ctx) ? Type.LDAPS : Type.LDAP);
        PreferredConnection cnx = new PreferredConnection(ldapUrl, type);
        return cnx;
    }

    public static LinkedHashSet<PreferredConnection> getPreferredConnections(InitialLdapContext ctx) {
        PreferredConnection cnx = PreferredConnection.getPreferredConnection(ctx);
        LinkedHashSet<PreferredConnection> returnValue = new LinkedHashSet<PreferredConnection>();
        returnValue.add(cnx);
        return returnValue;
    }

    public static enum Type {
        LDAP,
        LDAPS,
        START_TLS;

    }
}

