/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.opends.guitools.controlpanel.ControlPanelArgumentParser;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.ui.ControlCenterMainPane;
import org.opends.guitools.controlpanel.ui.GenericFrame;
import org.opends.guitools.controlpanel.ui.LocalOrRemotePanel;
import org.opends.guitools.controlpanel.ui.MainMenuBar;
import org.opends.guitools.controlpanel.util.BlindApplicationTrustManager;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.ui.UIFactory;
import org.opends.quicksetup.util.Utils;
import org.opends.server.util.DynamicConstants;
import org.opends.server.util.args.ArgumentException;

public class ControlPanel {
    private JFrame dlg;
    private ControlPanelInfo info;
    private ControlPanelArgumentParser argParser;
    private ControlCenterMainPane controlCenterPane;

    public static void main(String[] args) {
        try {
            ControlPanel.initLookAndFeel();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        final ControlPanel test = new ControlPanel();
        test.initialize(args);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                test.createAndDisplayGUI();
            }
        });
    }

    public void initialize(String[] args) {
        this.info = ControlPanelInfo.getInstance();
        Installation.getLocal();
        this.argParser = new ControlPanelArgumentParser(ControlPanel.class.getName(), AdminToolMessages.INFO_CONTROL_PANEL_LAUNCHER_USAGE_DESCRIPTION.get());
        try {
            this.argParser.initializeArguments();
            this.argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            throw new IllegalStateException("Arguments not correctly parsed: " + ae, ae);
        }
        if (this.argParser.isTrustAll()) {
            this.info.setTrustManager(new BlindApplicationTrustManager());
        }
        this.info.setConnectTimeout(this.argParser.getConnectTimeout());
    }

    public void createAndDisplayGUI() {
        LocalOrRemotePanel localOrRemotePanel = new LocalOrRemotePanel();
        localOrRemotePanel.setInfo(this.info);
        final GenericFrame localOrRemote = new GenericFrame(localOrRemotePanel);
        localOrRemote.pack();
        Utilities.centerOnScreen(localOrRemote);
        if (this.argParser.isRemote()) {
            this.updateLocalOrRemotePanel(localOrRemote);
        }
        if (this.argParser.getBindPassword() != null) {
            this.updateLocalOrRemotePanel(localOrRemote);
            this.getLocalOrRemotePanel(localOrRemote.getContentPane()).setCallOKWhenVisible(true);
        }
        ComponentAdapter listener = new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                ControlPanel.this.handleWindowClosed(localOrRemote, ControlPanel.this.info);
            }
        };
        localOrRemote.addComponentListener(listener);
        localOrRemote.setVisible(true);
    }

    private void handleWindowClosed(GenericFrame localOrRemote, final ControlPanelInfo info) {
        if (info.getServerDescriptor() == null) {
            MainMenuBar menuBar = new MainMenuBar(info);
            menuBar.quitClicked();
        }
        this.updateSharedLocalOrRemotePanel(localOrRemote, info);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ControlPanel.this.controlCenterPane = new ControlCenterMainPane(info);
                ControlPanel.this.dlg = Utilities.createFrame();
                ControlPanel.this.dlg.setDefaultCloseOperation(0);
                final MainMenuBar menuBar = new MainMenuBar(info);
                ControlPanel.this.dlg.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        menuBar.quitClicked();
                    }
                });
                ControlPanel.this.dlg.setJMenuBar(menuBar);
                String title = Utils.getCustomizedObject("INFO_CONTROL_PANEL_TITLE", AdminToolMessages.INFO_CONTROL_PANEL_TITLE.get(DynamicConstants.PRODUCT_NAME), Message.class).toString();
                ControlPanel.this.dlg.setTitle(title);
                ControlPanel.this.dlg.setContentPane(ControlPanel.this.controlCenterPane);
                ControlPanel.this.dlg.pack();
                Utilities.centerOnScreen(ControlPanel.this.dlg);
                ControlPanel.this.dlg.setVisible(true);
            }
        });
    }

    private static void initLookAndFeel() throws Throwable {
        UIFactory.initializeLookAndFeel();
    }

    private void updateLocalOrRemotePanel(RootPaneContainer localOrRemote) {
        LocalOrRemotePanel panel = this.getLocalOrRemotePanel(localOrRemote.getContentPane());
        if (panel != null) {
            if (this.argParser.isRemote()) {
                panel.setRemote(true);
            }
            if (this.argParser.getExplicitHostName() != null) {
                panel.setHostName(this.argParser.getExplicitHostName());
                panel.setRemote(true);
            }
            if (this.argParser.getExplicitPort() != -1) {
                panel.setPort(this.argParser.getExplicitPort());
                panel.setRemote(true);
            }
            if (this.argParser.getExplicitBindDn() != null) {
                panel.setBindDN(this.argParser.getExplicitBindDn());
            }
            if (this.argParser.getBindPassword() != null) {
                panel.setBindPassword(this.argParser.getBindPassword().toCharArray());
            }
        }
    }

    private void updateSharedLocalOrRemotePanel(RootPaneContainer localOrRemote, ControlPanelInfo info) {
        LocalOrRemotePanel panel = this.getLocalOrRemotePanel(localOrRemote.getContentPane());
        LocalOrRemotePanel panelToUpdate = this.getLocalOrRemotePanel(ControlCenterMainPane.getLocalOrRemoteDialog(info));
        if (panel != null && panelToUpdate != null) {
            panelToUpdate.setRemote(panel.isRemote());
            if (panel.getHostName() != null) {
                panelToUpdate.setHostName(panel.getHostName());
            }
            if (panel.getPort() != -1) {
                panelToUpdate.setPort(panel.getPort());
            }
            if (panel.getBindDN() != null) {
                panelToUpdate.setBindDN(panel.getBindDN());
            }
        }
    }

    private LocalOrRemotePanel getLocalOrRemotePanel(Container c) {
        LocalOrRemotePanel panel = null;
        if (c instanceof LocalOrRemotePanel) {
            panel = (LocalOrRemotePanel)c;
        } else {
            for (Component comp : c.getComponents()) {
                if (comp instanceof Container) {
                    panel = this.getLocalOrRemotePanel((Container)comp);
                }
                if (panel != null) break;
            }
        }
        return panel;
    }
}

